/**CHeaderFile*****************************************************************

  FileName    [prop.h]

  PackageName [prop]

  Synopsis    [Manager of generic properties]

  Description [This file is responsible of manipulate all the
  informations associated to a given property, i.e. the kind of
  property, the property itself, its cone of influence, if the
  property is not satisfied the associated copunter-example, the
  associated FSM in different formats (flatten sexp, flatten boolean
  sexp, bdd, and BE).]

  SeeAlso     []

  Author      [Marco Roveri]

  Copyright   [
  This file is part of the ``prop'' package of NuSMV version 2. 
  Copyright (C) 2000-2001 by ITC-irst. 

  NuSMV version 2 is free software; you can redistribute it and/or 
  modify it under the terms of the GNU Lesser General Public 
  License as published by the Free Software Foundation; either 
  version 2 of the License, or (at your option) any later version.

  NuSMV version 2 is distributed in the hope that it will be useful, 
  but WITHOUT ANY WARRANTY; without even the implied warranty of 
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU 
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public 
  License along with this library; if not, write to the Free Software 
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA.

  For more information of NuSMV see <http://nusmv.irst.itc.it>
  or email to <nusmv-users@irst.itc.it>.
  Please report bugs to <nusmv-users@irst.itc.it>.

  To contact the NuSMV development board, email to <nusmv@irst.itc.it>. ]

  Revision    [$Id: prop.h,v 1.1.1.1 2003/02/06 19:01:21 flerda Exp $]

******************************************************************************/

#ifndef _PROP
#define _PROP


#include "bmcFsm.h"

/*---------------------------------------------------------------------------*/
/* Constant declarations                                                     */
/*---------------------------------------------------------------------------*/
/**Enum************************************************************************

  Synopsis    [The status of a property]

  Description [The status of a property, i.e. If it is checked,
  unchecked, satisifed or unsatisfied.]

  SeeAlso     [optional]

******************************************************************************/
enum _Prop_Status {Prop_NoStatus, Prop_Unchecked, Prop_True, Prop_False, Prop_Wrong, Prop_Number};
#define PROP_NOSTATUS_STRING "NoStatus"
#define PROP_UNCHECKED_STRING "Unchecked"
#define PROP_TRUE_STRING "True"
#define PROP_FALSE_STRING "False"
#define PROP_WRONG_STRING "Wrong"
#define PROP_NUMBER_STRING "Number"
 
/**Enum************************************************************************

  Synopsis    [Enumerates the different types of a specification]

  Description [Enumerates the different types of a specification]

******************************************************************************/
enum _Prop_Type {Prop_NoType, Prop_Ctl, Prop_Ltl, Prop_Invar, Prop_Compute};
#define PROP_NOTYPE_STRING "NoType"
#define PROP_CTL_STRING "CTL"
#define PROP_LTL_STRING "LTL"
#define PROP_INVAR_STRING "Invar"
#define PROP_COMPUTE_STRING "Quantitative"

/*---------------------------------------------------------------------------*/
/* Type declarations                                                         */
/*---------------------------------------------------------------------------*/
typedef enum _Prop_Status Prop_Status;
typedef enum _Prop_Type Prop_Type;
typedef struct _Prop Prop_Rec;
typedef Prop_Rec * Prop_Ptr;

/*---------------------------------------------------------------------------*/
/* Structure declarations                                                    */
/*---------------------------------------------------------------------------*/
/**Struct**********************************************************************

  Synopsis    [Property Information Record]

  Description [This structure contains informations about a given
  property:<br>
  <dl>
  <dt><code>index</code>
     <dd>is the progressive number identifying the specification.</dd>
  <dt><code>prop</code>
      <dd>is the specification formula (s-expression).
  <dt><code>type</code>
      <dd>is the type of the specification (CTL, LTL, INVAR, COMPUTE). 
  <dt><code>cone</code>
      <dd>is the cone of influence of the formula.
  <dt><code>status</code>
      <dd>is the actual checking status of the specification.
  <dt><code>number</code>
      <dd>Result of a COMPUTE property. 
  <dt><code>trace</code>
      <dd>is the index of the counterexample produced when the
          formula is found to be false, otherwise is zero.
  <dt><code>scalar_fsm</code>
      <dd>The FSM associated to the property in scalar format. 
  <dt><code>bool_fsm</code>
      <dd>The FSM associated to the property in boolean format. 
  <dt><code>bdd_fsm</code>
      <dd>The FSM associated to the property in BDD format.
  <dt><code>be_fsm</code>
      <dd>The FSM associated to the property in BE format.
  </dl>
  ]

  SeeAlso     []

******************************************************************************/
struct _Prop {
  unsigned int index;  /* Progressive number */
  node_ptr     prop;   /* property formula (s-expression) */
  node_ptr     cone;   /* The cone of influence */
  Prop_Type    type;   /* type of specification */
  Prop_Status  status; /* verification status */
  int          number; /* The result of a quantitative spec */
  int          trace;  /* the counterexample number (if any) */
  Fsm_SexpPtr  scalar_fsm; /* the scalar FSM number */
  Fsm_SexpPtr  bool_fsm;   /* The scalar FSM converted in Boolean */
  Fsm_BddPtr   bdd_fsm;    /* The BDD FSM */
  Bmc_Fsm_ptr  be_fsm; /* The BE FSM */
};

/*---------------------------------------------------------------------------*/
/* Variable declarations                                                     */
/*---------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------*/
/* Macro declarations                                                        */
/*---------------------------------------------------------------------------*/


/**AutomaticStart*************************************************************/

/*---------------------------------------------------------------------------*/
/* Function prototypes                                                       */
/*---------------------------------------------------------------------------*/
EXTERN void Prop_Init ARGS((void));
EXTERN void Prop_End ARGS((void));
EXTERN void Prop_InitPropMaster ARGS((void));
EXTERN Fsm_BddPtr Prop_GetBddFsm ARGS((Prop_Ptr));
EXTERN Fsm_BddPtr Prop_MasterGetBddFsm ARGS((void));
EXTERN Bmc_Fsm_ptr Prop_GetBeFsm ARGS((Prop_Ptr));
EXTERN Bmc_Fsm_ptr Prop_GetBeFsmCoi ARGS((Prop_Ptr));
EXTERN Bmc_Fsm_ptr Prop_MasterGetBeFsm ARGS((void));
EXTERN Fsm_SexpPtr Prop_GetBoolFsm ARGS((Prop_Ptr));
EXTERN Fsm_SexpPtr Prop_GetScalarFsm ARGS((Prop_Ptr));
EXTERN Fsm_SexpPtr Prop_MasterGetBoolFsm ARGS((void));
EXTERN Fsm_SexpPtr Prop_MasterGetScalarFsm ARGS((void));
EXTERN Prop_Ptr Prop_Alloc ARGS((void));
EXTERN Prop_Ptr Prop_Db_GetLast ARGS((void));
EXTERN Prop_Ptr Prop_Db_GetNum ARGS((int));
EXTERN Prop_Ptr Prop_MakeSexpFsm ARGS((Prop_Ptr));
EXTERN Prop_Status Prop_GetStatus ARGS((Prop_Ptr));
EXTERN Prop_Type Prop_GetType ARGS((Prop_Ptr));
EXTERN Set_t Prop_GetCone ARGS((Prop_Ptr));
EXTERN const char * Prop_DecodeStatus ARGS((Prop_Status t));
EXTERN const char * Prop_DecodeType ARGS((Prop_Type));
EXTERN int Prop_Db_Add ARGS((Prop_Ptr));
EXTERN int Prop_Db_GetSize ARGS((void));
EXTERN int Prop_Db_PropCreateAndAdd ARGS((node_ptr, Prop_Type));
EXTERN int Prop_GetIndex ARGS((Prop_Ptr));
EXTERN int Prop_GetNumber ARGS((Prop_Ptr));
EXTERN int Prop_GetTrace ARGS((Prop_Ptr));
EXTERN int Prop_PrintPropNum ARGS((FILE *, int));
EXTERN node_ptr Prop_GetProp ARGS((Prop_Ptr));
EXTERN void Prop_BuildFsm ARGS((Prop_Ptr, node_ptr, node_ptr, node_ptr, add_ptr));
EXTERN void Prop_BuildMasterProp ARGS((node_ptr, node_ptr, node_ptr, add_ptr));
EXTERN void Prop_Db_Quit ARGS((void));
EXTERN void Prop_DbPrintAll ARGS((FILE *));
EXTERN void Prop_DbPrintAllStatus ARGS((FILE *, Prop_Status));
EXTERN void Prop_DbPrintAllStatusType ARGS((FILE *, Prop_Type, Prop_Status));
EXTERN void Prop_DbPrintAllType ARGS((FILE *, Prop_Type));
EXTERN void Prop_DbVerifyAllType ARGS((Prop_Type));
EXTERN void Prop_DbVerifyAllTypeCompute ARGS((void));
EXTERN void Prop_DbVerifyAllTypeCtl ARGS((void));
EXTERN void Prop_DbVerifyAllTypeInvar ARGS((void));
EXTERN void Prop_DbVerifyAllTypeLtl ARGS((void));
EXTERN void Prop_Db_Init ARGS((void));
EXTERN void Prop_Db_VerifyAll ARGS((void));
EXTERN void Prop_Db_VerifyProp ARGS((Prop_Ptr));
EXTERN void Prop_Db_VerifyPropIndex ARGS((int));
EXTERN void Prop_FillPropDb ARGS((node_ptr, node_ptr, node_ptr, node_ptr));
EXTERN void Prop_Free ARGS((Prop_Ptr));
EXTERN void Prop_MasterSetBddFsm ARGS((Fsm_BddPtr));
EXTERN void Prop_MasterSetBoolFsm ARGS((Fsm_SexpPtr));
EXTERN void Prop_MasterSetBeFsm ARGS((Bmc_Fsm_ptr));
EXTERN void Prop_MasterSetScalarFsm ARGS((Fsm_SexpPtr));
EXTERN void Prop_PrintProp ARGS((FILE *, Prop_Ptr));
EXTERN void Prop_PrintPropHeader ARGS((FILE *));
EXTERN void Prop_QuitPropMaster ARGS((void));
EXTERN void Prop_SetBddFsm ARGS((Prop_Ptr, Fsm_BddPtr));
EXTERN void Prop_SetBoolFsm ARGS((Prop_Ptr, Fsm_SexpPtr));
EXTERN void Prop_SetCone ARGS((Prop_Ptr, Set_t));
EXTERN void Prop_SetFsmToMaster ARGS((Prop_Ptr));
EXTERN void Prop_SetIndex ARGS((Prop_Ptr, int));
EXTERN void Prop_SetNumber ARGS((Prop_Ptr, int));
EXTERN void Prop_SetNumberInfinte ARGS((Prop_Ptr));
EXTERN void Prop_SetProp ARGS((Prop_Ptr, node_ptr));
EXTERN void Prop_SetBeFsm ARGS((Prop_Ptr, Bmc_Fsm_ptr));
EXTERN void Prop_SetScalarFsm ARGS((Prop_Ptr, Fsm_SexpPtr));
EXTERN void Prop_SetStatus ARGS((Prop_Ptr, Prop_Status));
EXTERN void Prop_SetTrace ARGS((Prop_Ptr, int));
EXTERN void Prop_SetType ARGS((Prop_Ptr, Prop_Type));
EXTERN lsList Prop_Db_GetPropsOfType ARGS((const Prop_Type type));
EXTERN int Prop_Db_PropParseAndAdd ARGS((const char* str, const Prop_Type type));
EXTERN int Prop_GetPropIdxFromString ARGS((const char* idx));
EXTERN int Prop_CheckType ARGS((Prop_Ptr property, Prop_Type type)); 

/**AutomaticEnd***************************************************************/

#endif /* _PROP */
