CSRC += parserUtil.c parserCmd.c
HEADERS += parserInt.h parser.h
LEXSRC  += input.l
YACCSRC += grammar.y
GENERATEDHEADERS += grammar.h
GENERATEDCSRC += grammar.c input.c

# Warning option -l olny in Linux to be moved in configure.in
$(objectdir)/input.c: input.l grammar.h
	@echo Compiling file $< into $@
	$(LEX) -l -o$(objectdir)/input.c $<
	-@chmod 0644 $(objectdir)/input.c

grammar.h: $(objectdir)/grammar.c

$(objectdir)/grammar.c: grammar.y
	@echo Compiling file $< into $@
	$(YACC) -d -o $(objectdir)/grammar.c $<
	-@chmod 0644 $(objectdir)/grammar.c

$(objectdir)/input.o: $(objectdir)/input.c
	@echo Compiling file $< into $@
	$(CC) -c $(CFLAGS) $(AC_FLAGS) $(VERDATE) \
		-DNAWK=\"$(NAWK)\" -DLIBRARY=\"$(datadir)\" \
		$(INCLUDEDIRS) \
		-o $@  $<

$(objectdir)/grammar.o: $(objectdir)/grammar.c
	@echo Compiling file $< into $@
	$(CC) -c $(CFLAGS) $(AC_FLAGS) $(VERDATE) \
		-DNAWK=\"$(NAWK)\" -DLIBRARY=\"$(datadir)\" \
		$(INCLUDEDIRS) \
		-o $@  $<

DEPENDENCYFILES = $(CSRC)
