%{
/**CFile***********************************************************************

  FileName    [input.l]

  PackageName [parser]

  Synopsis    [Lexical analyzer for the NuSMV input language]

  SeeAlso     [grammar.y]

  Author      [Marco Roveri]

  Copyright   [
  This file is part of the ``parser'' package of NuSMV version 2. 
  Copyright (C) 1998-2001 by CMU and ITC-irst. 

  NuSMV version 2 is free software; you can redistribute it and/or 
  modify it under the terms of the GNU Lesser General Public 
  License as published by the Free Software Foundation; either 
  version 2 of the License, or (at your option) any later version.

  NuSMV version 2 is distributed in the hope that it will be useful, 
  but WITHOUT ANY WARRANTY; without even the implied warranty of 
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU 
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public 
  License along with this library; if not, write to the Free Software 
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA.

  For more information of NuSMV see <http://nusmv.irst.itc.it>
  or email to <nusmv-users@irst.itc.it>.
  Please report bugs to <nusmv-users@irst.itc.it>.

  To contact the NuSMV development board, email to <nusmv@irst.itc.it>. ]

******************************************************************************/
 
#include "util.h"
#include "utils.h"
#include "node.h"
#include "grammar.h"

static char rcsid[] UTIL_UNUSED = "$Id: input.l,v 1.1.1.1 2003/02/06 19:01:15 flerda Exp $";

%}
%a	15000
%o	25000
%%
[ \n\t\r\f]             ;
"--"[^\n]*              ;
^"#".*\n                sscanf(yytext,"# %d",&yylineno);
"ASYNC"                 return(ASYNC);
"MODULE"                return(MODULE);
"process"               return(PROCESS);
"DEFINE"                return(DEFINE);
"VAR"                   return(VAR);
"IVAR"                  return(IVAR);
"CONSTANT"              return(CONSTANT);
"INIT"                  return(INIT);
"TRANS"                 return(TRANS);
"INVAR"                 return(INVAR);
"FORMAT"                return(FORMAT);
"SPEC"                  return(SPEC);
"LTLSPEC"               return(LTLSPEC);
"COMPUTE"               return(COMPUTE);
"INVARSPEC"             return(INVARSPEC);
"CONSTRAINT"            return(CONSTRAINT);
"SIMPWFF"               return(SIMPWFF);
"CTLWFF"                return(CTLWFF);
"LTLWFF"                return(LTLWFF);
"COMPWFF"               return(COMPWFF);
"IN"                    return(INCONTEXT);
"FAIRNESS"              return(FAIRNESS);
"JUSTICE"               return(JUSTICE);
"COMPASSION"            return(COMPASSION);
"ISA"                   return(ISA);
"ASSIGN"                return(ASSIGN);
"INPUT"                 return(INPUT);
"OUTPUT"                return(OUTPUT);
"IMPLEMENTS"            return(IMPLEMENTS);
"GOTO"                  return(GOTO);
"LET"                   return(LET);
"STEP"                  return(STEP);
"EVAL"                  return(EVAL);
"RESET"                 return(RESET);
"array"                 return(ARRAY);
"of"                    return(OF);
"boolean"               return(BOOLEAN);
"EX"                    return(EX);
"AX"                    return(AX);
"EF"                    return(EF);
"AF"                    return(AF);
"EG"                    return(EG);
"AG"                    return(AG);
"E"                     return(EE);
"F"                     return(OP_FUTURE);
"O"                     return(OP_ONCE);
"G"                     return(OP_GLOBAL);
"H"                     return(OP_HISTORICAL);
"X"                     return(OP_NEXT);
"Y"                     return(OP_PREC);
"Z"                     return(OP_NOTPRECNOT);
"A"                     return(AA);
"U"                     return(UNTIL);
"S"                     return(SINCE);
"V"                     return(RELEASES);
"T"                     return(TRIGGERED);
"BU"                    return(BUNTIL);
"EBF"                   return(EBF);
"ABF"                   return(ABF);
"EBG"                   return(EBG);
"ABG"                   return(ABG);
"MIN"                   return(MMIN);
"MAX"                   return(MMAX);
"("                     return(LP);
")"                     return(RP);
"["                     return(LB);
"]"                     return(RB);
"{"                     return(LCB);
"}"                     return(RCB);
"FALSE"                 {
				yylval.node = new_node(FALSEEXP,Nil,Nil);
				return(FALSEEXP);
			}
"TRUE"                  {
				yylval.node = new_node(TRUEEXP,Nil,Nil);
				return(TRUEEXP);
			}
"apropos"               return(APROPOS);
"case"                  return(CASE);
"esac"                  return(ESAC);
"if"                    return(IF);
"then"                  return(THEN);
"else"                  return(ELSE);
":="                    return(EQDEF);
"+"                     return(PLUS);
"-"                     return(MINUS);
"*"                     return(TIMES);
"/"                     return(DIVIDE);
"mod"                   return(MOD);
"="                     return(EQUAL);
"!="                    return(NOTEQUAL);
"<="                    return(LE);
">="                    return(GE);
"<"                     return(LT);
">"                     return(GT);
"next"                  return(NEXT);
"init"                  return(SMALLINIT);
"sigma"                 return(SIGMA);
"self"                  return(SELF);
"union"                 return(UNION);
"in"                    return(SETIN);
".."                    return(TWODOTS);
"."                     return(DOT);
"->"                    return(IMPLIES);
"<->"                   return(IFF);
"|"                     return(OR);
"&"                     return(AND);
"xor"                   return(XOR);
"xnor"                  return(XNOR);
"!"                     return(NOT);
[A-Za-z_][A-Za-z0-9_\$#-]*  { 
                             yylval.node = new_node(ATOM,(node_ptr)find_string(yytext),Nil);
                             return(ATOM);
                           }
[0-9]+                  {
                          int i;
                          sscanf(yytext,"%d",&i);
                          yylval.node = new_node(NUMBER,(node_ptr)i,Nil);
                          return(NUMBER);
                        }
\"[^\"]*\"              {
                          yylval.node = new_node(ATOM,(node_ptr)find_string(yytext),Nil);
                          return(ATOM);
                        } /* Unused token */
","                     return(COMMA);
":"                     return(COLON);
";"                     return(SEMI);
.			rpterr("illegal character");
%%

