/**CHeaderFile*****************************************************************

  FileName    [opt.h]

  PackageName [opt]

  Synopsis    [The option header file.]

  Description [This file conatins a data structure to manage all the
  command line options of the NuSMV system.]

  Author      [Marco Roveri]

  Copyright   [
  This file is part of the ``opt'' package of NuSMV version 2. 
  Copyright (C) 1998-2001 by CMU and ITC-irst. 

  NuSMV version 2 is free software; you can redistribute it and/or 
  modify it under the terms of the GNU Lesser General Public 
  License as published by the Free Software Foundation; either 
  version 2 of the License, or (at your option) any later version.

  NuSMV version 2 is distributed in the hope that it will be useful, 
  but WITHOUT ANY WARRANTY; without even the implied warranty of 
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU 
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public 
  License along with this library; if not, write to the Free Software 
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA.

  For more information of NuSMV see <http://nusmv.irst.itc.it>
  or email to <nusmv-users@irst.itc.it>.
  Please report bugs to <nusmv-users@irst.itc.it>.

  To contact the NuSMV development board, email to <nusmv@irst.itc.it>. ]

  Revision    [$Id: opt.h,v 1.5 2003/10/28 17:29:24 flerda Exp $]

******************************************************************************/

#ifndef _OPTH
#define _OPTH

#include "sat.h" /* for Sat_SatSolver_Type */

/*---------------------------------------------------------------------------*/
/* Constant declarations                                                     */
/*---------------------------------------------------------------------------*/
#define DEFAULT_PGM_NAME   (char *)NULL
#define DEFAULT_INPUT_FILE (char *)NULL
#define DEFAULT_INPUT_ORDER_FILE (char *)NULL
#define DEFAULT_OUTPUT_ORDER_FILE "temp.ord"
#define DEFAULT_CONJ_PART_THRESHOLD 1000
#define DEFAULT_IMAGE_CLUSTER_SIZE 1000
#define DEFAULT_SHOWN_STATES 25
/* maximum number of states shown during an interactive simulation step*/
#define MAX_SHOWN_STATES 100
/* BMC stuff */
#define DEFAULT_DIMACS_FILENAME        "@f_k@k_l@l_n@n.dimacs"
#define DEFAULT_INVAR_DIMACS_FILENAME  "@f_invar_n@n.dimacs"
#define DEFAULT_BMC_PB_LENGTH     10
#define DEFAULT_BMC_PB_LOOP       Bmc_Utils_GetAllLoopbacksString()
#define DEFAULT_BMC_OPTIMIZED_TABLEAU 1
#define DEFAULT_SAT_SOLVER        Sat_Sim
#define DEFAULT_BMC_FORCE_PLTL_TABLEAU 0

#define OPT_USER_POV_NULL_STRING  "" /* user pov of the null string */
/*---------------------------------------------------------------------------*/
/* Type declarations                                                         */
/*---------------------------------------------------------------------------*/
typedef enum {Monolithic, Threshold, Iwls95CP} Partition_Method;

/**Struct**********************************************************************

  Synopsis    [The option data structure.]

  Description [The option data structure contains the following fields:
  <ul>
  <li><b>pgm_name</b></li>
  <li><b>input_file</b></li>
  <li><b>input_order_file</b></li>
  <li><b>output_order_file</b></li>
  <li><b>verbose</b></li>
  <li><b>run_cpp</b></li>
  <li><b>check_trans</li>
  <li><b>saturation</li>
  <li><b>equality_reduced</li>
  <li><b>po</li>
  <li><b>process_order</li>
  <li><b>dump_bdds</li>
  <li><b>ignore_spec</b></li>
  <li><b>ignore_compute</b></li>
  <li><b>ignore_ltlspec</b></li>
  <li><b>ignore_invar</b></li>
  <li><b>forward_search</b></li>
  <li><b>print_reachable</b></li>
  <li><b>enable_reorder</b></li>
  <li><b>partition_method</b></li>
  <li><b>conj_part_threshold</b></li>
  <li><b>image_cluster_size</b></li>
  <li><b>ignore_init_file</b></li>
  <li><b>ag_only</b></li>
  <li><b>cone_of_influence</b></li>
  <li><b>bmc_mode</b></li>
  <li><b>bmc_dimacs_filename</b></li>
  <li><b>bmc_invar_dimacs_filename</b></li>
  <li><b>bmc_pb_length</b></li>
  <li><b>bmc_pb_loop</b></li>
  <li><b>bmc_optimized_tableau</b></li>
  <li><b>bmc_force_pltl_tableau</b></li> 
  <li><b>sat_solver</b></li>
  </ul>]

  SeeAlso     [optional]

******************************************************************************/
typedef struct options {
  char * pgm_name;
#define PROGRAM_NAME      "program_name"
  char * input_file;
#define INPUT_FILE        "input_file"
  char * input_order_file;
#define INPUT_ORDER_FILE  "input_order_file"
  char * output_order_file;
#define OUTPUT_ORDER_FILE "output_order_file"
  char * output_flatten_model_file;
#define OUTPUT_FLATTEN_MODEL_FILE "output_flatten_model_file"
  char * output_boolean_model_file;
#define OUTPUT_BOOLEAN_MODEL_FILE "output_boolean_model_file"
  int verbose;
#define VERBOSE_LEVEL     "verbose_level"
  int run_cpp;
#define RUN_CPP           "run_cpp"
  int shown_states;
#define SHOWN_STATES      "shown_states"
  boolean ignore_spec;
#define IGNORE_SPEC       "ignore_spec"
  boolean ignore_compute;
#define IGNORE_COMPUTE    "ignore_compute"
  boolean ignore_ltlspec;
#define IGNORE_LTLSPEC    "ignore_ltlspec"
  boolean check_trans;
#define OPT_CHECK_TRANS   "check_trans"
  boolean saturation;
#define OPT_SATURATION    "saturation"
  boolean equality_reduced;
#define OPT_EQUALITY_REDUCED "equality_reduced"
  boolean po;
#define OPT_PO            "po"
  boolean process_order;
#define OPT_PROCESS_ORDER "process_order"
  boolean dump_bdds;
#define OPT_DUMP_BDDS     "dump_bdds"
  boolean ignore_invar;
#define IGNORE_INVAR      "ignore_invar"
  boolean forward_search;
#define FORWARD_SEARCH    "forward_search"
  boolean print_reachable;
#define PRINT_REACHABLE   "print_reachable"
  boolean reorder;
#define ENABLE_REORDER    "enable_reorder"
  unsigned int reorder_method;
#define REORDER_METHOD    "reorder_method"
  boolean dynamic_reorder;
#define DYNAMIC_REORDER   "dynamic_reorder"
  boolean batch;
  Partition_Method partition_method;
#define PARTITION_METHOD  "partition_method"
  int conj_part_threshold;
#define CONJ_PART_THRESHOLD "conj_part_threshold"
  int image_cluster_size;
#define IMAGE_CLUSTER_SIZE "image_cluster_size"
  boolean ignore_init_file;
#define IGNORE_INIT_FILE  "ignore_init_file"
  boolean ag_only;
#define AG_ONLY_SEARCH    "ag_only_search"
  boolean cone_of_influence;
#define CONE_OF_INFLUENCE "cone_of_influence"
  boolean list_properties;
#define LIST_PROPERTIES "list_properties"
  int prop_no;
#define PROP_NO         "prop_no"
  /* BMC Stuff */
  boolean bmc_mode;
#define BMC_MODE          "bmc_mode"
  char *bmc_dimacs_filename;
#define BMC_DIMACS_FILENAME "bmc_dimacs_filename"
  char *bmc_invar_dimacs_filename;
#define BMC_INVAR_DIMACS_FILENAME "bmc_invar_dimacs_filename"
  int bmc_pb_length;
#define BMC_PB_LENGTH      "bmc_length"
  char* bmc_pb_loop;
#define BMC_PB_LOOP        "bmc_loopback"
  boolean bmc_optimized_tableau;
#define BMC_OPTIMIZED_TABLEAU "bmc_optimized_tableau"
  boolean bmc_force_pltl_tableau;
#define BMC_FORCE_PLTL_TABLEAU "bmc_force_pltl_tableau"
  boolean preorder;
#define SAT_SOLVER "sat_solver"
  Sat_SatSolver_Type sat_solver;

#define IWLS95_PREORDER  "iwls95preorder"
  boolean affinity;
#define AFFINITY_CLUSTERING  "affinity"
  
} options_rec, * options_ptr;

/*---------------------------------------------------------------------------*/
/* Function prototypes                                                       */
/*---------------------------------------------------------------------------*/
EXTERN options_ptr init_options ARGS((void));
EXTERN void init_options_cmd ARGS((void));
EXTERN void    set_pgm_name ARGS((options_ptr, char *));
EXTERN void    reset_pgm_name ARGS((options_ptr));
EXTERN char *  get_pgm_name ARGS((options_ptr));
EXTERN void    set_input_file ARGS((options_ptr, char *));
EXTERN void    reset_input_file ARGS((options_ptr));
EXTERN char *  get_input_file ARGS((options_ptr));
EXTERN void    set_input_order_file ARGS((options_ptr, char *));
EXTERN void    reset_input_order_file ARGS((options_ptr));
EXTERN char *  get_input_order_file ARGS((options_ptr));
EXTERN void    set_output_order_file ARGS((options_ptr, char *));
EXTERN void    reset_output_order_file ARGS((options_ptr));
EXTERN char *  get_output_order_file ARGS((options_ptr));
EXTERN boolean is_default_order_file ARGS((options_ptr opt));
EXTERN void    set_output_flatten_model_file ARGS((options_ptr, char *));
EXTERN void    reset_output_flatten_model_file ARGS((options_ptr));
EXTERN char *  get_output_flatten_model_file ARGS((options_ptr));
EXTERN void    set_output_boolean_model_file ARGS((options_ptr, char *));
EXTERN void    reset_output_boolean_model_file ARGS((options_ptr));
EXTERN char *  get_output_boolean_model_file ARGS((options_ptr));
EXTERN void    set_verbose_level ARGS((options_ptr, int));
EXTERN int     get_verbose_level ARGS((options_ptr));
EXTERN boolean opt_verbose_level_eq ARGS((options_ptr, int));
EXTERN boolean opt_verbose_level_gt ARGS((options_ptr, int));
EXTERN boolean opt_verbose_level_ge ARGS((options_ptr, int));
EXTERN boolean opt_verbose_level_lt ARGS((options_ptr, int));
EXTERN boolean opt_verbose_level_le ARGS((options_ptr, int));
EXTERN void    set_run_cpp ARGS((options_ptr));
EXTERN void    unset_run_cpp ARGS((options_ptr));
EXTERN boolean opt_run_cpp ARGS((options_ptr));
EXTERN void    set_shown_states_level ARGS((options_ptr, int));
EXTERN int     opt_shown_states_level ARGS((options_ptr));
EXTERN void    set_ignore_spec ARGS((options_ptr));
EXTERN void    unset_ignore_spec ARGS((options_ptr));
EXTERN boolean opt_ignore_spec ARGS((options_ptr));
EXTERN void    set_ignore_compute ARGS((options_ptr));
EXTERN void    unset_ignore_compute ARGS((options_ptr));
EXTERN boolean opt_ignore_compute ARGS((options_ptr));
EXTERN void    set_ignore_ltlspec ARGS((options_ptr));
EXTERN void    unset_ignore_ltlspec ARGS((options_ptr));
EXTERN boolean opt_ignore_ltlspec ARGS((options_ptr));
EXTERN void    set_check_trans ARGS((options_ptr));
EXTERN void    unset_check_trans ARGS((options_ptr));
EXTERN boolean opt_check_trans ARGS((options_ptr));
EXTERN void    set_saturation ARGS((options_ptr));
EXTERN void    unset_saturation ARGS((options_ptr));
EXTERN boolean opt_saturation ARGS((options_ptr));
EXTERN void    set_equality_reduced ARGS((options_ptr));
EXTERN void    unset_equality_reduced ARGS((options_ptr));
EXTERN boolean opt_equality_reduced ARGS((options_ptr));
EXTERN void    set_po ARGS((options_ptr));
EXTERN void    unset_po ARGS((options_ptr));
EXTERN boolean opt_po ARGS((options_ptr));
EXTERN void    set_process_order ARGS((options_ptr, int));
EXTERN int     opt_process_order ARGS((options_ptr));
EXTERN void    set_dump_bdds ARGS((options_ptr));
EXTERN void    unset_dump_bdds ARGS((options_ptr));
EXTERN boolean opt_dump_bdds ARGS((options_ptr));
EXTERN void    set_ignore_invar ARGS((options_ptr));
EXTERN void    unset_ignore_invar ARGS((options_ptr));
EXTERN boolean opt_ignore_invar ARGS((options_ptr));
EXTERN void    set_forward_search ARGS((options_ptr));
EXTERN void    unset_forward_search ARGS((options_ptr));
EXTERN boolean opt_forward_search ARGS((options_ptr));
EXTERN void    set_print_reachable ARGS((options_ptr));
EXTERN void    unset_print_reachable ARGS((options_ptr));
EXTERN boolean opt_print_reachable ARGS((options_ptr));
EXTERN void    set_reorder ARGS((options_ptr));
EXTERN void    unset_reorder ARGS((options_ptr));
EXTERN boolean opt_reorder ARGS((options_ptr));
EXTERN void    set_reorder_method ARGS((options_ptr, unsigned int));
EXTERN unsigned int get_reorder_method ARGS((options_ptr));
EXTERN void    set_dynamic_reorder ARGS((options_ptr));
EXTERN void    unset_dynamic_reorder ARGS((options_ptr));
EXTERN boolean opt_dynamic_reorder ARGS((options_ptr));
EXTERN void    set_batch ARGS((options_ptr));
EXTERN void    unset_batch ARGS((options_ptr));
EXTERN boolean opt_batch ARGS((options_ptr));
EXTERN void    set_partition_method ARGS((options_ptr, Partition_Method)); 
EXTERN Partition_Method get_partition_method ARGS((options_ptr opt));
EXTERN void    reset_partitioning_method ARGS((options_ptr));
EXTERN void    set_monolithic ARGS((options_ptr));
EXTERN void    set_conj_partitioning ARGS((options_ptr));
EXTERN void    set_iwls95cp_partitioning ARGS((options_ptr));
EXTERN boolean opt_monolithic ARGS((options_ptr));
EXTERN boolean opt_conj_partitioning ARGS((options_ptr));
EXTERN boolean opt_iwls95cp_partitioning ARGS((options_ptr));
EXTERN void    set_conj_part_threshold ARGS((options_ptr, int));
EXTERN void    reset_conj_part_threshold ARGS((options_ptr));
EXTERN int     get_conj_part_threshold ARGS((options_ptr));
EXTERN void set_image_cluster_size ARGS((options_ptr, int));
EXTERN void reset_image_cluster_size ARGS((options_ptr));
EXTERN int get_image_cluster_size ARGS((options_ptr));
EXTERN void    set_ignore_init_file ARGS((options_ptr));
EXTERN void    unset_ignore_init_file ARGS((options_ptr));
EXTERN boolean opt_ignore_init_file ARGS((options_ptr));
EXTERN void    set_ag_only ARGS((options_ptr));
EXTERN void    unset_ag_only ARGS((options_ptr));
EXTERN boolean opt_ag_only ARGS((options_ptr));
EXTERN void    set_cone_of_influence ARGS((options_ptr));
EXTERN void    unset_cone_of_influence ARGS((options_ptr));
EXTERN boolean opt_cone_of_influence ARGS((options_ptr));
EXTERN void    set_bmc_mode ARGS((options_ptr));
EXTERN void    unset_bmc_mode ARGS((options_ptr));
EXTERN boolean opt_bmc_mode ARGS((options_ptr));
EXTERN void    set_list_properties ARGS((options_ptr));
EXTERN void    unset_list_properties ARGS((options_ptr));
EXTERN boolean opt_list_properties ARGS((options_ptr));
EXTERN void    set_prop_no ARGS((options_ptr, int n));
EXTERN int     get_prop_no ARGS((options_ptr));
EXTERN Partition_Method str2method ARGS((char *));
EXTERN char* method2str ARGS((Partition_Method m));
EXTERN void print_partition_method  ARGS((FILE *));
EXTERN char* get_bmc_dimacs_filename ARGS((options_ptr));
EXTERN void set_bmc_dimacs_filename ARGS((options_ptr, char *));
EXTERN char* get_bmc_invar_dimacs_filename ARGS((options_ptr));
EXTERN void set_bmc_invar_dimacs_filename ARGS((options_ptr, char *));
EXTERN void set_bmc_pb_length ARGS((options_ptr opt, const int k));
EXTERN int get_bmc_pb_length ARGS((options_ptr));
EXTERN void set_bmc_pb_loop  ARGS((options_ptr opt, const char* loop));
EXTERN const char* get_bmc_pb_loop ARGS((options_ptr));
EXTERN void set_bmc_optimized_tableau ARGS((options_ptr));
EXTERN void unset_bmc_optimized_tableau ARGS((options_ptr));
EXTERN boolean opt_bmc_optimized_tableau ARGS((options_ptr));
EXTERN void    set_bmc_force_pltl_tableau   ARGS((options_ptr));
EXTERN void    unset_bmc_force_pltl_tableau ARGS((options_ptr));
EXTERN boolean opt_bmc_force_pltl_tableau   ARGS((options_ptr));
EXTERN void set_sat_solver ARGS((options_ptr, Sat_SatSolver_Type));
EXTERN Sat_SatSolver_Type get_sat_solver ARGS((options_ptr));
EXTERN void set_iwls95_preorder ARGS((options_ptr opt));
EXTERN void unset_iwls95_preorder ARGS((options_ptr opt));
EXTERN boolean opt_iwls95_preorder ARGS((options_ptr opt));
EXTERN void set_affinity ARGS((options_ptr));
EXTERN void unset_affinity ARGS((options_ptr));
EXTERN boolean opt_affinity ARGS((options_ptr));
#endif /* _OPTH */




