#define NO_PRINT_STATES
#define BURCH 0

#include "mcInt.h" 
#include "../node/node.h"
#include "../img/imgInt.h"

static bdd_ptr invar_bdd_saturation = (bdd_ptr) NULL;
static bdd_ptr vars_saturation = (bdd_ptr) NULL;

/*---------------------------------------------------------------------------*/
/* Static function prototypes                                                */
/*---------------------------------------------------------------------------*/
static void McSaturation_SaturateRecur(DPList list, int layer);

/*---------------------------------------------------------------------------*/
/* Definition of exported functions                                          */
/*---------------------------------------------------------------------------*/


static void McSaturation_SaturateRecur(DPList list, int layer) {
  /* frontier generated by last iteration */
  bdd_ptr frontier;
  /* true if last outer iteration reached a fix point */
  int fix_point;
  /* level at which we are currently working */
  int level = DPListLength(list)-1;
  /* number of outer iterations before reaching a fix point */
  int outer;
  /* Descriptor of current process */
  DPDesc *desc = DPListGetItem(list);

  if (opt_verbose_level_gt(options, 1)) {
    char *name = DPDescGetName(desc);
    fprintf(nusmv_stderr, "    starting saturation of level %d for layer %d (%s)\n", level, layer, name);
  }

  /* the initial frontier is the whole reachable states */
  frontier = bdd_dup(reachable_states_bdd);

  outer = 0;

  do {
    /* set of states reachable before image computation */
    bdd_ptr previous_reachable_states_bdd;
    /* number of inner iterations before reaching a fix point */
    int inner = 0;

    do {
      /* The bdd of the support variables */
      bdd_ptr support_bdd_current = DPDescGetSupportBDD(desc);
      /* The array to shift the support variable backward */
      int *support_vars_backward = DPDescGetSupportVector(desc);
      /* The transition relation for this layer */
      CPList trans = DPDescGetCList(desc);
      /* Name of the process */
      char *name = DPDescGetName(desc);

      /* the reachable states before last step */
      previous_reachable_states_bdd = bdd_dup(reachable_states_bdd);

      /* intersect the frontier with normal assignments  */
      bdd_and_accumulate(dd_manager, &frontier, invar_bdd_saturation);

      {
        /* set of new states */
        bdd_ptr new_states;

	/* computes the forward image from the current reachable states */
	{
#ifndef NO_PRINT_STATES
	  fprintf(nusmv_stdout, "@@@@ Applying transition relation for process %s\n", name);
#endif /* NO_PRINT_STATES */
#ifndef NO_PRINT_STATES
	  fprintf(nusmv_stdout, "@@@@ Frontier\n");
	  dd_printminterm(dd_manager, frontier);
	  fprintf(nusmv_stdout, "@@@@\n");
#endif

	if(opt_equality_reduced(options))
	{
	  bdd_ptr tmp = (bdd_ptr) CPImageBoth(dd_manager, trans,
	      frontier, support_bdd_current);
	  new_states = bdd_shift_set(dd_manager, tmp, support_vars_backward);
	  bdd_free(dd_manager, tmp);
	}
	else
	{
	  bdd_ptr tmp = (bdd_ptr) CPImageBoth(dd_manager, trans,
	      frontier, vars_saturation);
	  new_states = bdd_shift_backward(dd_manager, tmp);
	  bdd_free(dd_manager, tmp);
	}

#ifndef NO_PRINT_STATES
	  fprintf(nusmv_stdout, "@@@@ Image (after shifting)\n");
	  dd_printminterm(dd_manager, new_states);
	  fprintf(nusmv_stdout, "@@@@\n");
#endif
        }

        /* add the new states to the set of reachable states */
        bdd_or_accumulate(dd_manager, &reachable_states_bdd, new_states);

        bdd_free(dd_manager, new_states);
      }

      /* free the last frontier */
      bdd_free(dd_manager, frontier);

      /* computes the new frontier */
      {
        bdd_ptr tmp = bdd_not(dd_manager, previous_reachable_states_bdd);
        frontier = bdd_and(dd_manager, reachable_states_bdd, tmp);
        bdd_free(dd_manager, tmp);
      }

      {
	static int i = 0;
	if (opt_verbose_level_gt(options, 1))
	{
	  fprintf(nusmv_stderr,
	      "      iteration %d: BDD size = %d, frontier size = %d, states = %g\n",
	      i, bdd_size(dd_manager, reachable_states_bdd),
	      bdd_size(dd_manager, frontier),
	      bdd_count_states(dd_manager, reachable_states_bdd));
	}
	i++;

	if(opt_dump_bdds(options))
	{
	  FILE *fp;
	  char *fname = malloc(7 + 10);
	  sprintf(fname, "S-%d.dot", i);
	  fp = fopen(fname, "w");
	  free(fname);
	  Cudd_DumpDot(dd_manager, 1, &reachable_states_bdd, NULL, NULL, fp);
	  fclose(fp);
	  fprintf(nusmv_stderr, "States:\n");
	  Cudd_PrintDebug(dd_manager, reachable_states_bdd, 4, 4);
	}

	if(opt_dump_bdds(options))
	{
	  FILE *fp;
	  char *fname = malloc(7 + 10);
	  sprintf(fname, "F-%d.dot", i);
	  fp = fopen(fname, "w");
	  free(fname);
	  Cudd_DumpDot(dd_manager, 1, &frontier, NULL, NULL, fp);
	  fclose(fp);
	  fprintf(nusmv_stderr, "Frontier:\n");
	  Cudd_PrintDebug(dd_manager, frontier, 4, 4);
	}
      }

      bdd_free(dd_manager, previous_reachable_states_bdd);

      fix_point = bdd_count_states(dd_manager, frontier) == 0;

      inner++;
    } while(!fix_point);

    if (opt_verbose_level_gt(options, 1))
      fprintf(nusmv_stderr, "        on level %d at layer %d inner loop contains %d iteration(s)\n", level, layer, inner);

    bdd_free(dd_manager, frontier);

    if(((layer != level) && (outer == 0)) || inner != 1)
    {
      previous_reachable_states_bdd = bdd_dup(reachable_states_bdd);

      /* saturates lower levels */
      if(DPListIsNotEmpty(DPListNext(list)))
	McSaturation_SaturateRecur(DPListNext(list), layer);

      /* computes the new frontier */
      {
	bdd_ptr tmp = bdd_not(dd_manager, previous_reachable_states_bdd);
	frontier = bdd_and(dd_manager, reachable_states_bdd, tmp);
	bdd_free(dd_manager, tmp);
      }

      /* free the reachable states at last iteration */
      bdd_free(dd_manager, previous_reachable_states_bdd);

      fix_point = bdd_count_states(dd_manager, frontier) == 0;

      outer++;
    }
  } while(!fix_point);

  if (opt_verbose_level_gt(options, 3))
    fprintf(nusmv_stderr,
	"        on level %d at layer %d outer loop contains %d iteration(s)\n",
	level, layer, outer);

  /* free the last frontier */
  bdd_free(dd_manager, frontier);

  if (opt_verbose_level_gt(options, 1))
    fprintf(nusmv_stderr, "    finished saturation of level %d for layer %d\n",
	level, layer);
}

static void McSaturation_Burch(DPList list) {
  /* frontier generated by last iteration */
  bdd_ptr frontier;
  /* true if last outer iteration reached a fix point */
  int fix_point;
  /* level at which we are currently working */
  int level = DPListLength(list)-1;
  /* number of outer iterations before reaching a fix point */
  int outer;
  DPList curr ;
  bdd_ptr previous_reachable_states_bdd, global_previous_reachable_states_bdd;
  outer = 0;

  do {
    /* set of states reachable before image computation */
    global_previous_reachable_states_bdd = bdd_dup(reachable_states_bdd);

    /* number of inner iterations before reaching a fix point */
    int inner = 0;

    for( curr=list; curr = DPListNext(curr); DPListIsNotEmpty(DPListNext(curr)) ) {
      /* Descriptor of current process */
      DPDesc *desc = DPListGetItem(curr);

      if (opt_verbose_level_gt(options, 1)) {
	char *name = DPDescGetName(desc);
	fprintf(nusmv_stderr, "    starting burch saturation : (%s)\n",  name);
      }

      /* the initial frontier is the whole reachable states */
      frontier = bdd_dup(reachable_states_bdd);
      /* The bdd of the support variables */
      bdd_ptr support_bdd_current = DPDescGetSupportBDD(desc);
      /* The array to shift the support variable backward */
      int *support_vars_backward = DPDescGetSupportVector(desc);
      /* The transition relation for this layer */
      CPList trans = DPDescGetCList(desc);
      /* Name of the process */
      char *name = DPDescGetName(desc);

      do {
	/* the reachable states before last step */
	previous_reachable_states_bdd = bdd_dup(reachable_states_bdd);

	/* intersect the frontier with normal assignments  */
	bdd_and_accumulate(dd_manager, &frontier, invar_bdd_saturation);

	{
	  /* set of new states */
	  bdd_ptr new_states;

	  /* computes the forward image from the current reachable states */
	  {
#ifndef NO_PRINT_STATES
	    fprintf(nusmv_stdout, "@@@@ Applying transition relation for process %s\n", name);
#endif /* NO_PRINT_STATES */
#ifndef NO_PRINT_STATES
	    fprintf(nusmv_stdout, "@@@@ Frontier\n");
	    dd_printminterm(dd_manager, frontier);
	    fprintf(nusmv_stdout, "@@@@\n");
#endif

	    if(opt_equality_reduced(options))
	    {
	      bdd_ptr tmp = (bdd_ptr) CPImageBoth(dd_manager, trans,
		  frontier, support_bdd_current);
	      new_states = bdd_shift_set(dd_manager, tmp, support_vars_backward);
	      bdd_free(dd_manager, tmp);
	    }
	    else
	    {
	      bdd_ptr tmp = (bdd_ptr) CPImageBoth(dd_manager, trans,
		  frontier, vars_saturation);
	      new_states = bdd_shift_backward(dd_manager, tmp);
	      bdd_free(dd_manager, tmp);
	    }

#ifndef NO_PRINT_STATES
	    fprintf(nusmv_stdout, "@@@@ Image (after shifting)\n");
	    dd_printminterm(dd_manager, new_states);
	    fprintf(nusmv_stdout, "@@@@\n");
#endif
	  }

	  /* add the new states to the set of reachable states */
	  bdd_or_accumulate(dd_manager, &reachable_states_bdd, new_states);

	  bdd_free(dd_manager, new_states);
	}

	/* free the last frontier */
	bdd_free(dd_manager, frontier);

	/* computes the new frontier */
	{
	  bdd_ptr tmp = bdd_not(dd_manager, previous_reachable_states_bdd);
	  frontier = bdd_and(dd_manager, reachable_states_bdd, tmp);
	  bdd_free(dd_manager, tmp);
	}
	/*
	   {
	   static int i = 0;
	   if (opt_verbose_level_gt(options, 1))
	   {
	   fprintf(nusmv_stderr,
	   "      iteration %d: BDD size = %d, frontier size = %d, states = %g\n",
	   i, bdd_size(dd_manager, reachable_states_bdd),
	   bdd_size(dd_manager, frontier),
	   bdd_count_states(dd_manager, reachable_states_bdd));
	   }
	   i++;

	   }
	   i*/
	bdd_free(dd_manager, previous_reachable_states_bdd);

	fix_point = bdd_count_states(dd_manager, frontier) == 0;

	inner++;
      } while(!fix_point);
      bdd_free(dd_manager, frontier);

    } // "for" iteration over all processes ends


#if 0
    if (opt_verbose_level_gt(options, 1))
      fprintf(nusmv_stderr, "        on level %d at layer %d inner loop contains %d iteration(s)\n", level, layer, inner);

    if(((layer != level) && (outer == 0)) || inner != 1)
    {
      previous_reachable_states_bdd = bdd_dup(reachable_states_bdd);
      /* saturates lower levels */
      if(DPListIsNotEmpty(DPListNext(list)))
	McSaturation_SaturateRecur(DPListNext(list), layer);
#endif
      /* computes the new frontier */
      {
	bdd_ptr tmp = bdd_not(dd_manager, global_previous_reachable_states_bdd);
	frontier = bdd_and(dd_manager, reachable_states_bdd, tmp);
	bdd_free(dd_manager, tmp);
      }
      /* free the reachable states at last iteration */
      bdd_free(dd_manager, global_previous_reachable_states_bdd);
      fix_point = bdd_count_states(dd_manager, frontier) == 0;
      /*
	 outer++;
	 }*/
      bdd_free(dd_manager, frontier);


  } while(!fix_point);

  /*if (opt_verbose_level_gt(options, 3))
    fprintf(nusmv_stderr, "        on level %d at layer %d outer loop contains %d iteration(s)\n", level, layer, outer);
    */
  /* free the last frontier */
  //bdd_free(dd_manager, frontier);
  /*
     if (opt_verbose_level_gt(options, 1))
     fprintf(nusmv_stderr, "    finished saturation of level %d for layer %d\n",
     level, layer);*/

} // end McSaturation_Burch


void McSaturation_compute_reachable_states(Fsm_BddPtr fsm) {
  bdd_ptr init_bdd;
  DPList list;

  if (opt_verbose_level_gt(options, 1))
    fprintf(nusmv_stderr, "\ncomputing reachable state space by saturation...\n");

  /* set of initial states */
  init_bdd = Compile_FsmBddGetInit(fsm);

  /* set of invariant states */
  invar_bdd_saturation = Compile_FsmBddGetInvar(fsm);

  /* quantify over the present input and state variables */
  vars_saturation = bdd_and(dd_manager, input_variables_bdd,
      state_variables_bdd);

  /* initially the reachable states are the initial states */
  reachable_states_bdd = bdd_dup(init_bdd);

  /* build a DPList out of the given CPList in reversed order */
  {
    /* extract the transition relation */
    DPTrans_Ptr trans = Compile_FsmBddGetSaturation(fsm);
    /* extract the forward transition relation list */
    list = DPTransGetForward(trans);
    list = DPListReverse(list);
  }

#if BURCH
		McSaturation_Burch(list);
#else
  {
    /* lengths of the transition relation list */
    int layers = DPListLength(list);
    DPList reversed_lists[layers];
    DPList iter;
    int layer;

    iter = list;
    for(layer = 0; layer < layers; layer++)
    {
      reversed_lists[layers - layer - 1] = iter;
      iter = cdr(iter);
    }
    for(layer = 0; layer < layers; layer++)
    {
      {
	char *name = DPDescGetName(DPListGetItem(reversed_lists[layer]));
	fprintf(nusmv_stderr, "  starting layer %d (%s)\n", layer, name);
      }

      McSaturation_SaturateRecur(reversed_lists[layer], layer);
      fprintf(nusmv_stderr,
	  "  finished layer %d: BDD size = %d, states = %g\n",
	  layer,
	  bdd_size(dd_manager, reachable_states_bdd),
	  bdd_count_states(dd_manager, reachable_states_bdd));
    }
  }
#endif

  /* free the static variables */
  bdd_free(dd_manager, invar_bdd_saturation);
  bdd_free(dd_manager, vars_saturation);

  if(opt_dump_bdds(options))
  {
    FILE *fp = fopen("reachable.dot", "w");
    Cudd_DumpDot(dd_manager, 1, &reachable_states_bdd, NULL, NULL, fp);
    fclose(fp);
    Cudd_PrintDebug(dd_manager, reachable_states_bdd, 4, 4);
  }
}
