/**CHeaderFile*****************************************************************

  FileName    [mcInt.h]

  PackageName [mc]

  Synopsis    [Internal header file of the mc package.]

  Description [Internal header file of the mc package.]

  SeeAlso     [ mcMc.c mcExplain.c]

  Author      [Marco Roveri]

  Copyright   [
  This file is part of the ``mc'' package of NuSMV version 2. 
  Copyright (C) 1998-2001 by CMU and ITC-irst. 

  NuSMV version 2 is free software; you can redistribute it and/or 
  modify it under the terms of the GNU Lesser General Public 
  License as published by the Free Software Foundation; either 
  version 2 of the License, or (at your option) any later version.

  NuSMV version 2 is distributed in the hope that it will be useful, 
  but WITHOUT ANY WARRANTY; without even the implied warranty of 
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU 
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public 
  License along with this library; if not, write to the Free Software 
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA.

  For more information of NuSMV see <http://nusmv.irst.itc.it>
  or email to <nusmv-users@irst.itc.it>.
  Please report bugs to <nusmv-users@irst.itc.it>.

  To contact the NuSMV development board, email to <nusmv@irst.itc.it>. ]

  Revision    [$Id: mcInt.h,v 1.1.1.1 2003/02/06 19:01:17 flerda Exp $]

******************************************************************************/

#ifndef _MCINT
#define _MCINT

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <assert.h>

#include "sm.h"
#include "util.h"
#include "utils.h"
#include "node.h"
#include "set.h"
#include "dd.h"
#include "rbc.h"
#include "grammar.h"
#include "parser.h"
#include "compile.h"
#include "img.h"
#include "opt.h"
#include "prop.h"
#include "mc.h"
#include "cmd.h"

/*---------------------------------------------------------------------------*/
/* Variable declarations                                                     */
/*---------------------------------------------------------------------------*/

extern FILE * nusmv_stderr;
extern FILE * nusmv_stdout;
extern DdManager * dd_manager;
extern int yylineno;
extern options_ptr options;
extern cmp_struct_ptr cmps;

extern node_ptr one_number;
extern node_ptr zero_number;

extern bdd_ptr invar_bdd;
extern bdd_ptr init_bdd;
extern bdd_ptr reachable_states_bdd;
extern node_ptr reachable_states_layers;
extern node_ptr fairness_constraints_bdd;
extern bdd_ptr fair_states_bdd;

extern node_ptr real_state_variables;
extern add_ptr process_selector_add;
extern bdd_ptr input_variables_bdd;
extern node_ptr all_variables;
extern node_ptr all_symbols;

/*---------------------------------------------------------------------------*/
/* Function prototypes                                                       */
/*---------------------------------------------------------------------------*/
EXTERN node_ptr ex_explain       ARGS((Fsm_BddPtr, node_ptr, bdd_ptr));
EXTERN node_ptr eu_explain       ARGS((Fsm_BddPtr, node_ptr, bdd_ptr, bdd_ptr));
EXTERN node_ptr ebu_explain      ARGS((Fsm_BddPtr, node_ptr, bdd_ptr, bdd_ptr, int, int));
EXTERN node_ptr eg_explain       ARGS((Fsm_BddPtr, node_ptr, bdd_ptr));
EXTERN node_ptr ebg_explain      ARGS((Fsm_BddPtr, node_ptr, bdd_ptr, int, int));

#endif /* _MCINT */
