/**CHeaderFile*****************************************************************

  FileName    [mc.h]

  PackageName [mc]

  Synopsis    [Fair CTL model checking algorithms. External header file.]

  Description [Fair CTL model checking algorithms. External header file.]

  Author      [Marco Roveri]

  Revision    [$Id: mc.h,v 1.1.1.1 2003/02/06 19:01:17 flerda Exp $]

  Copyright   [
  This file is part of the ``mc'' package of NuSMV version 2. 
  Copyright (C) 1998-2001 by CMU and ITC-irst. 

  NuSMV version 2 is free software; you can redistribute it and/or 
  modify it under the terms of the GNU Lesser General Public 
  License as published by the Free Software Foundation; either 
  version 2 of the License, or (at your option) any later version.

  NuSMV version 2 is distributed in the hope that it will be useful, 
  but WITHOUT ANY WARRANTY; without even the implied warranty of 
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU 
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public 
  License along with this library; if not, write to the Free Software 
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA.

  For more information of NuSMV see <http://nusmv.irst.itc.it>
  or email to <nusmv-users@irst.itc.it>.
  Please report bugs to <nusmv-users@irst.itc.it>.

  To contact the NuSMV development board, email to <nusmv@irst.itc.it>. ]

******************************************************************************/

#ifndef _MC
#define _MC

#include "util.h"
#include "dd.h"
#include "opt.h"
#include "prop.h"

/*---------------------------------------------------------------------------*/
/* Function prototypes                                                       */
/*---------------------------------------------------------------------------*/

EXTERN void Mc_Init ARGS((void));
EXTERN void Mc_End ARGS((void));
EXTERN void Mc_CheckCTLSpec ARGS((Prop_Ptr prop));
EXTERN void Mc_CheckAGOnlySpec ARGS((Prop_Ptr prop));
EXTERN void Mc_CheckCompute ARGS((Prop_Ptr prop));
EXTERN void Mc_CheckInvar ARGS((Prop_Ptr prop));
EXTERN void check_spec ARGS((node_ptr));
EXTERN void check_compute ARGS((node_ptr));
EXTERN void check_transition_relation ARGS((Fsm_BddPtr));
EXTERN void check_invar ARGS((node_ptr));
EXTERN void check_invar_fb ARGS((node_ptr));
EXTERN void check_invar_strong ARGS((node_ptr));
EXTERN void check_after ARGS((node_ptr));
EXTERN void print_spec  ARGS((FILE *file, node_ptr n));
EXTERN void print_invar ARGS((FILE *file, node_ptr n));
EXTERN void print_compute ARGS((FILE *, node_ptr));
EXTERN bdd_ptr  compute_fair_states      ARGS((Fsm_BddPtr));
EXTERN bdd_ptr Mc_ComputeFairStates ARGS((Fsm_BddPtr)); 
EXTERN node_ptr Mc_ComputeJusticeConstraints ARGS((Fsm_BddPtr, node_ptr));
EXTERN node_ptr Mc_ComputeCompassionConstraints ARGS((Fsm_BddPtr, node_ptr));
EXTERN void     compute_reachable_states ARGS((Fsm_BddPtr));
EXTERN bdd_ptr  ex      ARGS((Fsm_BddPtr, bdd_ptr));
EXTERN bdd_ptr  ef      ARGS((Fsm_BddPtr, bdd_ptr));
EXTERN bdd_ptr  eg      ARGS((Fsm_BddPtr, bdd_ptr));
EXTERN bdd_ptr  eu      ARGS((Fsm_BddPtr, bdd_ptr, bdd_ptr));
EXTERN bdd_ptr  au      ARGS((Fsm_BddPtr, bdd_ptr, bdd_ptr));
EXTERN bdd_ptr  ebu     ARGS((Fsm_BddPtr, bdd_ptr, bdd_ptr, int, int));
EXTERN bdd_ptr  abu     ARGS((Fsm_BddPtr, bdd_ptr, bdd_ptr, int, int));
EXTERN bdd_ptr  ebf     ARGS((Fsm_BddPtr, bdd_ptr, int, int));
EXTERN bdd_ptr  ebg     ARGS((Fsm_BddPtr, bdd_ptr, int, int));
EXTERN int      minu    ARGS((Fsm_BddPtr, bdd_ptr, bdd_ptr));
EXTERN int      maxu    ARGS((Fsm_BddPtr, bdd_ptr, bdd_ptr));
EXTERN node_ptr explain ARGS((Fsm_BddPtr, node_ptr, node_ptr, node_ptr));
EXTERN node_ptr ex_explain ARGS((Fsm_BddPtr, node_ptr, bdd_ptr));
EXTERN bdd_ptr  eval_spec      ARGS((Fsm_BddPtr, node_ptr, node_ptr));
EXTERN node_ptr eval_formula_list ARGS((Fsm_BddPtr, node_ptr, node_ptr));
EXTERN void     free_formula_list ARGS((DdManager *, node_ptr));
EXTERN int      eval_compute   ARGS((Fsm_BddPtr, node_ptr, node_ptr));
EXTERN int      check_AG_only  ARGS((Fsm_BddPtr, node_ptr, node_ptr));
EXTERN node_ptr make_AG_counterexample ARGS((Fsm_BddPtr, node_ptr, bdd_ptr));
EXTERN int      check_invariant_forward     ARGS((Fsm_BddPtr, node_ptr));
EXTERN void     check_invariant_forward_opt ARGS((Fsm_BddPtr, node_ptr));
EXTERN void     check_invariant_forward_backward    ARGS((Fsm_BddPtr, node_ptr));
EXTERN void     check_invariant_forward_backward_op ARGS((Fsm_BddPtr, node_ptr));
EXTERN bdd_ptr  trans_is_total                      ARGS((Fsm_BddPtr));
EXTERN void     print_explanation           ARGS((node_ptr, node_ptr));
EXTERN void     print_reachable_states      ARGS((Fsm_BddPtr,int));
EXTERN void     init_traces_hash      ARGS((void));
EXTERN void     insert_traces_hash    ARGS((node_ptr, node_ptr));
EXTERN node_ptr lookup_traces_hash    ARGS((node_ptr));
EXTERN void     clear_traces_hash     ARGS((void));
EXTERN boolean  current_state_bdd_exist   ARGS((void));
EXTERN boolean  current_state_label_exist ARGS((void));
EXTERN boolean  current_state_exist       ARGS((void));
EXTERN bdd_ptr  current_state_bdd_get     ARGS((void));
EXTERN node_ptr current_state_label_get   ARGS((void)); 
EXTERN void     inc_trace_number          ARGS((void));
EXTERN void     dec_trace_number          ARGS((void));
EXTERN int      get_trace_number          ARGS((void));
EXTERN void     reset_trace_number        ARGS((void));
EXTERN node_ptr trace_get_new_label       ARGS((void));
EXTERN node_ptr trace_get_new_statelabel  ARGS((int));
EXTERN node_ptr trace_mk_statelabel       ARGS((int, int));
EXTERN int      trace_label_get_state     ARGS((node_ptr));
EXTERN int      trace_label_get_trace     ARGS((node_ptr));
EXTERN void     current_state_bdd_free    ARGS((void));
EXTERN void     current_state_label_reset ARGS((void));
EXTERN void     current_state_bdd_reset   ARGS((void));
EXTERN void     current_state_bdd_set     ARGS((bdd_ptr));
EXTERN void     current_state_set         ARGS((bdd_ptr, node_ptr));
EXTERN void     current_state_label_set   ARGS((node_ptr));

#endif /* _MC */
