/**CHeaderFile*****************************************************************

  FileName    [ltlInt.h]

  PackageName [ltl]

  Synopsis    [Internal header of the <tt>ltl</tt> package.]

  Author      [Marco Roveri]

  Copyright   [
  This file is part of the ``ltl'' package of NuSMV version 2. 
  Copyright (C) 1998-2001 by CMU and ITC-irst. 

  NuSMV version 2 is free software; you can redistribute it and/or 
  modify it under the terms of the GNU Lesser General Public 
  License as published by the Free Software Foundation; either 
  version 2 of the License, or (at your option) any later version.

  NuSMV version 2 is distributed in the hope that it will be useful, 
  but WITHOUT ANY WARRANTY; without even the implied warranty of 
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU 
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public 
  License along with this library; if not, write to the Free Software 
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA.

  For more information of NuSMV see <http://nusmv.irst.itc.it>
  or email to <nusmv-users@irst.itc.it>.
  Please report bugs to <nusmv-users@irst.itc.it>.

  To contact the NuSMV development board, email to <nusmv@irst.itc.it>. ]

  Revision    [$Id: ltlInt.h,v 1.1.1.1 2003/02/06 19:01:18 flerda Exp $]

******************************************************************************/

#ifndef _LTL_INT
#define _LTL_INT

#include <stdlib.h>
#include <stdio.h>
#include "util.h"
#include "utils.h"
#include "node.h"
#include "dd.h"
#include "set.h"
#include "rbc.h"
#include "grammar.h"
#include "parser.h"
#include "compile.h"
#include "mc.h"
#include "img.h"
#include "opt.h"
#include "cmd.h"
#include "prop.h"
#include "ltl.h"

/*---------------------------------------------------------------------------*/
/* Variable declarations                                                     */
/*---------------------------------------------------------------------------*/
extern add_ptr input_variables_add;
extern bdd_ptr input_variables_bdd;
extern add_ptr next_input_variables_add;
extern bdd_ptr next_input_variables_bdd;
extern add_ptr state_variables_add;
extern bdd_ptr state_variables_bdd;
extern add_ptr next_state_variables_add;
extern bdd_ptr next_state_variables_bdd;
extern node_ptr state_variables;
extern node_ptr input_variables;
extern node_ptr all_symbols;
extern node_ptr all_variables;
extern options_ptr options;
extern cmp_struct_ptr cmps;
extern bdd_ptr trans_bdd;
extern bdd_ptr fair_states_bdd;
extern node_ptr fairness_constraints_bdd;
extern node_ptr real_state_variables;
extern FILE * nusmv_stdout;
extern FILE * nusmv_stderr;
extern DdManager * dd_manager;
extern bdd_ptr invar_bdd;
extern bdd_ptr init_bdd;
extern node_ptr parse_tree;

/*---------------------------------------------------------------------------*/
/* Function prototypes                                                       */
/*---------------------------------------------------------------------------*/

EXTERN node_ptr witness ARGS((Fsm_BddPtr fsm,bdd_ptr feasible));
EXTERN bdd_ptr feasible ARGS((Fsm_BddPtr fsm));

#endif /* _LTL_INT */
