/**CHeaderFile*****************************************************************

  FileName    [img.h]

  PackageName [img]

  Synopsis    [Methods for performing image computations.]

  Description [This package is used to compute the image (forward or
  backward) of a set of states. The problem of computing images is fundamental
  in many symbolic analisys techniques (reachability analisys, model
  checking of CTL formulas, ...). The "img" package offers the user an
  interface which is independent from the techique choosen to represent
  the transition relation. 

  Actually 3 methods are offered to users:
  <ul>
  <li><b>Monolithic</b>: This is the most naive approach possible. A
       single relation <it>R(s,s')</it> is constructed during the compilation.</li>
  <li><b>Conjunctive</b>: The transition relation is decomposed in an
      implicit conjunction of transition relations (usually called
      clusters). This technique is based on the early quantification
      heuristic.
      <ul>
      <li><b>No heuristic (Threshold)</b>: In this method the clusters are 
          built according to a given threshold. After the clustering the
          early quantification is performed.</li>
      <li><b>IWLS95</b>: In this method is an improvement of the
          above. First of all for each variable is constructed its
          transition function. Then these transitions (which are
          implicitly conjoined) are ordered according to the algorithm
          described in "Efficient BDD Algorithms for FSM Synthesis and
          Verification", by R. K. Ranjan et. al. in the proceedings of
          IWLS'95. After this ordering the transition relations are
          grouped together, making a cluster whenever the BDD size (number
          of BDD nodes) reaches a threshold. After the clustering,
          clusters are ordered according the IWLS95 algorithm. In this
          method the order of clusters is differente for forward and
          backward image computation, and the corresponding routines
          are called with the appropriate order of clustering and
          early quantification schedule.</li>
      </ul>
      </li>
  </ul>
  ]

  Author      [Marco Roveri and Emanuele Olivetti]

  Copyright   [
  This file is part of the ``img'' package of NuSMV version 2. 
  Copyright (C) 1998-2001 by CMU and ITC-irst. 

  NuSMV version 2 is free software; you can redistribute it and/or 
  modify it under the terms of the GNU Lesser General Public 
  License as published by the Free Software Foundation; either 
  version 2 of the License, or (at your option) any later version.

  NuSMV version 2 is distributed in the hope that it will be useful, 
  but WITHOUT ANY WARRANTY; without even the implied warranty of 
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU 
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public 
  License along with this library; if not, write to the Free Software 
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA.

  For more information of NuSMV see <http://nusmv.irst.itc.it>
  or email to <nusmv-users@irst.itc.it>.
  Please report bugs to <nusmv-users@irst.itc.it>.

  To contact the NuSMV development board, email to <nusmv@irst.itc.it>. ]

  Revision    [$Id: img.h,v 1.2 2003/05/07 19:00:43 flerda Exp $]

******************************************************************************/

#ifndef _IMG
#define _IMG
/*---------------------------------------------------------------------------*/
/* Function prototypes                                                       */
/*---------------------------------------------------------------------------*/

EXTERN bdd_ptr Img_ImageBwd ARGS((Fsm_BddPtr, bdd_ptr));
EXTERN bdd_ptr Img_ImageFwd ARGS((Fsm_BddPtr, bdd_ptr)); 
EXTERN int Img_Check ARGS((void));
EXTERN int Img_CheckNoCone ARGS((void));
EXTERN bdd_ptr CPImageBoth ARGS((DdManager *, CPList, bdd_ptr, bdd_ptr));

#endif /* _IMG */

