/**CFile***********************************************************************

  FileName    [compileThreshold.c]

  PackageName [compile]

  Synopsis    [Routines to performs the computation of the
  conjunctively decomposed transition relation.]

  Description [Routines to performs the computation of the
  conjunctively decomposed transition relation.]

  SeeAlso     [compileMono.c, compileIwls95.c]

  Author      [Marco Roveri and Emanuele Olivetti]

  Copyright   [
  This file is part of the ``compile'' package of NuSMV version 2. 
  Copyright (C) 1998-2001 by CMU and ITC-irst. 

  NuSMV version 2 is free software; you can redistribute it and/or 
  modify it under the terms of the GNU Lesser General Public 
  License as published by the Free Software Foundation; either 
  version 2 of the License, or (at your option) any later version.

  NuSMV version 2 is distributed in the hope that it will be useful, 
  but WITHOUT ANY WARRANTY; without even the implied warranty of 
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU 
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public 
  License along with this library; if not, write to the Free Software 
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA.

  For more information of NuSMV see <http://nusmv.irst.itc.it>
  or email to <nusmv-users@irst.itc.it>.
  Please report bugs to <nusmv-users@irst.itc.it>.

  To contact the NuSMV development board, email to <nusmv@irst.itc.it>. ]

******************************************************************************/

#include "compileInt.h" 

static char rcsid[] UTIL_UNUSED = "$Id: compileThreshold.c,v 1.2 2003/02/13 18:21:39 flerda Exp $";

/* Set this to 1 for activating debugging of conjunctive-threshold routines */
/* It slow down the system performances. */
#define DEBUG_THRESHOLD 0

/*---------------------------------------------------------------------------*/
/* Variable declarations                                                     */
/*---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*/
/* Static function prototypes                                                */
/*---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*/
/* Definition of exported functions                                          */
/*---------------------------------------------------------------------------*/
/**Function********************************************************************

  Synopsis           [Builds an implicitly conjoined transition relation.]

  Description        [This function builds the BDD representing the
  implicitly conjoined transition relation. The third argument (that's
  "assumption") is the set of states to which the transition relation
  has to be restricted to.]

  SideEffects        []

  SeeAlso            [Compile_BuildModelMono Compile_BuildModelIwls95]

******************************************************************************/
CPTrans_Ptr Compile_BuildModelThreshold(node_ptr list_variables,
					int threshold, 
					bdd_ptr assumption)
{
  CPTrans_Ptr result;
  bdd_ptr vars;
  CPList cluster_bdd = CPListEmpty;
  CPList fwd_trans = CPListEmpty;
  CPList bwd_trans = CPListEmpty;

  /* converting variables list to bdd list */
  cluster_bdd = CPListBuildElementaryBDDList(list_variables, assumption);

  if (opt_affinity(options) != true) {    
    /* Threshold clustering */
    CPListBuildThreshold(dd_manager, cluster_bdd, &fwd_trans, threshold);
  }
  else {
    /* Threshold clustering with affinity */
    compileCPMakeAffinityClusters(dd_manager, cluster_bdd, &fwd_trans, threshold);
  }

  /* backward and forward trans are the same */
  bwd_trans = CPListDup(fwd_trans);


  /* Fill forward cluster list with variables schedule */
  vars = bdd_and(dd_manager, state_variables_bdd, input_variables_bdd);
  CPListBuildSchedule(fwd_trans, vars);
  bdd_free(dd_manager, vars);

  /* Fill backward cluster list with variables schedule */
  vars = bdd_and(dd_manager, next_state_variables_bdd, next_input_variables_bdd);
  CPListBuildSchedule(bwd_trans, vars);
  bdd_free(dd_manager, vars);

  /* building the result */
  result = CPTransAlloc(); 
  CPTransSetForward(result, fwd_trans);
  CPTransSetBackward(result, bwd_trans);

  if (opt_verbose_level_gt(options, 1)) {
    CPTransPrintInfo(nusmv_stderr, result);
  }

#if DEBUG_THRESHOLD
  compileCPCheckPartitionedTransition(result, list_variables, assumption);
#endif

  return(result);
}
