/**CFile***********************************************************************

  FileName    [compilePO.c]

  PackageName [compile]

  Synopsis    [Routines to performs the computation of the
  conjunctively decomposed transition relation.]

  Description [Routines to performs the computation of the
  conjunctively decomposed transition relation.]

  SeeAlso     [compileMono.c, compileIwls95.c]

  Author      [Flavio Lerda]

  Copyright   [
  This file is part of the ``compile'' package of NuSMV version 2. 
  Copyright (C) 1998-2001 by CMU and ITC-irst. 

  NuSMV version 2 is free software; you can redistribute it and/or 
  modify it under the terms of the GNU Lesser General Public 
  License as published by the Free Software Foundation; either 
  version 2 of the License, or (at your option) any later version.

  NuSMV version 2 is distributed in the hope that it will be useful, 
  but WITHOUT ANY WARRANTY; without even the implied warranty of 
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU 
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public 
  License along with this library; if not, write to the Free Software 
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA.

  For more information of NuSMV see <http://nusmv.irst.itc.it>
  or email to <nusmv-users@irst.itc.it>.
  Please report bugs to <nusmv-users@irst.itc.it>.

  To contact the NuSMV development board, email to <nusmv@irst.itc.it>. ]

******************************************************************************/

#include "compileInt.h" 

static char rcsid[] UTIL_UNUSED = "$Id: compilePO.c,v 1.3 2003/10/28 17:29:17 flerda Exp $";

/*---------------------------------------------------------------------------*/
/* Variable declarations                                                     */
/*---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*/
/* Static function prototypes                                                */
/*---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*/
/* Definition of exported functions                                          */
/*---------------------------------------------------------------------------*/
/**Function********************************************************************

  Synopsis           [Builds an process partitioned transition relation.]

  Description        [This function builds the BDD representing the
  transition relation partitioned by process.]

  SideEffects        []

  SeeAlso            [Compile_BuildModelMono Compile_BuildModelIwls95]

******************************************************************************/
DPTrans_Ptr Compile_BuildModelPhase1(node_ptr list_variables,
					node_ptr procs_expr,
					bdd_ptr assumption)
{
  DPTrans_Ptr result;
  bdd_ptr vars;
  DPList cluster_bdd = DPListEmpty;
  DPList fwd_trans = DPListEmpty;
  DPList bwd_trans = DPListEmpty;

  fwd_trans = DPListBuildProcs(list_variables, procs_expr, PT_Phase1, assumption);

  /* backward and forward trans are the same */
  bwd_trans = DPListDup(fwd_trans);

  /* Fill forward cluster list with variables schedule */
  vars = bdd_and(dd_manager, state_variables_bdd, input_variables_bdd);
  DPListBuildSchedule(fwd_trans, vars);
  bdd_free(dd_manager, vars);

  /* Fill backward cluster list with variables schedule */
  vars = bdd_and(dd_manager, next_state_variables_bdd, next_input_variables_bdd);
  DPListBuildSchedule(bwd_trans, vars);
  bdd_free(dd_manager, vars);

  /* building the result */
  result = DPTransAlloc(); 
  DPTransSetForward(result, fwd_trans);
  DPTransSetBackward(result, bwd_trans);

  if (opt_verbose_level_gt(options, 1)) {
    DPTransPrintInfo(nusmv_stderr, result);
  }

  return(result);
}
/**Function********************************************************************

  Synopsis           [Builds an process partitioned transition relation.]

  Description        [This function builds the BDD representing the
  transition relation partitioned by process.]

  SideEffects        []

  SeeAlso            [Compile_BuildModelMono Compile_BuildModelIwls95]

******************************************************************************/
DPTrans_Ptr Compile_BuildModelPhase2(node_ptr list_variables,
					node_ptr procs_expr,
					bdd_ptr assumption)
{
  DPTrans_Ptr result;
  bdd_ptr vars;
  DPList cluster_bdd = DPListEmpty;
  DPList fwd_trans = DPListEmpty;
  DPList bwd_trans = DPListEmpty;

  fwd_trans = DPListBuildProcs(list_variables, procs_expr, PT_Phase2, assumption);

  /* backward and forward trans are the same */
  bwd_trans = DPListDup(fwd_trans);

  /* Fill forward cluster list with variables schedule */
  vars = bdd_and(dd_manager, state_variables_bdd, input_variables_bdd);
  DPListBuildSchedule(fwd_trans, vars);
  bdd_free(dd_manager, vars);

  /* Fill backward cluster list with variables schedule */
  vars = bdd_and(dd_manager, next_state_variables_bdd, next_input_variables_bdd);
  DPListBuildSchedule(bwd_trans, vars);
  bdd_free(dd_manager, vars);

  /* building the result */
  result = DPTransAlloc(); 
  DPTransSetForward(result, fwd_trans);
  DPTransSetBackward(result, bwd_trans);

  if (opt_verbose_level_gt(options, 1)) {
    DPTransPrintInfo(nusmv_stderr, result);
  }

  return(result);
}
