/**CFile***********************************************************************

  FileName    [compileMono.c]

  PackageName [compile]

  Synopsis    [Routines to performs the computation of the monolithic
  transition relation.]

  Description [Routines to performs the computation of the monolithic
  transition relation.]

  SeeAlso     [compileIwls95.c, compileThreshold.c]

  Author      [Marco Roveri and Emanuele Olivetti]

  Copyright   [
  This file is part of the ``compile'' package of NuSMV version 2. 
  Copyright (C) 1998-2001 by CMU and ITC-irst. 

  NuSMV version 2 is free software; you can redistribute it and/or 
  modify it under the terms of the GNU Lesser General Public 
  License as published by the Free Software Foundation; either 
  version 2 of the License, or (at your option) any later version.

  NuSMV version 2 is distributed in the hope that it will be useful, 
  but WITHOUT ANY WARRANTY; without even the implied warranty of 
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU 
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public 
  License along with this library; if not, write to the Free Software 
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA.

  For more information of NuSMV see <http://nusmv.irst.itc.it>
  or email to <nusmv-users@irst.itc.it>.
  Please report bugs to <nusmv-users@irst.itc.it>.

  To contact the NuSMV development board, email to <nusmv@irst.itc.it>. ]

******************************************************************************/

#include "compileInt.h" 

static char rcsid[] UTIL_UNUSED = "$Id: compileMono.c,v 1.1.1.1 2003/02/06 19:01:17 flerda Exp $";

/*---------------------------------------------------------------------------*/
/* Variable declarations                                                     */
/*---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*/
/* Definition of exported functions                                          */
/*---------------------------------------------------------------------------*/
/**Function********************************************************************

  Synopsis           [Builds the monolithic transition relation into CP 
                      structure.]

  Description        [Starting from the the list of variables builds
  the corresponding transition relation. The result is restricted to
  the set <tt>assumption</tt> using the Coudert and Madre algorithm.]

  SideEffects        []

  SeeAlso            [Compile_CompileModel]

******************************************************************************/
CPTrans_Ptr Compile_BuildModelMonolithic(node_ptr list_variables, bdd_ptr assumption)
{
  CPTrans_Ptr result = CPTransAlloc();
  
  CPList cluster_bwd = CPListEmpty;
  CPList cluster_fwd = CPListEmpty;
  
  CPCluster * BCi = CPClusterAlloc();
  CPCluster * FCi = CPClusterAlloc();

  bdd_ptr mono_trans;

  if (opt_verbose_level_gt(options, 1)) {
    print_in_process("Evaluating next() assignments and TRANS statements", Nil);
  }

  /* Building monolithic transition relation BDD */
  mono_trans = bdd_dup(CPListBuildMonolithicBDD(list_variables, assumption));

  /* Filling CP structure */

  /* backward */
  CPClusterSetTi(BCi, bdd_dup(mono_trans));
  CPClusterSetEi(BCi, bdd_and(dd_manager, next_input_variables_bdd, next_state_variables_bdd));
  cluster_bwd = CPListAlloc(BCi);
  CPTransSetBackward(result, cluster_bwd);

  /* forward */
  CPClusterSetTi(FCi, bdd_dup(mono_trans));
  CPClusterSetEi(FCi, bdd_and(dd_manager, input_variables_bdd, state_variables_bdd));
  cluster_fwd = CPListAlloc(FCi);
  CPTransSetForward(result, cluster_fwd);

  bdd_free(dd_manager, mono_trans);

  if (opt_verbose_level_gt(options, 1)) {
    CPTransPrintInfo(nusmv_stderr, result);
  }

  return(result);
}

/*---------------------------------------------------------------------------*/
/* Definition of static functions                                            */
/*---------------------------------------------------------------------------*/


