/**CHeaderFile*****************************************************************

  FileName    [compileInt.h]

  PackageName [compile]

  Synopsis    [Internal declaration needed for the compilation.]

  Description [This file provides the user routines to perform
  compilation of the read model into BDD.]

  Author      [Marco Roveri]

  Copyright   [
  This file is part of the ``compile'' package of NuSMV version 2. 
  Copyright (C) 1998-2001 by CMU and ITC-irst. 

  NuSMV version 2 is free software; you can redistribute it and/or 
  modify it under the terms of the GNU Lesser General Public 
  License as published by the Free Software Foundation; either 
  version 2 of the License, or (at your option) any later version.

  NuSMV version 2 is distributed in the hope that it will be useful, 
  but WITHOUT ANY WARRANTY; without even the implied warranty of 
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU 
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public 
  License along with this library; if not, write to the Free Software 
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA.

  For more information of NuSMV see <http://nusmv.irst.itc.it>
  or email to <nusmv-users@irst.itc.it>.
  Please report bugs to <nusmv-users@irst.itc.it>.

  To contact the NuSMV development board, email to <nusmv@irst.itc.it>. ]

  Revision    [$Id: compileInt.h,v 1.1.1.1 2003/02/06 19:01:17 flerda Exp $]

******************************************************************************/

#ifndef _compile_int
#define _compile_int

#include "sm.h"
#include "util.h"
#include "utils.h"
#include "node.h"
#include "dd.h"
#include "set.h"
#include "rbc.h"
#include "grammar.h"
#include "parser.h"
#include "compile.h"
#include "mc.h"
#include "img.h"
#include "cmd.h"
#include "opt.h"
#include "prop.h"
#include "ucmd.h"


/*---------------------------------------------------------------------------*/
/* Variable declarations                                                     */
/*---------------------------------------------------------------------------*/
extern options_ptr options;

extern FILE * nusmv_stderr;
extern FILE * nusmv_stdout;

extern int yylineno;

extern DdManager * dd_manager;

extern cmp_struct_ptr cmps;
extern node_ptr parse_tree;
extern node_ptr state_variables;
extern node_ptr real_state_variables;
extern node_ptr all_symbols;
extern node_ptr input_variables;
extern node_ptr all_variables;
extern node_ptr zero_number;
extern node_ptr one_number;
extern node_ptr boolean_type; 

extern node_ptr fairness_constraints_bdd;
extern bdd_ptr fair_states_bdd;

extern add_ptr trans_add;
extern bdd_ptr trans_bdd;

extern node_ptr variable_names[];

extern node_ptr cp_trans_add;
extern node_ptr cp_trans_bdd;
extern node_ptr dp_trans_add;
extern node_ptr dp_trans_bdd;
extern node_ptr forward_quantifiers_add;
extern node_ptr forward_quantifiers_bdd;
extern node_ptr reverse_quantifiers_add;
extern node_ptr reverse_quantifiers_bdd;

extern add_ptr invar_add;
extern bdd_ptr invar_bdd;

extern add_ptr init_add;
extern bdd_ptr init_bdd;

extern add_ptr state_variables_add;
extern bdd_ptr state_variables_bdd;

extern add_ptr next_state_variables_add;
extern bdd_ptr next_state_variables_bdd;

extern add_ptr input_variables_add;
extern bdd_ptr input_variables_bdd;

extern add_ptr next_input_variables_add;
extern add_ptr next_input_variables_bdd;

extern node_ptr running_atom;

extern bdd_ptr running_add;

extern node_ptr proc_selector_internal_vname;
extern add_ptr process_selector_add;
extern node_ptr process_running_symbols;

extern bdd_ptr reachable_states_bdd;

extern node_ptr input_boolean_variables;
extern node_ptr state_boolean_variables;
extern node_ptr determinization_boolean_variables;

/*---------------------------------------------------------------------------*/
/* Function prototypes                                                       */
/*---------------------------------------------------------------------------*/
EXTERN void build_model_monolithic ARGS((node_ptr, node_ptr, node_ptr, add_ptr));

EXTERN void Compile_CompileModelIwls95 ARGS((node_ptr, node_ptr, node_ptr, add_ptr));

EXTERN add_ptr  Compile_EncodeVar ARGS((node_ptr, node_ptr, boolean, boolean));
EXTERN node_ptr Compile_GetOrdering ARGS((void));

EXTERN void     init_check_constant_hash    ARGS((void));
EXTERN void     insert_check_constant_hash  ARGS((node_ptr, node_ptr));
EXTERN node_ptr lookup_check_constant_hash  ARGS((node_ptr));
EXTERN void     clear_check_constant_hash   ARGS((void));

EXTERN void     init_value_hash       ARGS((void));
EXTERN void     insert_value_hash     ARGS((node_ptr, node_ptr));
EXTERN node_ptr lookup_value_hash     ARGS((node_ptr));
EXTERN void     clear_value_hash      ARGS((void));

EXTERN void     init_module_hash      ARGS((void));
EXTERN void     insert_module_hash    ARGS((node_ptr, node_ptr));
EXTERN node_ptr lookup_module_hash    ARGS((node_ptr));
EXTERN void     clear_module_hash     ARGS((void));

EXTERN void     init_constant_hash    ARGS((void));
EXTERN void     insert_constant_hash  ARGS((node_ptr, node_ptr));
EXTERN node_ptr lookup_constant_hash  ARGS((node_ptr));
EXTERN void     clear_constant_hash   ARGS((void));

EXTERN void     init_assign_db_hash       ARGS((void));
EXTERN void     insert_assign_db_hash     ARGS((node_ptr, node_ptr));
EXTERN node_ptr lookup_assign_db_hash     ARGS((node_ptr));
EXTERN void     clear_assign_db_hash      ARGS((void));

EXTERN void Iwls95OrderClusters ARGS((DdManager *, CPList, CPList *,
				bdd_ptr, bdd_ptr, bdd_ptr,
				Iwls95OptionStruct_t *));
EXTERN node_ptr Iwls95ComputeClusterInfo ARGS((DdManager *dd, CPList Q, bdd_ptr PS, bdd_ptr PI, bdd_ptr NS));
EXTERN bdd_ptr Iwls95ComputeClustersCube ARGS((DdManager *, CPList));
EXTERN bdd_ptr Iwls95CubeAnd ARGS((DdManager *, bdd_ptr, bdd_ptr));
EXTERN void Iwls95MakeClusters ARGS((DdManager * dd, CPList RelationList, CPList * NewRelationList, Iwls95OptionStruct_t * Options));

EXTERN int Iwls95PrintOption ARGS((FILE * fp));
EXTERN int CommandIwls95PrintOption ARGS((int argc, char ** argv));
EXTERN int CommandCPPrintClusterInfo ARGS((int argc, char ** argv));

EXTERN void compileFlattenSexpModel ARGS((node_ptr, node_ptr, node_ptr));
EXTERN node_ptr compileFlattenProcess ARGS((node_ptr));
EXTERN node_ptr get_bool_variable_name ARGS((int));

EXTERN void free_variable_sexp_model_hash_free ARGS((void));
EXTERN node_ptr var_model_sexp_build ARGS((node_ptr, node_ptr, node_ptr));
EXTERN node_ptr var_model_sexp_get_init ARGS((node_ptr));
EXTERN node_ptr var_model_sexp_get_invar ARGS((node_ptr));
EXTERN node_ptr var_model_sexp_get_next ARGS((node_ptr vm));

EXTERN void init_variable_sexp_model_hash ARGS((void));
EXTERN void insert_variable_sexp_model_hash ARGS((node_ptr, node_ptr));
EXTERN node_ptr lookup_variable_sexp_model_hash ARGS((node_ptr));
EXTERN void clear_variable_sexp_model_hash ARGS((void));

EXTERN void insert_coi_hash ARGS((node_ptr, Set_t));
EXTERN Set_t lookup_coi_hash ARGS((node_ptr));

EXTERN void insert_define_dep_hash ARGS((node_ptr, Set_t));
EXTERN Set_t lookup_define_dep_hash ARGS((node_ptr));

EXTERN void insert_dependencies_hash ARGS((node_ptr, Set_t));
EXTERN Set_t lookup_dependencies_hash ARGS((node_ptr));

EXTERN node_ptr compileMakeFsmExpr ARGS((node_ptr, int));
EXTERN node_ptr compileMakeFsmBExpr ARGS((node_ptr, int));
EXTERN void Compile_BuildFsmBddPartitionMethod ARGS((Fsm_BddPtr, node_ptr, Partition_Method, add_ptr));

EXTERN node_ptr compileBuildElementaryBDDList ARGS((node_ptr, add_ptr));

EXTERN int CPCheckQuantificationSchedule ARGS((DdManager *dd, CPList Cl_list));

EXTERN void check_wff ARGS((node_ptr, node_ptr));
EXTERN int Compile_WriteFlattenBool ARGS((FILE *, Fsm_SexpPtr, cmp_struct_ptr));

EXTERN void compileCPCheckPartitionedTransition ARGS((CPTrans_Ptr transition, node_ptr list_variables, bdd_ptr assumption));

EXTERN void compileCPMakeAffinityClusters ARGS((DdManager * , CPList, CPList * , int));

#endif /* _compile_int */


