/**CHeaderFile*****************************************************************

  FileName    [bmcVarsMgr.h]

  PackageName [bmc]

  Synopsis    [Public interface for the VarsMgr class]

  Description []

  SeeAlso     []

  Author      [Roberto Cavada]

  Copyright   [
  This file is part of the ``bmc'' package of NuSMV version 2.
  Copyright (C) 2000-2001 by ITC-irst and University of Trento.

  NuSMV version 2 is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  NuSMV version 2 is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA.

  For more information of NuSMV see <http://nusmv.irst.itc.it>
  or email to <nusmv-users@irst.itc.it>.
  Please report bugs to <nusmv-users@irst.itc.it>.

  To contact the NuSMV development board, email to <nusmv@irst.itc.it>. ]

******************************************************************************/

#ifndef _BMC_VARS_MGR__H
#define _BMC_VARS_MGR__H


#include "utils.h"
#include "be.h"
#include "node.h"
#include "assoc.h" /* for hash_ptr */


/*---------------------------------------------------------------------------*/
/* Constant declarations                                                     */
/*---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*/
/* Type declarations                                                         */
/*---------------------------------------------------------------------------*/

/**Struct**********************************************************************

  Synopsis    [The Variables Manager accessor type]

  Description [Whenever you want to access a VarsMgr instance you will 
  handle with this type]

  SeeAlso     [VarsMgr type]

******************************************************************************/
typedef struct VarsMgr_TAG* VarsMgr_ptr;


/*---------------------------------------------------------------------------*/
/* Structure declarations                                                    */
/*---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*/
/* Variable declarations                                                     */
/*---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*/
/* Macro declarations                                                        */
/*---------------------------------------------------------------------------*/



/**AutomaticStart*************************************************************/

/*---------------------------------------------------------------------------*/
/* Function prototypes                                                       */
/*---------------------------------------------------------------------------*/

EXTERN VarsMgr_ptr Bmc_VarsMgr_Create ARGS((node_ptr state_vars_bexp));

EXTERN void Bmc_VarsMgr_Delete ARGS((VarsMgr_ptr* vars_mgr_ref));


EXTERN int Bmc_VarsMgr_GetNum ARGS((const VarsMgr_ptr vars_mgr));

EXTERN int Bmc_VarsMgr_GetMaxTime ARGS((const VarsMgr_ptr vars_mgr));

EXTERN Be_Manager_ptr
Bmc_VarsMgr_GetBeMgr ARGS((const VarsMgr_ptr vars_mgr));

EXTERN boolean
Bmc_VarsMgr_IsStateIndex ARGS((const VarsMgr_ptr vars_mgr, const int index,
			       const int maxTime));

EXTERN be_ptr
Bmc_VarsMgr_ShiftCurr2Next ARGS((const VarsMgr_ptr vars_mgr, 
				 const be_ptr exp));

EXTERN be_ptr
Bmc_VarsMgr_ShiftCurrNext2Time ARGS((const VarsMgr_ptr vars_mgr,
				     const be_ptr exp,
				     const int time));

EXTERN be_ptr
Bmc_VarsMgr_ShiftCurrNext2Times ARGS((const VarsMgr_ptr vars_mgr,
				      const be_ptr exp,
				      const int ctime, const int ntime));

EXTERN be_ptr
Bmc_VarsMgr_MkAndCurrNextInterval ARGS((const VarsMgr_ptr vars_mgr,
					const be_ptr exp,
					const int from, const int to));

EXTERN be_ptr
Bmc_VarsMgr_MkOrCurrNextInterval ARGS((const VarsMgr_ptr vars_mgr,
				       const be_ptr exp,
				       const int from, const int to));

EXTERN be_ptr
Bmc_VarsMgr_State2Curr ARGS((const VarsMgr_ptr vars_mgr,
			     const node_ptr statevar));

EXTERN node_ptr
Bmc_VarsMgr_Index2State ARGS((const VarsMgr_ptr vars_mgr, const int i));

EXTERN node_ptr
Bmc_VarsMgr_Curr2State ARGS((const VarsMgr_ptr vars_mgr,
			     const be_ptr curvar));

EXTERN be_ptr Bmc_VarsMgr_Index2Curr ARGS((const VarsMgr_ptr vars_mgr,
					   const int i));

EXTERN be_ptr Bmc_VarsMgr_Index2Next ARGS((const VarsMgr_ptr vars_mgr,
					   const int i));

EXTERN be_ptr
Bmc_VarsMgr_Index2Timed ARGS((const VarsMgr_ptr vars_mgr,
			      const int i, const int time));

EXTERN be_ptr
Bmc_VarsMgr_Curr2Next ARGS((const VarsMgr_ptr vars_mgr,
			    const be_ptr curvar));

EXTERN be_ptr
Bmc_VarsMgr_State2Next ARGS((const VarsMgr_ptr vars_mgr,
			     const node_ptr statevar));

EXTERN be_ptr
Bmc_VarsMgr_Next2Timed ARGS((const VarsMgr_ptr vars_mgr,
			     const be_ptr nextvar,
			     const int time));

EXTERN be_ptr
Bmc_VarsMgr_Curr2Timed ARGS((const VarsMgr_ptr vars_mgr,
			     const be_ptr curvar,
			     const int time));

EXTERN be_ptr
Bmc_VarsMgr_State2Timed ARGS((const VarsMgr_ptr vars_mgr,
			      const node_ptr statevar,
			      const int time));

EXTERN be_ptr
Bmc_VarsMgr_Timed2Curr ARGS((const VarsMgr_ptr vars_mgr,
			     const be_ptr timedvar));

EXTERN node_ptr
Bmc_VarsMgr_Timed2State ARGS((const VarsMgr_ptr vars_mgr,
			      const be_ptr timedvar));

EXTERN node_ptr
Bmc_VarsMgr_Next2State ARGS((const VarsMgr_ptr vars_mgr,
			     const be_ptr nextvar));

EXTERN be_ptr
Bmc_VarsMgr_Timed2Next ARGS((const VarsMgr_ptr vars_mgr,
			     const be_ptr timedvar));

EXTERN be_ptr
Bmc_VarsMgr_Next2Curr ARGS((const VarsMgr_ptr vars_mgr,
			    const be_ptr nextvar));

EXTERN int
Bmc_VarsMgr_Time2AbsIndex ARGS((const VarsMgr_ptr vars_mgr,
				const int time));

EXTERN int
Bmc_VarsMgr_AbsIndex2Time ARGS((const VarsMgr_ptr vars_mgr,
				const int varIdx));

EXTERN int
Bmc_VarsMgr_AbsIndex2Index ARGS((const VarsMgr_ptr vars_mgr,
				 const int varIdx));

EXTERN int
Bmc_VarsMgr_Index2AbsIndex ARGS((const VarsMgr_ptr vars_mgr,
				 const int idx, const int time));

/**AutomaticEnd***************************************************************/

#endif /* _BMC_VARS_MGR__H */

