/**CHeaderFile*****************************************************************

  FileName    [bmcSat.h]

  PackageName [bmc]

  Synopsis    [The bmc<->sat gateway public interface]

  Description []

  SeeAlso     []

  Author      [Roberto Cavada]

  Copyright   [
  This file is part of the ``bmc'' package of NuSMV version 2.
  Copyright (C) 2000-2001 by ITC-irst and University of Trento.

  NuSMV version 2 is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  NuSMV version 2 is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA.

  For more information of NuSMV see <http://nusmv.irst.itc.it>
  or email to <nusmv-users@irst.itc.it>.
  Please report bugs to <nusmv-users@irst.itc.it>.

  To contact the NuSMV development board, email to <nusmv@irst.itc.it>. ]

******************************************************************************/

#ifndef _BMC_SAT_H
#define _BMC_SAT_H


#include "bmcVarsMgr.h"
#include "utils.h"
#include "sat.h"

/*---------------------------------------------------------------------------*/
/* Constant declarations                                                     */
/*---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*/
/* Type declarations                                                         */
/*---------------------------------------------------------------------------*/

/**Struct*********************************************************************

  Synopsis           [This is the Bmc_SatTrace cass accessor type]
  Description        []
  SeeAlso            []

******************************************************************************/
typedef struct Bmc_SatTrace_TAG* Bmc_SatTrace_ptr;


/**Struct*********************************************************************

  Synopsis           [This is the Bmc_Problem cass accessor type]
  Description        []
  SeeAlso            []

******************************************************************************/
typedef struct Bmc_Problem_TAG* Bmc_Problem_ptr;


/*---------------------------------------------------------------------------*/
/* Structure declarations                                                    */
/*---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*/
/* Variable declarations                                                     */
/*---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*/
/* Macro declarations                                                        */
/*---------------------------------------------------------------------------*/



/**AutomaticStart*************************************************************/

/*---------------------------------------------------------------------------*/
/* Function prototypes                                                       */
/*---------------------------------------------------------------------------*/

EXTERN Sat_SatResult_ptr Bmc_Sat_SolveProblem 
ARGS((const VarsMgr_ptr vars_mgr,
      Sat_SatSolver_ptr solver, 
      const Bmc_Problem_ptr bmcProb, 
      const int k)); 

EXTERN Sat_SatResult_ptr Bmc_Sat_SolveInvarProblem 
ARGS((const VarsMgr_ptr vars_mgr,
      Sat_SatSolver_ptr solver, 
      const Bmc_Problem_ptr bmcProb)); 



/* ====================================================================== */
/* SatTrace methods:                                                      */
/* ====================================================================== */
EXTERN Bmc_SatTrace_ptr
Bmc_SatTrace_Create ARGS((Bmc_Problem_ptr bmcProb, 
			  Sat_SatResult_ptr satResult));
EXTERN void
Bmc_SatTrace_Delete ARGS((Bmc_SatTrace_ptr* self_ref));

EXTERN node_ptr 
Bmc_SatTrace_GetSymbModel ARGS((const Bmc_SatTrace_ptr self,  
				const VarsMgr_ptr vars_mgr, 
				const int k));
EXTERN node_ptr 
Bmc_SatTrace_GetSymbModelInvar ARGS((const Bmc_SatTrace_ptr self,  
				     const VarsMgr_ptr vars_mgr)); 


/* ====================================================================== */
/* BMC Problem class methods:                                             */
/* ====================================================================== */
EXTERN Bmc_Problem_ptr 
Bmc_Problem_Create ARGS((const VarsMgr_ptr vars_mgr, const be_ptr prob));

EXTERN void Bmc_Problem_Delete         ARGS((Bmc_Problem_ptr self));
EXTERN be_ptr Bmc_Problem_GetBeProblem ARGS((const Bmc_Problem_ptr self));
EXTERN Be_Cnf_ptr Bmc_Problem_GetCnf   ARGS((const Bmc_Problem_ptr self));


/**AutomaticEnd***************************************************************/

#endif /* _BMC_SAT_H */

