/**CHeaderFile*****************************************************************

  FileName    [bmcInt.h]

  PackageName [bmc]

  Synopsis    [The private interfaces for the <tt>bmc</tt> package]

  Description []

  SeeAlso     []

  Author      [Roberto Cavada]

  Copyright   [
  This file is part of the ``bmc'' package of NuSMV version 2.
  Copyright (C) 2000-2001 by ITC-irst and University of Trento.

  NuSMV version 2 is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  NuSMV version 2 is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA.

  For more information of NuSMV see <http://nusmv.irst.itc.it>
  or email to <nusmv-users@irst.itc.it>.
  Please report bugs to <nusmv-users@irst.itc.it>.

  To contact the NuSMV development board, email to <nusmv@irst.itc.it>. ]

******************************************************************************/

#ifndef _BMC_INT_H
#define _BMC_INT_H

#include <time.h>
#include <limits.h>
#include <stdio.h>

#include "../node/node.h"

/* ---------------------------------------------------------------------- */
/* In order to include "compile"! */
#include "sm.h"
#include "util.h"
#include "utils.h"
#include "node.h"
#include "dd.h"
#include "set.h"
#include "rbc.h"
#include "parser.h"
#include "compile.h"
/* ---------------------------------------------------------------------- */

#include "dd.h"

/* ---------------------------------------------------------------------- */
/* In order to include "opt"! */
#include "sm.h"
#include "util.h"
#include "utils.h"
#include "node.h"
#include "set.h"
#include "dd.h"
#include "rbc.h"
#include "cmd.h"
#include "compile.h"
#include "prop.h"
#include "opt.h"
/* ---------------------------------------------------------------------- */

#include "be.h"

#include "bmcVarsMgr.h"


/*---------------------------------------------------------------------------*/
/* Constant declarations                                                     */
/*---------------------------------------------------------------------------*/
#define DIMAX_FILENAME_MAXLEN 4096

#define BMC_NO_PROPERTY_INDEX -1

#define BMC_BEXP_OUTPUT_SMV 0
#define BMC_BEXP_OUTPUT_LB 1

/*---------------------------------------------------------------------------*/
/* Type declarations                                                         */
/*---------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------*/
/* Structure declarations                                                    */
/*---------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------*/
/* Variable declarations                                                     */
/*---------------------------------------------------------------------------*/

EXTERN FILE* nusmv_stderr;
EXTERN FILE* nusmv_stdout;
EXTERN cmp_struct_ptr cmps;
EXTERN node_ptr all_variables;
EXTERN node_ptr all_symbols;
EXTERN options_ptr options;
EXTERN DdManager* dd_manager;

/*---------------------------------------------------------------------------*/
/* Macro declarations                                                        */
/*---------------------------------------------------------------------------*/

#ifndef max
#define max(_a_, _b_) ((_a_ < _b_) ? _b_ : _a_)
#endif

#ifndef min
#define min(_a_, _b_) ((_a_ < _b_) ? _a_ : _b_)
#endif

/**AutomaticStart*************************************************************/

/*---------------------------------------------------------------------------*/
/* Function prototypes                                                       */
/*---------------------------------------------------------------------------*/

EXTERN int
Bmc_TestTableau ARGS((int argc, char ** argv));

EXTERN void Bmc_TestReset    ARGS((void));


EXTERN void
Bmc_PrintStats ARGS((Be_Manager_ptr beManager, int clustSize, FILE* outFile));


EXTERN boolean
isPureFuture ARGS((const node_ptr pltl_wff));

EXTERN be_ptr
Bmc_GetTestTableau ARGS((const VarsMgr_ptr vars_mgr,
                         const node_ptr ltl_wff,
                         const int k, const int l));

EXTERN be_ptr
BmcInt_Tableau_GetAtTime ARGS((const VarsMgr_ptr vars_mgr,
             const node_ptr ltl_wff,
             const int time, const int k, const int l));

/* ================================================== */
/* Tableaux for an LTL formula:                       */
EXTERN be_ptr
bmc_tableauGetNextAtTime ARGS((const VarsMgr_ptr vars_mgr,
                               const node_ptr ltl_wff,
                               const int time, const int k, const int l));

EXTERN be_ptr
bmc_tableauGetEventuallyAtTime ARGS((const VarsMgr_ptr vars_mgr,
                                     const node_ptr ltl_wff,
                                     const int intime, const int k,
                                     const int l));

EXTERN be_ptr
bmc_tableauGetGloballyAtTime ARGS((const VarsMgr_ptr vars_mgr,
                                   const node_ptr ltl_wff,
                                   const int intime, const int k,
                                   const int l));

EXTERN be_ptr
bmc_tableauGetUntilAtTime ARGS((const VarsMgr_ptr vars_mgr,
                                const node_ptr p, const node_ptr q,
                                const int time, const int k, const int l));

EXTERN be_ptr
bmc_tableauGetReleasesAtTime ARGS((const VarsMgr_ptr vars_mgr,
                                   const node_ptr p, const node_ptr q,
                                   const int time, const int k, const int l));
/* ================================================== */


/* ================================================== */
/* Tableaux for a PLTL formula:                       */
EXTERN be_ptr
Bmc_TableauPLTL_GetTableau ARGS((const VarsMgr_ptr vars_mgr,
                                 const node_ptr pltl_wff,
                                 const int k, const int l));

EXTERN be_ptr
Bmc_TableauPLTL_GetAllTimeTableau ARGS((const VarsMgr_ptr vars_mgr,
                                        const node_ptr pltl_wff,
                                        const int k));
/* ================================================== */

/**AutomaticEnd***************************************************************/

#endif /* _BMC_INT_H */

























