/**CHeaderFile*****************************************************************

  FileName    [bmcBmc.h]

  PackageName [bmc]

  Synopsis    [High-level functionalities interface file]

  Description [High level functionalities allow to perform Bounded Model 
  Checking for LTL properties and invariants, as well as simulations.]

  SeeAlso     []

  Author      [Roberto Cavada]

  Copyright   [
  This file is part of the ``bmc'' package of NuSMV version 2. 
  Copyright (C) 2000-2001 by ITC-irst and University of Trento. 

  NuSMV version 2 is free software; you can redistribute it and/or 
  modify it under the terms of the GNU Lesser General Public 
  License as published by the Free Software Foundation; either 
  version 2 of the License, or (at your option) any later version.

  NuSMV version 2 is distributed in the hope that it will be useful, 
  but WITHOUT ANY WARRANTY; without even the implied warranty of 
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU 
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public 
  License along with this library; if not, write to the Free Software 
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA.

  For more information of NuSMV see <http://nusmv.irst.itc.it>
  or email to <nusmv-users@irst.itc.it>.
  Please report bugs to <nusmv-users@irst.itc.it>.

  To contact the NuSMV development board, email to <nusmv@irst.itc.it>. ]

******************************************************************************/

#ifndef _BMC_BMC_H
#define _BMC_BMC_H

#include "util.h"


/* ---------------------------------------------------------------------- */
/* In order to include "prop.h" */
#include "utils.h"
#include "ucmd.h"
#include "array.h"
#include "node.h"
#include "dd.h"
#include "rbc.h"
#include "set.h"
#include "compile.h"
#include "opt.h"
#include "set.h"
#include "rbc.h"
#include "mc.h"
#include "ltl.h"
#include "cmd.h"
#include "prop.h"
/* ---------------------------------------------------------------------- */


/*---------------------------------------------------------------------------*/
/* Type declarations                                                         */
/*---------------------------------------------------------------------------*/

/**Enum***********************************************************************

  Synopsis    [It is used when invoking Bmc_GenSolve* functions]

  Description [Possible values are:
  DO_NOTHING        nop action
  GEN_DIMACS        generates the dimacs file
  GEN_DIMACS_SOLVE  generates the dimacs file and solves the problem
  SOLVE             solves the problem 
  ]

  SeeAlso     []

******************************************************************************/
typedef enum { 
  DO_NOTHING,        
  GEN_DIMACS,        
  GEN_DIMACS_SOLVE,  
  SOLVE              
} Bmc_GenSolve_Action;
  

/*---------------------------------------------------------------------------*/
/* Variable declarations                                                     */
/*---------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------*/
/* Macro declarations                                                        */
/*---------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------*/
/* Function prototypes                                                       */
/*---------------------------------------------------------------------------*/
EXTERN void 
Bmc_GenSolveLtl ARGS((Prop_Ptr ltlprop, 
		      const int k, const int relative_loop, 
		      const boolean bIncreaseK, 
		      const Bmc_GenSolve_Action action, 
		      const char* dimacsFilename)); 

EXTERN void 
Bmc_GenSolveInvar ARGS((Prop_Ptr invarprop,  
			const Bmc_GenSolve_Action action,
			const char* dimacsFilename));

EXTERN void 
Bmc_Simulate ARGS((const Bmc_Fsm_ptr be_fsm, const int k)); 

#endif /* _BMC_BMC_H */

