# FileName	[dependency.make]
#
# PackageName	[NuSMV]
#
# Synopsis	[Makefile to automatically create the dependency files.]
#
# Description	[This file is called from the main Makefile.]
#
# SeeAlso	[Makefile.in]
#
# Author	[Marco Roveri]
#
# Copyright	[Copyright (C) 1998-2001 by CMU and ITC-irst. 
#
# NuSMV version 2 is free software; you can redistribute it and/or 
# modify it under the terms of the GNU Lesser General Public 
# License as published by the Free Software Foundation; either 
# version 2 of the License, or (at your option) any later version.
#
# NuSMV version 2 is distributed in the hope that it will be useful, 
# but WITHOUT ANY WARRANTY; without even the implied warranty of 
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU 
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public 
# License along with this library; if not, write to the Free Software 
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA.
#
# For more information of NuSMV see <http://nusmv.irst.itc.it>
# or email to <nusmv-users@irst.itc.it>.
# Please report bugs to <nusmv-users@irst.itc.it>.
#
# To contact the NuSMV development board, email to <nusmv@irst.itc.it>.]
#
# Revision	[$Id: dependency.make,v 1.1.1.1 2003/02/06 19:01:21 flerda Exp $]

include $(PKGNAME).make
VPATH = $(vpath)

ifdef DEPENDENCYFILES
$(PKGNAME).d : $(DEPENDENCYFILES) $(HEADERS) $(PKGNAME).make
	@echo -n "Dependency file $(PKGNAME).d->"
	@$(CC) -MM $(CFLAGS) $(AC_FLAGS) $(INCLUDEDIRS) \
	$(filter %.c, $^) | \
	sed 's/^[a-zA-Z0-9_]*\.o[ :]*/$(objectdir)\/&/g' > $@
	@echo "Created."
else
$(PKGNAME).d :
	@echo "No dependency files given in $(PKGNAME).make"
	@echo "Define the variable DEPENDENCYFILES to create the dependencies"
endif
