# FileName	[ aclocal.m4 ]
#
# PackageName	[ nusmv ]
#
# Synopsis	[ Site local configuration script for autoconf ]
#
# SeeAlso	[ configure.in ]
#
# Author	[ Marco Roveri]
#
# Copyright	[Copyright (C) 1998-2001 by CMU and ITC-irst. 
#
# NuSMV version 2 is free software; you can redistribute it and/or 
# modify it under the terms of the GNU Lesser General Public 
# License as published by the Free Software Foundation; either 
# version 2 of the License, or (at your option) any later version.
#
# NuSMV version 2 is distributed in the hope that it will be useful, 
# but WITHOUT ANY WARRANTY; without even the implied warranty of 
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU 
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public 
# License along with this library; if not, write to the Free Software 
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA.
#
# For more information of NuSMV see <http://nusmv.irst.itc.it>
# or email to <nusmv-users@irst.itc.it>.
# Please report bugs to <nusmv-users@irst.itc.it>.
#
# To contact the NuSMV development board, email to <nusmv@irst.itc.it>.]
#
# Revision	[$Id: aclocal.m4,v 1.1.1.1 2003/02/06 19:01:15 flerda Exp $]
#
AC_DEFUN(NUSMV_CHECK_LIB_TERMCAP,
[
if test "X$smv_termcap_lib" = "X"; then
_bash_needmsg=yes
else
AC_MSG_CHECKING(which library has the termcap functions)
_bash_needmsg=
fi
AC_CACHE_VAL(smv_termcap_lib,
[AC_CHECK_LIB(termcap, tgetflag, smv_termcap_lib=libtermcap,
    [AC_CHECK_LIB(curses, tgetflag, smv_termcap_lib=libcurses,
        [AC_CHECK_LIB(ncurses, tgetflag, smv_termcap_lib=libncurses,
            smv_termcap_lib=gnutermcap)])])])
if test "X$_bash_needmsg" = "Xyes"; then
AC_MSG_CHECKING(which library has the termcap functions)
fi
AC_MSG_RESULT(using $smv_termcap_lib)
if test $smv_termcap_lib = gnutermcap; then
LIBDIRS="$LIBDIRS -L/opt/gnu/lib"
TERMCAP_LIB=-ltermcap
TERMCAP_DEP=
elif test $smv_termcap_lib = libtermcap; then
TERMCAP_LIB=-ltermcap
TERMCAP_DEP=
elif test $smv_termcap_lib = libncurses; then
TERMCAP_LIB=-lncurses
TERMCAP_DEP=
else
TERMCAP_LIB=-lcurses
TERMCAP_DEP=
fi
])