/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.radar.rhai.calendar;

import edu.cmu.cs.radar.rhai.calendar.Time;
import java.text.DateFormat;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class DateTime
extends Date {
    private static final long serialVersionUID = 1L;
    public static final DateFormat[] FORMATS = new DateFormat[]{new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS Z"), new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"), new SimpleDateFormat("yyyy-MM-dd HH:mm"), new SimpleDateFormat("yyyy-MM-dd")};

    public DateTime() {
    }

    public DateTime(long date) {
        super(date);
    }

    public DateTime(Date date) {
        super(date.getTime());
    }

    public DateTime(Date date, Time time) {
        this(date);
        this.setTime(time);
    }

    public DateTime(String str) {
        Date date = DateTime.createDateTimeFromString(str);
        if (date == null) {
            throw new IllegalArgumentException("'" + str + "' is an invalid datetime");
        }
        this.setTime(date.getTime());
    }

    public Date getAsDate() {
        Calendar cal = Calendar.getInstance();
        cal.setTime(this);
        cal.clear(9);
        cal.clear(10);
        cal.clear(11);
        cal.clear(12);
        cal.clear(13);
        cal.clear(14);
        return cal.getTime();
    }

    public Time getAsTime() {
        Calendar cal = Calendar.getInstance();
        cal.setTime(this);
        int hour = cal.get(11);
        int minute = cal.get(12);
        int second = cal.get(13);
        return new Time(hour, minute, second);
    }

    public void setTime(Time time) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(this);
        cal.set(11, 0);
        cal.clear(12);
        cal.clear(13);
        cal.clear(14);
        cal.add(11, time.getHour());
        cal.add(12, time.getMinute());
        cal.add(13, time.getSecond());
        this.setTime(cal.getTime().getTime());
    }

    protected static Date createDateTimeFromString(String str) {
        DateFormat[] dateFormatArray = FORMATS;
        int n = FORMATS.length;
        int n2 = 0;
        while (n2 < n) {
            DateFormat element = dateFormatArray[n2];
            Date datetime = element.parse(str, new ParsePosition(0));
            if (datetime != null) {
                return datetime;
            }
            ++n2;
        }
        return null;
    }

    public boolean isSameDate(DateTime otherDate) {
        return this.getAsDate().equals(otherDate.getAsDate());
    }

    public static class Range {
        protected DateTime mStart;
        protected DateTime mEnd;

        public Range(DateTime start, DateTime end) {
            if (start == null) {
                throw new NullPointerException("argument 'start'");
            }
            if (end == null) {
                throw new NullPointerException("argument 'end'");
            }
            if (start.after(end)) {
                throw new IllegalArgumentException("'end' (" + end.toString() + ") < 'start' (" + start.toString() + ")");
            }
            this.mStart = start;
            this.mEnd = end;
        }

        public static Range create(String strRange) {
            String[] parts = strRange.split("--");
            DateTime start = new DateTime(parts[0].trim());
            DateTime end = new DateTime(parts[1].trim());
            return new Range(start, end);
        }

        public DateTime getStart() {
            return this.mStart;
        }

        public DateTime getEnd() {
            return this.mEnd;
        }

        public boolean overlaps(Range otherRange) {
            return !(!this.mStart.before(otherRange.mEnd) && !this.mStart.equals(otherRange.mEnd) || !this.mEnd.after(otherRange.mStart) && !this.mEnd.equals(otherRange.mStart));
        }

        public boolean contains(Range otherRange) {
            return !(!this.mStart.before(otherRange.mStart) && !this.mStart.equals(otherRange.mStart) || !this.mEnd.after(otherRange.mEnd) && !this.mEnd.equals(otherRange.mEnd));
        }

        public String toString() {
            return String.valueOf(this.mStart.toString()) + " -- " + this.mEnd.toString();
        }
    }
}

