// $Id: IRadar.java,v 4.4 2008/06/06 15:07:07 jordan Exp $

package edu.cmu.cs.radar.integ;

public interface IRadar {
    public static final String RADAR_TEST_CONDITION = "radar.test.condition";

    public static final int RADAR_TEST_UNDEFINED = -1;
    public static final int RADAR_TEST_CONTROL = 0;
    public static final int RADAR_TEST_MINUSL = 1;
    public static final int RADAR_TEST_PLUSL = 2;
    public static final int RADAR_TEST_COTSPLUSA = 3;
    public static final String RADAR_TEST_CONTROL_STRING = "cots";
    public static final String RADAR_TEST_MINUSL_STRING = "radarminusl";
    public static final String RADAR_TEST_PLUSL_STRING = "radarplusl";
    public static final String RADAR_TEST_COTSPLUSA_STRING = "cots+a";

    public boolean condIsPlusL();
    public boolean condIsMinusL();
    public boolean condIsNotRadar();

    public static final String RADAR_TASKSTATE_UNKNOWN = "UNKNOWN";
    public static final String RADAR_TASKSTATE_SUSPENDED = "SUSPENDED";
    public static final String RADAR_TASKSTATE_RUNNING = "RUNNING";
    public static final String RADAR_TASKSTATE_READY = "READY";
    public static final String RADAR_TASKSTATE_FAILED = "FAILED";
    public static final String RADAR_TASKSTATE_ERROR = "ERROR";
    public static final String RADAR_TASKSTATE_DELETED = "DELETED";
    public static final String RADAR_TASKSTATE_CREATED = "CREATED";
    public static final String RADAR_TASKSTATE_COMPLETED = "COMPLETED";
    public static final String RADAR_TASKSTATE_CANCELED = "CANCELED";
    public static final String RADAR_TASKSTATE_ASSIGNED = "ASSIGNED";

    public static final String ADB_HOST = "adb.host";
    public static final String ADB_NAME = "adb.user";
    public static final String ADB_PASSWORD = "adb.password";
    public static final String ADB_DATABASE = "adb.database";
    public static final String ADB_DRIVER = "adb.driver";

    public static final String USER_CODE = "user.code";

    /**
     * subject for main loop status
     */
    public static final String RADAR_MAIN = "radar.main";

    /**
     * subject for VOT results
     */
    public static final String RADAR_VOT = "radar.vot";

    /**
     * subject for DUCW attribute
     */
    public static final String DUCW_DELI_ATTRIB = "DUCW";

    // -Dradar.verbose to get verbosity
    public static final String RADAR_VERBOSE = "radar.verbose";

    public static final String RADAR_VIO_DBDRIVER = "radar.vio.dbdriver";
    public static final String RADAR_VIO_DBSTRING = "radar.vio.dbstring";
    public static final String RADAR_VIO_DBUSER = "radar.vio.dbuser";
    public static final String RADAR_VIO_DBPASSWORD = "radar.vio.dbpassword";
    public static final String RADAR_VIO_WEBPATH = "radar.vio.webpath";
    public static final String RADAR_VIO_APPPATH = "radar.vio.apppath";

    public static final String RADAR_VENDORS_DBDRIVER = "radar.vendors.dbdriver";
    public static final String RADAR_VENDORS_DBSTRING = "radar.vendors.dbstring";
    public static final String RADAR_VENDORS_DBUSER = "radar.vendors.dbuser";
    public static final String RADAR_VENDORS_DBPASSWORD = "radar.vendors.dbpassword";

    public static final String RADAR_SKIP_TM = "radar.skip.tm";
    public static final String RADAR_SUMMARY_FILE = "radar.summary.file";
    public static final String RADAR_COUNTDOWN_DATE = "radar.countdown.date";
    public static final String RADAR_CONFERENCE_STARTHOUR = "radar.conference.starthour";
    public static final String RADAR_CONFERENCE_ENDHOUR = "radar.conference.endhour";
    public static final String RADAR_COMPONENTS_FILE = "radar.components.file";
    public static final String RADAR_SHUTDOWN_SEMAPHORE = "radar.shutdown.semaphore";
    public static final String RADAR_READY_SEMAPHORE = "radar.ready.semaphore";
    public static final String RADAR_DATA_DIR = "radar.data.dir";
    public static final String RADAR_USE_BETA = "radar.use.beta";

    public static final String RADAR_CMRADAR_WRAPPER = "radar.cmradar.wrapper";

    public static final String RADAR_STP_IMPORTANCE_DEFAULT = "radar.stp.importance.default";
    public static final String RADAR_STP_ELICITATION_LIMIT = "radar.stp.elicitation.limit";
    public static final String RADAR_STP_POPUP_LIMIT = "radar.stp.popup.limit";
    public static final String RADAR_STP_WEIGHT_CAPACITY = "radar.stp.weight.capacity";
    public static final String RADAR_STP_IMPORTANCE_USER = "radar.stp.importance.user";
    public static final String RADAR_STP_EDITING = "radar.stp.editing";

    // for user-provided constraints

    public static final String RADAR_MODE = "radar.mode";
    public static final String RADAR_MODE_TRAINING = "training";
    public static final String RADAR_MODE_TEST = "test";

    public static final String RADAR_BA_MODE = "radar.ba.mode";
    public static final String RADAR_BA_DEFAULT_RECIPIENT = "radar.ba.default.recipient";
    public static final String RADAR_BA_MAX_EMAILS = "radar.ba.max.emails";
    public static final String RADAR_BA_ALL_TASKS = "radar.ba.all.tasks";
    public static final String RADAR_BA_MARKBRIEFEDMESSAGES = "radar.ba.markBriefedMessages";

    public static final String RADAR_URL_WBE = "radar.url.wbe";
    public static final String RADAR_URL_VIO = "radar.url.vio";

    public static final String USER_NAME = "user.name";
    public static final String IMAP_USER = "user.imap.name";
    public static final String IMAP_SERVER = "user.imap.server";
    public static final String IMAP_HOSTNAME = "user.imap.hostname";
    public static final String IMAP_FEEDBACK_FOLDER = "user.imap.folder.feedback";
    public static final String IMAP_PORT = "user.imap.port";
    public static final String IMAP_PASSWORD = "user.imap.password";
    public static final String USER_HOME = "user.home";
}
