// $Id: IAnythingRequires.java,v 4.4 2008/05/28 21:39:51 jordan Exp $

package edu.cmu.cs.radar.integ;

import java.util.Set;

import edu.cmu.cs.radar.deli.Corpus;
import edu.cmu.cs.radar.deli.Document;

import javax.mail.internet.MimeMessage;

public interface IAnythingRequires {
    public void setTaskKVP(String taskId, String key, String val);
    public void setTaskContents(String taskId, String contents);
    public void setTaskState(String taskId, String state);
    public Integer ensureActiveTaskExists(String taskType);
    public Integer getActiveTask(String taskType, Set<String> stateFilter);
    public void sendEMail(MimeMessage msg);

    /**
     * returns the One True RADAR Corpus
     */
    public Corpus getCorpus();
    /**
     * returns a single RADAR Document indexed by Message-Id
     *
     * @param	msgId	The Message-ID
     */
    public Document getDocument(String msgId);
}
