// $Id: IAnythingProvides.java,v 4.1 2008/04/26 00:12:37 jordan Exp $

package edu.cmu.cs.radar.integ;

/**
This class describes the interfaces that Radar components should provide.
*/

public interface IAnythingProvides {
    // Radar views these interfaces as a foreign body of code that it's
    // loading as follows:
    // 1. load the class
    // 2. make an instance of the class
    // 3. call instance.initialize(IRadarServices radarServices)
    // 4-N. make API calls as defined by the Java interface
    // N+1. call instance.shutdown()

    public boolean initialize(IRadarServices radarServices);
    // set up the GUI; load code; check basic error conditions
    // and return true if all is well and the console can use you.
    //
    // The architecture will provide you with a radarServices facade
    // thru the method argument.  Store it however you like, but when
    // you need to make requests of the rest of the Radar, you will
    // use this facade.

    public boolean shutdown();
    // Radar is shutting down.  Return true if you have
    // successfuly shut down.
}
