/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.radar.rhai.spacetime;

import SpaceTime.DataModel.Change;
import SpaceTime.DataModel.NodeChangeSummary;
import edu.cmu.cs.radar.integ.IRadarServices;
import edu.cmu.cs.radar.rhai.spacetime.CalendarGrid;
import edu.cmu.cs.radar.rhai.spacetime.ComponentDragContainer;
import edu.cmu.cs.radar.rhai.spacetime.DatePicker;
import edu.cmu.cs.radar.rhai.spacetime.EditConferencePropertiesDialog;
import edu.cmu.cs.radar.rhai.spacetime.Entry;
import edu.cmu.cs.radar.rhai.spacetime.GenericStatusDialog;
import edu.cmu.cs.radar.rhai.spacetime.RequestDetailsPanel;
import edu.cmu.cs.radar.rhai.spacetime.RequestListModel;
import edu.cmu.cs.radar.rhai.spacetime.RoomDetailsPanel;
import edu.cmu.cs.radar.rhai.spacetime.RoomPicker;
import edu.cmu.cs.radar.rhai.spacetime.ScoreChart;
import edu.cmu.cs.radar.rhai.spacetime.SelectionListener;
import edu.cmu.cs.radar.rhai.spacetime.SelectionManager;
import edu.cmu.cs.radar.rhai.spacetime.SelectionState;
import edu.cmu.cs.radar.rhai.spacetime.Services;
import edu.cmu.cs.radar.rhai.spacetime.SpaceTimeDate;
import edu.cmu.cs.radar.rhai.spacetime.SpaceTimeItemList;
import edu.cmu.cs.radar.rhai.spacetime.SpaceTimeRequestNode;
import edu.cmu.cs.radar.rhai.spacetime.TitlePane;
import edu.cmu.cs.radar.rhai.spacetime.WorkJournal;
import edu.cmu.cs.radar.stp.cachingdatamodel.EventAdapter;
import edu.cmu.cs.radar.stp.cachingdatamodel.GlobalChangeListener;
import edu.cmu.cs.radar.stp.cachingdatamodel.SpaceTimeDataAdapter;
import edu.cmu.cs.radar.stp.cachingdatamodel.SpaceTimeNode;
import edu.cmu.cs.radar.stp.cachingdatamodel.SpaceTimeSession;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.HashSet;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class SpaceTimeWindowFrame
extends JFrame
implements ListDataListener,
SelectionListener {
    private static final long serialVersionUID = 0L;
    public static final String OPTIMIZE_TASK_TYPE = "OPTIMIZE-SCHEDULE";
    public static final String PUBLISH_TASK_TYPE = "PUBLISH-SCHEDULE";
    public static SpaceTimeWindowFrame s_singleton;
    private SpaceTimeDataAdapter _dataAdapter;
    private SpaceTimeSession _stmSession;
    private RequestListModel _listModel;
    private SpaceTimeItemList _itemList;
    private DatePicker _datePicker;
    private CalendarGrid _calendarGrid;
    private RoomPicker _roomPicker;
    private RoomDetailsPanel _roomDetailsPanel;
    private RequestDetailsPanel _requestDetailsPanel;
    private JPanel _buttonPane;
    private JMenuItem _undoMenuItem;
    private JMenuItem _redoMenuItem;
    private JLabel _hintLabel;
    private JButton _optimizeScheduleButton;
    private JButton _optimizeVendorOrdersButton;
    private JButton _publishButton;
    private boolean _showScorePendingHint;
    private boolean _showOverlapErrorHint;
    private boolean _showOptimizationHint;
    private JCheckBoxMenuItem _showScoresMenuItem;
    private JCheckBoxMenuItem _showDetailsMenuItem;
    private TitlePane _globalScoreTitlePane;
    private ScoreChart _globalScoreChart;
    private SelectionManager _selectionManager;
    private IRadarServices _radar;
    private boolean _stateDirty;
    private boolean _scheduleDirty;
    private boolean _optimizeEnabled;
    private SelectionState _selectionState;
    private static final String HINT_SCORE_PENDING = "<html><b>Please wait ...</b><br>Checking event constraints.</html>";
    private static final String HINT_FIX_OVERLAP = "<html><b>Hint:</b><br>To enable optimization, move any events that overlap with locked events.</html>";
    private static final String HINT_OPTIMIZE = "<html><b>Hint:</b><br>You should optimize the schedule.</html>";
    private static final String HINT_PUBLISH = "<html><b>Hint:</b><br>You should publish the schedule.</html>";
    private static final String HINT_NONE = "<html><b>Hint:</b><br>No problems found.</html>";
    private static final String VENDOR_OPTIMIZER_BUTTON_LABEL_ENABLED = "<html><b>Optimize Vendor Orders</b><br>Determine the best items to order.</html>";
    private static final String VENDOR_OPTIMIZER_BUTTON_LABEL_DISABLED = "<html><b>Optimizing Vendor Orders</b><br>Ordering all necessary items.</html>";

    public SpaceTimeWindowFrame(SpaceTimeSession stmSession, IRadarServices radar) {
        super("Radar SpaceTime Planner");
        s_singleton = this;
        this._radar = radar;
        this._stateDirty = false;
        this._scheduleDirty = false;
        this._optimizeEnabled = true;
        this._showScorePendingHint = false;
        this._showOverlapErrorHint = false;
        this._showOptimizationHint = false;
        this._selectionManager = new SelectionManager();
        this._selectionManager.addListener(this);
        ClassLoader classLoader = Entry.class.getClassLoader();
        this._stmSession = stmSession;
        this._dataAdapter = this._stmSession.getDataAdapter();
        if (this._dataAdapter == null) {
            JOptionPane.showMessageDialog(null, "Fatal error", "Unable to connect to STP server", 0);
            System.exit(0);
        }
        this._listModel = new RequestListModel(this._dataAdapter);
        this._selectionState = new SelectionState(this._selectionManager, this._listModel);
        this._selectionState.toString();
        this._calendarGrid = new CalendarGrid(this._listModel);
        this._calendarGrid.setSelectionManager(this._selectionManager);
        this._datePicker = new DatePicker(this._listModel);
        this._datePicker.addDateListener(this._calendarGrid);
        this._selectionManager.addListener(this._datePicker);
        this._roomPicker = new RoomPicker(this._listModel, this._selectionManager);
        this._roomPicker.addScheduleListListener(this._calendarGrid);
        TitlePane roomTitlePane = new TitlePane("Buildings / Rooms", 4, this._roomPicker);
        this._roomDetailsPanel = new RoomDetailsPanel(this._dataAdapter, this._selectionManager);
        TitlePane roomDetailsTitlePane = new TitlePane("", 4, this._roomDetailsPanel);
        roomDetailsTitlePane.setPreferredSize(new Dimension(100, 400));
        this._roomDetailsPanel.setTitlePane(roomDetailsTitlePane);
        JSplitPane roomPanel = new JSplitPane(0, roomTitlePane, roomDetailsTitlePane);
        roomPanel.setResizeWeight(1.0);
        JPanel calendarSelectionPanel = new JPanel();
        calendarSelectionPanel.setLayout(new BorderLayout());
        calendarSelectionPanel.add((Component)this._datePicker, "North");
        calendarSelectionPanel.add((Component)roomPanel, "Center");
        calendarSelectionPanel.setMinimumSize(new Dimension(150, Integer.MAX_VALUE));
        calendarSelectionPanel.setPreferredSize(new Dimension(200, Integer.MAX_VALUE));
        JSplitPane calendarPanel = new JSplitPane(1, calendarSelectionPanel, this._calendarGrid);
        this._itemList = new SpaceTimeItemList(this._listModel);
        this._itemList.setSelectionManager(this._selectionManager);
        this._itemList.showScores(true);
        this._itemList.showGraphs(true);
        this._itemList.setDebug(this._dataAdapter.getParameters().debugModeOn());
        this._requestDetailsPanel = new RequestDetailsPanel(this._dataAdapter, this._selectionManager);
        TitlePane requestDetailsTitlePane = new TitlePane("", 0, this._requestDetailsPanel);
        roomDetailsTitlePane.setPreferredSize(new Dimension(100, 400));
        this._requestDetailsPanel.setTitlePane(requestDetailsTitlePane);
        JSplitPane requestPanel = new JSplitPane(0, this._itemList, requestDetailsTitlePane);
        requestPanel.setDividerLocation(400);
        this._buttonPane = new JPanel();
        this._buttonPane.setLayout(new BoxLayout(this._buttonPane, 1));
        this._buttonPane.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this._buttonPane.setBackground(Color.white);
        this._hintLabel = new JLabel();
        this._hintLabel.setHorizontalAlignment(2);
        this._hintLabel.setBorder(new EmptyBorder(0, 16, 0, 16));
        this._optimizeScheduleButton = new JButton(new OptimizeScheduleAction());
        this._optimizeScheduleButton.setEnabled(false);
        this._optimizeScheduleButton.setHorizontalAlignment(2);
        this._publishButton = new JButton(new PublishScheduleAction());
        this._publishButton.setEnabled(false);
        this._publishButton.setHorizontalAlignment(2);
        this._optimizeVendorOrdersButton = new JButton(new OptimizeVendorOrdersAction());
        this._optimizeVendorOrdersButton.setEnabled(false);
        this._optimizeVendorOrdersButton.setHorizontalAlignment(2);
        this._globalScoreChart = new ScoreChart();
        this._globalScoreTitlePane = new TitlePane("Overall Score", 0, this._globalScoreChart);
        this._globalScoreTitlePane.setPreferredSize(new Dimension(100, 50));
        this._buttonPane.add(this._hintLabel);
        this._buttonPane.add(this._optimizeScheduleButton);
        this._buttonPane.add(this._publishButton);
        if (this._dataAdapter.getParameters().vendorOptimizer()) {
            this._buttonPane.add(this._optimizeVendorOrdersButton);
        }
        JPanel rightMainPanel = new JPanel();
        rightMainPanel.setLayout(new BorderLayout());
        rightMainPanel.add((Component)this._buttonPane, "North");
        rightMainPanel.add((Component)requestPanel, "Center");
        rightMainPanel.setMinimumSize(new Dimension(180, Integer.MAX_VALUE));
        rightMainPanel.setPreferredSize(new Dimension(240, Integer.MAX_VALUE));
        JSplitPane contentPanel = new JSplitPane(1, calendarPanel, rightMainPanel);
        contentPanel.setResizeWeight(1.0);
        ComponentDragContainer dragContainer = new ComponentDragContainer();
        dragContainer.setContentPane(contentPanel);
        ImageIcon icon = new ImageIcon(classLoader.getResource("edu/cmu/cs/radar/rhai/media/radar-icon.png"));
        this.setIconImage(icon.getImage());
        Rectangle maximumWindowBounds = GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds();
        int width = Math.min(1000, maximumWindowBounds.width);
        int height = Math.min(800, maximumWindowBounds.height);
        int x = maximumWindowBounds.x + (maximumWindowBounds.width - width) / 2;
        int y = maximumWindowBounds.y + (maximumWindowBounds.height - height) / 2;
        this.setLocation(x, y);
        this.setSize(width, height);
        this.setContentPane(dragContainer);
        this._listModel.addListDataListener(this);
        Services.journal.addListener(new WorkJournal.Listener(){

            @Override
            public void workJournalChanged() {
                SpaceTimeWindowFrame.this._redoMenuItem.setEnabled(Services.journal.isRedoAvailable());
                SpaceTimeWindowFrame.this._redoMenuItem.setText("Redo " + Services.journal.getRedoTitle());
                SpaceTimeWindowFrame.this._undoMenuItem.setEnabled(Services.journal.isUndoAvailable());
                SpaceTimeWindowFrame.this._undoMenuItem.setText("Undo " + Services.journal.getUndoTitle());
            }
        });
        this.createMainMenu();
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
            }

            @Override
            public void windowClosing(WindowEvent e) {
                SpaceTimeWindowFrame.this.requestCloseWindow();
            }

            @Override
            public void windowOpened(WindowEvent e) {
                SpaceTimeWindowFrame.this._stateDirty = true;
                SpaceTimeWindowFrame.this._listModel.updateData();
                SpaceTimeWindowFrame.this._stateDirty = false;
                SpaceTimeWindowFrame.this._optimizeScheduleButton.setEnabled(true);
                SpaceTimeWindowFrame.this._optimizeVendorOrdersButton.setEnabled(true);
                SpaceTimeWindowFrame.this._publishButton.setEnabled(true);
                SpaceTimeWindowFrame.this.syncOptimizeMenu();
                SpaceTimeWindowFrame.this.updateWindowTitle();
            }
        });
        this._dataAdapter.addGlobalChangeListener(new GlobalChangeListener(){

            @Override
            public void worldStateNodeChanged(String nodeId, NodeChangeSummary changes) {
                if (changes == null || !this.isShownInGuiOnlyChange(changes)) {
                    SpaceTimeWindowFrame.this.setStateDirty(true);
                }
                if (changes != null && this.isScheduleChange(changes)) {
                    SpaceTimeWindowFrame.this.setScheduleDirty(true);
                }
                SpaceTimeWindowFrame.this._globalScoreChart.setValue(SpaceTimeWindowFrame.this._dataAdapter.getGlobalScore());
                SpaceTimeWindowFrame.this.syncOptimizeMenu();
                SpaceTimeWindowFrame.this.updateWindowTitle();
            }

            @Override
            public void worldStateNodeAdded(String nodeId) {
                SpaceTimeWindowFrame.this._roomPicker.listModelChanged();
                SpaceTimeWindowFrame.this.setStateDirty(true);
                SpaceTimeWindowFrame.this._globalScoreChart.setValue(SpaceTimeWindowFrame.this._dataAdapter.getGlobalScore());
                SpaceTimeWindowFrame.this.syncOptimizeMenu();
                SpaceTimeWindowFrame.this.updateWindowTitle();
            }

            @Override
            public void worldStateGlobalScoreChanged(double score) {
                SpaceTimeWindowFrame.this._globalScoreChart.setValue((float)score);
                SpaceTimeWindowFrame.this.syncOptimizeMenu();
                SpaceTimeWindowFrame.this.updateWindowTitle();
            }

            @Override
            public void worldStateNodeScoreChanged(String nodeId, double score) {
            }

            public boolean isShownInGuiOnlyChange(NodeChangeSummary changes) {
                if (changes._edgesChanged != null && changes._edgesChanged.length > 0) {
                    return false;
                }
                if (changes._propertiesChanged != null) {
                    Change[] changeArray = changes._propertiesChanged;
                    int n = changes._propertiesChanged.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Change element = changeArray[n2];
                        if (!element._sourceId.equals("shownInGui")) {
                            return false;
                        }
                        ++n2;
                    }
                }
                return true;
            }

            public boolean isScheduleChange(NodeChangeSummary changes) {
                if (changes._edgesChanged == null) {
                    return false;
                }
                Change[] changeArray = changes._edgesChanged;
                int n = changes._edgesChanged.length;
                int n2 = 0;
                while (n2 < n) {
                    Change change = changeArray[n2];
                    if (change._sourceId.equals("assignTo")) {
                        return true;
                    }
                    ++n2;
                }
                return false;
            }
        });
        if (this._dataAdapter != null) {
            this.setShowOptimizationHint(this._dataAdapter.getOptimizationHint());
            this._dataAdapter.addEventListener(new EventAdapter(){

                @Override
                public void optimizationRecommended(boolean optimize) {
                    SpaceTimeWindowFrame.this.setShowOptimizationHint(optimize);
                    SpaceTimeWindowFrame.this.syncOptimizeMenu();
                    SpaceTimeWindowFrame.this.updateWindowTitle();
                }
            });
            this._dataAdapter.addEventListener(new EventAdapter(){

                @Override
                public void vendorOrdersPlaced() {
                    SpaceTimeWindowFrame.this._optimizeVendorOrdersButton.setText(SpaceTimeWindowFrame.VENDOR_OPTIMIZER_BUTTON_LABEL_DISABLED);
                    SpaceTimeWindowFrame.this._optimizeVendorOrdersButton.setEnabled(false);
                    SpaceTimeWindowFrame.this._radar.getProps().setProperty("radar.vot.suspendVerification", "true");
                    SpaceTimeWindowFrame.this.syncOptimizeMenu();
                    SpaceTimeWindowFrame.this.updateWindowTitle();
                }
            });
            this._dataAdapter.addEventListener(new EventAdapter(){

                @Override
                public void vendorOrdersConfirmed() {
                    SpaceTimeWindowFrame.this._optimizeVendorOrdersButton.setText(SpaceTimeWindowFrame.VENDOR_OPTIMIZER_BUTTON_LABEL_ENABLED);
                    SpaceTimeWindowFrame.this._optimizeVendorOrdersButton.setEnabled(true);
                    SpaceTimeWindowFrame.this._radar.getProps().setProperty("radar.vot.suspendVerification", "false");
                    SpaceTimeWindowFrame.this.syncOptimizeMenu();
                    SpaceTimeWindowFrame.this.updateWindowTitle();
                }
            });
            this._calendarGrid.suppressLayout(true);
            this._globalScoreChart.setValue(this._dataAdapter.getGlobalScore());
            this._calendarGrid.suppressLayout(false);
            this.syncOptimizeMenu();
        }
        if (this._radar != null) {
            this.setRadar();
        }
    }

    private void createMainMenu() {
        JMenuItem exitItem = new JMenuItem("Exit", 69);
        JMenu fileMenu = new JMenu("File");
        fileMenu.setMnemonic(70);
        fileMenu.add(exitItem);
        this._undoMenuItem = new JMenuItem("Undo");
        this._undoMenuItem.setAccelerator(KeyStroke.getKeyStroke(90, 2));
        this._undoMenuItem.setEnabled(false);
        this._redoMenuItem = new JMenuItem("Redo");
        this._redoMenuItem.setAccelerator(KeyStroke.getKeyStroke(89, 2));
        this._redoMenuItem.setEnabled(false);
        JMenuItem editConferenceProperties = new JMenuItem("Conference Properties", 67);
        JMenu editMenu = new JMenu("Edit");
        editMenu.setMnemonic(69);
        editMenu.add(this._undoMenuItem);
        editMenu.add(this._redoMenuItem);
        editMenu.add(editConferenceProperties);
        JMenuItem roomAndEventElicitor = new JMenuItem("Generate Questions about Rooms and Events", 69);
        JMenuItem vendorElicitor = new JMenuItem("Generate Questions about Vendors", 86);
        JMenuItem runBatchLearning = new JMenuItem("Run Slow Learning", 76);
        JMenu wargamingMenu = new JMenu("Wargaming");
        wargamingMenu.setMnemonic(87);
        wargamingMenu.add(roomAndEventElicitor);
        if (this._dataAdapter.getParameters().vendorElicitor()) {
            wargamingMenu.add(vendorElicitor);
        }
        wargamingMenu.add(runBatchLearning);
        JMenu debugMenu = new JMenu("Debug");
        debugMenu.setMnemonic(68);
        this._showScoresMenuItem = new JCheckBoxMenuItem("Show Scores");
        this._showScoresMenuItem.setMnemonic(83);
        this._showScoresMenuItem.setSelected(true);
        debugMenu.add(this._showScoresMenuItem);
        this._showDetailsMenuItem = new JCheckBoxMenuItem("Show Debug Details");
        this._showDetailsMenuItem.setMnemonic(68);
        this._showDetailsMenuItem.setSelected(false);
        this._showDetailsMenuItem.setAccelerator(KeyStroke.getKeyStroke(68, 2));
        debugMenu.add(this._showDetailsMenuItem);
        exitItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Services.logger.info("The user selected the Exit menu item");
                SpaceTimeWindowFrame.this.requestCloseWindow();
            }
        });
        this._showScoresMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean showScores = SpaceTimeWindowFrame.this._showScoresMenuItem.isSelected();
                SpaceTimeWindowFrame.this._globalScoreTitlePane.setVisible(showScores);
                SpaceTimeWindowFrame.this._itemList.showScores(showScores);
                if (SpaceTimeWindowFrame.this._dataAdapter != null && !showScores) {
                    SpaceTimeWindowFrame.this._dataAdapter.flushScores();
                }
            }
        });
        this._showDetailsMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean showDetails = SpaceTimeWindowFrame.this._showDetailsMenuItem.isSelected();
                SpaceTimeWindowFrame.this._itemList.showDetailsPane(showDetails);
            }
        });
        this._undoMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Services.journal.undo();
                SpaceTimeWindowFrame.this._itemList.refreshDetails();
            }
        });
        this._redoMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Services.journal.redo();
            }
        });
        roomAndEventElicitor.addActionListener(new ActionListener(){
            private GenericStatusDialog _dlg;

            @Override
            public void actionPerformed(ActionEvent e) {
                this._dlg = new GenericStatusDialog(SpaceTimeWindowFrame.this, "Generating Questions about Rooms and Events", "Generating questions for you about rooms and events. This operation may take several minutes.", false);
                EventAdapter listener = new EventAdapter(){

                    @Override
                    public void elicitationDone(String outputFile) {
                        _dlg.setOperationComplete();
                    }
                };
                SpaceTimeWindowFrame.this._dataAdapter.addEventListener(listener);
                SpaceTimeWindowFrame.this._stmSession.runElicitation();
                this._dlg.setVisible(true);
                SpaceTimeWindowFrame.this._dataAdapter.removeEventListener(listener);
                this._dlg.dispose();
                this._dlg = null;
            }
        });
        vendorElicitor.addActionListener(new ActionListener(){
            private GenericStatusDialog _dlg;

            @Override
            public void actionPerformed(ActionEvent e) {
                this._dlg = new GenericStatusDialog(SpaceTimeWindowFrame.this, "Generating Questions about Vendors", "Generating questions for you about vendors. This operation may take several minutes.", false);
                EventAdapter listener = new EventAdapter(){

                    @Override
                    public void vendorElicitorDone(String outputFile) {
                        _dlg.setOperationComplete();
                    }
                };
                SpaceTimeWindowFrame.this._dataAdapter.addEventListener(listener);
                SpaceTimeWindowFrame.this._stmSession.runVendorElicitor();
                this._dlg.setVisible(true);
                SpaceTimeWindowFrame.this._dataAdapter.removeEventListener(listener);
                this._dlg.dispose();
                this._dlg = null;
            }
        });
        runBatchLearning.addActionListener(new ActionListener(){
            private GenericStatusDialog _dlg;

            @Override
            public void actionPerformed(ActionEvent e) {
                this._dlg = new GenericStatusDialog(SpaceTimeWindowFrame.this, "Slow Learning", "Analyzing collected data.", true);
                EventAdapter listener = new EventAdapter(){

                    @Override
                    public void batchLearningDone() {
                        _dlg.setOperationComplete();
                    }
                };
                SpaceTimeWindowFrame.this._dataAdapter.addEventListener(listener);
                SpaceTimeWindowFrame.this._stmSession.startBatchLearning();
                this._dlg.setVisible(true);
                if (this._dlg.isCancelled()) {
                    SpaceTimeWindowFrame.this._stmSession.interruptBatchLearning();
                }
                SpaceTimeWindowFrame.this._dataAdapter.removeEventListener(listener);
                this._dlg.dispose();
                this._dlg = null;
            }
        });
        editConferenceProperties.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Services.logger.info("The user open the Conference Properties dialog");
                SpaceTimeNode grass = SpaceTimeWindowFrame.this._dataAdapter.getNodeById("grass");
                EditConferencePropertiesDialog dlg = new EditConferencePropertiesDialog("Conference Properties", grass);
                dlg.setVisible(true);
                dlg.dispose();
            }
        });
        JMenuBar mainMenu = new JMenuBar();
        mainMenu.add(fileMenu);
        mainMenu.add(editMenu);
        if (this.isTrainingMode()) {
            mainMenu.add(wargamingMenu);
        }
        if (this._dataAdapter.getParameters().debugModeOn()) {
            mainMenu.add(debugMenu);
        }
        this.setJMenuBar(mainMenu);
    }

    protected boolean isTrainingMode() {
        if (this._radar != null) {
            String mode = this._radar.getProps().getProperty("radar.mode", "test");
            return mode.equalsIgnoreCase("training");
        }
        return this._dataAdapter.getParameters().trainingMode();
    }

    private void setShowOptimizationHint(boolean newShowOptimizationHint) {
        if (this._showOptimizationHint == newShowOptimizationHint) {
            return;
        }
        this._showOptimizationHint = newShowOptimizationHint;
        if (this._showOptimizationHint) {
            this.ensureActiveTaskExists(OPTIMIZE_TASK_TYPE);
        } else {
            this.deleteActiveTask(OPTIMIZE_TASK_TYPE);
        }
    }

    private void setStateDirty(boolean newStateDirty) {
        if (this._stateDirty == newStateDirty) {
            return;
        }
        this._stateDirty = newStateDirty;
    }

    private void setScheduleDirty(boolean newScheduleDirty) {
        if (this._scheduleDirty == newScheduleDirty) {
            return;
        }
        this._scheduleDirty = newScheduleDirty;
        if (this._scheduleDirty) {
            this.ensureActiveTaskExists(PUBLISH_TASK_TYPE);
        } else {
            this.deleteActiveTask(PUBLISH_TASK_TYPE);
        }
    }

    private void ensureActiveTaskExists(String taskType) {
        if (this._radar != null) {
            Services.logger.info("creating an active " + taskType + " task, if none exists");
            Integer taskId = this._radar.ensureActiveTaskExists(taskType);
            if (taskId != null) {
                Services.logger.info("active " + taskType + " task exists, id=" + taskId);
            } else {
                Services.logger.error("unable to ensure than an active " + taskType + " task exists");
            }
        }
    }

    private void markActiveTaskAsStarted(String taskType) {
        if (this._radar != null) {
            Services.logger.info("setting the active " + taskType + " task as running");
            Integer taskId = this._radar.ensureActiveTaskExists(taskType);
            if (taskId != null) {
                this._radar.setTaskState(taskId.toString(), "RUNNING");
                Services.logger.info("active " + taskType + " task (id=" + taskId + "): state set to running");
            } else {
                Services.logger.error("unable to find an active " + taskType + " task");
            }
        }
    }

    private void markActiveTaskAsCompleted(String taskType) {
        if (this._radar != null) {
            Services.logger.info("setting the active " + taskType + " task as completed");
            Integer taskId = this._radar.getActiveTask(taskType, null);
            if (taskId != null) {
                this._radar.setTaskState(taskId.toString(), "COMPLETED");
                Services.logger.info("active " + taskType + " task (id=" + taskId + "): state set to completed");
            } else {
                Services.logger.error("unable to find an active " + taskType + " task");
            }
        }
    }

    private void deleteActiveTask(String taskType) {
        if (this._radar != null) {
            Services.logger.info("deleting the active " + taskType + " task, if one exists");
            HashSet<String> ignoreStates = new HashSet<String>();
            ignoreStates.add("RUNNING");
            Integer taskId = this._radar.getActiveTask(taskType, ignoreStates);
            if (taskId != null) {
                this._radar.setTaskState(taskId.toString(), "DELETED");
                Services.logger.info("active " + taskType + " task (id=" + taskId + "): state set to deleted");
            }
        }
    }

    public SpaceTimeSession getStmSession() {
        return this._stmSession;
    }

    private void requestCloseWindow() {
        if (this._radar != null) {
            JOptionPane.showMessageDialog(this, "The Radar SpaceTime Planner cannot be closed.", "Radar SpaceTime Planner", 2);
            return;
        }
        if (this.promptSaveIfDirty()) {
            this._stmSession.shutdown();
            this.dispose();
            System.exit(0);
        }
    }

    private boolean promptSaveIfDirty() {
        if (this._stateDirty) {
            if (this._publishButton.isEnabled()) {
                Object[] buttonLabels = new String[]{"Publish then exit", "Exit without publishing", "Do not exit"};
                int result = JOptionPane.showOptionDialog(this, "The schedule has changed.\nDo you want to publish it before exiting?", "Exit", 1, 2, null, buttonLabels, buttonLabels[0]);
                switch (result) {
                    case -1: 
                    case 2: {
                        return false;
                    }
                    case 0: {
                        this._publishButton.doClick();
                        return true;
                    }
                    case 1: {
                        return true;
                    }
                }
            } else {
                Object[] buttonLabels = new String[]{"Exit without publishing", "Do not exit"};
                int result = JOptionPane.showOptionDialog(this, "The schedule has changed, but cannot be published as is.\nDo you want to exit anyway?", "Exit", 0, 2, null, buttonLabels, buttonLabels[0]);
                switch (result) {
                    case 0: {
                        return true;
                    }
                    case -1: 
                    case 1: {
                        return false;
                    }
                }
            }
        }
        return true;
    }

    private void setRadar() {
        if (this._radar.condIsPlusL() || this._radar.condIsMinusL()) {
            this._showScoresMenuItem.setSelected(true);
            this._optimizeEnabled = true;
        } else {
            this._showScoresMenuItem.setSelected(false);
            this._optimizeEnabled = false;
            this._optimizeScheduleButton.setEnabled(false);
        }
    }

    public SpaceTimeDataAdapter getDataAdapter() {
        return this._dataAdapter;
    }

    @Override
    public void contentsChanged(ListDataEvent e) {
        if (this._dataAdapter == null) {
            return;
        }
        if (!this._showScoresMenuItem.isSelected()) {
            this._dataAdapter.flushScores();
        }
        this.setStateDirty(true);
        this._globalScoreChart.setValue(this._dataAdapter.getGlobalScore());
        this.syncOptimizeMenu();
        this._datePicker.setValidDateRange(new SpaceTimeDate(this._dataAdapter.getScenarioStart()), new SpaceTimeDate(this._dataAdapter.getScenarioStop()));
        this.updateWindowTitle();
    }

    @Override
    public void intervalAdded(ListDataEvent e) {
    }

    @Override
    public void intervalRemoved(ListDataEvent e) {
    }

    @Override
    public void setSelection(Object sender, Object selection, int type, boolean selected, boolean doubleClick) {
        if (doubleClick && type == 1 && selection instanceof SpaceTimeNode) {
            SpaceTimeNode node = (SpaceTimeNode)selection;
            SpaceTimeRequestNode requestNode = new SpaceTimeRequestNode(node);
            if (requestNode.isAssigned()) {
                this._datePicker.setSelectedDate(requestNode.getStart());
            }
            requestNode.dispose();
        }
    }

    @Override
    public void setViewState(Object sender, Object selection, boolean show) {
    }

    private void updateWindowTitle() {
        Services.logger.trace("SpaceTimeWindowFrame.updateWindowTitle(): enter");
        Services.logger.trace("_showScorePendingHint=" + this._showScorePendingHint + ", _showOverlapErrorHint=" + this._showOverlapErrorHint + ", _showOptimizationHint=" + this._showOptimizationHint + ", _stateDirty=" + this._stateDirty + ", _scheduleDirty=" + this._scheduleDirty);
        String baseName = "Radar SpaceTime Planner";
        if (this._stateDirty) {
            baseName = String.valueOf(baseName) + "*";
        }
        this.setTitle(baseName);
        if (this._dataAdapter == null) {
            this._hintLabel.setText("");
        } else if (this._showScorePendingHint) {
            this._hintLabel.setText(HINT_SCORE_PENDING);
        } else if (this._showOverlapErrorHint) {
            this._hintLabel.setText(HINT_FIX_OVERLAP);
        } else if (this._showOptimizationHint) {
            this._hintLabel.setText(HINT_OPTIMIZE);
        } else if (this._scheduleDirty) {
            this._hintLabel.setText(HINT_PUBLISH);
        } else {
            this._hintLabel.setText(HINT_NONE);
        }
        Services.logger.trace("_hintLabel=" + this._hintLabel.getText());
        Services.logger.trace("SpaceTimeWindowFrame.updateWindowTitle(): exit");
    }

    private void syncOptimizeMenu() {
        Services.logger.trace("SpaceTimeWindowFrame.syncOptimizeMenu(): enter");
        this._showScorePendingHint = false;
        this._showOverlapErrorHint = false;
        boolean optimizedAllowed = true;
        boolean commitAllowed = true;
        for (SpaceTimeNode node : this._dataAdapter.getRequests()) {
            SpaceTimeRequestNode requestNode = new SpaceTimeRequestNode(node);
            if (node.getScore() <= -6.0) {
                Services.logger.trace("node with infeasible score: " + node.getDisplayName());
                commitAllowed = false;
                if (node.getScore() == -6.0 && requestNode.isLockedToRoom()) {
                    optimizedAllowed = false;
                    this._showOverlapErrorHint = true;
                }
                if (node.getScore() == -101.0) {
                    optimizedAllowed = false;
                    this._showScorePendingHint = true;
                }
            }
            requestNode.dispose();
        }
        if (this._dataAdapter.getGlobalScore() <= -6.0f) {
            Services.logger.trace("infeasible global score");
            commitAllowed = false;
        }
        this._optimizeScheduleButton.setEnabled(this._optimizeEnabled && optimizedAllowed);
        this._publishButton.setEnabled(commitAllowed);
        this.updateWindowTitle();
        Services.logger.trace("optimizedAllowed=" + optimizedAllowed + ", commitAllowed=" + commitAllowed);
        Services.logger.trace("SpaceTimeWindowFrame.syncOptimizeMenu(): exit");
    }

    private abstract class AsyncAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public AsyncAction(String name) {
            super(name);
        }

        protected void async(Runnable runnable) {
            Thread runnableThread = new Thread(runnable);
            runnableThread.start();
        }
    }

    private class OptimizeScheduleAction
    extends AsyncAction {
        private static final long serialVersionUID = 1L;
        private GenericStatusDialog _dlg;

        public OptimizeScheduleAction() {
            super("<html><b>Optimize the Schedule</b><br>Create the best possible schedule.</html>");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            WorkJournal.WorldStateCaptureItem stateItem = new WorkJournal.WorldStateCaptureItem(SpaceTimeWindowFrame.this._listModel, "optimize schedule");
            Services.logger.info("The user pressed button: Optimize the Schedule");
            this._dlg = new GenericStatusDialog(SpaceTimeWindowFrame.this, "Optimizing Schedule", "The optimizer is searching for a schedule that best satisfies the constraints. This operation may take several minutes.", false);
            EventAdapter listener = new EventAdapter(){

                @Override
                public void optimizationDone() {
                    Services.logger.trace("optimizer done");
                    OptimizeScheduleAction.this._dlg.setOperationComplete();
                    SpaceTimeWindowFrame.this.markActiveTaskAsCompleted(SpaceTimeWindowFrame.OPTIMIZE_TASK_TYPE);
                }
            };
            SpaceTimeWindowFrame.this._dataAdapter.addEventListener(listener);
            this.async(new Runnable(){

                @Override
                public void run() {
                    SpaceTimeWindowFrame.this.markActiveTaskAsStarted(SpaceTimeWindowFrame.OPTIMIZE_TASK_TYPE);
                    Services.logger.trace("starting optimizer");
                    SpaceTimeWindowFrame.this._stmSession.runOptimizer();
                }
            });
            Services.logger.trace("showing optimizer dialog");
            this._dlg.setVisible(true);
            Services.logger.trace("optimizer dialog closed");
            SpaceTimeWindowFrame.this._dataAdapter.removeEventListener(listener);
            this._dlg.dispose();
            this._dlg = null;
            stateItem.captureState();
            Services.journal.addItem(stateItem);
        }
    }

    private class OptimizeVendorOrdersAction
    extends AsyncAction {
        private static final long serialVersionUID = 1L;
        private GenericStatusDialog _dlg;

        public OptimizeVendorOrdersAction() {
            super(SpaceTimeWindowFrame.VENDOR_OPTIMIZER_BUTTON_LABEL_ENABLED);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Services.logger.info("The user pressed button: Recommend Vendor Order Changes");
            this._dlg = new GenericStatusDialog(SpaceTimeWindowFrame.this, "Generating Recommended Vendor Order Changes", "The optimizer is generating a list of recommended changes to the vendor orders. This operation may take several minutes.", false);
            EventAdapter listener = new EventAdapter(){

                @Override
                public void vendorOptimizerDone() {
                    Services.logger.trace("vendor optimizer done");
                    OptimizeVendorOrdersAction.this._dlg.setOperationComplete();
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    OptimizeVendorOrdersAction.this._dlg.setVisible(false);
                }
            };
            SpaceTimeWindowFrame.this._dataAdapter.addEventListener(listener);
            this.async(new Runnable(){

                @Override
                public void run() {
                    Services.logger.trace("starting vendor optimizer");
                    SpaceTimeWindowFrame.this._stmSession.runVendorOptimizer();
                }
            });
            Services.logger.trace("showing vendor optimizer dialog");
            this._dlg.setVisible(true);
            Services.logger.trace("vendor optimizer dialog closed");
            SpaceTimeWindowFrame.this._dataAdapter.removeEventListener(listener);
            this._dlg.dispose();
            this._dlg = null;
        }
    }

    private class PublishScheduleAction
    extends AsyncAction {
        private static final long serialVersionUID = 1L;
        private GenericStatusDialog _dlg;

        public PublishScheduleAction() {
            super("<html><b>Publish the Schedule</b><br>Update the website with recent changes.</html>");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Services.logger.info("The user pressed button: Publish the Schedule");
            boolean condIsPlusL = SpaceTimeWindowFrame.this._radar != null ? SpaceTimeWindowFrame.this._radar.condIsPlusL() : true;
            String title = condIsPlusL ? "Publishing Schedule" : "Preparing Schedule for Publishing";
            String message = condIsPlusL ? "The schedule is being published to the web site." : "The schedule is being prepared for web site publishing.";
            message = String.valueOf(message) + " This operation may take several minutes.";
            this._dlg = new GenericStatusDialog(SpaceTimeWindowFrame.this, title, message, false);
            EventAdapter listener = new EventAdapter(){

                @Override
                public void schedulePublished(final String wbeFile) {
                    Services.logger.trace("publish schedule done");
                    if (SpaceTimeWindowFrame.this._radar != null) {
                        new Thread(new Runnable(){

                            @Override
                            public void run() {
                                Services.radar.invokeWbE(wbeFile);
                                PublishScheduleAction.this._dlg.setOperationComplete();
                                SpaceTimeWindowFrame.this.markActiveTaskAsCompleted(SpaceTimeWindowFrame.PUBLISH_TASK_TYPE);
                            }
                        }).start();
                    } else {
                        PublishScheduleAction.this._dlg.setOperationComplete();
                    }
                }
            };
            SpaceTimeWindowFrame.this._dataAdapter.addEventListener(listener);
            this.async(new Runnable(){

                @Override
                public void run() {
                    SpaceTimeWindowFrame.this.markActiveTaskAsStarted(SpaceTimeWindowFrame.PUBLISH_TASK_TYPE);
                    Services.logger.trace("starting publish schedule");
                    SpaceTimeWindowFrame.this._stmSession.commit();
                }
            });
            Services.logger.trace("showing publish schedule dialog");
            this._dlg.setVisible(true);
            Services.logger.trace("publish schedule dialog closed");
            SpaceTimeWindowFrame.this._dataAdapter.removeEventListener(listener);
            this._dlg.dispose();
            this._dlg = null;
            if (!SpaceTimeWindowFrame.this._dataAdapter.getParameters().vendorOptimizer()) {
                message = "Since the schedule has changed, some vendor orders may no longer be valid.";
                condIsPlusL = false;
                if (condIsPlusL) {
                    Object[] buttonLabels;
                    int result = JOptionPane.showOptionDialog(SpaceTimeWindowFrame.this, message = String.valueOf(message) + "\nWould you like to use the Vendor Order Tracker (VOT) now?", "Reminder", 2, 1, null, buttonLabels = new String[]{"Open VOT", "Close"}, buttonLabels[0]);
                    if (result == 0 && Services.radar != null) {
                        String VOT_PROPERTY = "radar.stp.vot-url";
                        String votURL = Services.radar.getProps().getProperty("radar.stp.vot-url");
                        if (votURL != null) {
                            Services.logger.info("The user launched VOT");
                            Services.radar.explore(votURL);
                        } else {
                            Services.logger.error("unable to start VOT because property 'radar.stp.vot-url' not found");
                        }
                    }
                } else {
                    JOptionPane.showMessageDialog(SpaceTimeWindowFrame.this, message, "Reminder", 1);
                }
            }
            SpaceTimeWindowFrame.this.setStateDirty(false);
            SpaceTimeWindowFrame.this.setScheduleDirty(false);
            SpaceTimeWindowFrame.this.updateWindowTitle();
        }
    }
}

