/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.radar.rhai.spacetime;

import SpaceTime.DataModel.RoomRequest;
import SpaceTime.DataModel.RoomRequestImpl;
import SpaceTime.DataModel.TimeSlot;
import SpaceTime.DataModel.TimeSlotImpl;
import edu.cmu.cs.radar.integ.ICMRadarRequires;
import edu.cmu.cs.radar.integ.IRadar;
import edu.cmu.cs.radar.integ.IRadarServices;
import edu.cmu.cs.radar.integ.ISTMProvides;
import edu.cmu.cs.radar.rhai.spacetime.STMBackendController;
import edu.cmu.cs.radar.rhai.spacetime.Services;
import edu.cmu.cs.radar.rhai.spacetime.SpaceTimeWindowFrame;
import edu.cmu.cs.radar.stp.cachingdatamodel.EventAdapter;
import edu.cmu.cs.radar.stp.cachingdatamodel.SpaceTimeDataAdapter;
import edu.cmu.cs.radar.stp.cachingdatamodel.SpaceTimeSession;
import java.lang.reflect.InvocationTargetException;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.apache.log4j.Logger;

public class ArchitectureEntry
implements ISTMProvides {
    private SpaceTimeWindowFrame _frame;
    private IRadarServices _radarServices;
    private SpaceTimeSession _stmSession;
    private Logger _logger = Logger.getLogger("STM:SHIM");

    public ArchitectureEntry() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public boolean initialize(IRadarServices radarServices) {
        this._radarServices = radarServices;
        Services.radar = radarServices;
        boolean configureLog4j = false;
        if (Services.radar.getClass().getName().endsWith("RadarServicesLight")) {
            configureLog4j = true;
        }
        Services.initLogger(configureLog4j);
        this._stmSession = STMBackendController.startSTMBackend(this._radarServices.getProps(), this._logger);
        if (this._stmSession == null) {
            this._logger.error("initialize() returning false; was unable to connect to st backend");
            return false;
        }
        SpaceTimeDataAdapter dataAdapter = this._stmSession.getDataAdapter();
        if (dataAdapter == null) {
            this._logger.error("initialize() returning false; was unable to connect to st backend");
            return false;
        }
        String mode = this._radarServices.getProps().getProperty("radar.mode", "test");
        boolean isTrainingMode = mode.equalsIgnoreCase("training");
        dataAdapter.getParameters().trainingMode(isTrainingMode);
        EventAdapter roomRequestListener = new EventAdapter(){

            @Override
            public void roomsRequested(final RoomRequest[] roomRequests) {
                Runnable runFindRoom = new Runnable(){

                    @Override
                    public void run() {
                        RoomRequest[] roomRequestArray = roomRequests;
                        int n = roomRequests.length;
                        int n2 = 0;
                        while (n2 < n) {
                            RoomRequest element = roomRequestArray[n2];
                            RoomRequestImpl roomRequestImpl = (RoomRequestImpl)element;
                            ArchitectureEntry.this._logger.info("calling findRoom()");
                            ArchitectureEntry.this._radarServices.findRoom(roomRequestImpl.toCMRadarFormat());
                            ++n2;
                        }
                    }
                };
                new Thread(runFindRoom).start();
            }
        };
        dataAdapter.addEventListener(roomRequestListener);
        return true;
    }

    public boolean initializeUI(IRadar.KeyVal[] vendorAnnos) {
        try {
            IRadar.KeyVal[] keyValArray = vendorAnnos;
            int n = vendorAnnos.length;
            int n2 = 0;
            while (n2 < n) {
                IRadar.KeyVal vendorAnno = keyValArray[n2];
                this._stmSession.processVOP(vendorAnno.val);
                ++n2;
            }
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    ArchitectureEntry.this._frame = new SpaceTimeWindowFrame(ArchitectureEntry.this._stmSession, ArchitectureEntry.this._radarServices);
                }
            });
        }
        catch (InterruptedException ex) {
            this._logger.error("opening SpaceTime GUI", ex);
            return false;
        }
        catch (InvocationTargetException ex) {
            this._logger.error("opening SpaceTime GUI", ex);
            return false;
        }
        return true;
    }

    @Override
    public boolean shutdown() {
        if (this._stmSession != null) {
            this._stmSession.shutdown();
        }
        if (this._frame != null) {
            this._frame.dispose();
        }
        return true;
    }

    @Override
    public void show() {
        if (this._frame != null) {
            this._frame.setVisible(true);
            this._radarServices.deiconify(this._frame);
        }
    }

    @Override
    public void toFront() {
        if (this._frame != null) {
            this._radarServices.deiconify(this._frame);
            this._frame.toFront();
        }
    }

    @Override
    public void hide() {
        if (this._frame != null) {
            this._frame.setVisible(false);
            this._radarServices.iconify(this._frame);
        }
    }

    @Override
    public void foundARoom(ICMRadarRequires.Reservation reservation) {
        if (this._stmSession != null) {
            this._stmSession.getDataAdapter().submitRoomReservation(reservation);
        }
    }

    public void vendorEmailArrived(IRadar.KeyVal vendorAnno) {
        if (this._stmSession != null) {
            this._stmSession.processVOP(vendorAnno.val);
        }
    }

    @Override
    public void updateRoomStatistics(ICMRadarRequires.RoomStat[] stats) {
        TimeSlot[] slots = new TimeSlot[stats.length];
        int i = 0;
        while (i < slots.length) {
            slots[i] = new TimeSlotImpl(stats[i]);
            ++i;
        }
        this._stmSession.getDataAdapter().updateTimeSlots(slots);
    }
}

