/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.radar.rhai.spacetime;

import edu.cmu.cs.radar.rhai.spacetime.SpaceTimeWindowFrame;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;

public class GenericStatusDialog
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = 0L;
    private final String STATUS_PREFIX = "Status: ";
    private boolean _cancellable;
    private boolean _cancelled;
    private JLabel _messageLabel;
    private JProgressBar _progressBar;
    private JLabel _statusLabel;
    private JButton _cancelButton;
    private JButton _closeButton;

    public GenericStatusDialog(SpaceTimeWindowFrame owner, String title, String message, boolean cancellable) {
        super(owner, title, true);
        this.setResizable(false);
        this.setDefaultCloseOperation(0);
        this._cancellable = cancellable;
        this._cancelled = false;
        if (!this._cancellable) {
            message = String.valueOf(message) + " This operation cannot be cancelled.";
        }
        this._messageLabel = new JLabel("<html>" + message + "</html>");
        this._messageLabel.setAlignmentX(0.0f);
        this._progressBar = new JProgressBar();
        this._progressBar.setAlignmentX(0.0f);
        this._progressBar.setIndeterminate(true);
        this._statusLabel = new JLabel("Status: ");
        this._statusLabel.setAlignmentX(0.0f);
        this._cancelButton = new JButton("Cancel");
        this._cancelButton.setVisible(this._cancellable);
        this._cancelButton.setEnabled(true);
        this._cancelButton.addActionListener(this);
        this._closeButton = new JButton("Close");
        this._closeButton.setEnabled(false);
        this._closeButton.addActionListener(this);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 0));
        buttonPanel.add(Box.createHorizontalGlue());
        buttonPanel.add(this._cancelButton);
        buttonPanel.add(Box.createRigidArea(new Dimension(10, 0)));
        buttonPanel.add(this._closeButton);
        buttonPanel.setAlignmentX(0.0f);
        JPanel content = new JPanel();
        content.setLayout(new BoxLayout(content, 1));
        content.setAlignmentY(0.0f);
        content.add(this._messageLabel);
        content.add(Box.createRigidArea(new Dimension(0, 10)));
        content.add(this._statusLabel);
        content.add(Box.createRigidArea(new Dimension(0, 10)));
        content.add(this._progressBar);
        content.add(Box.createRigidArea(new Dimension(0, 10)));
        content.add(Box.createVerticalGlue());
        content.add(buttonPanel);
        content.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        content.setPreferredSize(new Dimension(400, 180));
        this.setContentPane(content);
        this.pack();
        this.setLocationRelativeTo(owner);
        if (this._cancellable) {
            this.getRootPane().setDefaultButton(this._cancelButton);
        }
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    GenericStatusDialog.this._closeButton.doClick();
                }
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                GenericStatusDialog.this._closeButton.doClick();
            }
        });
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this._cancelButton) {
            this._cancelled = true;
            this.setVisible(false);
        } else if (e.getSource() == this._closeButton) {
            this._cancelled = false;
            this.setVisible(false);
        }
    }

    public boolean isCancelled() {
        return this._cancelled;
    }

    public void setStatusText(String text) {
        this._statusLabel.setText("<html>Status: " + text + "</html>");
    }

    public void setOperationComplete() {
        this._progressBar.setIndeterminate(false);
        this._progressBar.setValue(this._progressBar.getMaximum());
        this.setStatusText("<b>Done</b>");
        this._cancelButton.setEnabled(false);
        this._closeButton.setEnabled(true);
        this.getRootPane().setDefaultButton(this._closeButton);
    }
}

