/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.radar.rhai.spacetime;

import SpaceTime.DataModel.Change;
import SpaceTime.DataModel.NodeChangeSummary;
import edu.cmu.cs.radar.rhai.spacetime.NoHorizontalScrollViewport;
import edu.cmu.cs.radar.rhai.spacetime.RoomDetailsPanel;
import edu.cmu.cs.radar.rhai.spacetime.SelectionListener;
import edu.cmu.cs.radar.rhai.spacetime.SelectionManager;
import edu.cmu.cs.radar.rhai.spacetime.Services;
import edu.cmu.cs.radar.rhai.spacetime.TitlePane;
import edu.cmu.cs.radar.stp.cachingdatamodel.NodeChangeListener;
import edu.cmu.cs.radar.stp.cachingdatamodel.SpaceTimeDataAdapter;
import edu.cmu.cs.radar.stp.cachingdatamodel.SpaceTimeNode;
import edu.cmu.cs.radar.stp.cachingdatamodel.SpaceTimeProperty;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public abstract class DetailsPanel
extends JPanel
implements SelectionListener,
NodeChangeListener {
    private static final long serialVersionUID = 1L;
    protected static Icon __minusIcon;
    protected static Icon __plusIcon;
    protected static final String CATEGORY_OTHER = "Other";
    protected SpaceTimeDataAdapter _dataAdapter;
    protected SpaceTimeNode _node;
    protected TitlePane _titlePane;
    protected JTree _detailsTree;
    protected DefaultTreeModel _treeModel;
    protected EditNodeAction _editAction;
    protected JButton _editButton;
    protected Map<String, TreeNode> _propertyToTreeNodeMap;

    static {
        ClassLoader classLoader = RoomDetailsPanel.class.getClassLoader();
        __minusIcon = new ImageIcon(classLoader.getResource("edu/cmu/cs/radar/rhai/media/minus.png"));
        __plusIcon = new ImageIcon(classLoader.getResource("edu/cmu/cs/radar/rhai/media/plus.png"));
    }

    public DetailsPanel(SpaceTimeDataAdapter dataAdapter, SelectionManager selectionManager, EditNodeAction editAction) {
        this.setLayout(new BorderLayout());
        this.setBackground(Color.white);
        this._dataAdapter = dataAdapter;
        this._editAction = editAction;
        this._detailsTree = new JTree(new DefaultTreeModel(null));
        this._detailsTree.setRootVisible(false);
        this._detailsTree.setEditable(false);
        this._detailsTree.setToggleClickCount(1);
        this._detailsTree.setRowHeight(-1);
        this._detailsTree.setSelectionModel(null);
        DefaultTreeCellRenderer renderer = this.getTreeCellRenderer();
        renderer.setClosedIcon(__plusIcon);
        renderer.setOpenIcon(__minusIcon);
        renderer.setLeafIcon(null);
        renderer.setBackground(this.getBackground());
        renderer.setBorderSelectionColor(null);
        renderer.setBackgroundSelectionColor(new Color(55, 104, 197));
        renderer.setTextSelectionColor(Color.white);
        this._detailsTree.setCellRenderer(renderer);
        this._treeModel = new DefaultTreeModel(new DefaultMutableTreeNode());
        this._detailsTree.setModel(this._treeModel);
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setViewport(new NoHorizontalScrollViewport());
        scrollPane.setViewportView(this._detailsTree);
        scrollPane.setBorder(null);
        scrollPane.setBackground(this.getBackground());
        scrollPane.setViewportBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        scrollPane.setHorizontalScrollBarPolicy(31);
        this.add((Component)scrollPane, "Center");
        this._editButton = new JButton(editAction);
        this._editButton.setHorizontalAlignment(2);
        this.add((Component)this._editButton, "South");
        this._propertyToTreeNodeMap = new HashMap<String, TreeNode>();
        selectionManager.addListener(this);
    }

    protected DefaultTreeCellRenderer getTreeCellRenderer() {
        return new DefaultTreeCellRenderer();
    }

    protected abstract void augmentDetailsTree(DefaultMutableTreeNode var1);

    public void setTitlePane(TitlePane titlePane) {
        this._titlePane = titlePane;
        this.update();
    }

    public void setNode(SpaceTimeNode node) {
        if (this._node != null) {
            this._node.removeChangeListener(this);
        }
        this._node = node;
        if (this._node != null) {
            this._node.addChangeListener(this);
        }
        this.update();
    }

    @Override
    public void setViewState(Object sender, Object selection, boolean show) {
    }

    private void update() {
        if (this._titlePane == null) {
            return;
        }
        if (this._node == null) {
            this._titlePane.setTitle("Details");
            this._detailsTree.setModel(new DefaultTreeModel(null));
            this._editAction.setNode(null);
            this._editButton.setVisible(false);
        } else {
            this._titlePane.setTitle("Details for " + this._node.getDisplayName());
            this.buildTree();
            this._editAction.setNode(this._node);
            this._editButton.setVisible(true);
        }
    }

    public static Map<String, List<SpaceTimeProperty>> collectCategories(SpaceTimeNode node, boolean onlyDisplayed) {
        HashMap<String, List<SpaceTimeProperty>> categories = new HashMap<String, List<SpaceTimeProperty>>();
        for (String propertyName : node.getPropertyNames()) {
            SpaceTimeProperty property = node.getProperty(propertyName);
            if (property == null) {
                Services.logger.warn("null property: node='" + node.getName() + "', property='" + propertyName + "'");
                continue;
            }
            if (!onlyDisplayed ? property.isHidden() : !property.isDisplayed()) continue;
            String category = property.getCategory();
            if (category == null) {
                category = CATEGORY_OTHER;
            }
            if (!categories.containsKey(category)) {
                categories.put(category, new ArrayList());
            }
            List properties = (List)categories.get(category);
            properties.add(property);
        }
        return categories;
    }

    private void buildTree() {
        this._propertyToTreeNodeMap.clear();
        Map<String, List<SpaceTimeProperty>> categories = DetailsPanel.collectCategories(this._node, true);
        DefaultMutableTreeNode rootTreeNode = new DefaultMutableTreeNode(this._node.getDisplayName());
        ArrayList categoryLabels = new ArrayList(categories.keySet());
        Collections.sort(categoryLabels);
        for (String categoryLabel : categoryLabels) {
            List<SpaceTimeProperty> propertyGroup = categories.get(categoryLabel);
            if (propertyGroup.size() <= 0) continue;
            Collections.sort(propertyGroup, SpaceTimeProperty.sLabelAndDisplayStringComparator);
            DefaultMutableTreeNode categoryNode = new DefaultMutableTreeNode(categoryLabel);
            for (SpaceTimeProperty property : propertyGroup) {
                DefaultMutableTreeNode propertyTreeNode = new DefaultMutableTreeNode(property.getDisplayLabelAndValueString(), false);
                categoryNode.add(propertyTreeNode);
                this._propertyToTreeNodeMap.put(property.getPropertyType(), propertyTreeNode);
            }
            rootTreeNode.add(categoryNode);
        }
        this.augmentDetailsTree(rootTreeNode);
        this._treeModel.setRoot(rootTreeNode);
        this._detailsTree.setModel(this._treeModel);
        int i = 0;
        while (i < rootTreeNode.getChildCount()) {
            TreePath path = new TreePath(((DefaultMutableTreeNode)rootTreeNode.getChildAt(i)).getPath());
            this._detailsTree.expandPath(path);
            ++i;
        }
    }

    @Override
    public void nodeChanged(String nodeName, NodeChangeSummary changes) {
        if (this._node == null || !this._node.getName().equals(nodeName)) {
            return;
        }
        if (changes != null && changes._propertiesChanged != null) {
            Change[] changeArray = changes._propertiesChanged;
            int n = changes._propertiesChanged.length;
            int n2 = 0;
            while (n2 < n) {
                Change change = changeArray[n2];
                String propertyName = change._sourceId;
                SpaceTimeProperty property = this._node.getProperty(propertyName);
                if (property != null) {
                    boolean propertyInTree;
                    DefaultMutableTreeNode propertyTreeNode = (DefaultMutableTreeNode)this._propertyToTreeNodeMap.get(propertyName);
                    boolean bl = propertyInTree = propertyTreeNode != null;
                    if (property.isDisplayed() != propertyInTree) {
                        this.buildTree();
                        return;
                    }
                    if (propertyTreeNode != null) {
                        propertyTreeNode.setUserObject(property.getDisplayLabelAndValueString());
                        this._treeModel.nodeChanged(propertyTreeNode);
                    }
                }
                ++n2;
            }
        }
    }

    public static abstract class EditNodeAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        protected SpaceTimeNode _node;

        public EditNodeAction(String name) {
            super(name);
        }

        public void setNode(SpaceTimeNode node) {
            this._node = node;
            this.setEnabled(node != null);
        }
    }
}

