/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.radar.rhai.calendar;

import edu.cmu.cs.radar.rhai.calendar.CalendarObject;
import edu.cmu.cs.radar.rhai.calendar.CalendarObjectCollection;
import edu.cmu.cs.radar.rhai.calendar.Constraint;
import edu.cmu.cs.radar.rhai.calendar.ConstraintView;
import edu.cmu.cs.radar.rhai.calendar.ConstraintsView;
import edu.cmu.cs.radar.rhai.calendar.DateTime;
import edu.cmu.cs.radar.rhai.calendar.FilteredCalendarObjectCollection;
import edu.cmu.cs.radar.rhai.calendar.MemoryCalendarObjectCollection;
import edu.cmu.cs.radar.rhai.calendar.SimpleCalendarObject;
import edu.cmu.cs.radar.rhai.calendar.Time;
import edu.cmu.cs.radar.rhai.calendar.TimeGrid;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Date;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class MultiOptionTimeGrid
extends JPanel {
    private static final long serialVersionUID = 1L;
    protected Object mLabel;
    protected Time.Range mRange;
    protected ConstraintsView mConstraintsView;
    protected ButtonGroup mOptionButtonGroup;

    public MultiOptionTimeGrid(Time.Range range) {
        if (range == null) {
            throw new NullPointerException("argument 'range'");
        }
        this.mRange = range;
        this.setBackground(Color.WHITE);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbcons = null;
        this.mConstraintsView = new ConstraintsView(range);
        gbcons = new GridBagConstraints();
        gbcons.gridx = 0;
        gbcons.gridy = 1;
        gbcons.weightx = 0.0;
        gbcons.fill = 1;
        this.add((Component)this.mConstraintsView, gbcons);
        this.mOptionButtonGroup = new ButtonGroup();
    }

    public Option addOption(CalendarObjectCollection calObjCol, String name) {
        Option option = new Option(calObjCol, this.mRange, name);
        GridBagLayout gblayout = (GridBagLayout)this.getLayout();
        GridBagConstraints gbcons = null;
        gbcons = gblayout.getConstraints(this.mConstraintsView);
        int newOptionGridX = gbcons.gridx++;
        gblayout.setConstraints(this.mConstraintsView, gbcons);
        gbcons = new GridBagConstraints();
        gbcons.gridx = newOptionGridX;
        gbcons.gridy = 0;
        gbcons.fill = 10;
        gbcons.weightx = 0.0;
        gbcons.weighty = 0.0;
        gbcons.gridx = newOptionGridX;
        gbcons.gridy = 1;
        gbcons.fill = 1;
        gbcons.weightx = 1.0;
        gbcons.weighty = 1.0;
        this.add((Component)option, gbcons);
        this.revalidate();
        return option;
    }

    public void addConstraints(Constraint[] constraints) {
        this.mConstraintsView.add(new ConstraintView(constraints));
    }

    public static void test() {
        MemoryCalendarObjectCollection calObjCol = new MemoryCalendarObjectCollection();
        DateTime monday = new DateTime("2004-12-20");
        MultiOptionTimeGrid mondayPanel = new MultiOptionTimeGrid(Time.Range.create("8:00--18:00"));
        FilteredCalendarObjectCollection mondayCalObjCol = new FilteredCalendarObjectCollection(new DateFilter(monday));
        mondayCalObjCol.connectToSource(calObjCol);
        mondayPanel.addOption(mondayCalObjCol, "x");
        DateTime tuesday = new DateTime("2004-12-21");
        MultiOptionTimeGrid tuesdayPanel = new MultiOptionTimeGrid(Time.Range.create("8:00--18:00"));
        FilteredCalendarObjectCollection tuesdayCalObjCol = new FilteredCalendarObjectCollection(new DateFilter(tuesday));
        tuesdayCalObjCol.connectToSource(calObjCol);
        tuesdayPanel.addOption(tuesdayCalObjCol, "y");
        SimpleCalendarObject calObj1 = new SimpleCalendarObject("id1", DateTime.Range.create("2004-12-20 10:00 -- 2004-12-20 11:00"));
        SimpleCalendarObject calObj2 = new SimpleCalendarObject("id2", DateTime.Range.create("2004-12-21 11:00 -- 2004-12-21 12:00"));
        calObjCol.addCalendarObject(calObj1);
        calObjCol.addCalendarObject(calObj2);
        JPanel days = new JPanel();
        days.add(mondayPanel);
        days.add(tuesdayPanel);
        ClassLoader classLoader = MultiOptionTimeGrid.class.getClassLoader();
        ImageIcon icon = new ImageIcon(classLoader.getResource("edu/cmu/cs/radar/rhai/media/radar-icon.png"));
        JFrame frame = new JFrame("Radar Rhai Calendar");
        frame.setIconImage(icon.getImage());
        frame.setLocation(300, 125);
        frame.setSize(800, 800);
        frame.setDefaultCloseOperation(2);
        frame.setContentPane(days);
        frame.setVisible(true);
    }

    public static void main(String[] args) {
        MultiOptionTimeGrid.test();
    }

    public static class DateFilter
    implements FilteredCalendarObjectCollection.Filter {
        public DateTime.Range mRange;

        public DateFilter(Date date) {
            if (date == null) {
                throw new NullPointerException("argument 'date'");
            }
            this.mRange = new DateTime.Range(new DateTime(date, new Time("0:00")), new DateTime(date, new Time("24:00")));
        }

        @Override
        public boolean include(CalendarObject calObj) {
            return this.mRange.contains(calObj.getDateTimeRange());
        }
    }

    public class Option
    extends TimeGrid {
        private static final long serialVersionUID = 1L;
        protected JRadioButton mHeader;

        private Option(CalendarObjectCollection calObjCol, Time.Range range, String name) {
            super(calObjCol, range);
            this.mHeader = new JRadioButton(name);
            this.mHeader.setBackground(null);
            this.mHeader.setFocusable(false);
            this.mHeader.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    Option.this.setBackground(e.getStateChange() == 1 ? new Color(235, 240, 242) : null);
                }
            });
            MultiOptionTimeGrid.this.mOptionButtonGroup.add(this.mHeader);
        }

        public JRadioButton getHeader() {
            return this.mHeader;
        }

        public void select() {
            this.mHeader.setSelected(true);
        }
    }
}

