// $Id: IRadarServices.java,v 4.9 2008/06/16 17:27:21 jordan Exp $

package edu.cmu.cs.radar.integ;

import java.util.Date;
import java.util.Properties;
import java.awt.Frame;

/**
 * This interface encapsulates what various parts of Radar will call.
 * In other words, it's how the rest of Radar looks to any individual
 * component.
 * 
 */
public interface IRadarServices extends IRadar,
  IAMRequires, IBARequires, ICMRadarRequires, IConsoleRequires,
  IDummyRequires, IFormsRequires, ISTMRequires, ITestRigProvides
{
    /**
     * get all the properties used to configure RADAR
     */
    public Properties getProps(); 

    /**
     * get RADAR username
     */
    public String getUser(); 

    /**
     * get path of the root of the writable RADAR directory
     */
    public String getRoot(); 

    public void iconify(Frame x);
    public void deiconify(Frame x);

    /**
     * translate to "test" time
     */
    public Date translateToTestTime(Date d);

    /**
     * bring the STM to the front
     */
    public void bringSTMToFront();

    /**
     * listener interface for component status
     */
    public interface StatusListener {
	/**
	 * called when status of component changes
	 *
	 * @param	name	name of component
	 * @param	o	old value
	 * @param	n	new value
	 */
	public void changed(String name, String o, String n);
    }
    /**
     * set component status
     *
     * @return	previous status
     * @param	component	name of component
     * @param	status	status of component
     */
    public String setStatus(String component, String status);
    /**
     * snapshot of component status
     *
     * @param	component	name of component
     */
    public String getStatus(String component);
    /**
     * listen for status
     *
     * @return	current status
     * @param	component	name of component
     * @param	sl	listener
     */
    public String addStatusListener(String component, StatusListener sl);
    /**
     * stop listening for status
     *
     * @param	component	name of component
     * @param	sl	listener
     */
    public void removeStatusListener(String component, StatusListener sl);
}
