package edu.cmu.cs.radar.integ;

/**
 * Defines constants for RADAR-wide task properties stored by the Task Manager. Further details at: <a
 * href="http://radar-wm.isri.cmu.edu:8000/radar/wiki/Task/PublicDataModel">Task Public Data Model</a>. *
 * <p>
 * The keys use the following prefix namespace acronyms:
 * <ul>
 * <li>TPK: Task Property Key</li>
 * </ul>
 * 
 * @author faulring
 */
public interface TaskConstants
{
	/**
	 * The prefix for task constants.
	 */
	public final String TASK_PREFIX = "urn:edu.cmu.cs.radar.task.";

	/**
	 * The prefix for task property keys.
	 */
	public static final String TPK_PREFIX = TASK_PREFIX + "property.key.";

	/**
	 * The task type represented by this prototype. The "type" field of task instances will be set to this
	 * value.
	 * <p>
	 * Type: String
	 * <p>
	 * Required
	 * <p>
	 * Read-only
	 */
	public static final String TPK_TYPE = TPK_PREFIX + "type";

	/**
	 * A boolean flag indicating whether or not the user can create task instances of this type.
	 * <p>
	 * Type: Boolean
	 * <p>
	 * Required
	 * <p>
	 * Read-only
	 */
	public static final String TPK_USER_CREATABLE = TPK_PREFIX + "user-creatable";

	/**
	 * A boolean flag indicating whether or not more than active task instance of this type is allowed. Any
	 * number of deleted or completed instances are allowed.
	 * <p>
	 * Type: Boolean
	 * <p>
	 * Required
	 * <p>
	 * Read-only
	 */
	public static final String TPK_ONLY_ONE_ACTIVE = TPK_PREFIX + "only-one-active";

	/**
	 * The XML template used to generate the XML form for each instance of this prototype.
	 * <p>
	 * Type: String
	 * <p>
	 * Required
	 * <p>
	 * Read-only
	 */
	public static final String TPK_FORM = TPK_PREFIX + "form";

	/**
	 * The fully qualified name of the class that implements edu.cmu.cs.radar.task.ITaskPrototype. Only the
	 * TMI and Console use this class.
	 * <p>
	 * Type: String
	 * <p>
	 * Required
	 * <p>
	 * Read-only
	 */
	public static final String TPK_ITASK_PROTOTYPE = TPK_PREFIX + "itask-prototype";

	/**
	 * Indicates who created the task: Radar or the User. Valid values are "RADAR" and "USER".
	 * <p>
	 * Type: String
	 * <p>
	 * Required
	 */
	public static final String TPK_CREATOR = TPK_PREFIX + "creator";

	/**
	 * The value for the TPK_CREATOR property that indicates that RADAR created the task.
	 */
	public final String CREATOR_RADAR = "RADAR";

	/**
	 * The value for the TPK_CREATOR property that indicates that the USER created the task.
	 */
	public final String CREATOR_USER = "USER";

	/**
	 * The html version of the task's description.
	 * <p>
	 * Type: String
	 * <p>
	 * Required
	 */
	public static final String TPK_DESCRIPTION_HTML = TPK_PREFIX + "description-html";

	/**
	 * The time that the user last modified this task. Note that the user can modify this task without
	 * necessarily completing it, for example changing the record for a scheduling task.
	 * <p>
	 * Type: Date
	 */
	public static final String TPK_USER_MODIFIED_TIME = TPK_PREFIX + "user-modified-time";
}