/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.radar.rhai.spacetime;

import edu.cmu.cs.radar.rhai.spacetime.SpaceTimeRequestNode;
import edu.cmu.cs.radar.rhai.spacetime.SwingHelper;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.FilteredImageSource;
import java.awt.image.RGBImageFilter;
import javax.swing.JComponent;

public class GenericRequestDragComponent
extends JComponent {
    private static final long serialVersionUID = 0L;
    private DrawListener _drawListener;
    private SpaceTimeRequestNode _requestNode;
    private Object _source;
    private Image _image;

    public GenericRequestDragComponent(SpaceTimeRequestNode requestNode, Object source) {
        this._requestNode = requestNode;
        this._source = source;
    }

    public SpaceTimeRequestNode getRequestNode() {
        return this._requestNode;
    }

    public Object getSource() {
        return this._source;
    }

    public void setDrawListener(DrawListener drawListener) {
        this._drawListener = drawListener;
    }

    public void setImage(Image image) {
        FilteredImageSource filterSource = new FilteredImageSource(image.getSource(), new AlphaFilter());
        this._image = this.createImage(filterSource);
    }

    @Override
    public boolean isOpaque() {
        return false;
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = SwingHelper.prepareGraphics(g);
        if (this._drawListener != null) {
            this._drawListener.draw(g2, this.getSize());
            return;
        }
        if (this._image != null) {
            g2.drawImage(this._image, 0, 0, this);
        }
    }

    private static class AlphaFilter
    extends RGBImageFilter {
        private AlphaFilter() {
        }

        @Override
        public int filterRGB(int x, int y, int rgb) {
            return 0xC0000000 | rgb & 0xFFFFFF;
        }
    }

    public static interface DrawListener {
        public void draw(Graphics var1, Dimension var2);
    }
}

