/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.radar.rhai.spacetime;

import edu.cmu.cs.radar.rhai.calendar.DateTime;
import java.text.FieldPosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

public class SpaceTimeDate
extends Date {
    private static final long serialVersionUID = 0L;

    public SpaceTimeDate() {
    }

    public SpaceTimeDate(Date date) {
        this.setTime(date.getTime());
    }

    public SpaceTimeDate(long optDate) {
        long utc = optDate * 1000L;
        int offset = Calendar.getInstance().getTimeZone().getOffset(optDate * 1000L);
        this.setTime(utc - (long)offset);
    }

    public long getOptDate() {
        int offset = Calendar.getInstance().getTimeZone().getOffset(this.getTime());
        return (this.getTime() + (long)offset) / 1000L;
    }

    public int getHourOfDay() {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(this);
        return cal.get(11);
    }

    public void setHourOfDay(int hour) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(this);
        cal.set(11, hour);
        this.setTime(cal.getTime().getTime());
    }

    public int getMinute() {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(this);
        return cal.get(12);
    }

    public void setMinute(int hour) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(this);
        cal.set(12, hour);
        this.setTime(cal.getTime().getTime());
    }

    public boolean equalsDate(SpaceTimeDate other) {
        return new DateTime(this).isSameDate(new DateTime(other));
    }

    public String toString(String formatString) {
        StringBuffer dateStringBuffer = new StringBuffer();
        SimpleDateFormat dateFormat = new SimpleDateFormat(formatString);
        dateFormat.format((Date)this, dateStringBuffer, new FieldPosition(0));
        return dateStringBuffer.toString();
    }
}

