/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.radar.rhai.calendar;

import edu.cmu.cs.radar.rhai.calendar.CalendarObject;
import edu.cmu.cs.radar.rhai.calendar.DateTime;
import edu.cmu.cs.radar.rhai.calendar.Time;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class SimpleCalendarObject
implements CalendarObject {
    private String mID;
    private DateTime mStart;
    private DateTime mEnd;
    private int mLayer;
    protected List<CalendarObject.Listener> mListeners = new ArrayList<CalendarObject.Listener>();

    public SimpleCalendarObject(String id, DateTime.Range range) {
        this(id, range.getStart(), range.getEnd());
    }

    public SimpleCalendarObject(String id, DateTime start, DateTime end) {
        this(id, start, end, 2);
    }

    public SimpleCalendarObject(String id, DateTime start, DateTime end, int layer) {
        if (id == null) {
            throw new NullPointerException("argument 'id'");
        }
        if (start == null) {
            throw new NullPointerException("argument 'start'");
        }
        if (end == null) {
            throw new NullPointerException("argument 'end'");
        }
        if (!start.before(end)) {
            throw new IllegalArgumentException("'start' (" + start + ") >= 'end' (" + end + ")");
        }
        if (!start.isSameDate(end)) {
            throw new IllegalArgumentException("'start' (" + start + ") and 'end' (" + end + ") do not have the same date");
        }
        this.mID = id;
        this.mStart = new DateTime(start);
        this.mEnd = new DateTime(end);
        this.mLayer = layer;
    }

    @Override
    public String getID() {
        return this.mID;
    }

    @Override
    public DateTime getStartDateTime() {
        return new DateTime(this.mStart);
    }

    public Date getStartDate() {
        return this.mStart.getAsDate();
    }

    public Time getStartTime() {
        return this.mStart.getAsTime();
    }

    @Override
    public void setStartDateTime(DateTime start) {
        this.setDateTimes(start, this.mEnd);
    }

    @Override
    public void setStartTime(Time start) {
        this.setTimes(start, this.mEnd.getAsTime());
    }

    @Override
    public DateTime getEndDateTime() {
        return new DateTime(this.mEnd);
    }

    public Date getEndDate() {
        return this.mEnd.getAsDate();
    }

    public Time getEndTime() {
        return this.mEnd.getAsTime();
    }

    @Override
    public void setEndDateTime(DateTime end) {
        this.setDateTimes(this.mStart, end);
    }

    @Override
    public void setDate(Date date) {
        DateTime newStart = new DateTime(date, this.mStart.getAsTime());
        DateTime newEnd = new DateTime(date, this.mEnd.getAsTime());
        this.updateDateTimes(newStart, newEnd);
    }

    @Override
    public DateTime.Range getDateTimeRange() {
        return new DateTime.Range(new DateTime(this.mStart), new DateTime(this.mEnd));
    }

    @Override
    public Time.Duration getDuration() {
        return new Time.Duration(this.getStartTime(), this.getEndTime());
    }

    @Override
    public void setEndTime(Time end) {
        this.setTimes(this.mStart.getAsTime(), end);
    }

    public void setDateTimes(DateTime start, DateTime end) {
        if (start == null) {
            throw new NullPointerException("argument 'start'");
        }
        if (end == null) {
            throw new NullPointerException("argument 'end'");
        }
        if (!start.before(end)) {
            throw new IllegalArgumentException("'start' >= 'end'");
        }
        if (!start.isSameDate(end)) {
            throw new IllegalArgumentException("'start' (" + start + ") and 'end' (" + end + ") do not have the same date");
        }
        this.updateDateTimes(new DateTime(start), new DateTime(end));
    }

    @Override
    public void moveTime(Time newStartTime) {
        Time newEnd = this.mEnd.getAsTime().shiftBy(new Time.Duration(this.mStart.getAsTime(), newStartTime));
        this.setTimes(newStartTime, newEnd);
    }

    public void setTimes(Time start, Time end) {
        if (!start.before(end)) {
            throw new IllegalArgumentException("'start' >= 'end'");
        }
        if (start.before(Time.START_OF_DAY) || start.after(Time.END_OF_DAY)) {
            throw new IllegalArgumentException("'start' is out of bounds: " + start.toString());
        }
        if (end.before(Time.START_OF_DAY) || end.after(Time.END_OF_DAY)) {
            throw new IllegalArgumentException("'end' is out of bounds: " + start.toString());
        }
        this.updateDateTimes(new DateTime(this.mStart, start), new DateTime(this.mEnd, end));
    }

    protected void updateDateTimes(DateTime newStart, DateTime newEnd) {
        boolean revalidate;
        DateTime oldStart = new DateTime(this.mStart);
        DateTime oldEnd = new DateTime(this.mEnd);
        boolean canChange = this.fireCheckDateTimesChange(newStart, newEnd);
        if (!canChange) {
            return;
        }
        this.mStart = new DateTime(newStart);
        this.mEnd = new DateTime(newEnd);
        boolean bl = revalidate = !this.mStart.equals(oldStart) || !this.mEnd.equals(oldEnd);
        if (revalidate) {
            this.fireDateTimesChanged();
        }
    }

    @Override
    public int getLayer() {
        return this.mLayer;
    }

    @Override
    public void setLayer(int layer) {
        this.mLayer = layer;
        this.fireLayerChanged();
    }

    @Override
    public void addCalendarObjectListener(CalendarObject.Listener listener) {
        this.mListeners.add(listener);
    }

    @Override
    public void removeCalendarObjectListener(CalendarObject.Listener listener) {
        this.mListeners.remove(listener);
    }

    protected void firePropertyChanged(String property) {
        Object[] listeners;
        Object[] objectArray = listeners = this.mListeners.toArray();
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            CalendarObject.Listener listener = (CalendarObject.Listener)element;
            listener.propertyChanged(this, property);
            ++n2;
        }
    }

    protected boolean fireCheckDateTimesChange(DateTime newStart, DateTime newEnd) {
        Object[] listeners;
        Object[] objectArray = listeners = this.mListeners.toArray();
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            CalendarObject.Listener listener = (CalendarObject.Listener)element;
            boolean canChange = listener.checkDateTimesChange(this, newStart, newEnd);
            if (!canChange) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    protected void fireDateTimesChanged() {
        Object[] listeners;
        Object[] objectArray = listeners = this.mListeners.toArray();
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            CalendarObject.Listener listener = (CalendarObject.Listener)element;
            listener.dateTimesChanged(this);
            listener.propertyChanged(this, "DATE_TIMES");
            ++n2;
        }
    }

    protected void fireLayerChanged() {
        Object[] listeners;
        Object[] objectArray = listeners = this.mListeners.toArray();
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            CalendarObject.Listener listener = (CalendarObject.Listener)element;
            listener.layerChanged(this);
            listener.propertyChanged(this, "LAYER");
            ++n2;
        }
    }

    public String toString() {
        return String.valueOf(this.getID()) + ": " + this.mStart + "\u2013" + this.mEnd;
    }
}

