/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.radar.rhai.calendar;

import edu.cmu.cs.radar.rhai.calendar.CalendarObject;
import edu.cmu.cs.radar.rhai.calendar.DateTime;
import edu.cmu.cs.radar.rhai.calendar.Time;
import edu.cmu.cs.radar.rhai.calendar.TimeView;
import edu.cmu.cs.radar.rhai.spacetime.SwingHelper;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.RoundRectangle2D;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputAdapter;

public class CalendarObjectView
extends JComponent
implements CalendarObject.Listener {
    private static final long serialVersionUID = 1L;
    public static final BasicStroke UNSELECTED_BORDER = new BasicStroke(1.0f);
    final BasicStroke SELECTED_BORDER = new BasicStroke(1.0f, 0, 0, 10.0f, new float[]{2.0f}, 0.0f);
    public static final Color DEFAULT_COLOR = new Color(224, 224, 224);
    public static final Color SHADOW_COLOR = new Color(176, 176, 176, 128);
    public static final int X_SHADOW_OFFSET = 3;
    public static final int Y_SHADOW_OFFSET = 4;
    protected CalendarObject mCalendarObject;
    protected Color mColor;
    protected boolean mSelected;
    protected boolean mInterimSelected;
    protected Shape mOutline;
    protected Shape mShadow;
    protected MouseInteractor mMouseInteractor;

    public CalendarObjectView(CalendarObject calObj) {
        if (calObj == null) {
            throw new NullPointerException("argument 'calObj'");
        }
        this.mCalendarObject = calObj;
        this.setColor(DEFAULT_COLOR);
        this.setSelected(false);
        this.setInterimSelected(false);
        this.setFocusable(true);
        this.mMouseInteractor = new MouseInteractor();
        this.mCalendarObject.addCalendarObjectListener(this);
        this.layerChanged(this.mCalendarObject);
    }

    public TimeView getTimeView() {
        Container parent = this.getParent();
        return parent instanceof TimeView ? (TimeView)parent : null;
    }

    public CalendarObject getCalendarObject() {
        return this.mCalendarObject;
    }

    public Color getColor() {
        return this.mColor;
    }

    public void setColor(Color color) {
        this.mColor = color;
        this.repaint();
    }

    public void setSelected(boolean selected) {
        this.mSelected = selected;
        this.repaint();
    }

    protected boolean isSelected() {
        return this.mSelected;
    }

    protected void setInterimSelected(boolean interimSelected) {
        this.mInterimSelected = interimSelected;
        this.repaint();
    }

    public boolean getInterimSelected() {
        return this.mInterimSelected;
    }

    public String getID() {
        return this.mCalendarObject.getID();
    }

    public Time getStart() {
        return this.mCalendarObject.getStartDateTime().getAsTime();
    }

    public Time getEnd() {
        return this.mCalendarObject.getEndDateTime().getAsTime();
    }

    public int getLayer() {
        return this.mCalendarObject.getLayer();
    }

    public Time.Duration getDuration() {
        return this.mCalendarObject.getDuration();
    }

    public Color getBackgroundColor() {
        return this.mColor;
    }

    public Color getForegroundColor() {
        return this.mColor.darker();
    }

    public Color getBorderColor() {
        return this.mColor.darker();
    }

    public Color getSelectedColor() {
        return this.mColor.darker();
    }

    public Color getShadowColor() {
        return SHADOW_COLOR;
    }

    @Override
    public void propertyChanged(CalendarObject calObj, String property) {
        if (this.mCalendarObject == calObj) {
            this.revalidate();
        }
    }

    @Override
    public boolean checkDateTimesChange(CalendarObject calObj, DateTime newStart, DateTime newEnd) {
        if (this.mCalendarObject == calObj) {
            Time.Range newRange = new Time.Range(newStart.getAsTime(), newEnd.getAsTime());
            TimeView timeView = this.getTimeView();
            if (timeView != null) {
                return timeView.getRange().contains(newRange);
            }
        }
        return true;
    }

    @Override
    public void dateTimesChanged(CalendarObject calObj) {
        if (this.mCalendarObject == calObj) {
            this.revalidate();
        }
    }

    @Override
    public void layerChanged(CalendarObject calObj) {
        if (this.mCalendarObject == calObj) {
            if (this.getLayer() != 1) {
                this.mMouseInteractor.activate();
            } else {
                this.mMouseInteractor.deactivate();
            }
            this.revalidate();
        }
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        if (this.mMouseInteractor.mMouseState != 0) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Rectangle r = new Rectangle(0, 0, CalendarObjectView.this.getWidth(), CalendarObjectView.this.getHeight());
                    CalendarObjectView.this.scrollRectToVisible(r);
                }
            });
        }
    }

    public void setHorizontalBounds(int x, int width) {
        TimeView timeView = this.getTimeView();
        int top = timeView.getValueForTimeAsInteger(this.getStart());
        int bottom = timeView.getValueForTimeAsInteger(this.getEnd());
        int height = bottom - top + 1;
        this.updateShapes(new Rectangle(width - 1, height - 1));
        Area area = new Area(this.mOutline);
        if (this.mShadow != null) {
            area.add(new Area(this.mShadow));
        }
        Rectangle bounds = area.getBounds();
        this.setBounds(x + bounds.x, top + bounds.y, bounds.width + 1, bounds.height + 1);
    }

    protected void updateShapes(Rectangle outlineBounds) {
        if (this.getLayer() == 3) {
            outlineBounds.width -= 5;
        }
        this.mOutline = this.createOutline(outlineBounds.width, outlineBounds.height);
        if (this.getLayer() == 3) {
            GeneralPath shadow = new GeneralPath(this.mOutline);
            shadow.transform(AffineTransform.getTranslateInstance(3.0, 4.0));
            this.mShadow = shadow;
        }
    }

    protected Shape createOutline(int width, int height) {
        return new RoundRectangle2D.Float(0.0f, 0.0f, width, height, 15.0f, 15.0f);
    }

    @Override
    public boolean contains(int x, int y) {
        return this.mOutline != null ? this.mOutline.contains(x, y) : false;
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = SwingHelper.prepareGraphics(g);
        if (this.mOutline == null) {
            return;
        }
        switch (this.mCalendarObject.getLayer()) {
            case 1: {
                this.paintComponentInPreferenceLayer(g2);
                break;
            }
            case 2: {
                this.paintComponentInExistingLayer(g2);
                break;
            }
            case 3: {
                this.paintComponentInProposalLayer(g2);
            }
        }
    }

    protected void paintComponentInPreferenceLayer(Graphics2D g2) {
        g2 = (Graphics2D)g2.create();
        g2.setClip(1, 1, this.getWidth() - 2, this.getHeight() - 2);
        Color paint = new Color(0.85f, 0.85f, 0.85f);
        g2.setStroke(new BasicStroke(1.0f));
        g2.setPaint(paint);
        int width = this.getWidth();
        int height = this.getHeight();
        int x = 0;
        while (x <= width + height) {
            g2.drawLine(x, 0, x - height, height);
            x += 16;
        }
    }

    protected void paintComponentInExistingLayer(Graphics2D g2) {
        this.paintBackground(g2);
        this.paintBorder(g2);
    }

    protected void paintComponentInProposalLayer(Graphics2D g2) {
        if (this.mShadow != null) {
            g2.setPaint(this.getShadowColor());
            g2.fill(this.mShadow);
        }
        this.paintBackground(g2);
        this.paintBorder(g2);
    }

    protected void paintBackground(Graphics2D g2) {
        g2.setPaint(this.isSelected() ? this.getSelectedColor() : this.getBackgroundColor());
        g2.fill(this.mOutline);
    }

    protected void paintBorder(Graphics2D g2) {
        g2.setStroke(UNSELECTED_BORDER);
        if (this.isSelected()) {
            g2.setPaint(Color.WHITE);
            g2.draw(this.mOutline);
            g2.setStroke(this.SELECTED_BORDER);
        }
        g2.setPaint(this.getBorderColor());
        g2.draw(this.mOutline);
    }

    @Override
    public String toString() {
        return "View for: " + this.mCalendarObject.toString();
    }

    public class MouseInteractor
    extends MouseInputAdapter {
        protected static final int STATE_MOUSE_UP = 0;
        protected static final int STATE_MOUSE_MOVE = 1;
        protected static final int STATE_MOUSE_GROW_START = 2;
        protected static final int STATE_MOUSE_GROW_END = 3;
        protected int mMouseState = 0;
        protected static final int GROW_REGION_HEIGHT = 7;
        protected Point mMouseDownLocation;

        public void activate() {
            CalendarObjectView.this.setAutoscrolls(true);
            CalendarObjectView.this.addMouseListener(this);
            CalendarObjectView.this.addMouseMotionListener(this);
        }

        public void deactivate() {
            CalendarObjectView.this.setAutoscrolls(false);
            CalendarObjectView.this.removeMouseListener(this);
            CalendarObjectView.this.removeMouseMotionListener(this);
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            Point mouseLocation = e.getPoint();
            if (this.pointInGrowStart(mouseLocation)) {
                CalendarObjectView.this.setCursor(Cursor.getPredefinedCursor(8));
            } else if (this.pointInGrowEnd(mouseLocation)) {
                CalendarObjectView.this.setCursor(Cursor.getPredefinedCursor(9));
            } else {
                CalendarObjectView.this.setCursor(Cursor.getPredefinedCursor(13));
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.mMouseDownLocation = e.getPoint();
            if (this.pointInGrowStart(this.mMouseDownLocation)) {
                this.mMouseState = 2;
                CalendarObjectView.this.getTopLevelAncestor().setCursor(Cursor.getPredefinedCursor(8));
            } else if (this.pointInGrowEnd(this.mMouseDownLocation)) {
                this.mMouseState = 3;
                CalendarObjectView.this.getTopLevelAncestor().setCursor(Cursor.getPredefinedCursor(9));
            } else {
                this.mMouseState = 1;
                CalendarObjectView.this.getTopLevelAncestor().setCursor(Cursor.getPredefinedCursor(13));
            }
            if (this.mMouseState != 0) {
                CalendarObjectView.this.getParent().add((Component)CalendarObjectView.this, 0);
                CalendarObjectView.this.setSelected(true);
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.mMouseState = 0;
            CalendarObjectView.this.getTopLevelAncestor().setCursor(null);
            CalendarObjectView.this.setSelected(false);
            CalendarObjectView.this.repaint();
            CalendarObjectView.this.requestFocusInWindow();
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            Time desiredTime;
            int desiredStartY = CalendarObjectView.this.getY() + e.getY();
            if (this.mMouseState == 1) {
                desiredStartY -= this.mMouseDownLocation.y;
            }
            if ((desiredTime = CalendarObjectView.this.getTimeView().getTimeForValue(desiredStartY)) != null) {
                boolean roundTo5 = (e.getModifiersEx() & 0x40) == 64;
                boolean roundTo1 = (e.getModifiersEx() & 0x80) == 128;
                int roundTo = 15;
                if (roundTo5) {
                    roundTo = 5;
                }
                if (roundTo1) {
                    roundTo = 1;
                }
                desiredTime = desiredTime.roundToMinutes(roundTo);
                switch (this.mMouseState) {
                    case 1: {
                        CalendarObjectView.this.mCalendarObject.moveTime(desiredTime);
                        break;
                    }
                    case 2: {
                        if (!CalendarObjectView.this.getEnd().after(desiredTime)) break;
                        CalendarObjectView.this.mCalendarObject.setStartTime(desiredTime);
                        break;
                    }
                    case 3: {
                        if (!CalendarObjectView.this.getStart().before(desiredTime)) break;
                        CalendarObjectView.this.mCalendarObject.setEndTime(desiredTime);
                    }
                }
            }
        }

        public boolean pointInGrowStart(Point pt) {
            Rectangle outlineBounds = CalendarObjectView.this.mOutline.getBounds();
            return pt.y <= outlineBounds.y + 7;
        }

        public boolean pointInGrowEnd(Point pt) {
            Rectangle outlineBounds = CalendarObjectView.this.mOutline.getBounds();
            return pt.y >= outlineBounds.y + outlineBounds.height - 7;
        }
    }
}

