/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.radar.rhai.spacetime;

import edu.cmu.cs.radar.rhai.spacetime.Allocation;
import edu.cmu.cs.radar.rhai.spacetime.CalendarGrid;
import edu.cmu.cs.radar.rhai.spacetime.GenericRequestDragComponent;
import edu.cmu.cs.radar.rhai.spacetime.Services;
import edu.cmu.cs.radar.rhai.spacetime.SwingHelper;
import edu.cmu.cs.radar.rhai.spacetime.UnscheduleEventAction;
import edu.cmu.cs.radar.rhai.spacetime.WindowUtilities;
import edu.cmu.cs.radar.stp.cachingdatamodel.SpaceTimeNode;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JComponent;

public class CalendarGridEntry
extends JComponent
implements GenericRequestDragComponent.DrawListener,
MouseListener,
KeyListener,
FocusListener {
    private static final long serialVersionUID = 0L;
    private static final int TITLE_HEIGHT = 14;
    private static ImageIcon LOCKED_ICON;
    private static ImageIcon ALERT_ICON;
    private static ImageIcon PENDING_ICON;
    private static Color SELECTED_COLOR;
    private CalendarGrid.GridPanel _parent;
    private Allocation _allocation;
    private SpaceTimeNode _node;
    private boolean _isSelected;

    static {
        ClassLoader classLoader = CalendarGridEntry.class.getClassLoader();
        LOCKED_ICON = new ImageIcon(classLoader.getResource("edu/cmu/cs/radar/rhai/media/lock.png"));
        ALERT_ICON = new ImageIcon(classLoader.getResource("edu/cmu/cs/radar/rhai/media/alert.png"));
        PENDING_ICON = new ImageIcon(classLoader.getResource("edu/cmu/cs/radar/rhai/media/pending.png"));
        SELECTED_COLOR = new Color(55, 104, 197);
    }

    public CalendarGridEntry(CalendarGrid.GridPanel parent, Allocation allocation) {
        this._parent = parent;
        this._allocation = allocation;
        this._node = this._allocation.getRequestNode().getNode();
        this._isSelected = false;
        this.setFocusable(true);
        this.setSize(100, 100);
        this.setLocation(80, 80);
        this.addMouseListener(this);
        this.addKeyListener(this);
        this.addFocusListener(this);
    }

    public Allocation getAllocation() {
        return this._allocation;
    }

    public String getObjectId() {
        return this._node.getName();
    }

    @Override
    public void draw(Graphics g, Dimension size) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setComposite(AlphaComposite.getInstance(3, 0.5f));
        this.paint(g);
    }

    @Override
    protected void paintComponent(Graphics g) {
        double score;
        super.paintComponent(g);
        Graphics2D g2 = SwingHelper.prepareGraphics(g);
        int width = this.getWidth() - 1;
        int height = this.getHeight() - 1;
        g2.setPaint(new Color(250, 250, 220));
        g2.fillRect(0, 0, width, height);
        g2.setColor(this._isSelected ? SELECTED_COLOR : Color.gray);
        g2.drawRect(0, 0, width, height);
        g2.setColor(this._isSelected ? SELECTED_COLOR : Color.lightGray);
        g2.fillRect(1, 1, width - 1, 14);
        g2.setColor(this._isSelected ? SELECTED_COLOR : Color.lightGray);
        g2.fillRect(1, height - 3, width - 1, 3);
        g2.setColor(Color.darkGray);
        g2.drawLine(width / 2 - 5, height - 2, width / 2 + 5, height - 2);
        g2.setColor(Color.lightGray);
        g2.drawLine(width / 2 - 5, height - 1, width / 2 + 5, height - 1);
        int iconOffset = 0;
        if (this._allocation.getRequestNode().isLocked() && this._allocation.getRequestNode().isLockedToRoom()) {
            g2.drawImage(LOCKED_ICON.getImage(), this.getWidth() - (iconOffset += LOCKED_ICON.getIconWidth()), 1, null);
            ++iconOffset;
        }
        if ((score = this._allocation.getRequestNode().getNode().getScore()) <= -6.0) {
            ImageIcon icon = score == -6.0 ? ALERT_ICON : PENDING_ICON;
            g2.drawImage(icon.getImage(), this.getWidth() - (iconOffset += icon.getIconWidth()) - 1, 1, null);
            ++iconOffset;
        }
        g2.setFont(this.getFont().deriveFont(1, 11.0f));
        String titleText = WindowUtilities.trimString(this._allocation.getDisplayName(), g2.getFontMetrics(), this.getWidth() - iconOffset - 8);
        g2.setColor(this._isSelected ? Color.white : Color.black);
        g2.drawString(titleText, 4, 12);
        g2.setFont(this.getFont().deriveFont(0, 11.0f));
        String description = WindowUtilities.trimString(this._allocation.getDescription(), g2.getFontMetrics(), this.getWidth() - 6);
        g2.setColor(this._isSelected ? Color.white : Color.black);
        g2.drawString(description, 4, 25);
    }

    public void setSelected(boolean selected) {
        this._isSelected = selected;
        this.repaint();
    }

    public void nodeSelected(boolean selected) {
        this._isSelected = selected;
        this.repaint();
    }

    public JComponent getDragComponent() {
        GenericRequestDragComponent dragComponent = new GenericRequestDragComponent(this._allocation.getRequestNode(), this.getParent());
        dragComponent.setSize(this.getSize());
        dragComponent.setDrawListener(this);
        return dragComponent;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        Services.logger.info("The user selected event '" + this._node.getName() + "' in the schedule");
        this.requestFocusInWindow();
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (this._isSelected && e.getKeyCode() == 127) {
            this.getUnassignAction().actionPerformed(null);
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void focusGained(FocusEvent e) {
        this.repaint();
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.repaint();
    }

    public Action getUnassignAction() {
        return new UnscheduleEventAction(this._parent.getRequestListModel(), this.getAllocation().getRequestNode());
    }
}

