package SpaceTime.DataModel;

import java.util.HashMap;
import java.util.Iterator;

import edu.cmu.cs.radar.integ.ICMRadarRequires.Reservation;

public class RoomReservationImpl extends RoomReservation {
	public RoomReservationImpl(){
	}
	
	public RoomReservationImpl(Reservation r){
		_startTime = r.getStartTime();
		_endTime = r.getFinishTime();
		_roomId = r.getRoomId();
		
		HashMap props = r.getRoomProperties();
		if(props!=null && props.size()>0){
			_propNames = new String[props.size()];
			_propValues = new double[props.size()];
			Iterator it = props.keySet().iterator();
			int count = 0;
			while(it.hasNext()){
				Object key = it.next();
				Object value = props.get(key);
				_propNames[count] = (String)key;
				_propValues[count] = ((Double)value).doubleValue();
				count++;
			}
		}
		else{
			_propNames = null;
			_propValues = null;
		}
	}
	
	public double StartTime(){
		return _startTime;
	}
	
	public double EndTime(){
		return _endTime;
	}
	
	public String RoomId(){
		return _roomId;
	}
	
	public int PropertiesCount(){
		if(_propNames!=null){
			return _propNames.length;
		}
		else{
			return 0;
		}
	}
	
	public String PropertyNameAt(int index){
		if(_propNames!=null && _propNames.length > index){
			return _propNames[index];
		}
		else{
			return null;
		}	
	}
	
	public double PropertyValueAt(int index){
		return _propValues[index];	
	}	

}
