// $Id: DummyRadar.java,v 3.23 2007/07/27 20:05:39 jordan Exp $

package edu.cmu.cs.radar.integ;

import java.awt.Frame;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;

import org.apache.log4j.Logger;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/**
 * A dummy version of Radar for testing purposes.
 * Note that most methods return fixed values.
 */
public class DummyRadar extends DummyAny implements IRadarServices {

    // simple illustration of specialist/console integraton shims.
    public static void main(String args[]) {
	if (args.length < 1) {
	    s_logger.error("Usage: DummyRadar "
	      + "[demoVIO|demoBA|demoSTM|demoWbE|demoConsole args ...");
	} else if (args[0].equals("demoVIO")) {
	    (new DummyRadar()).demoVIO(args);
	} else if (args[0].equals("demoBA")) {
	    (new DummyRadar()).demoBA(args);
	} else if (args[0].equals("demoSTM")) {
	    (new DummyRadar()).demoSTM(args);
	} else if (args[0].equals("demoAM")) {
	    (new DummyRadar()).demoAM(args);
	} else if (args[0].equals("demoWbE")) {
	    (new DummyRadar()).demoWbE(args);
	} else if (args[0].equals("demoConsole")) {
	    (new DummyRadar()).demoConsole(args);
	}
    }

    public void demoSTM(String args[]) {
	ISTMProvides stm = new DummySTM();
	s_logger.info("starting");
	if (!stm.initialize(this)) {
	    s_logger.error("STM failed to initialize");
	    return;
	}
	s_logger.info("STM initialized");
    }

    public void demoBA(String args[]) {
	IBAProvides ba = new DummyBA();
	s_logger.info("starting");
	if (!ba.initialize(this)) {
	    s_logger.error("BA failed to initialize");
	    return;
	}
	s_logger.info("BA initialized");
    }

    private static Document readDocument(File f) {
	try {
	    DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
	    DocumentBuilder docbuilder = factory.newDocumentBuilder();
	    Document doc = docbuilder.parse(f);
	    return doc;
	} catch (java.io.IOException e) {
	    s_logger.error("couldn't read document",e);
	} catch (javax.xml.parsers.ParserConfigurationException e) {
	    s_logger.error("couldn't read document",e);
	} catch (org.xml.sax.SAXException e) {
	    s_logger.error("couldn't read document",e);
	}
	return null;
    }

    private static String xmlToString(Element item) {
	try {
	    DOMSource source = new DOMSource(item);
	    StringWriter sw = new StringWriter();
	    StreamResult result = new StreamResult(sw);
	    Transformer transformer
		= TransformerFactory.newInstance().newTransformer();
	    transformer.transform(source, result);
	    String xmlData = sw.toString();
	    return xmlData;
	} catch (javax.xml.transform.TransformerConfigurationException e) {
	    s_logger.error("error in xmlToString", e);
	} catch (javax.xml.transform.TransformerException e) {
	    s_logger.error("error in xmlToString", e);
	}
	return null;
    }

    public void demoConsole(String args[]) {
	IConsoleProvides console = new DummyConsole();
	s_logger.info("Console starting");
	if (!console.initialize(this)) {
	    s_logger.error("Console failed to initialize");
	    return;
	}
	s_logger.info("Console initialized");

	s_logger.info("Console shutting down");
	if (!console.shutdown())
	    s_logger.error("Console failed to shutdown");
    }

    public void demoWbE(String args[]) {
	IWbEProvides wbe = new DummyWbE();
	s_logger.info("WbE starting");
	if (!wbe.initialize(this)) {
	    s_logger.error("WbE failed to initialize");
	    return;
	}
	s_logger.info("WbE initialized");

	wbe.invoke("foo", "bar");

	s_logger.info("WbE shutting down");
	if (!wbe.shutdown())
	    s_logger.error("WbE failed to shutdown");
    }

    public void demoAM(String args[]) {
	IAMProvides am = new DummyAM();
	s_logger.info("starting");
	if (!am.initialize(this)) {
	    s_logger.error("AM failed to initialize");
	    return;
	}
	s_logger.info("AM initialized");

	am.doSomethingInteresting("yeah");

	s_logger.info("shutting down");
	if (!am.shutdown())
	    s_logger.error("AM failed to shutdown");
    }

    public void demoVIO(String args[]) {
	IVIOProvides vio = new DummyVIO();
	s_logger.info("starting");
	if (!vio.initialize(this)) {
	    s_logger.error("VIO failed to initialize");
	    return;
	}
	s_logger.info("VIO initialized");

	for (int i = 0; i < args.length; i++) {
	    s_logger.info("handling arg: "+args[i]);
	    // simulate calls that will happen as email arrives
	    // (for emails categorized as "for VIO")
	    String[] ignore = vio.extractVIOTasks(null, null, null);
	    if (ignore != null) {
		for (int j = 0; j < ignore.length; j++) {
		    s_logger.info("got extracted VIO task: "+ignore[j]);	    
		}
	    }
	    try {
		Thread.sleep(1000);
	    } catch (Exception ex) {}
	}

	if (!vio.shutdown()) {
	    s_logger.error("VIO failed to shutdown");
	}
	s_logger.info("shutting down");
    }

    private static int toInt(String s) {
	try {
	    return Integer.parseInt(s);
	} catch(NumberFormatException e) {
	    return 0;
	}
    }

    // get all the properties used to configure Radar.
    public Properties getProps() { 
	Properties ret = System.getProperties();
	ret.setProperty("radar.version", "1.0");
	ret.setProperty("radar.test.condition", "radarplusl");
	//"control/radarplusl/radarminusl".
	return ret;
    }

    public String getUser() {
	return System.getProperty("user.name");
    }

    // get a String representing the root of the writeable Radar
    // directory structure.  The return value can be used to construct
    // a File object.
    public String getRoot() { 
	return System.getProperty("user.home");
    }

    //----------------------------------------------------------------------
    static Logger s_logger = Logger.getLogger("DummyRadar");

    public Logger makeLog(String name) {
	return Logger.getLogger(name);
    }

    //----------------------------------------------------------------------

    public MimeMessage getMessage(String messageID) {
	Session s = Session.getInstance(System.getProperties());
	try{
	    Session session = Session.getInstance(System.getProperties());
	    File emlFile = new File(messageID);
	    FileInputStream fis = new FileInputStream(emlFile);
	    // parse it to RFC 2822
	    MimeMessage mm = new MimeMessage(session, fis);
	    return mm;
	} catch (MessagingException ex) {
	    s_logger.error(ex.toString());
	    ex.printStackTrace();
	} catch (FileNotFoundException ex) {
	    s_logger.error(ex.toString());
	    ex.printStackTrace();
	}
	return getFallbackMessage(messageID);
    }

    public MimeMessage getFallbackMessage(String messageID) {
	Session s = Session.getInstance(System.getProperties());
        // set the fields
	MimeMessage msg = new MimeMessage(s);
	try {
	    msg.setFrom(new InternetAddress("jordan@thinkbank.com",
					    "Jordan Hayes"));
	    msg.addRecipient(Message.RecipientType.TO,
			     new InternetAddress("tomasic@cs.cmu.edu", 
						 "Anthony Tomasic"));
	    msg.addRecipient(Message.RecipientType.CC,
			     new InternetAddress("othar@thinkbank.com", 
						 "Othar Hansson"));
	    msg.setSubject("Testing!");
	    msg.addHeader("X-Jordan", "Too kewl for skool");
	    msg.addHeader("X-RadarUID", "RAID_176");
	    msg.setSentDate(new Date());
	    msg.setText("I concur.\n\n/jordan\n");
	} catch (UnsupportedEncodingException ex) {	
	} catch (MessagingException ex) {	
	}
	return msg;
    }

    //----------------------------------------------------------------------
    // used by CMRadar
    public void foundRoom(Reservation result) {}
    public void updateProbabilities(Vector data) {}

    //----------------------------------------------------------------------
    // used by ST GUI
    public void userRequestsRoomEdit(String roomId) {
	s_logger.info(roomId);
    }
    public void userRequestsEventEdit(String eventId) {
	s_logger.info(eventId);
    }

    public void findRoom(ICMRadarProvides.EventInformation ei) {
	if (null == ei)
	    s_logger.info("ei is null");
	else
	    s_logger.info(ei.toString());
    }

    public void invokeWbE(String filePath) {
	s_logger.info("invokeWbE " + filePath);
    }

    // Console
    public void explore(String url) {
	s_logger.info(url);
    }
    public void showBA(String taskId) {
	s_logger.info("show[" + taskId + "]");
    }

    //----------------------------------------------------------------------
    // used by VIO
    public void taskDone(String messageID, String xmlBlock) {
	s_logger.info("VIO is done with "+messageID);
    }

    //----------------------------------------------------------------------
    // used by Briefing Assistant

    public void sendBriefing(String callback, String xml) {
	// open a draft message in Outlook...
    }

    public void showDraftEmail(String recip, String subj, String body) {
	// open a draft message in Outlook...
    }

    /**
     * get the annoDB "document number" for the specified message ID
     */
    public String getMessageDocno(String messageID) {
	return messageID;
    }

    /**
     * return a collection of emailIDs (docno's in the Annotation DB)
     * that were received in the specified date range.
     **/
    public Collection queryEmail(Date dateFrom, Date dateTo) {
	Collection ret = new ArrayList();
	ret.add("10017");	// hypothetical docnos in the annotations DB
	ret.add("10018");
	ret.add("10019");
	return ret;
    }  

    public void markEmailBriefed(String messageId) {}

    /**
     * return a collection of ITasks that were modified (started,
     * completed, etc.) in the specified date range.
     * */
    public Collection queryTasks(Date dateFrom, Date dateTo) {
	Collection ret = new ArrayList();
	// ret.add(new EasyTask("session change from Joe Smith", "completed at 2pm", "10017")); 
	// ret.add(new EasyTask("session change from Joe Jones", "completed at 3pm", "10018")); 
	return ret;
    }

    public void markDone(String requestID) {
    }

    public void setFormComplete(String tmTaskId) {
    }

    public boolean condIsPlusL() { return false; }
    public boolean condIsMinusL() { return false; }
    public boolean condIsNotRadar() { return true; }

    public void iconify(Frame x) {}
    public void deiconify(Frame x) {}

    // for VIO
    public void invokeWbE(String progName, String dataURL) {
	s_logger.info("invokeWbE(progName='" + progName
	  + "', dataURL='" + dataURL + "')");
    }
}
