/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.radar.rhai.spacetime;

import SpaceTime.DataModel.NodeChangeSummary;
import edu.cmu.cs.radar.rhai.spacetime.Allocation;
import edu.cmu.cs.radar.rhai.spacetime.CalendarGridEntry;
import edu.cmu.cs.radar.rhai.spacetime.ComponentDragContainer;
import edu.cmu.cs.radar.rhai.spacetime.ComponentDragListener;
import edu.cmu.cs.radar.rhai.spacetime.DateSelectionListener;
import edu.cmu.cs.radar.rhai.spacetime.EditEventAction;
import edu.cmu.cs.radar.rhai.spacetime.EditRoomAction;
import edu.cmu.cs.radar.rhai.spacetime.GenericRequestDragComponent;
import edu.cmu.cs.radar.rhai.spacetime.RangedItemList;
import edu.cmu.cs.radar.rhai.spacetime.RequestListModel;
import edu.cmu.cs.radar.rhai.spacetime.RoomDetailsPanel;
import edu.cmu.cs.radar.rhai.spacetime.RoomNode;
import edu.cmu.cs.radar.rhai.spacetime.ScheduleInfo;
import edu.cmu.cs.radar.rhai.spacetime.ScheduleList;
import edu.cmu.cs.radar.rhai.spacetime.ScheduleListListener;
import edu.cmu.cs.radar.rhai.spacetime.SelectionListener;
import edu.cmu.cs.radar.rhai.spacetime.SelectionManager;
import edu.cmu.cs.radar.rhai.spacetime.Services;
import edu.cmu.cs.radar.rhai.spacetime.SpaceTimeDate;
import edu.cmu.cs.radar.rhai.spacetime.SpaceTimeDuration;
import edu.cmu.cs.radar.rhai.spacetime.SpaceTimeRequestNode;
import edu.cmu.cs.radar.rhai.spacetime.SpaceTimeTimeIntervals;
import edu.cmu.cs.radar.rhai.spacetime.SwingHelper;
import edu.cmu.cs.radar.rhai.spacetime.WindowUtilities;
import edu.cmu.cs.radar.rhai.spacetime.WorkJournal;
import edu.cmu.cs.radar.stp.cachingdatamodel.GlobalChangeListener;
import edu.cmu.cs.radar.stp.cachingdatamodel.SpaceTimeDataAdapter;
import edu.cmu.cs.radar.stp.cachingdatamodel.SpaceTimeNode;
import edu.cmu.cs.radar.stp.cachingdatamodel.SpaceTimeProperty;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager2;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.TexturePaint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class CalendarGrid
extends JPanel
implements ScheduleListListener,
DateSelectionListener,
SelectionListener {
    private static final long serialVersionUID = 0L;
    private static final int LEFT_MARGIN = 40;
    private static final int HOUR_DIVIDER = 4;
    private static final int VBUFFER = 0;
    private static final int HOUR_HEIGHT = 60;
    private SpaceTimeDate _date;
    private int _startHour;
    private int _stopHour;
    private List<ScheduleInfo> _schedules;
    private List<Boolean> _availabilities;
    private JScrollPane _scrollPane;
    private GridPanel _gridPanel;
    private CalendarTitle _titlePanel;
    private TimeStrip _timeStrip;
    private RequestListModel _listModel;
    private SelectionManager _selectionManager;

    public CalendarGrid(RequestListModel requestModel) {
        this._listModel = requestModel;
        this.setBackground(Color.white);
        this.setLayout(new BorderLayout());
        this._schedules = new ArrayList<ScheduleInfo>();
        this._availabilities = new ArrayList<Boolean>();
        this._date = new SpaceTimeDate();
        this._startHour = 7;
        this._stopHour = 21;
        this._gridPanel = new GridPanel(this);
        this._scrollPane = new JScrollPane(this._gridPanel);
        this._scrollPane.setBorder(null);
        this._scrollPane.getVerticalScrollBar().setUnitIncrement(30);
        this._scrollPane.getVerticalScrollBar().setBlockIncrement(240);
        this._scrollPane.getHorizontalScrollBar().setUnitIncrement(100);
        this._scrollPane.getHorizontalScrollBar().setBlockIncrement(400);
        this._titlePanel = new CalendarTitle(this);
        this._titlePanel.setTitle(this._date.toString("EEEE, MMMM d, yyyy"));
        this._timeStrip = new TimeStrip(this);
        this._timeStrip.setPreferredSize(new Dimension(40, 100));
        this.add((Component)this._timeStrip, "West");
        this.add((Component)this._titlePanel, "North");
        this.add((Component)this._scrollPane, "Center");
        this.populateData();
        this._scrollPane.addComponentListener(new ComponentListener(){

            @Override
            public void componentResized(ComponentEvent e) {
                CalendarGrid.this._gridPanel.recomputeLayout();
            }

            @Override
            public void componentMoved(ComponentEvent e) {
            }

            @Override
            public void componentHidden(ComponentEvent e) {
            }

            @Override
            public void componentShown(ComponentEvent e) {
            }
        });
        this._listModel.addListDataListener(new ListDataListener(){

            @Override
            public void contentsChanged(ListDataEvent e) {
                CalendarGrid.this._gridPanel.removeAll();
                CalendarGrid.this.populateData();
                CalendarGrid.this._gridPanel.recomputeLayout();
                CalendarGrid.this.repaint();
            }

            @Override
            public void intervalAdded(ListDataEvent e) {
            }

            @Override
            public void intervalRemoved(ListDataEvent e) {
            }
        });
        this._scrollPane.getVerticalScrollBar().addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent e) {
                CalendarGrid.this._timeStrip.setScrollOffset(CalendarGrid.this._scrollPane.getVerticalScrollBar().getValue());
            }
        });
        this._scrollPane.getHorizontalScrollBar().addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent e) {
                CalendarGrid.this._titlePanel.setScrollOffset(CalendarGrid.this._scrollPane.getHorizontalScrollBar().getValue());
            }
        });
    }

    @Override
    public void setSelection(Object sender, Object selection, int type, boolean selected, boolean doubleClick) {
        if (type == 1) {
            if (selection == null) {
                this._gridPanel._layoutManager.entrySelected(null);
                return;
            }
            CalendarGridEntry entry = this.getEntryFromObjectId(selection.toString());
            if (entry == null) {
                return;
            }
            this._gridPanel._layoutManager.entrySelected(entry);
            if (doubleClick) {
                this._gridPanel._layoutManager.layoutGrid();
                this._gridPanel.scrollRectToVisible(new Rectangle(entry.getLocation(), entry.getSize()));
            }
        } else if (type == 2) {
            this._gridPanel._layoutManager.entrySelected(null);
        }
    }

    @Override
    public void setViewState(Object sender, Object selection, boolean show) {
    }

    public CalendarGridEntry getEntryFromObjectId(String id) {
        for (CalendarGridEntry entry : this._gridPanel._layoutManager._controls) {
            if (!id.equals(entry.getObjectId())) continue;
            return entry;
        }
        return null;
    }

    public void setSelectionManager(SelectionManager manager) {
        this._selectionManager = manager;
        this._selectionManager.addListener(this);
        this._selectionManager.addListener(this._titlePanel);
    }

    private void populateData() {
        SpaceTimeDataAdapter dataAdapter = this._listModel.getDataAdapter();
        if (dataAdapter == null) {
            return;
        }
        for (SpaceTimeNode spaceTimeNode : dataAdapter.getRequests()) {
            SpaceTimeRequestNode requestNode = new SpaceTimeRequestNode(spaceTimeNode);
            Allocation allocation = requestNode.getAllocation();
            if (allocation == null) continue;
            CalendarGridEntry gridEntry = new CalendarGridEntry(this._gridPanel, allocation);
            this._gridPanel.add((Component)gridEntry, null);
        }
        GlobalChangeListener changeListener = new GlobalChangeListener(){

            @Override
            public void worldStateNodeChanged(String nodeId, NodeChangeSummary changes) {
                CalendarGrid.this.checkGridForAssignment(nodeId);
                CalendarGrid.this._gridPanel.recomputeLayout();
                CalendarGrid.this.repaint();
            }

            @Override
            public void worldStateNodeAdded(String nodeId) {
                CalendarGrid.this.checkGridForAssignment(nodeId);
                CalendarGrid.this._gridPanel.recomputeLayout();
                CalendarGrid.this.repaint();
            }

            @Override
            public void worldStateGlobalScoreChanged(double score) {
            }

            @Override
            public void worldStateNodeScoreChanged(String nodeId, double score) {
                CalendarGridEntry entry = CalendarGrid.this._gridPanel.findGridEntry(nodeId);
                if (entry != null) {
                    entry.repaint();
                }
            }
        };
        this._listModel.getDataAdapter().addGlobalChangeListener(changeListener);
    }

    private void checkGridForAssignment(String nodeId) {
        SpaceTimeNode node = this._listModel.getDataAdapter().getNodeById(nodeId);
        SpaceTimeRequestNode requestNode = new SpaceTimeRequestNode(node);
        if (requestNode.isAssigned()) {
            this._gridPanel.findGridEntry(nodeId);
        }
        requestNode.dispose();
    }

    public void setDate(SpaceTimeDate date) {
        this._date = date;
    }

    public void setStartHour(int hour) {
        this._startHour = hour;
    }

    public void setStopHour(int hour) {
        this._stopHour = hour;
    }

    public void suppressLayout(boolean suppress) {
        this._gridPanel._layoutManager.suppressLayout(suppress);
    }

    @Override
    public synchronized void showSchedule(ScheduleList scheduleList) {
        this._schedules.clear();
        this._availabilities.clear();
        for (ScheduleInfo scheduleInfo : scheduleList) {
            this._schedules.add(scheduleInfo);
            SpaceTimeNode node = this._listModel.getDataAdapter().getNodeById(scheduleInfo.id);
            if (node != null) {
                if (RoomNode.markedUsable(node)) {
                    this._availabilities.add(Boolean.TRUE);
                    continue;
                }
                this._availabilities.add(Boolean.FALSE);
                continue;
            }
            this._availabilities.add(Boolean.FALSE);
        }
        this._gridPanel.recomputeLayout();
        this._titlePanel.updateRooms();
        this.repaint();
    }

    @Override
    public void selectDate(Date date) {
        this._date = new SpaceTimeDate(date);
        this._titlePanel.setTitle(this._date.toString("EEEE, MMMM d, yyyy"));
        this._gridPanel.recomputeLayout();
        this.repaint();
    }

    protected int getScheduleIndex(List<ScheduleInfo> schedules, String id) {
        if (id == null) {
            return -1;
        }
        int i = 0;
        while (i < schedules.size()) {
            ScheduleInfo scheduleInfo = schedules.get(i);
            if (id.equals(scheduleInfo.id)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private static class CalendarTitle
    extends JComponent
    implements SelectionListener {
        private static final long serialVersionUID = 0L;
        private static final int TITLE_HEIGHT = 35;
        private static final int CATEGORY_HEIGHT = 32;
        private String _label;
        private CalendarGrid _calendarGrid;
        private int _scrollOffset;
        private int _hoverIndex;
        private int _selectedIndex;
        private SpaceTimeNode _selectedRoom;
        private String _tooltip = null;

        public CalendarTitle(CalendarGrid calendarGrid) {
            this.setBackground(Color.white);
            this._calendarGrid = calendarGrid;
            this._label = "";
            this._scrollOffset = 0;
            this._hoverIndex = -1;
            this._selectedIndex = -1;
            this._selectedRoom = null;
            this.setToolTipText("");
            this.addMouseListener(new MouseListener(){

                @Override
                public void mouseExited(MouseEvent e) {
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                }

                @Override
                public void mousePressed(MouseEvent e) {
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void mouseClicked(MouseEvent e) {
                    CalendarGrid calendarGrid = CalendarTitle.this._calendarGrid;
                    synchronized (calendarGrid) {
                        if (e.getPoint().y < 35) {
                            return;
                        }
                        int columnWidth = CalendarTitle.this._calendarGrid._gridPanel.getCategoryWidth();
                        int columns = CalendarTitle.this._calendarGrid._schedules.size();
                        int index = (e.getPoint().x - 40 + CalendarTitle.this._scrollOffset) / columnWidth;
                        if (index >= columns) {
                            index = -1;
                        }
                        if (index != CalendarTitle.this._selectedIndex) {
                            CalendarTitle.this._selectedIndex = index;
                            if (CalendarTitle.this._selectedIndex < 0) {
                                CalendarTitle.this._selectedRoom = null;
                                return;
                            }
                            ScheduleInfo scheduleInfo = (ScheduleInfo)CalendarTitle.this._calendarGrid._schedules.get(CalendarTitle.this._selectedIndex);
                            SpaceTimeNode roomNode = CalendarTitle.this._calendarGrid._listModel.getDataAdapter().getNodeById(scheduleInfo.id);
                            CalendarTitle.this._selectedRoom = roomNode;
                            CalendarTitle.this._calendarGrid._gridPanel.setSelectedRoom(CalendarTitle.this._selectedIndex, false);
                            CalendarTitle.this._calendarGrid._selectionManager.notifySelection(this, roomNode.getName(), 2, true, false, false);
                            Services.logger.info("The user selected room '" + CalendarTitle.this._selectedRoom.getName() + "' in the schedule");
                            CalendarTitle.this.repaint();
                        }
                        if (e.getButton() == 3) {
                            JPopupMenu menu = new JPopupMenu();
                            ScheduleInfo scheduleInfo = (ScheduleInfo)CalendarTitle.this._calendarGrid._schedules.get(CalendarTitle.this._selectedIndex);
                            SpaceTimeNode roomNode = CalendarTitle.this._calendarGrid._listModel.getDataAdapter().getNodeById(scheduleInfo.id);
                            JMenuItem hideItem = new JMenuItem("Hide Room");
                            hideItem.addActionListener(new ActionListener(this){
                                final /* synthetic */ 1 this$2;
                                {
                                    this.this$2 = var1_1;
                                }

                                public void actionPerformed(ActionEvent e) {
                                    CalendarGrid.access$3(CalendarTitle.access$0(1.access$0(this.this$2))).notifyViewStateChange(1.access$0(this.this$2), CalendarTitle.access$5(1.access$0(this.this$2)), false, false);
                                }
                            });
                            JMenuItem editItem = new JMenuItem(new EditRoomAction(roomNode));
                            menu.add(hideItem);
                            menu.add(editItem);
                            menu.show(CalendarTitle.this, e.getX(), e.getY());
                        }
                    }
                }

                static /* synthetic */ CalendarTitle access$0(1 var0) {
                    return var0.CalendarTitle.this;
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int getColumnIndexAt(MouseEvent event) {
            CalendarGrid calendarGrid = this._calendarGrid;
            synchronized (calendarGrid) {
                int index;
                block6: {
                    block5: {
                        if (event.getPoint().y >= 35) break block5;
                        return -1;
                    }
                    int columnWidth = this._calendarGrid._gridPanel.getCategoryWidth();
                    int columns = this._calendarGrid._schedules.size();
                    index = (event.getPoint().x - 40 + this._scrollOffset) / columnWidth;
                    if (index < columns) break block6;
                    return -1;
                }
                return index;
            }
        }

        @Override
        public Point getToolTipLocation(MouseEvent event) {
            int index = this.getColumnIndexAt(event);
            if (index < 0) {
                return super.getToolTipLocation(event);
            }
            int columnWidth = this._calendarGrid._gridPanel.getCategoryWidth();
            Point location = new Point();
            location.x = 40 + columnWidth * index + 10 - this._scrollOffset;
            location.x = Math.max(location.x, 50);
            location.y = 72;
            return location;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String getToolTipText(MouseEvent event) {
            CalendarGrid calendarGrid = this._calendarGrid;
            synchronized (calendarGrid) {
                int index = this.getColumnIndexAt(event);
                if (index == this._hoverIndex) {
                    return this._tooltip;
                }
                this._hoverIndex = index;
                this._tooltip = null;
                if (this._hoverIndex >= 0) {
                    ScheduleInfo scheduleInfo = (ScheduleInfo)this._calendarGrid._schedules.get(this._hoverIndex);
                    SpaceTimeNode roomNode = this._calendarGrid._listModel.getDataAdapter().getNodeById(scheduleInfo.id);
                    if (roomNode != null) {
                        this._tooltip = this.createTooltip(roomNode);
                    }
                }
                return this._tooltip;
            }
        }

        private String createTooltip(SpaceTimeNode roomNode) {
            Map<String, List<SpaceTimeProperty>> categories = RoomDetailsPanel.collectCategories(roomNode, true);
            String tooltip = "<div><b>" + roomNode.getDisplayName() + "</b></div>";
            ArrayList categoryLabels = new ArrayList(categories.keySet());
            Collections.sort(categoryLabels);
            for (String categoryLabel : categoryLabels) {
                List<SpaceTimeProperty> propertyGroup = categories.get(categoryLabel);
                if (propertyGroup.size() <= 0) continue;
                Collections.sort(propertyGroup, SpaceTimeProperty.sLabelAndDisplayStringComparator);
                tooltip = String.valueOf(tooltip) + "<div style='padding-top: 4px'>" + categoryLabel + "</div>";
                ArrayList<String> displayStrings = new ArrayList<String>();
                for (SpaceTimeProperty property : propertyGroup) {
                    displayStrings.add(property.getDisplayLabelAndValueString());
                }
                for (String displayString : displayStrings) {
                    tooltip = String.valueOf(tooltip) + "<div style='padding-left: 12px'>\u2022 " + displayString + "</div>";
                }
            }
            return "<html><body style='padding: 4px'>" + tooltip + "</body></html>";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setSelection(Object sender, Object selection, int type, boolean selected, boolean doubleClick) {
            CalendarGrid calendarGrid = this._calendarGrid;
            synchronized (calendarGrid) {
                if (type == 1) {
                    this._selectedIndex = -1;
                    this._selectedRoom = null;
                    this._calendarGrid._gridPanel.setSelectedRoom(-1, false);
                    this.repaint();
                } else if (type == 2) {
                    if (selection != null) {
                        SpaceTimeNode roomNode = this._calendarGrid._listModel.getDataAdapter().getNodeById(selection.toString());
                        int i = 0;
                        while (i < this._calendarGrid._schedules.size()) {
                            ScheduleInfo scheduleInfo = (ScheduleInfo)this._calendarGrid._schedules.get(i);
                            if (scheduleInfo.id.equals(roomNode.getName())) {
                                this._selectedIndex = i;
                                this._selectedRoom = roomNode;
                                this._calendarGrid._gridPanel.setSelectedRoom(this._selectedIndex, doubleClick);
                                this.repaint();
                                return;
                            }
                            ++i;
                        }
                    }
                    this._selectedIndex = -1;
                    this._selectedRoom = null;
                    this._calendarGrid._gridPanel.setSelectedRoom(this._selectedIndex, false);
                    this.repaint();
                }
            }
        }

        @Override
        public void setViewState(Object sender, Object selection, boolean show) {
        }

        public void setTitle(String title) {
            this._label = title;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void updateRooms() {
            CalendarGrid calendarGrid = this._calendarGrid;
            synchronized (calendarGrid) {
                if (this._selectedRoom != null) {
                    int i = 0;
                    while (i < this._calendarGrid._schedules.size()) {
                        ScheduleInfo info = (ScheduleInfo)this._calendarGrid._schedules.get(i);
                        if (this._selectedRoom.getName().equals(info.id)) {
                            this._selectedIndex = i;
                            this._calendarGrid._gridPanel.setSelectedRoom(i, false);
                            return;
                        }
                        ++i;
                    }
                    this._selectedIndex = -1;
                    this._selectedRoom = null;
                    this._calendarGrid._gridPanel.setSelectedRoom(-1, false);
                }
            }
        }

        @Override
        public Dimension getPreferredSize() {
            return this.getMinimumSize();
        }

        @Override
        public Dimension getMinimumSize() {
            return new Dimension(100, 67);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void paintComponent(Graphics g) {
            CalendarGrid calendarGrid = this._calendarGrid;
            synchronized (calendarGrid) {
                super.paintComponent(g);
                Graphics2D g2 = SwingHelper.prepareGraphics(g);
                g2.setFont(this.getFont().deriveFont(1, 24.0f));
                g2.setColor(Color.gray);
                g2.drawString(this._label, 40, 30);
                g2.setClip(40, 0, this.getWidth() - 40, this.getHeight());
                if (this._calendarGrid._schedules.size() > 0) {
                    int columnWidth = this._calendarGrid._gridPanel.getCategoryWidth();
                    int columns = this._calendarGrid._schedules.size();
                    g2.drawLine(40 - this._scrollOffset, 35, 40 + columnWidth * columns - this._scrollOffset, 35);
                    g2.setColor(Color.black);
                    g2.fillRect(40 - this._scrollOffset, 36, columnWidth * columns, 31);
                    Font buildingFont = this.getFont().deriveFont(0, 11.0f);
                    Font roomFont = this.getFont().deriveFont(1, 11.0f);
                    g2.setFont(roomFont);
                    FontMetrics buildingFontMetrics = g2.getFontMetrics(buildingFont);
                    FontMetrics roomFontMetrics = g2.getFontMetrics(roomFont);
                    g2.setColor(Color.black);
                    g2.drawLine(40 - this._scrollOffset, 35, 40 - this._scrollOffset, 67);
                    int i = 0;
                    while (i < columns) {
                        if (this._selectedIndex == i) {
                            g2.setColor(new Color(55, 104, 197));
                            g2.fillRect(40 - this._scrollOffset + i * columnWidth + 1, 35, columnWidth - 1, 32);
                        }
                        ScheduleInfo scheduleInfo = (ScheduleInfo)this._calendarGrid._schedules.get(i);
                        String buildingTitle = WindowUtilities.trimString("in " + scheduleInfo.buildingName, buildingFontMetrics, columnWidth - 8);
                        g2.setFont(buildingFont);
                        g2.setColor(Color.white);
                        g2.drawString(buildingTitle, 40 - this._scrollOffset + i * columnWidth + 4, 63);
                        String roomTitle = WindowUtilities.trimString(scheduleInfo.roomName, roomFontMetrics, columnWidth - 8);
                        g2.setFont(roomFont);
                        g2.setColor(Color.white);
                        g2.drawString(roomTitle, 40 - this._scrollOffset + i * columnWidth + 4, 49);
                        g2.setColor(Color.white);
                        g2.drawLine(40 - this._scrollOffset + (i + 1) * columnWidth, 35, 40 - this._scrollOffset + (i + 1) * columnWidth, 67);
                        ++i;
                    }
                }
            }
        }

        public void setScrollOffset(int offset) {
            this._scrollOffset = offset;
            this.repaint();
        }
    }

    private static class TimeStrip
    extends JComponent {
        private static final long serialVersionUID = 0L;
        private int _scrollOffset;
        private CalendarGrid _calendarGrid;

        public TimeStrip(CalendarGrid calendarGrid) {
            this._calendarGrid = calendarGrid;
            this._scrollOffset = 0;
            this.setBackground(Color.white);
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            Graphics2D g2 = SwingHelper.prepareGraphics(g);
            Font timeFontLarge = this.getFont().deriveFont(0, 18.0f);
            Font timeFontSmall = this.getFont().deriveFont(0, 10.0f);
            FontMetrics fontMetrics = g2.getFontMetrics(timeFontLarge);
            int i = 0;
            while (i <= this._calendarGrid._stopHour - this._calendarGrid._startHour) {
                int vOffset = 0 - this._scrollOffset + 8;
                g2.setFont(timeFontLarge);
                g2.setColor(Color.black);
                String hourString = Integer.toString((i + this._calendarGrid._startHour - 1) % 12 + 1);
                String ampmString = this._calendarGrid._startHour + i < 12 || this._calendarGrid._startHour + i == 24 ? "am" : "pm";
                int hourStringWidth = fontMetrics.stringWidth(hourString);
                g2.drawString(hourString, 40 - hourStringWidth - 18, i * 60 + vOffset + 7);
                g2.setFont(timeFontSmall);
                g2.drawString("00", 24, i * 60 + vOffset + 1);
                g2.setColor(Color.darkGray);
                g2.drawString(ampmString, 23, i * 60 + vOffset + 8);
                ++i;
            }
            g2.setColor(Color.lightGray);
            g2.drawLine(this.getWidth() - 1, 0 - this._scrollOffset, this.getWidth() - 1, 0 + (this._calendarGrid._stopHour - this._calendarGrid._startHour) * 60 - this._scrollOffset);
        }

        public void setScrollOffset(int offset) {
            this._scrollOffset = offset;
            this.repaint();
        }
    }

    public static class GridPanel
    extends JPanel
    implements ComponentDragListener {
        private static final long serialVersionUID = 0L;
        private static final int MINCOLUMNWIDTH = 100;
        private CalendarGrid _calendarGrid;
        private CalendarGridLayoutManager _layoutManager;
        private boolean _isComponentDragging;
        private CalendarGridEntry _componentDragEntry;
        private GregorianCalendar _calendar;
        private int _width;
        private WorkJournal.NodeStateCaptureItem _dragEventAction;
        private int _selectedIndex;
        private static TexturePaint UNAVAILABLE_TEXTURE;

        static {
            ClassLoader classLoader = CalendarGridEntry.class.getClassLoader();
            ImageIcon unavailableIcon = new ImageIcon(classLoader.getResource("edu/cmu/cs/radar/rhai/media/unavailable.png"));
            BufferedImage unavailableImage = new BufferedImage(unavailableIcon.getIconHeight(), unavailableIcon.getIconWidth(), 2);
            unavailableImage.createGraphics().drawImage(unavailableIcon.getImage(), 0, 0, null);
            UNAVAILABLE_TEXTURE = new TexturePaint(unavailableImage, new Rectangle2D.Double(0.0, 0.0, unavailableImage.getWidth(), unavailableImage.getHeight()));
        }

        public GridPanel(CalendarGrid calendarGrid) {
            this.setBackground(Color.white);
            this._calendarGrid = calendarGrid;
            this._calendar = new GregorianCalendar();
            this._layoutManager = new CalendarGridLayoutManager(this);
            this._isComponentDragging = false;
            this._width = 100;
            this._selectedIndex = -1;
            this.setLayout(this._layoutManager);
            this.setAutoscrolls(true);
        }

        public RequestListModel getRequestListModel() {
            return this._calendarGrid._listModel;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void recomputeLayout() {
            CalendarGrid calendarGrid = this._calendarGrid;
            synchronized (calendarGrid) {
                this._width = this.getCategoryWidth() * this._calendarGrid._schedules.size();
                this.revalidate();
            }
        }

        @Override
        public Dimension getPreferredSize() {
            return this.getMinimumSize();
        }

        @Override
        public Dimension getMinimumSize() {
            return new Dimension(this._width, 0 + (this._calendarGrid._stopHour - this._calendarGrid._startHour) * 60);
        }

        protected int getVerticalPosition(Date date) {
            this._calendar.setTime(date);
            int hour = this._calendar.get(11);
            int minute = this._calendar.get(12);
            return 0 + (hour - this._calendarGrid._startHour) * 60 + minute * 60 / 60;
        }

        protected Date getVisibleStartTime() {
            this._calendar.setTime(this._calendarGrid._date);
            this._calendar.set(11, this._calendarGrid._startHour);
            this._calendar.set(12, 0);
            return this._calendar.getTime();
        }

        protected Date getVisibleStopTime() {
            this._calendar.setTime(this._calendarGrid._date);
            this._calendar.set(11, this._calendarGrid._stopHour);
            this._calendar.set(12, 0);
            return this._calendar.getTime();
        }

        public void setSelectedRoom(int index, boolean makeViewable) {
            this._selectedIndex = index;
            if (this._selectedIndex >= 0 && makeViewable) {
                int categoryWidth = this.getCategoryWidth();
                this.scrollRectToVisible(new Rectangle(this._selectedIndex * categoryWidth, 0, categoryWidth, 1));
            }
            this.repaint();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void paintComponent(Graphics g) {
            CalendarGrid calendarGrid = this._calendarGrid;
            synchronized (calendarGrid) {
                super.paintComponent(g);
                Graphics2D g2 = SwingHelper.prepareGraphics(g);
                int columnWidth = this.getCategoryWidth();
                int columns = this._calendarGrid._schedules.size();
                int scheduleCount = this._calendarGrid._schedules.size();
                if (scheduleCount > 0) {
                    int i = 0;
                    while (i <= this._calendarGrid._stopHour - this._calendarGrid._startHour) {
                        int vOffset = 0;
                        g2.setColor(Color.lightGray);
                        g2.drawLine(0, i * 60 + vOffset, columnWidth * columns, i * 60 + vOffset);
                        g2.setColor(new Color(220, 220, 220));
                        g2.drawLine(0, i * 60 + vOffset + 30, columnWidth * columns, i * 60 + vOffset + 30);
                        ++i;
                    }
                }
                int maxHeight = 0 + (this._calendarGrid._stopHour - this._calendarGrid._startHour) * 60;
                Date startTime = this.getVisibleStartTime();
                Date stopTime = this.getVisibleStopTime();
                int i = 0;
                while (i < scheduleCount) {
                    int x = (i + 1) * columnWidth;
                    int y = 0;
                    g2.setColor(Color.darkGray);
                    g2.drawLine(x, y, x, maxHeight);
                    ScheduleInfo scheduleInfo = (ScheduleInfo)this._calendarGrid._schedules.get(i);
                    SpaceTimeNode roomNode = null;
                    roomNode = this._calendarGrid._listModel.getDataAdapter().getNodeById(scheduleInfo.id);
                    if (roomNode != null) {
                        g2.setPaint(UNAVAILABLE_TEXTURE);
                        Boolean usableFlag = (Boolean)this._calendarGrid._availabilities.get(i);
                        if (Boolean.FALSE.equals(usableFlag)) {
                            g2.fillRect(i * columnWidth + 1, y + 1, columnWidth - 1, maxHeight - 0 - 1);
                        } else {
                            SpaceTimeTimeIntervals intervals = new SpaceTimeTimeIntervals(roomNode);
                            intervals.intersect(startTime, stopTime);
                            intervals.complement(startTime, stopTime);
                            for (SpaceTimeTimeIntervals.Interval interval : intervals) {
                                int startPos = this.getVerticalPosition(interval._start);
                                int stopPos = this.getVerticalPosition(interval._stop);
                                g2.fillRect(x - columnWidth + 1, startPos + 1, columnWidth - 1, stopPos - startPos - 1);
                            }
                        }
                        if (this._selectedIndex == i) {
                            g2.setColor(new Color(55, 104, 197, 50));
                            g2.fillRect(i * columnWidth + 1, y + 1, columnWidth - 1, maxHeight - 0 - 1);
                        }
                    }
                    ++i;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int getCategoryWidth() {
            CalendarGrid calendarGrid = this._calendarGrid;
            synchronized (calendarGrid) {
                int width;
                int schedules;
                block5: {
                    schedules = this._calendarGrid._schedules.size();
                    width = this._calendarGrid._scrollPane.getWidth();
                    if (this._calendarGrid._scrollPane.getVerticalScrollBar().isVisible()) {
                        width -= this._calendarGrid._scrollPane.getVerticalScrollBar().getWidth();
                    }
                    if (schedules != 0) break block5;
                    return 1;
                }
                return Math.max(100, (width - 1) / schedules);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ScheduleInfo getScheduleInfoFromLocation(Point p) {
            CalendarGrid calendarGrid = this._calendarGrid;
            synchronized (calendarGrid) {
                block4: {
                    if (this._calendarGrid._schedules.size() != 0) break block4;
                    return null;
                }
                int categoryWidth = this.getCategoryWidth();
                int categoryIndex = Math.min(this._calendarGrid._schedules.size() - 1, p.x / categoryWidth);
                ScheduleInfo scheduleInfo = (ScheduleInfo)this._calendarGrid._schedules.get(categoryIndex);
                return scheduleInfo;
            }
        }

        private SpaceTimeDate getDateFromLocation(Point p) {
            int yincrement = 15;
            int yincrements = (p.y - 0) / yincrement;
            yincrements = Math.min(Math.max(0, yincrements), (this._calendarGrid._stopHour - this._calendarGrid._startHour) * 4);
            SpaceTimeDate date = new SpaceTimeDate(this._calendarGrid._date);
            date.setHourOfDay(this._calendarGrid._startHour + yincrements / 4);
            date.setMinute(yincrements % 4 * 15);
            return date;
        }

        private CalendarGridEntry findGridEntry(String nodeId) {
            CalendarGridEntry foundEntry = null;
            for (CalendarGridEntry entry : this._layoutManager._controls) {
                if (!entry.getAllocation().getRequestNode().getNode().getName().equals(nodeId)) continue;
                return entry;
            }
            SpaceTimeNode node = this._calendarGrid._listModel.getDataAdapter().getNodeById(nodeId);
            foundEntry = new CalendarGridEntry(this, new Allocation(new SpaceTimeRequestNode(node)));
            this.add((Component)foundEntry, null);
            return foundEntry;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void componentDragEnter(ComponentDragContainer dragContainer, Component component, Point p) {
            CalendarGrid calendarGrid = this._calendarGrid;
            synchronized (calendarGrid) {
                if (component instanceof GenericRequestDragComponent) {
                    if (((GenericRequestDragComponent)component).getSource() == this) {
                        return;
                    }
                } else {
                    return;
                }
                if (this._calendarGrid._schedules.size() == 0) {
                    return;
                }
                this._isComponentDragging = true;
                GenericRequestDragComponent requestDragComponent = (GenericRequestDragComponent)component;
                dragContainer.captureDragControl();
                SpaceTimeRequestNode requestNode = requestDragComponent.getRequestNode();
                this._dragEventAction = new WorkJournal.NodeStateCaptureItem(this._calendarGrid._listModel, requestNode.getNode(), "assign");
                this._componentDragEntry = this.findGridEntry(requestNode.getNode().getName());
                this._componentDragEntry.setVisible(true);
                ScheduleInfo scheduleInfo = this.getScheduleInfoFromLocation(p);
                SpaceTimeDuration duration = requestNode.getDuration();
                if (duration == null || duration.getOptDuration() == 0L) {
                    duration = requestNode.calculateOptimalDuration();
                }
                requestNode.setParametersPreservingLocks(scheduleInfo.id, this.getDateFromLocation(p), duration);
                this._layoutManager.entrySelected(this._componentDragEntry);
                this._componentDragEntry.setSelected(true);
                int roomIndex = this._calendarGrid.getScheduleIndex(this._calendarGrid._schedules, scheduleInfo.id);
                this._componentDragEntry.setLocation(this._layoutManager.getEntryPosition(this._componentDragEntry, roomIndex));
                this._componentDragEntry.setSize(this._layoutManager.getEntrySize(this._componentDragEntry));
                Point localPoint = SwingUtilities.convertPoint(this, p, this._componentDragEntry);
                this._layoutManager.mousePressed(new MouseEvent(this, 0, 0L, 0, localPoint.x, localPoint.y, 1, false));
            }
        }

        @Override
        public void componentDragLeave(ComponentDragContainer dragContainer, Component component, Point p) {
            if (component instanceof GenericRequestDragComponent && ((GenericRequestDragComponent)component).getSource() == this) {
                return;
            }
            if (!this._isComponentDragging) {
                return;
            }
            this._isComponentDragging = false;
            dragContainer.unCaptureDragControl();
            this._layoutManager.mouseReleased(new MouseEvent(this, 0, 0L, 0, p.x, p.y, 1, false));
            Allocation allocation = this._componentDragEntry.getAllocation();
            allocation.getRequestNode().removeAllocation();
            this._componentDragEntry.setVisible(false);
            this._componentDragEntry = null;
            this.repaint();
        }

        @Override
        public void componentDragAbort(ComponentDragContainer dragContainer, Component component) {
            if (dragContainer.getSourceComponent() == this) {
                this._layoutManager.abortDrag();
                this.componentDragLeave(dragContainer, component, new Point(0, 0));
                this._dragEventAction = null;
            }
        }

        @Override
        public void componentDragged(Point p) {
            if (!this._isComponentDragging || this._componentDragEntry == null) {
                return;
            }
            Point localPoint = SwingUtilities.convertPoint(this, p, this._componentDragEntry);
            this._layoutManager.mouseDragged(new MouseEvent(this._componentDragEntry, 0, 0L, 0, localPoint.x, localPoint.y, 1, false));
        }

        @Override
        public boolean componentDropped(Point p) {
            if (!this._isComponentDragging || this._componentDragEntry == null) {
                return false;
            }
            this._dragEventAction.captureState();
            Services.journal.addItem(this._dragEventAction);
            this._dragEventAction.setLogDescription("dragged an event from the event list to the schedule");
            Services.logger.info(this._dragEventAction.log());
            this._componentDragEntry.requestFocus();
            this._componentDragEntry = null;
            this._layoutManager.mouseReleased(new MouseEvent(this, 0, 0L, 0, p.x, p.y, 1, false));
            return true;
        }

        @Override
        public void componentDropComplete(ComponentDragContainer dragContainer, Component component) {
            this._layoutManager.layoutContainer(this);
            this._layoutManager._dragEventAction = null;
            component.requestFocus();
        }
    }

    private static class CalendarGridLayoutManager
    implements LayoutManager2,
    MouseListener,
    MouseMotionListener {
        private static final int BUFFER = 3;
        private static final int DRAGSTATE_NONE = 0;
        private static final int DRAGSTATE_RESIZE = 1;
        private static final int DRAGSTATE_MOVE = 2;
        private static final int DRAGSTATE_ABORTED = 3;
        private Point _mouseAnchor;
        private GridPanel _gridPanel;
        private List<CalendarGridEntry> _controls;
        private List<RangedItemList> _rangedLists;
        private int _dragState;
        private boolean _dragFlag;
        private boolean _dragNodeChanged;
        private ComponentDragContainer _dragContainer;
        private SpaceTimeDate _restoreStartTime;
        private String _restoreRoom;
        private CalendarGridEntry _selectedEntry;
        private WorkJournal.NodeStateCaptureItem _dragEventAction;
        private boolean _suppressLayout;
        private Point _mouseDownWRTScreen;

        public CalendarGridLayoutManager(GridPanel gridPanel) {
            this._gridPanel = gridPanel;
            this._controls = new ArrayList<CalendarGridEntry>();
            this._rangedLists = new ArrayList<RangedItemList>();
            this._dragState = 0;
            this._dragFlag = false;
            this._suppressLayout = false;
        }

        @Override
        public void addLayoutComponent(String arg0, Component component) {
        }

        @Override
        public void layoutContainer(Container container) {
            if (this._suppressLayout) {
                return;
            }
            this.layoutGrid();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void layoutGrid() {
            CalendarGrid calendarGrid = this._gridPanel._calendarGrid;
            synchronized (calendarGrid) {
                this._rangedLists.clear();
                ArrayList<ScheduleInfo> schedulesCopy = new ArrayList<ScheduleInfo>();
                for (ScheduleInfo scheduleInfo : this._gridPanel._calendarGrid._schedules) {
                    this._rangedLists.add(new RangedItemList());
                    schedulesCopy.add(scheduleInfo);
                }
                SpaceTimeDate shownDate = this._gridPanel._calendarGrid._date;
                for (CalendarGridEntry gridEntry : this._controls) {
                    Allocation allocation = gridEntry.getAllocation();
                    if (!allocation.getRequestNode().isAssigned()) {
                        gridEntry.setVisible(false);
                        continue;
                    }
                    SpaceTimeDate startDate = allocation.getStart();
                    SpaceTimeDuration duration = allocation.getDuration();
                    if (!startDate.equalsDate(shownDate)) {
                        gridEntry.setVisible(false);
                        continue;
                    }
                    String roomName = allocation.getRoom();
                    int roomIndex = this._gridPanel._calendarGrid.getScheduleIndex(schedulesCopy, roomName);
                    if (roomIndex >= 0) {
                        RangedItemList rangedList = this._rangedLists.get(roomIndex);
                        rangedList.addItem(gridEntry, startDate.getOptDate(), startDate.getOptDate() + duration.getOptDuration());
                    } else {
                        gridEntry.setVisible(false);
                    }
                    gridEntry.repaint();
                }
                int i = 0;
                while (i < this._rangedLists.size()) {
                    this.arrangeCategory(i);
                    ++i;
                }
            }
        }

        @Override
        public Dimension minimumLayoutSize(Container container) {
            return new Dimension(200, 200);
        }

        @Override
        public Dimension preferredLayoutSize(Container container) {
            return new Dimension(200, 200);
        }

        @Override
        public void removeLayoutComponent(Component component) {
            this._controls.remove(component);
            this.layoutContainer(this._gridPanel);
        }

        @Override
        public void addLayoutComponent(Component component, Object constraint) {
            if (component instanceof CalendarGridEntry) {
                component.addMouseListener(this);
                component.addMouseMotionListener(this);
                this._controls.add((CalendarGridEntry)component);
            }
        }

        private void suppressLayout(boolean suppress) {
            this._suppressLayout = suppress;
            if (!this._suppressLayout) {
                this.layoutContainer(this._gridPanel);
            }
        }

        public void entrySelected(CalendarGridEntry entry) {
            if (this._selectedEntry == entry) {
                return;
            }
            if (this._selectedEntry != null) {
                this._selectedEntry.setSelected(false);
            }
            if (entry != null) {
                entry.setSelected(true);
            }
            this._selectedEntry = entry;
        }

        public void arrangeCategory(int index) {
            RangedItemList.ItemInformation[] items;
            RangedItemList itemList = this._rangedLists.get(index);
            RangedItemList.ItemInformation[] itemInformationArray = items = itemList.getAllItemInformation();
            int n = 0;
            int n2 = itemInformationArray.length;
            while (n < n2) {
                RangedItemList.ItemInformation element = itemInformationArray[n];
                this.setEntryDimensions((CalendarGridEntry)element.getKey(), index, element.getColumn(), element.getTotalColumns());
                ++n;
            }
        }

        public void setEntryDimensions(CalendarGridEntry entry, int roomIndex, int column, int totalColumns) {
            Allocation allocation = entry.getAllocation();
            SpaceTimeDate date = allocation.getStart();
            int categoryWidth = this._gridPanel.getCategoryWidth();
            int columnWidth = categoryWidth / totalColumns;
            int xPos = 3 + roomIndex * categoryWidth + column * columnWidth;
            int yPos = 0 + 60 * (date.getHourOfDay() - this._gridPanel._calendarGrid._startHour) + date.getMinute() * 60 / 60;
            SpaceTimeDuration duration = allocation.getDuration();
            int width = columnWidth - 6;
            int height = (int)(60L * duration.getOptDuration()) / 3600;
            entry.setLocation(xPos, yPos);
            entry.setSize(width, height);
            entry.setVisible(true);
        }

        private Point getEntryPosition(CalendarGridEntry gridEntry, int roomIndex) {
            Allocation allocation = gridEntry.getAllocation();
            allocation.waitUntilAssignmentValid();
            SpaceTimeDate date = allocation.getStart();
            int xPos = 3 + roomIndex * this._gridPanel.getCategoryWidth();
            int yPos = 0 + 60 * (date.getHourOfDay() - this._gridPanel._calendarGrid._startHour) + date.getMinute() * 60 / 60;
            return new Point(xPos, yPos);
        }

        private Dimension getEntrySize(CalendarGridEntry gridEntry) {
            Allocation allocation = gridEntry.getAllocation();
            allocation.waitUntilAssignmentValid();
            SpaceTimeDuration duration = allocation.getDuration();
            int width = this._gridPanel.getCategoryWidth() - 6;
            int height = (int)(60L * duration.getOptDuration()) / 3600;
            return new Dimension(width, height);
        }

        @Override
        public float getLayoutAlignmentX(Container arg0) {
            return 0.0f;
        }

        @Override
        public float getLayoutAlignmentY(Container arg0) {
            return 0.0f;
        }

        @Override
        public void invalidateLayout(Container container) {
        }

        @Override
        public Dimension maximumLayoutSize(Container arg0) {
            return null;
        }

        private void abortDrag() {
            this._dragState = 3;
        }

        @Override
        public void mouseClicked(MouseEvent arg0) {
        }

        @Override
        public void mouseEntered(MouseEvent arg0) {
        }

        @Override
        public void mouseExited(MouseEvent arg0) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this._dragFlag = false;
            this._dragNodeChanged = false;
            this._mouseAnchor = e.getPoint();
            this._mouseDownWRTScreen = new Point(e.getPoint());
            SwingUtilities.convertPointToScreen(this._mouseDownWRTScreen, e.getComponent());
            if (this._dragState == 0) {
                this._dragState = this.testEdge(e, e.getComponent()) ? 1 : 2;
            }
            if (e.getComponent() instanceof CalendarGridEntry) {
                CalendarGridEntry gridEntry = (CalendarGridEntry)e.getComponent();
                if (this._gridPanel._calendarGrid._selectionManager != null) {
                    if (this._selectedEntry != null) {
                        this._gridPanel._calendarGrid._selectionManager.notifySelection(this._gridPanel._calendarGrid, this._selectedEntry.getAllocation().getRequestNode().getNode().getName(), 1, false, true, false);
                    }
                    this._gridPanel._calendarGrid._selectionManager.notifySelection(this._gridPanel._calendarGrid, gridEntry.getAllocation().getRequestNode().getNode().getName(), 1, true, true, false);
                }
                if (gridEntry.getAllocation().getRequestNode().isLockedToRoom()) {
                    this._dragState = 0;
                    return;
                }
                this._dragEventAction = new WorkJournal.NodeStateCaptureItem(this._gridPanel._calendarGrid._listModel, gridEntry.getAllocation().getRequestNode().getNode(), "drag");
                this._restoreStartTime = gridEntry.getAllocation().getRequestNode().getStart();
                this._restoreRoom = gridEntry.getAllocation().getRoom();
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this._mouseAnchor = null;
            this._mouseDownWRTScreen = null;
            if (this._dragContainer == null) {
                this._dragContainer = ComponentDragContainer.findDragContainer(this._gridPanel);
            }
            if (this._dragContainer.isDragging() && this._dragContainer.getSourceComponent() == this._gridPanel) {
                Point localPoint = SwingUtilities.convertPoint(e.getComponent(), e.getPoint(), this._gridPanel);
                this._dragContainer.dragMouseDrop(localPoint);
            }
            if (this._dragFlag && this._dragEventAction != null && this._dragNodeChanged && !this._dragContainer.isCaptured()) {
                this._dragEventAction.captureState();
                Services.journal.addItem(this._dragEventAction);
                this._dragEventAction.setLogDescription("dragged an event within schedule");
                Services.logger.info(this._dragEventAction.log());
                this._dragEventAction = null;
            }
            this._dragState = 0;
            this._dragFlag = false;
            this._dragEventAction = null;
            if (e.getButton() == 3) {
                if (!(e.getComponent() instanceof CalendarGridEntry)) {
                    return;
                }
                CalendarGridEntry gridEntry = (CalendarGridEntry)e.getComponent();
                JPopupMenu menu = new JPopupMenu();
                JMenuItem unassignItem = new JMenuItem(gridEntry.getUnassignAction());
                menu.add(unassignItem);
                JMenuItem editPreferenceItem = new JMenuItem(new EditEventAction(gridEntry.getAllocation().getRequestNode().getNode()));
                menu.add(editPreferenceItem);
                Point point = e.getPoint();
                menu.show(e.getComponent(), point.x, point.y);
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            this._dragFlag = true;
            Component component = e.getComponent();
            if (!(component instanceof CalendarGridEntry)) {
                return;
            }
            if (this._mouseAnchor == null) {
                return;
            }
            MouseEvent translatedEvent = SwingUtilities.convertMouseEvent(component, e, this._gridPanel);
            Rectangle r = new Rectangle(translatedEvent.getX(), translatedEvent.getY(), 1, 1);
            this._gridPanel.scrollRectToVisible(r);
            switch (this._dragState) {
                case 1: {
                    this.resizeItem(e, component);
                    break;
                }
                case 2: {
                    this.moveItem(e, component);
                    break;
                }
                case 3: {
                    this._dragEventAction = null;
                }
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            Component component = e.getComponent();
            if (!(component instanceof CalendarGridEntry)) {
                return;
            }
            if (this._mouseAnchor != null) {
                return;
            }
            CalendarGridEntry entry = (CalendarGridEntry)component;
            if (entry.getAllocation().getRequestNode().isLockedToRoom()) {
                component.setCursor(new Cursor(0));
                return;
            }
            if (this.testEdge(e, component)) {
                component.setCursor(new Cursor(8));
            } else {
                component.setCursor(new Cursor(0));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void moveItem(MouseEvent e, Component component) {
            CalendarGrid calendarGrid = this._gridPanel._calendarGrid;
            synchronized (calendarGrid) {
                int prevColumn;
                if (this._mouseDownWRTScreen != null) {
                    Point ptWRTScreen = new Point(e.getPoint());
                    SwingUtilities.convertPointToScreen(ptWRTScreen, e.getComponent());
                    if (this._mouseDownWRTScreen.distance(ptWRTScreen) < 5.0) {
                        return;
                    }
                    this._mouseDownWRTScreen = null;
                }
                CalendarGridEntry gridEntry = (CalendarGridEntry)component;
                if (this._dragContainer == null) {
                    this._dragContainer = ComponentDragContainer.findDragContainer(this._gridPanel);
                }
                Point localPoint = SwingUtilities.convertPoint(e.getComponent(), e.getPoint(), this._gridPanel);
                Rectangle bounds = new Rectangle(new Point(0, 0), this._gridPanel.getSize());
                if (!bounds.contains(localPoint)) {
                    if (!this._dragContainer.isDragging()) {
                        JComponent dragComponent = gridEntry.getDragComponent();
                        Dimension entrySize = gridEntry.getSize();
                        dragComponent.setLocation(new Point(localPoint.x - entrySize.width / 2, localPoint.y - entrySize.height / 2));
                        this._dragContainer.startDrag(this._gridPanel, dragComponent, localPoint);
                        gridEntry.getAllocation().setStart(this._restoreStartTime);
                        gridEntry.getAllocation().setRoom(this._restoreRoom);
                        this.layoutContainer(this._gridPanel);
                    } else {
                        this._dragContainer.dragMouseMove(localPoint);
                    }
                    return;
                }
                if (this._dragContainer.isDragging() && this._dragContainer.getSourceComponent() == this._gridPanel) {
                    this._dragContainer.abortDrag();
                    this._dragState = 2;
                }
                int yincrement = 15;
                int xincrement = this._gridPanel.getCategoryWidth();
                Point ptInGrid = SwingUtilities.convertPoint(gridEntry, e.getPoint(), this._gridPanel);
                ptInGrid.y -= 0;
                ptInGrid.y -= this._mouseAnchor.y;
                int yIncrementCount = ptInGrid.y / yincrement;
                yIncrementCount = Math.max(0, yIncrementCount);
                yIncrementCount = Math.min(yIncrementCount, (this._gridPanel._calendarGrid._stopHour - this._gridPanel._calendarGrid._startHour) * 4 - component.getHeight() / yincrement);
                int xIncrementCount = ptInGrid.x / xincrement;
                xIncrementCount = Math.max(0, xIncrementCount);
                xIncrementCount = Math.min(xIncrementCount, this._gridPanel._calendarGrid._schedules.size() - 1);
                Allocation allocation = gridEntry.getAllocation();
                allocation.waitUntilAssignmentValid();
                long prevStart = allocation.getStart().getOptDate();
                SpaceTimeDate startDate = allocation.getStart();
                startDate.setHourOfDay(this._gridPanel._calendarGrid._startHour + yIncrementCount / 4);
                startDate.setMinute(yIncrementCount % 4 * 15);
                ScheduleInfo scheduleInfo = (ScheduleInfo)this._gridPanel._calendarGrid._schedules.get(xIncrementCount);
                if (allocation.getRequestNode().isLockedToStartTime()) {
                    allocation.getRequestNode().setLockedToStartTime(false);
                }
                if ((prevColumn = component.getX() / xincrement) == xIncrementCount && prevStart == startDate.getOptDate()) {
                    return;
                }
                long start = startDate.getOptDate();
                long duration = allocation.getDuration().getOptDuration();
                SpaceTimeDate adjustedStart = new SpaceTimeDate(start);
                TimeSlot timeSlot = new TimeSlot(start, duration);
                if (prevColumn != xIncrementCount) {
                    RangedItemList prevItemList = this._rangedLists.get(prevColumn);
                    RangedItemList currentItemList = this._rangedLists.get(xIncrementCount);
                    prevItemList.removeItem(gridEntry);
                    currentItemList.addItem(gridEntry, timeSlot.start, timeSlot.start + timeSlot.duration);
                    allocation.setRoom(scheduleInfo.id);
                    this._dragNodeChanged = true;
                }
                if (prevStart != startDate.getOptDate()) {
                    RangedItemList rangedList = this._rangedLists.get(xIncrementCount);
                    rangedList.moveItem(gridEntry, timeSlot.start, timeSlot.start + timeSlot.duration);
                    allocation.setStart(adjustedStart);
                    this._dragNodeChanged = true;
                }
                if (this._dragNodeChanged) {
                    allocation.getRequestNode().getNode().setScore(-101.0);
                }
                this.layoutContainer(this._gridPanel);
            }
        }

        private void resizeItem(MouseEvent e, Component component) {
            Point p1 = component.getLocation();
            Point p2 = e.getPoint();
            int yincrement = 15;
            int yincrementsBase = (p1.y - 0) / yincrement;
            int yincrements = (p1.y + p2.y + yincrement / 2 - 0) / yincrement;
            yincrements = Math.min(yincrements, (this._gridPanel._calendarGrid._stopHour - this._gridPanel._calendarGrid._startHour) * 4);
            int yincrementsDiff = yincrements - yincrementsBase;
            yincrementsDiff = Math.max(1, yincrementsDiff);
            CalendarGridEntry gridEntry = (CalendarGridEntry)component;
            Allocation allocation = gridEntry.getAllocation();
            SpaceTimeDuration duration = allocation.getDuration();
            if (duration.getOptDuration() != (long)(yincrementsDiff * 900)) {
                allocation.setDuration(new SpaceTimeDuration(yincrementsDiff * 900));
                this._dragNodeChanged = true;
            }
            if (this._dragNodeChanged) {
                allocation.getRequestNode().getNode().setScore(-101.0);
            }
            this.layoutContainer(this._gridPanel);
        }

        private boolean testEdge(MouseEvent e, Component component) {
            return e.getPoint().y > component.getHeight() - 4;
        }

        private static class TimeSlot {
            public long start;
            public long duration;

            public TimeSlot(long start, long duration) {
                this.start = start;
                this.duration = duration;
            }
        }
    }
}

