/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.radar.stp.cachingdatamodel;

import SpaceTimeMain.STMSession;
import SpaceTimeMain.STMSessionHelper;
import edu.cmu.cs.radar.rhai.spacetime.Services;
import edu.cmu.cs.radar.stp.cachingdatamodel.SpaceTimeDataAdapter;
import java.util.Properties;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAHelper;

public class SpaceTimeSession {
    public static final double SCOREINFEASIBLE = -6.0;
    public static final double SCOREPENDING = -101.0;
    public static final double UNSCORED = -100.0;
    private static SpaceTimeSession s_singleton;
    private ORB _orb;
    private POA _rootPOA;
    private STMSession _session;
    private SpaceTimeDataAdapter _dataAdapter;
    public Exception _connectException;

    public static SpaceTimeSession createInstance(Properties radarProperties) {
        s_singleton = new SpaceTimeSession(radarProperties);
        return s_singleton;
    }

    public static SpaceTimeSession getInstance() {
        return s_singleton;
    }

    private SpaceTimeSession(Properties radarProperties) {
        try {
            String hostname = radarProperties.getProperty("radar.stp.iiop.hostname", "localhost");
            String port = radarProperties.getProperty("radar.stp.iiop.port", "8087");
            Services.logger.info("connecting to spacetime backend at '" + hostname + ":" + port + "'");
            Properties props = System.getProperties();
            props.put("org.omg.CORBA.ORBInitialHost", hostname);
            props.put("org.oml.CORBA.ORBInitialPort", port);
            this._orb = ORB.init((String[])new String[0], (Properties)props);
            String sessionMoniker = "corbaloc::" + hostname + ":" + port + "/SpaceTimeSession";
            this._session = STMSessionHelper.narrow(this._orb.string_to_object(sessionMoniker));
            this._rootPOA = POAHelper.narrow((Object)this._orb.resolve_initial_references("RootPOA"));
            this._rootPOA.the_POAManager().activate();
        }
        catch (Exception ex) {
            this._rootPOA = null;
            this._session = null;
            this._connectException = ex;
        }
    }

    public boolean isConnected() {
        return this._session != null && this._rootPOA != null;
    }

    public void shutdown() {
        try {
            if (this._dataAdapter != null) {
                this._dataAdapter.dispose();
            }
            if (this._rootPOA != null) {
                this._rootPOA.the_POAManager().deactivate(true, true);
            }
            if (this._session != null) {
                this._session.signalExit();
            }
        }
        catch (Exception ex) {
            Services.logger.error("shutting down backend connection", ex);
        }
        this._dataAdapter = null;
        this._rootPOA = null;
        this._session = null;
    }

    public SpaceTimeDataAdapter getDataAdapter() {
        if (this._rootPOA == null || this._session == null) {
            return null;
        }
        if (this._dataAdapter == null) {
            this._dataAdapter = new SpaceTimeDataAdapter(this._session.dAdaptr(), this._rootPOA);
        }
        return this._dataAdapter;
    }

    public void runOptimizer() {
        try {
            this._session.runOptimizer(false);
        }
        catch (Exception ex) {
            Services.logger.error("SpaceTimeSession.runOptimzer", ex);
        }
    }

    public void commit() {
        try {
            this._session.commitWorldstate();
        }
        catch (Exception ex) {
            Services.logger.error("SpaceTimeSession.commitWorldstate", ex);
        }
    }

    public void runElicitation() {
        try {
            this._session.runElicitation();
        }
        catch (Exception ex) {
            Services.logger.error("SpaceTimeSession.runElicitation", ex);
        }
    }

    public int getBatchLearningTimeEstimate() {
        try {
            return this._session.getBatchLearningTimeEstimate();
        }
        catch (Exception ex) {
            Services.logger.error("SpaceTimeSession.getBatchLearningTimeEstimate", ex);
            return -1;
        }
    }

    public void startBatchLearning() {
        try {
            this._session.startBatchLearning();
        }
        catch (Exception ex) {
            Services.logger.error("SpaceTimeSession.startBatchLearning", ex);
        }
    }

    public void interruptBatchLearning() {
        try {
            this._session.interruptBatchLearning();
        }
        catch (Exception ex) {
            Services.logger.error("SpaceTimeSession.interruptBatchLearning", ex);
        }
    }

    public void runVendorOptimizer() {
        try {
            this._session.runVendorOptimizer();
        }
        catch (Exception ex) {
            Services.logger.error("SpaceTimeSession.runVendorOptimizer", ex);
        }
    }

    public void runVendorElicitor() {
        try {
            this._session.runVendorElicitor();
        }
        catch (Exception ex) {
            Services.logger.error("SpaceTimeSession.runVendorElicitor", ex);
        }
    }

    public void processVOP(String xmlString) {
        try {
            this._session.processVOP(xmlString);
        }
        catch (Exception ex) {
            Services.logger.error("SpaceTimeSession.processVOP", ex);
        }
    }
}

