/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.radar.rhai.spacetime;

import SpaceTime.DataModel.NodeChangeSummary;
import edu.cmu.cs.radar.rhai.spacetime.ComponentDragContainer;
import edu.cmu.cs.radar.rhai.spacetime.EditEventAction;
import edu.cmu.cs.radar.rhai.spacetime.GenericRequestDragComponent;
import edu.cmu.cs.radar.rhai.spacetime.ItemDetailsList;
import edu.cmu.cs.radar.rhai.spacetime.RequestDetailsListItem;
import edu.cmu.cs.radar.rhai.spacetime.RequestListModel;
import edu.cmu.cs.radar.rhai.spacetime.SelectionListener;
import edu.cmu.cs.radar.rhai.spacetime.SelectionManager;
import edu.cmu.cs.radar.rhai.spacetime.Services;
import edu.cmu.cs.radar.rhai.spacetime.SpaceTimeRequestNode;
import edu.cmu.cs.radar.rhai.spacetime.UnscheduleEventAction;
import edu.cmu.cs.radar.rhai.spacetime.WorkJournal;
import edu.cmu.cs.radar.stp.cachingdatamodel.GlobalChangeListener;
import edu.cmu.cs.radar.stp.cachingdatamodel.SpaceTimeNode;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class SpaceTimeItemList
extends ItemDetailsList
implements SelectionListener {
    private static final long serialVersionUID = 0L;
    private RequestListModel _listModel;
    private SelectionManager _selectionManager;
    private ItemDetailsList.Item _currentSelection;
    private boolean _showScores;
    private boolean _showGraphs;
    private boolean _globalChangeFlag;
    private boolean _debug;
    public static final String CATEGORY_UNSCHEDULED = "Unscheduled";
    public static final String CATEGORY_SCHEDULED = "Scheduled";

    public SpaceTimeItemList(RequestListModel listModel) {
        super("Events");
        this._listModel = listModel;
        this._showScores = true;
        this._showGraphs = true;
        this._globalChangeFlag = false;
        this._debug = false;
        this._listModel.addListDataListener(new ListDataListener(){

            @Override
            public void contentsChanged(ListDataEvent e) {
                GlobalChangeListener changeListener = new GlobalChangeListener(){

                    @Override
                    public void worldStateNodeChanged(String nodeId, NodeChangeSummary changes) {
                        SpaceTimeItemList.this._globalChangeFlag = true;
                        if (SpaceTimeItemList.this._currentSelection != null && nodeId.equals(SpaceTimeItemList.this._currentSelection.getObjectId())) {
                            SpaceTimeItemList.this.selectItem(SpaceTimeItemList.this._currentSelection);
                        }
                    }

                    @Override
                    public void worldStateNodeAdded(String nodeId) {
                        SpaceTimeItemList.this._globalChangeFlag = true;
                    }

                    @Override
                    public void worldStateGlobalScoreChanged(double score) {
                    }

                    @Override
                    public void worldStateNodeScoreChanged(String nodeId, double score) {
                        SpaceTimeItemList.this.repaint();
                    }
                };
                SpaceTimeItemList.this._listModel.getDataAdapter().addGlobalChangeListener(changeListener);
                SpaceTimeItemList.this._currentSelection = null;
                SpaceTimeItemList.this.buildListItems();
                SpaceTimeItemList.this.invalidate();
            }

            @Override
            public void intervalAdded(ListDataEvent e) {
            }

            @Override
            public void intervalRemoved(ListDataEvent e) {
            }
        });
        this.addCategory(new RequestCategory(CATEGORY_UNSCHEDULED, true, this));
        this.addCategory(new RequestCategory(CATEGORY_SCHEDULED, false, this));
        this.buildListItems();
    }

    public SpaceTimeNode getCurrentSelection() {
        if (this._currentSelection != null) {
            return (SpaceTimeNode)this._currentSelection.getObject();
        }
        return null;
    }

    public RequestListModel getListModel() {
        return this._listModel;
    }

    public void refreshDetails() {
        this.selectItem(this._currentSelection);
    }

    private void buildListItems() {
        int itemCount = this.getItemCount();
        int i = 0;
        while (i < itemCount) {
            RequestDetailsListItem item = (RequestDetailsListItem)this.getItemAtIndex(i);
            item.dispose();
            ++i;
        }
        this.clearItems();
        int size = this._listModel.getSize();
        int i2 = 0;
        while (i2 < size) {
            SpaceTimeNode node = this._listModel.getElementAt(i2);
            RequestDetailsListItem listItem = new RequestDetailsListItem(this, node);
            listItem.setDebug(this._debug);
            listItem.showScores(this._showScores);
            listItem.showGraphs(this._showGraphs);
            this.addItem(listItem);
            ++i2;
        }
    }

    public void showScores(boolean show) {
        this._showScores = show;
        int count = this.getItemCount();
        int i = 0;
        while (i < count) {
            RequestDetailsListItem item = (RequestDetailsListItem)this.getItemAtIndex(i);
            item.showScores(show);
            ++i;
        }
        this.selectItem(this._currentSelection);
    }

    public void showGraphs(boolean show) {
        this._showGraphs = show;
        int count = this.getItemCount();
        int i = 0;
        while (i < count) {
            RequestDetailsListItem item = (RequestDetailsListItem)this.getItemAtIndex(i);
            item.showGraphs(show);
            ++i;
        }
        this.selectItem(this._currentSelection);
    }

    public void setDebug(boolean debug) {
        this._debug = debug;
        int count = this.getItemCount();
        int i = 0;
        while (i < count) {
            RequestDetailsListItem item = (RequestDetailsListItem)this.getItemAtIndex(i);
            item.setDebug(debug);
            ++i;
        }
        this.selectItem(this._currentSelection);
    }

    public void setSelectionManager(SelectionManager manager) {
        this._selectionManager = manager;
        this._selectionManager.addListener(this);
    }

    @Override
    public void setSelection(Object sender, Object selection, int type, boolean selected, boolean doubleClick) {
        if (type == 1) {
            ItemDetailsList.Item item;
            this.setBackgroundSelection(false);
            if (selected && (item = this.getItemFromObjectId(selection.toString())) != null) {
                this._currentSelection = item;
                this.selectItem(this._currentSelection);
            }
        } else if (type == 2) {
            this.setBackgroundSelection(true);
            this.repaint();
        }
    }

    @Override
    public void setViewState(Object sender, Object selection, boolean show) {
    }

    protected void changeSelection(ItemDetailsList.Item item, boolean doubleClick) {
        if (this._selectionManager != null) {
            if (this._currentSelection != null) {
                this._selectionManager.notifySelection(this, this._currentSelection.getObjectId(), 1, false, false, doubleClick);
            }
            this._selectionManager.notifySelection(this, item.getObjectId(), 1, true, false, doubleClick);
        }
        this._currentSelection = item;
    }

    @Override
    protected void onItemSelected(ItemDetailsList.Item item, boolean doubleClick) {
        if (this._currentSelection == item && !doubleClick) {
            return;
        }
        if (!doubleClick) {
            Services.logger.info("The user selected event '" + item.getObjectId() + "' in the event list");
        } else {
            Services.logger.info("The user double clicked on event '" + item.getObjectId() + "' in the event list");
        }
        this.changeSelection(item, doubleClick);
    }

    @Override
    protected void onContextMenu(ItemDetailsList.Item item, Point point) {
        RequestDetailsListItem requestItem = (RequestDetailsListItem)item;
        SpaceTimeRequestNode eventNode = requestItem.getRequestNode();
        JPopupMenu menu = new JPopupMenu();
        if (eventNode.isAssigned()) {
            JMenuItem viewInSchedule = new JMenuItem(new ViewEntryInScheduleAction(requestItem));
            menu.add(viewInSchedule);
            JMenuItem unassignItem = new JMenuItem(new UnscheduleEventAction(this._listModel, eventNode));
            menu.add(unassignItem);
        }
        JMenuItem editPreferenceItem = new JMenuItem(new EditEventAction(eventNode.getNode()));
        menu.add(editPreferenceItem);
        menu.show(this, point.x, point.y);
    }

    @Override
    protected boolean allowDrag(Component dragComponent) {
        if (dragComponent instanceof GenericRequestDragComponent) {
            GenericRequestDragComponent component = (GenericRequestDragComponent)dragComponent;
            SpaceTimeRequestNode requestNode = component.getRequestNode();
            return !requestNode.isLockedToRoom();
        }
        return false;
    }

    @Override
    protected void onItemDrag(Component dragComponent) {
        this._globalChangeFlag = false;
        GenericRequestDragComponent requestDragComponent = (GenericRequestDragComponent)dragComponent;
        SpaceTimeRequestNode requestNode = requestDragComponent.getRequestNode();
        WorkJournal.NodeStateCaptureItem nodeState = new WorkJournal.NodeStateCaptureItem(this._listModel, requestNode.getNode(), "unknown");
        Services.journal.setExecutingItem(nodeState);
    }

    @Override
    protected void onItemDropped(ComponentDragContainer dragContainer, ItemDetailsList.Category category) {
        Component object;
        boolean internalDrag = dragContainer.getSourceComponent() == this && !this._globalChangeFlag;
        WorkJournal.NodeStateCaptureItem unscheduleEventAction = null;
        if (Services.journal.getExecutingItem() instanceof WorkJournal.NodeStateCaptureItem) {
            unscheduleEventAction = (WorkJournal.NodeStateCaptureItem)Services.journal.getExecutingItem();
        }
        if ((object = dragContainer.getDragComponent()) instanceof GenericRequestDragComponent) {
            GenericRequestDragComponent dragComponent = (GenericRequestDragComponent)object;
            SpaceTimeRequestNode requestNode = dragComponent.getRequestNode();
            String categoryName = category.getName();
            if (CATEGORY_UNSCHEDULED.equals(categoryName)) {
                if (internalDrag && !requestNode.isAssigned()) {
                    Services.journal.setExecutingItem(null);
                    return;
                }
                if (requestNode.isLockedToRoom()) {
                    Services.journal.setExecutingItem(null);
                    return;
                }
                if (unscheduleEventAction != null) {
                    unscheduleEventAction.setActionTitle("unschedule");
                } else {
                    unscheduleEventAction = new WorkJournal.NodeStateCaptureItem(this._listModel, requestNode.getNode(), "unschedule");
                }
                requestNode.removeAllocation();
                unscheduleEventAction.captureState();
                Services.journal.addItem(unscheduleEventAction);
                unscheduleEventAction.setLogDescription("dragged an event to the unscheduled section in event list");
                Services.logger.info(unscheduleEventAction.log());
            }
        }
    }

    @Override
    protected void onItemDragAbort(Component dragComponent) {
        WorkJournal.NodeStateCaptureItem executingItem = null;
        if (Services.journal.getExecutingItem() instanceof WorkJournal.NodeStateCaptureItem) {
            executingItem = (WorkJournal.NodeStateCaptureItem)Services.journal.getExecutingItem();
        }
        if (executingItem != null) {
            executingItem.undoAction();
        }
    }

    private static class RequestCategory
    extends ItemDetailsList.Category {
        private static final int ICON_OFFSET = 16;
        private ImageIcon _plusIcon;
        private ImageIcon _minusIcon;

        public RequestCategory(String name, boolean validDropTarget, ItemDetailsList owner) {
            super(name, owner);
            this.setValidDropTarget(validDropTarget);
            ClassLoader classLoader = this.getClass().getClassLoader();
            this._minusIcon = new ImageIcon(classLoader.getResource("edu/cmu/cs/radar/rhai/media/minus.png"));
            this._plusIcon = new ImageIcon(classLoader.getResource("edu/cmu/cs/radar/rhai/media/plus.png"));
        }

        @Override
        public int getHeight() {
            return 18;
        }

        @Override
        protected void onClick(Point p) {
            Rectangle rect = new Rectangle(3, 5, 11, 11);
            if (rect.contains(p)) {
                this.setCollapsed(!this.isCollapsed());
            }
        }

        @Override
        protected void draw(Graphics g, int width) {
            Graphics2D g2 = (Graphics2D)g;
            Font fontPlain = g2.getFont().deriveFont(0, 11.0f);
            Font fontBold = g2.getFont().deriveFont(1, 11.0f);
            g.setFont(fontBold);
            FontMetrics fontMetrics = g.getFontMetrics(fontBold);
            if (this.size() > 0) {
                g2.drawImage(this.isCollapsed() ? this._plusIcon.getImage() : this._minusIcon.getImage(), 3, 5, 11, 11, null);
            }
            int stringWidth = fontMetrics.stringWidth(this.getName());
            g2.setColor(Color.black);
            g2.drawString(this.getName(), 20, 15);
            g2.setFont(fontPlain);
            g2.setColor(Color.darkGray);
            String eventLabel = this.size() == 1 ? "event" : "events";
            g2.drawString("(" + this.size() + " " + eventLabel + ")", 24 + stringWidth, 15);
        }
    }

    public class ViewEntryInScheduleAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        private ItemDetailsList.Item _item;

        public ViewEntryInScheduleAction(ItemDetailsList.Item item) {
            super("View in Schedule");
            this._item = item;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Services.logger.info("The user chose to view event '" + this._item.getObjectId() + "' in the schedule.");
            SpaceTimeItemList.this.changeSelection(this._item, true);
        }
    }
}

