/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.radar.rhai.spacetime;

import edu.cmu.cs.radar.rhai.spacetime.ComponentDragContainer;
import edu.cmu.cs.radar.rhai.spacetime.ComponentDragListener;
import edu.cmu.cs.radar.rhai.spacetime.SwingHelper;
import edu.cmu.cs.radar.rhai.spacetime.TitlePane;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;

public class ItemDetailsList
extends JComponent
implements MouseMotionListener,
MouseListener,
ComponentDragListener {
    private static final long serialVersionUID = 0L;
    private ItemPane _itemPane;
    private JSplitPane _splitPane;
    private DetailsPane _detailsPane;
    private TitlePane _itemTitlePane;
    private TitlePane _detailsTitlePane;
    private JScrollPane _itemScrollPane;
    private ComponentDragContainer _dragContainer;
    private boolean _suppressDragForAbort;
    private boolean _prohibitDrag;
    private int _dividerSize = 0;

    public ItemDetailsList(String title) {
        this.setBackground(Color.white);
        this._itemPane = new ItemPane(this);
        this._detailsPane = new DetailsPane();
        this._suppressDragForAbort = false;
        this._prohibitDrag = false;
        this._itemScrollPane = new JScrollPane(this._itemPane);
        this._itemScrollPane.getVerticalScrollBar().setUnitIncrement(18);
        this._itemScrollPane.getViewport().setBackground(Color.white);
        this._itemScrollPane.setBorder(null);
        JScrollPane detailsScrollPane = new JScrollPane(this._detailsPane);
        detailsScrollPane.setHorizontalScrollBarPolicy(31);
        detailsScrollPane.getViewport().setBackground(Color.white);
        detailsScrollPane.setBorder(null);
        this._itemTitlePane = new TitlePane(title, 0, this._itemScrollPane);
        this._detailsTitlePane = new TitlePane("Debug Details", 0, detailsScrollPane);
        this._splitPane = new JSplitPane(0, this._itemTitlePane, null);
        this._splitPane.setBackground(Color.white);
        this._splitPane.setBorder(null);
        this._dividerSize = this._splitPane.getDividerSize();
        this.setLayout(new BorderLayout());
        this.add((Component)this._splitPane, "Center");
        this.showDetailsPane(false);
        this._splitPane.setResizeWeight(1.0);
        this._splitPane.setDividerLocation(400);
        this._itemPane.addMouseListener(this);
        this._itemPane.addMouseMotionListener(this);
        this.setAutoscrolls(true);
    }

    public void showDetailsPane(boolean show) {
        this._detailsTitlePane.setVisible(show);
        this._splitPane.setBottomComponent(show ? this._detailsTitlePane : null);
        this._splitPane.setDividerSize(show ? this._dividerSize : 0);
        if (show) {
            this._splitPane.setDividerLocation(0.7);
            if (this._detailsPane._item != null) {
                this._detailsPane._item.update();
            }
        }
    }

    public void clearItems() {
        this._detailsPane.setItem(null);
        this._detailsPane.removeAll();
        this._detailsTitlePane.setTitle("Debug Details");
        this._itemPane.clearItems();
    }

    public void addItem(Item item) {
        this._itemPane.addItem(item.getCategory(), item);
        item.setItemChangeListener(new ItemChangeListener(){

            @Override
            public void itemChanged(Item item) {
                ItemDetailsList.this.repaint();
            }

            @Override
            public void categoryChanged(Item item, String oldCategory) {
                ItemDetailsList.this._itemPane.removeItem(oldCategory, item);
                ItemDetailsList.this._itemPane.addItem(item.getCategory(), item);
                ItemDetailsList.this.repaint();
            }
        });
        item._itemDetailsList = this;
    }

    public void removeItem(Item item) {
        this._itemPane.removeItem(item.getCategory(), item);
        item.setItemChangeListener(null);
        item._itemDetailsList = null;
    }

    public void updateItem(Item item) {
        this._detailsPane.setItem(item);
    }

    public int getItemCount() {
        return this._itemPane.getItemCount();
    }

    public Item getItemAtIndex(int index) {
        return this._itemPane.getItemAtIndex(index);
    }

    public Item getItemFromId(String id) {
        return this._itemPane.getItemFromObjectId(id);
    }

    public void addCategory(String categoryName) {
        this._itemPane.addCategory(categoryName);
    }

    public void addCategory(Category category) {
        this._itemPane.addCategory(category);
    }

    public void selectItem(Item item) {
        this.selectItem(item, true);
    }

    public void selectItem(Item item, boolean autoScroll) {
        Rectangle itemRect;
        if (item != null) {
            item.update();
        }
        this._itemPane.selectItem(item);
        this._detailsPane.removeAll();
        this._detailsPane.setItem(item);
        if (item != null) {
            this._detailsTitlePane.setTitle(item.getDetailsTitle());
            item.addComponents();
        } else {
            this._detailsTitlePane.setTitle("Debug Details");
        }
        if (autoScroll && (itemRect = this._itemPane.getItemRect(item)) != null) {
            this._itemPane.scrollRectToVisible(itemRect);
        }
    }

    public Item getSelectedItem() {
        return this._itemPane.getSelectedItem();
    }

    public Item getItemFromObjectId(String id) {
        return this._itemPane.getItemFromObjectId(id);
    }

    protected void setBackgroundSelection(boolean backgroundSelection) {
        this._itemPane.setBackgroundSelection(backgroundSelection);
    }

    protected void onItemSelected(Item item, boolean doubleClick) {
    }

    protected void onContextMenu(Category category, Point point) {
    }

    protected void onContextMenu(Item item, Point point) {
    }

    protected void onItemDropped(ComponentDragContainer dragContainer, Category category) {
    }

    protected void onItemDrag(Component dragComponent) {
    }

    protected boolean allowDrag(Component dragComponent) {
        return false;
    }

    protected void onItemDragAbort(Component dragComponent) {
    }

    @Override
    public void componentDragEnter(ComponentDragContainer dragContainer, Component component, Point p) {
        this._itemPane.componentDragEnter(dragContainer, component, p);
    }

    @Override
    public void componentDragLeave(ComponentDragContainer dragContainer, Component component, Point p) {
        this._itemPane.componentDragLeave(dragContainer, component, p);
    }

    @Override
    public void componentDragAbort(ComponentDragContainer dragContainer, Component component) {
        this._suppressDragForAbort = true;
        this._itemPane.componentDragAbort(dragContainer, component);
    }

    @Override
    public void componentDragged(Point p) {
        this._itemPane.componentDragged(p);
    }

    @Override
    public boolean componentDropped(Point p) {
        return this._itemPane.componentDropped(p);
    }

    @Override
    public void componentDropComplete(ComponentDragContainer dragContainer, Component component) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        Category category;
        if (e.getButton() == 1 && (category = this._itemPane.getCategoryAtLocation(e.getPoint())) != null) {
            category.onClick(new Point(e.getX(), e.getY() - category._lastOffset));
        }
        if (e.getButton() == 3 && e.getClickCount() == 1) {
            ItemInfo itemInfo = this._itemPane.getItemAtLocation(e.getPoint());
            Point localPoint = SwingUtilities.convertPoint(this._itemPane, e.getPoint(), this);
            if (itemInfo != null && itemInfo.item != null) {
                this.onContextMenu(itemInfo.item, localPoint);
            }
            return;
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this._suppressDragForAbort = false;
        this._prohibitDrag = false;
        this._itemPane.requestFocus();
        ItemInfo itemInfo = this._itemPane.getItemAtLocation(e.getPoint());
        if (this._itemPane._selectedItem != null) {
            this.setBackgroundSelection(false);
            this._itemPane._selectedItem.setSelected(false, false);
        }
        if (itemInfo != null) {
            this.setBackgroundSelection(false);
            itemInfo.item.setSelected(true, false);
            this.onItemSelected(itemInfo.item, e.getClickCount() == 2);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this._dragContainer != null && this._dragContainer.isDragging()) {
            this._dragContainer.dragMouseDrop(SwingUtilities.convertPoint(e.getComponent(), e.getPoint(), this));
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this._suppressDragForAbort) {
            return;
        }
        if (this._dragContainer == null) {
            this._dragContainer = ComponentDragContainer.findDragContainer(this);
        }
        Point localPoint = SwingUtilities.convertPoint(e.getComponent(), e.getPoint(), this);
        if (!this._dragContainer.isDragging()) {
            if (this._prohibitDrag) {
                return;
            }
            Item selectedItem = this._itemPane._selectedItem;
            if (selectedItem == null) {
                return;
            }
            Component dragComponent = selectedItem.getDragComponent(this.getWidth());
            if (dragComponent == null) {
                return;
            }
            if (!this.allowDrag(dragComponent)) {
                this._prohibitDrag = true;
                return;
            }
            Rectangle bounds = this._itemPane.getItemRect(selectedItem);
            if (bounds == null) {
                return;
            }
            dragComponent.setBounds(bounds);
            this._dragContainer.startDrag(this, dragComponent, localPoint);
            this.onItemDrag(dragComponent);
        } else {
            this._dragContainer.dragMouseMove(localPoint);
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    private static class ItemPane
    extends JComponent
    implements ComponentDragListener {
        private static final long serialVersionUID = 0L;
        private ItemDetailsList _list;
        private List<Category> _sortedCategories;
        private Item _selectedItem;
        private ComponentDragContainer _dragContainer;
        private Category _dropTargetCategory;
        private boolean _backgroundSelection;
        private static final int ITEM_INDENT = 0;

        public ItemPane(ItemDetailsList list) {
            this._list = list;
            this._backgroundSelection = false;
            this._sortedCategories = new ArrayList<Category>();
            this.setBackground(Color.white);
            this.addKeyListener(new KeyListener(){

                @Override
                public void keyPressed(KeyEvent e) {
                    switch (e.getKeyCode()) {
                        case 38: {
                            Item lastItem = null;
                            block4: for (Category category : ItemPane.this._sortedCategories) {
                                for (Item item : category) {
                                    if (ItemPane.this._selectedItem == item) {
                                        if (lastItem == null) continue block4;
                                        ItemPane.this._list.selectItem(lastItem);
                                        ItemPane.this._list.onItemSelected(lastItem, false);
                                        continue block4;
                                    }
                                    lastItem = item;
                                }
                            }
                            break;
                        }
                        case 40: {
                            Item lastItem = null;
                            block6: for (Category category : ItemPane.this._sortedCategories) {
                                int j = category.size() - 1;
                                while (j >= 0) {
                                    Item item = category.get(j);
                                    if (ItemPane.this._selectedItem == item) {
                                        if (lastItem == null) continue block6;
                                        ItemPane.this._list.selectItem(lastItem);
                                        ItemPane.this._list.onItemSelected(lastItem, false);
                                        continue block6;
                                    }
                                    lastItem = item;
                                    --j;
                                }
                            }
                            break;
                        }
                    }
                }

                @Override
                public void keyTyped(KeyEvent e) {
                }

                @Override
                public void keyReleased(KeyEvent e) {
                }
            });
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            Graphics2D g2 = SwingHelper.prepareGraphics(g);
            int width = this.getWidth();
            int offset = 0;
            for (Category category : this._sortedCategories) {
                category._lastOffset = offset;
                Graphics categorySubGraphics = g2.create(0, offset, width, category.getHeight());
                category.draw(categorySubGraphics, width);
                categorySubGraphics.dispose();
                if (this._dropTargetCategory == category) {
                    g2.setColor(new Color(50, 50, 250, 50));
                    g2.fillRect(0, offset, width - 1, category.getHeight() - 1);
                    g2.setColor(new Color(0, 0, 200));
                    g2.drawRect(0, offset, width - 1, category.getHeight() - 1);
                }
                offset += category.getHeight();
                if (category.isCollapsed()) continue;
                for (Item item : category) {
                    Graphics subGraphics = g2.create(0, offset, width - 0, item.getHeight());
                    if (item == this._selectedItem) {
                        item.drawSelected(subGraphics, width, this._backgroundSelection);
                    } else {
                        item.draw(subGraphics, width);
                    }
                    subGraphics.dispose();
                    offset += item.getHeight();
                }
            }
        }

        private void setBackgroundSelection(boolean backgroundSelection) {
            if (this._backgroundSelection != backgroundSelection) {
                this._backgroundSelection = backgroundSelection;
                this.repaint();
            }
        }

        public int getItemCount() {
            int count = 0;
            for (Category category : this._sortedCategories) {
                count += category.size();
            }
            return count;
        }

        public Item getItemFromObjectId(String id) {
            if (id == null) {
                return null;
            }
            for (Category category : this._sortedCategories) {
                for (Item item : category) {
                    if (!item.getObjectId().equals(id)) continue;
                    return item;
                }
            }
            return null;
        }

        public Item getItemAtIndex(int index) {
            int offset = 0;
            for (Category category : this._sortedCategories) {
                for (Item item : category) {
                    if (index == offset) {
                        return item;
                    }
                    ++offset;
                }
            }
            return null;
        }

        public Rectangle getItemRect(Item item) {
            if (item == null) {
                return null;
            }
            int width = this.getWidth();
            int offset = 0;
            for (Category category : this._sortedCategories) {
                offset += category.getHeight();
                if (category.isCollapsed()) continue;
                for (Item localItem : category) {
                    if (item == localItem) {
                        Rectangle rect = new Rectangle(0, offset, width - 0, localItem.getHeight());
                        return rect;
                    }
                    offset += localItem.getHeight();
                }
            }
            return null;
        }

        public ItemInfo getItemAtLocation(Point p) {
            int width = this.getWidth();
            int offset = 0;
            for (Category category : this._sortedCategories) {
                offset += category.getHeight();
                if (category.isCollapsed()) continue;
                for (Item item : category) {
                    Rectangle rect = new Rectangle(0, offset, width - 0, item.getHeight());
                    if (rect.contains(p.x, p.y)) {
                        return new ItemInfo(item, offset);
                    }
                    offset += item.getHeight();
                }
            }
            return null;
        }

        public Category getCategoryAtLocation(Point p) {
            int width = this.getWidth();
            int offset = 0;
            for (Category category : this._sortedCategories) {
                Rectangle rect = new Rectangle(0, offset, width - 0, category.getHeight());
                if (rect.contains(p.x, p.y)) {
                    return category;
                }
                offset += category.getHeight();
                if (category.isCollapsed()) continue;
                for (Item item : category) {
                    offset += item.getHeight();
                }
            }
            return null;
        }

        public void addCategory(String categoryName) {
            Category category = this.findCategory(categoryName);
            if (category == null) {
                Category newCategory = new Category(categoryName, this._list);
                this._sortedCategories.add(newCategory);
            }
        }

        public void addCategory(Category category) {
            this._sortedCategories.add(category);
        }

        private Category findCategory(String categoryName) {
            for (Category category : this._sortedCategories) {
                if (!categoryName.equals(category.getName())) continue;
                return category;
            }
            return null;
        }

        private Category getCategory(String categoryName) {
            Category category = this.findCategory(categoryName);
            if (category != null) {
                return category;
            }
            Category newCategory = new Category(categoryName, this._list);
            this._sortedCategories.add(newCategory);
            return newCategory;
        }

        private void calculateSize() {
            int offset = 0;
            for (Category category : this._sortedCategories) {
                offset += category.getHeight();
                if (category.isCollapsed()) continue;
                for (Item item : category) {
                    offset += item.getHeight();
                }
            }
            this.setPreferredSize(new Dimension(100, offset));
        }

        public void addItem(String categoryName, Item item) {
            Category category = this.getCategory(categoryName);
            category.add(item);
            this.calculateSize();
            this.revalidate();
            this.repaint();
        }

        public void removeItem(String categoryName, Item item) {
            Category category = this.getCategory(categoryName);
            category.remove(item);
            this.calculateSize();
            this.revalidate();
            this.repaint();
        }

        public void clearItems() {
            for (Category category : this._sortedCategories) {
                for (Item item : category._items) {
                    item.dispose();
                }
                category._items.clear();
            }
            this.calculateSize();
        }

        public void selectItem(Item item) {
            if (this._selectedItem == item) {
                return;
            }
            this._selectedItem = item;
            this.repaint();
        }

        public Item getSelectedItem() {
            return this._selectedItem;
        }

        @Override
        public void componentDragEnter(ComponentDragContainer dragContainer, Component component, Point p) {
            this._dragContainer = dragContainer;
        }

        @Override
        public void componentDragLeave(ComponentDragContainer dragContainer, Component component, Point p) {
            this._dropTargetCategory = null;
            this.repaint();
        }

        @Override
        public void componentDragAbort(ComponentDragContainer dragContainer, Component component) {
            this._list.onItemDragAbort(dragContainer);
        }

        @Override
        public void componentDragged(Point p) {
            ItemInfo itemInfo;
            Category category = this.getCategoryAtLocation(p);
            if (category == null && (itemInfo = this.getItemAtLocation(p)) != null) {
                String categoryName = itemInfo.item.getCategory();
                category = this.getCategory(categoryName);
            }
            if (category != null && !category.isValidDropTarget()) {
                category = null;
            }
            if (this._dropTargetCategory != category) {
                this._dropTargetCategory = category;
                this.repaint();
            }
        }

        @Override
        public boolean componentDropped(Point p) {
            if (this._dropTargetCategory != null) {
                this._list.onItemDropped(this._dragContainer, this._dropTargetCategory);
                this._dropTargetCategory = null;
                this.repaint();
            }
            return true;
        }

        @Override
        public void componentDropComplete(ComponentDragContainer dragContainer, Component component) {
        }
    }

    private static class DetailsPane
    extends JComponent
    implements Scrollable {
        private static final long serialVersionUID = 0L;
        private Item _item;

        public DetailsPane() {
            this.setLayout(null);
        }

        public void setItem(Item item) {
            this._item = item;
            if (item != null) {
                item.update();
                this.setPreferredSize(new Dimension(this.getWidth(), item.getDetailsHeight()));
            }
            this.revalidate();
            this.repaint();
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            Graphics2D g2 = SwingHelper.prepareGraphics(g);
            if (this._item != null) {
                this._item.drawDetails(g2, this.getWidth());
            }
        }

        @Override
        public Dimension getPreferredScrollableViewportSize() {
            return this.getPreferredSize();
        }

        @Override
        public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
            return 80;
        }

        @Override
        public boolean getScrollableTracksViewportHeight() {
            return false;
        }

        @Override
        public boolean getScrollableTracksViewportWidth() {
            return true;
        }

        @Override
        public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
            return 20;
        }
    }

    public static class Category
    implements Iterable<Item> {
        private String _name;
        private List<Item> _items;
        private boolean _collapsed;
        private boolean _validDropTarget;
        private ItemDetailsList _owner;
        private int _lastOffset;

        public Category(String name, ItemDetailsList owner) {
            this._name = name;
            this._owner = owner;
            this._items = new ArrayList<Item>();
            this._validDropTarget = true;
            this._collapsed = false;
        }

        public void add(Item item) {
            int index = Collections.binarySearch(this._items, item);
            this._items.add(index < 0 ? ~index : index, item);
        }

        public void remove(Item item) {
            this._items.remove(item);
        }

        public Item get(int index) {
            return this._items.get(index);
        }

        public int size() {
            return this._items.size();
        }

        protected void onClick(Point p) {
        }

        public boolean isValidDropTarget() {
            return this._validDropTarget;
        }

        public void setValidDropTarget(boolean valid) {
            this._validDropTarget = valid;
        }

        public String getName() {
            return this._name;
        }

        public int getHeight() {
            return 18;
        }

        public boolean isCollapsed() {
            return this._collapsed;
        }

        public void setCollapsed(boolean collapsed) {
            if (this._collapsed != collapsed) {
                this._collapsed = collapsed;
                this._owner._itemPane.calculateSize();
                this._owner._itemPane.revalidate();
                this._owner._itemPane.repaint();
            }
        }

        protected void draw(Graphics g, int width) {
            g.setColor(Color.black);
            g.drawString(this._name, 0, 15);
        }

        @Override
        public Iterator<Item> iterator() {
            return this._items.iterator();
        }
    }

    public static class Item
    implements Comparable<Item> {
        private ItemDetailsList _itemDetailsList;
        private String _name;
        private ItemChangeListener _itemChangeListener;

        public Item(String name) {
            this._name = name;
        }

        public void dispose() {
        }

        public void update() {
        }

        public String getName() {
            return this._name;
        }

        public String getDetailsTitle() {
            return "Debug Details for " + this._name;
        }

        public String getCategory() {
            return "Default";
        }

        public Object getObject() {
            return null;
        }

        public String getObjectId() {
            return "";
        }

        public int getHeight() {
            return 18;
        }

        public ItemDetailsList getOwner() {
            return this._itemDetailsList;
        }

        protected void setSelected(boolean selected, boolean autoScroll) {
            if (this._itemDetailsList != null) {
                this._itemDetailsList.selectItem(this, autoScroll);
            }
        }

        private void setItemChangeListener(ItemChangeListener listener) {
            this._itemChangeListener = listener;
        }

        protected void notifyChange() {
            if (this._itemChangeListener != null) {
                this._itemChangeListener.itemChanged(this);
            }
        }

        protected void notifyCategoryChange(String oldCategory) {
            if (this._itemChangeListener != null) {
                this._itemChangeListener.categoryChanged(this, oldCategory);
            }
        }

        public int getDetailsHeight() {
            return 20;
        }

        public String toString() {
            return this._name;
        }

        protected Component getDragComponent(int width) {
            return null;
        }

        @Override
        public int compareTo(Item object) {
            return this._name.compareTo(object.toString());
        }

        protected void draw(Graphics g, int width) {
            g.setColor(Color.black);
            g.drawString(this._name, 0, 15);
        }

        protected void drawSelected(Graphics g, int width, boolean background) {
            g.setColor(Color.blue);
            g.drawString(this._name, 0, 15);
        }

        protected void drawDetails(Graphics g, int width) {
            g.setColor(Color.black);
            g.drawString(this._name, 0, 15);
        }

        protected void addComponent(Component component) {
            this._itemDetailsList._detailsPane.add(component);
        }

        protected void addComponents() {
        }
    }

    public static interface ItemChangeListener {
        public void itemChanged(Item var1);

        public void categoryChanged(Item var1, String var2);
    }

    private static class ItemInfo {
        public Item item;
        public int position;

        public ItemInfo(Item item, int position) {
            this.item = item;
            this.position = position;
        }
    }
}

