/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.radar.rhai.spacetime;

import SpaceTime.DataModel.NodeChangeSummary;
import edu.cmu.cs.radar.rhai.spacetime.Allocation;
import edu.cmu.cs.radar.rhai.spacetime.SpaceTimeDate;
import edu.cmu.cs.radar.rhai.spacetime.SpaceTimeDuration;
import edu.cmu.cs.radar.stp.cachingdatamodel.LinearFunctionData;
import edu.cmu.cs.radar.stp.cachingdatamodel.NodeChangeListener;
import edu.cmu.cs.radar.stp.cachingdatamodel.SpaceTimeEdge;
import edu.cmu.cs.radar.stp.cachingdatamodel.SpaceTimeNode;
import edu.cmu.cs.radar.stp.cachingdatamodel.SpaceTimeProperty;
import edu.cmu.cs.radar.stp.cachingdatamodel.UncertaintyDistributionData;

public class SpaceTimeRequestNode
implements NodeChangeListener {
    private static final String XMLATTRVAL_ASSIGNTO = "assignTo";
    private static final String XMLATTRVAL_FIXTO = "fixTo";
    private static final String ATTR_ASSIGNEDSTART = "assignedStart";
    private static final String ATTR_ASSIGNEDDURATION = "assignedDuration";
    private static final String ATTR_FIXEDSTART = "fixedStart";
    private static final String ATTR_FIXEDDURATION = "fixedDuration";
    private static final String ATTR_REQUESTOF = "requestOf";
    private static final String ATTR_PERSONWEIGHT = "personWeight";
    private static final String ATTR_REQUESTWEIGHT = "requestWeight";
    private SpaceTimeNode _node;
    private SpaceTimeProperty _startProperty;
    private SpaceTimeProperty _durationProperty;
    private boolean _isAssigned;
    private boolean _isLocked;
    private Allocation _allocation;

    public SpaceTimeRequestNode(SpaceTimeNode node) {
        this._node = node;
        this._node.addChangeListener(this);
        this.refreshAssignment();
    }

    public void nodeChanged(String nodeId, NodeChangeSummary changes) {
        this.refreshAssignment();
    }

    public void nodeSelected(boolean selected) {
    }

    private synchronized void refreshAssignment() {
        SpaceTimeEdge edge = this._node.getEdge(XMLATTRVAL_ASSIGNTO);
        if (edge == null) {
            edge = this._node.getEdge(XMLATTRVAL_FIXTO);
        }
        this._startProperty = null;
        this._durationProperty = null;
        if (edge != null) {
            SpaceTimeProperty property = edge.getProperty(ATTR_ASSIGNEDSTART);
            if (property != null) {
                this._startProperty = property;
            }
            if ((property = edge.getProperty(ATTR_ASSIGNEDDURATION)) != null) {
                this._durationProperty = property;
            }
            if ((property = edge.getProperty(ATTR_FIXEDSTART)) != null) {
                this._startProperty = property;
            }
            if ((property = edge.getProperty(ATTR_FIXEDDURATION)) != null) {
                this._durationProperty = property;
            }
        }
        this._isAssigned = false;
        edge = this._node.getEdge(XMLATTRVAL_ASSIGNTO);
        if (edge != null && !edge.getTarget().equals("grass") && this._startProperty != null && this._durationProperty != null) {
            this._isAssigned = true;
        }
        this._isLocked = false;
        if (this.isLockedInternal()) {
            this._isAssigned = true;
            this._isLocked = true;
        }
    }

    public String getRequestName() {
        return this._node.getName();
    }

    public String getDescription() {
        SpaceTimeProperty descriptionProperty = this._node.getProperty("description");
        if (descriptionProperty == null) {
            return "";
        }
        String description = descriptionProperty.getStringValue();
        if (description == null) {
            return "";
        }
        return description;
    }

    public boolean isAssigned() {
        return this._isLocked || this._isAssigned;
    }

    public boolean isLocked() {
        return this._isLocked;
    }

    public synchronized boolean isRejected() {
        String room = this.getRoom();
        if (room == null) {
            return false;
        }
        return "grass".equals(room);
    }

    public synchronized void setLockedToStartTime(boolean lock) {
        if (!this._isAssigned && !this._isLocked) {
            return;
        }
        if (this._startProperty == null || this._durationProperty == null) {
            return;
        }
        if (lock) {
            this._startProperty.setPropertyType(ATTR_FIXEDSTART);
            this._isAssigned = true;
            this._isLocked = true;
            return;
        }
        this._startProperty.setPropertyType(ATTR_ASSIGNEDSTART);
        this._isAssigned = true;
        this._isLocked = true;
    }

    public synchronized boolean isLockedToRoom() {
        SpaceTimeEdge fixEdge = this._node.getEdge(XMLATTRVAL_FIXTO);
        return fixEdge != null;
    }

    public synchronized boolean isLockedToStartTime() {
        return this._startProperty != null && this._startProperty.getPropertyType().equals(ATTR_FIXEDSTART);
    }

    public synchronized boolean isLockedToDuration() {
        return this._durationProperty != null && this._durationProperty.getPropertyType().equals(ATTR_FIXEDDURATION);
    }

    private synchronized boolean isLockedInternal() {
        return this.isLockedToRoom() || this.isLockedToStartTime() || this.isLockedToDuration();
    }

    public synchronized String getRoom() {
        SpaceTimeEdge edge = this._node.getEdge(XMLATTRVAL_ASSIGNTO);
        if (edge == null) {
            edge = this._node.getEdge(XMLATTRVAL_FIXTO);
        }
        if (edge != null) {
            return edge.getTarget();
        }
        return null;
    }

    public synchronized SpaceTimeNode getRequestor() {
        SpaceTimeEdge edge = this._node.getEdge(ATTR_REQUESTOF);
        if (edge == null) {
            return null;
        }
        return this._node.getAdapter().getNodeById(edge.getTarget());
    }

    public synchronized String getRoomDisplayName() {
        String roomId = this.getRoom();
        if (roomId == null) {
            return roomId;
        }
        SpaceTimeNode node = this._node.getAdapter().getNodeById(roomId);
        if (node == null) {
            return roomId;
        }
        return node.getDisplayName();
    }

    public synchronized String getBuildingDisplayName() {
        String roomId = this.getRoom();
        if (roomId == null) {
            return "unknown";
        }
        SpaceTimeNode node = this._node.getAdapter().getNodeById(roomId);
        if (node == null) {
            return "unknown";
        }
        SpaceTimeProperty buildingProperty = node.getProperty("building");
        if (buildingProperty != null) {
            return buildingProperty.getStringValue();
        }
        return "unknown";
    }

    public synchronized void setRoom(String roomId) {
        SpaceTimeEdge edge = this._node.getEdge(XMLATTRVAL_FIXTO);
        if (edge == null) {
            edge = this._node.getEdge(XMLATTRVAL_ASSIGNTO);
        }
        if (edge == null) {
            edge = this._node.getAdapter().createEdge(roomId, XMLATTRVAL_ASSIGNTO);
            edge.setEdgeType(XMLATTRVAL_ASSIGNTO);
            this._node.addEdge(edge);
        }
        edge.setTarget(roomId);
    }

    public synchronized void setParametersPreservingLocks(String roomId, SpaceTimeDate start, SpaceTimeDuration duration) {
        SpaceTimeEdge edge = this._node.getEdge(XMLATTRVAL_ASSIGNTO);
        boolean isEdgeNew = false;
        if (edge == null) {
            edge = this._node.getEdge(XMLATTRVAL_FIXTO);
        }
        if (edge == null) {
            edge = this._node.getAdapter().createEdge(roomId, XMLATTRVAL_ASSIGNTO);
            isEdgeNew = true;
        } else {
            edge.setTarget(roomId);
        }
        if (this._startProperty == null) {
            this._startProperty = this._node.getAdapter().createProperty(ATTR_ASSIGNEDSTART);
            edge.addProperty(this._startProperty);
        }
        this._startProperty.setIntValue((int)start.getOptDate());
        if (this._durationProperty == null) {
            this._durationProperty = this._node.getAdapter().createProperty(ATTR_ASSIGNEDDURATION);
            edge.addProperty(this._durationProperty);
        }
        this._durationProperty.setIntValue((int)duration.getOptDuration());
        if (isEdgeNew) {
            this._node.addEdge(edge);
        }
    }

    public synchronized void assign(String roomId, SpaceTimeDate start, SpaceTimeDuration duration) {
        if (roomId == null) {
            throw new NullPointerException("roomId is null");
        }
        if (start == null) {
            throw new NullPointerException("start is null");
        }
        if (duration == null) {
            throw new NullPointerException("duration");
        }
        this._isAssigned = true;
        this._isLocked = false;
        SpaceTimeEdge edge = this._node.getEdge(XMLATTRVAL_ASSIGNTO);
        if (edge == null) {
            edge = this._node.getEdge(XMLATTRVAL_FIXTO);
        }
        if (edge == null) {
            edge = this._node.getAdapter().createEdge(roomId, XMLATTRVAL_ASSIGNTO);
            this._node.addEdge(edge);
        }
        edge.setTarget(roomId);
        edge.setEdgeType(XMLATTRVAL_ASSIGNTO);
        if (this._startProperty == null) {
            this._startProperty = this._node.getAdapter().createProperty(ATTR_ASSIGNEDSTART);
            edge.addProperty(this._startProperty);
        }
        this._startProperty.setIntValue((int)start.getOptDate());
        this._startProperty.setPropertyType(ATTR_ASSIGNEDSTART);
        if (this._durationProperty == null) {
            this._durationProperty = this._node.getAdapter().createProperty(ATTR_ASSIGNEDDURATION);
            edge.addProperty(this._durationProperty);
        }
        this._durationProperty.setIntValue((int)duration.getOptDuration());
        this._durationProperty.setPropertyType(ATTR_ASSIGNEDDURATION);
    }

    public synchronized void lock(String roomId, SpaceTimeDate start, SpaceTimeDuration duration) {
        this._isAssigned = true;
        this._isLocked = true;
        SpaceTimeEdge edge = this._node.getEdge(XMLATTRVAL_FIXTO);
        if (edge == null) {
            edge = this._node.getEdge(XMLATTRVAL_ASSIGNTO);
        }
        if (edge == null) {
            edge = this._node.getAdapter().createEdge(roomId, XMLATTRVAL_FIXTO);
            this._node.addEdge(edge);
        }
        edge.setTarget(roomId);
        edge.setEdgeType(XMLATTRVAL_FIXTO);
        try {
            if (this._startProperty == null) {
                this._startProperty = this._node.getAdapter().createProperty(ATTR_FIXEDSTART);
                edge.addProperty(this._startProperty);
            }
            this._startProperty.setIntValue((int)start.getOptDate());
            this._startProperty.setPropertyType(ATTR_FIXEDSTART);
            if (this._durationProperty == null) {
                this._durationProperty = this._node.getAdapter().createProperty(ATTR_FIXEDDURATION);
                edge.addProperty(this._durationProperty);
            }
            this._durationProperty.setIntValue((int)duration.getOptDuration());
            this._durationProperty.setPropertyType(ATTR_FIXEDDURATION);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public synchronized SpaceTimeDate getStart() {
        if (this._startProperty == null) {
            this.refreshAssignment();
        }
        if (this._startProperty != null) {
            return new SpaceTimeDate(this._startProperty.getIntValue());
        }
        return null;
    }

    public synchronized void setStart(SpaceTimeDate time) {
        if (this._startProperty == null) {
            SpaceTimeEdge edge = this._node.getEdge(XMLATTRVAL_FIXTO);
            if (edge == null) {
                edge = this._node.getEdge(XMLATTRVAL_ASSIGNTO);
            }
            if (edge == null) {
                return;
            }
            this._startProperty = this._node.getAdapter().createProperty(ATTR_ASSIGNEDSTART);
            this._startProperty.setPropertyType(ATTR_ASSIGNEDSTART);
            edge.addProperty(this._startProperty);
        }
        this._startProperty.setIntValue((int)time.getOptDate());
    }

    public synchronized SpaceTimeDuration getDuration() {
        if (this._durationProperty != null) {
            return new SpaceTimeDuration(this._durationProperty.getIntValue());
        }
        return null;
    }

    public synchronized void setDuration(SpaceTimeDuration duration) {
        if (this._durationProperty == null) {
            SpaceTimeEdge edge = this._node.getEdge(XMLATTRVAL_FIXTO);
            if (edge == null) {
                edge = this._node.getEdge(XMLATTRVAL_ASSIGNTO);
            }
            if (edge == null) {
                return;
            }
            this._durationProperty = this._node.getAdapter().createProperty(ATTR_ASSIGNEDDURATION);
            this._durationProperty.setPropertyType(ATTR_ASSIGNEDDURATION);
            edge.addProperty(this._startProperty);
        }
        this._durationProperty.setIntValue((int)duration.getOptDuration());
    }

    public synchronized SpaceTimeDate getStop() {
        if (this._startProperty != null && this._durationProperty != null) {
            return new SpaceTimeDate(this._startProperty.getIntValue() + this._durationProperty.getIntValue());
        }
        return null;
    }

    public synchronized Allocation getAllocation() {
        if (this._allocation == null) {
            if (!this._isAssigned && !this._isLocked) {
                return null;
            }
            this._allocation = new Allocation(this);
        }
        return this._allocation;
    }

    public synchronized int getImportance() {
        int personWeight = this.getRequestorWeight();
        SpaceTimeProperty weightProperty = this._node.getProperty(ATTR_REQUESTWEIGHT);
        if (weightProperty == null) {
            return 0;
        }
        UncertaintyDistributionData uncertaintyData = weightProperty.getUncertaintyData();
        if (uncertaintyData != null) {
            return (int)((float)personWeight * uncertaintyData.getAverage());
        }
        return personWeight * weightProperty.getIntValue();
    }

    public synchronized String getImportanceString() {
        SpaceTimeNode requestorNode;
        SpaceTimeProperty weightProperty = this._node.getProperty(ATTR_REQUESTWEIGHT);
        if (weightProperty == null) {
            return "0";
        }
        UncertaintyDistributionData weightUncertainty = weightProperty.getUncertaintyData();
        UncertaintyDistributionData personUncertainty = null;
        int personWeight = 1;
        SpaceTimeEdge requestorEdge = this._node.getEdge(ATTR_REQUESTOF);
        if (requestorEdge != null && (requestorNode = this._node.getAdapter().getNodeById(requestorEdge.getTarget())) != null) {
            SpaceTimeProperty personWeightProperty = requestorNode.getProperty(ATTR_PERSONWEIGHT);
            personUncertainty = personWeightProperty.getUncertaintyData();
            personWeight = personWeightProperty.getIntValue();
        }
        if (personUncertainty != null && weightUncertainty != null) {
            return String.valueOf(personUncertainty.getMin() * weightUncertainty.getMin()) + " - " + personUncertainty.getMax() * weightUncertainty.getMax();
        }
        if (personUncertainty != null && weightUncertainty == null) {
            return String.valueOf(personUncertainty.getMin() * (float)weightProperty.getIntValue()) + " - " + personUncertainty.getMax() * (float)weightProperty.getIntValue();
        }
        if (personUncertainty == null && weightUncertainty != null) {
            return String.valueOf((float)personWeight * weightUncertainty.getMin()) + " - " + (float)personWeight * weightUncertainty.getMax();
        }
        return Integer.toString(personWeight * weightProperty.getIntValue());
    }

    public synchronized int getRequestorWeight() {
        SpaceTimeEdge requestorEdge = this._node.getEdge(ATTR_REQUESTOF);
        if (requestorEdge == null) {
            return 1;
        }
        SpaceTimeNode requestorNode = this._node.getAdapter().getNodeById(requestorEdge.getTarget());
        if (requestorNode == null) {
            return 1;
        }
        SpaceTimeProperty personWeightProperty = requestorNode.getProperty(ATTR_PERSONWEIGHT);
        if (personWeightProperty == null) {
            return 1;
        }
        UncertaintyDistributionData personUncertainty = personWeightProperty.getUncertaintyData();
        int personWeight = personWeightProperty.getIntValue();
        if (personUncertainty != null) {
            personWeight = (int)personUncertainty.getAverage();
        }
        return personWeight;
    }

    public synchronized String getRequestorWeightString() {
        SpaceTimeEdge requestorEdge = this._node.getEdge(ATTR_REQUESTOF);
        if (requestorEdge == null) {
            return "0";
        }
        SpaceTimeNode requestorNode = this._node.getAdapter().getNodeById(requestorEdge.getTarget());
        if (requestorNode == null) {
            return "0";
        }
        SpaceTimeProperty personWeightProperty = requestorNode.getProperty(ATTR_PERSONWEIGHT);
        if (personWeightProperty == null) {
            return "0";
        }
        UncertaintyDistributionData personUncertainty = personWeightProperty.getUncertaintyData();
        int personWeight = personWeightProperty.getIntValue();
        if (personUncertainty != null) {
            return String.valueOf(personUncertainty.getMin()) + " - " + personUncertainty.getMax();
        }
        return Integer.toString(personWeight);
    }

    public synchronized boolean isAssociated(String preference) {
        return this._node.getAdapter().isPropertyAssociated(preference);
    }

    public synchronized float getWeight(String preference) {
        String weightName = this._node.getAdapter().getAssociatedWeightName(preference);
        if (weightName == null) {
            return 0.0f;
        }
        SpaceTimeProperty requestWeightProperty = this._node.getProperty(weightName);
        if (requestWeightProperty == null) {
            return 0.0f;
        }
        UncertaintyDistributionData uncertaintyData = requestWeightProperty.getUncertaintyData();
        if (uncertaintyData != null) {
            return uncertaintyData.getAverage();
        }
        return requestWeightProperty.getIntValue();
    }

    public synchronized String getWeightString(String preference) {
        String weightName = this._node.getAdapter().getAssociatedWeightName(preference);
        if (weightName == null) {
            return "0";
        }
        SpaceTimeProperty requestWeightProperty = this._node.getProperty(weightName);
        if (requestWeightProperty == null) {
            return "0";
        }
        UncertaintyDistributionData uncertaintyData = requestWeightProperty.getUncertaintyData();
        if (uncertaintyData != null) {
            return uncertaintyData.getMin() + " - " + uncertaintyData.getMax();
        }
        return "" + requestWeightProperty.getIntValue();
    }

    public synchronized void removeAllocation() {
        this._node.removeEdge(XMLATTRVAL_FIXTO);
        this._node.removeEdge(XMLATTRVAL_ASSIGNTO);
        SpaceTimeEdge edge = this._node.getAdapter().createEdge("grass", XMLATTRVAL_ASSIGNTO);
        this._node.addEdge(edge);
        this._startProperty = null;
        this._durationProperty = null;
        this._isAssigned = false;
        this._isLocked = false;
    }

    public synchronized SpaceTimeDuration calculateOptimalDuration() {
        long l = 3600L;
        SpaceTimeProperty durationPreference = this._node.getProperty("durationPref");
        if (durationPreference == null) {
            return new SpaceTimeDuration(3600L);
        }
        LinearFunctionData data = durationPreference.getFunctionData();
        if (data == null) {
            return new SpaceTimeDuration(3600L);
        }
        int durationStep = 900;
        double maxPref = 0.0;
        double maxDuration = 0.0;
        int i = 0;
        while (i < data.size()) {
            double x = data.getX(i);
            if (!(x <= 0.0) && x % (double)durationStep == 0.0 && data.getY(i) > maxPref) {
                maxPref = data.getY(i);
                maxDuration = data.getX(i);
            }
            ++i;
        }
        if (maxDuration == 0.0) {
            maxDuration = 3600.0;
        }
        return new SpaceTimeDuration((int)maxDuration);
    }

    public synchronized SpaceTimeDate calculateOptimalStartTime() {
        SpaceTimeProperty startPreference = this._node.getProperty("startPref");
        if (startPreference == null) {
            return null;
        }
        LinearFunctionData data = startPreference.getFunctionData();
        if (data == null) {
            return null;
        }
        double maxPref = 0.0;
        double maxStart = 0.0;
        int i = 0;
        while (i < data.size()) {
            if (data.getY(i) > maxPref) {
                maxPref = data.getY(i);
                maxStart = data.getX(i);
            }
            ++i;
        }
        if (maxStart == 0.0) {
            return null;
        }
        return new SpaceTimeDate((int)maxStart);
    }

    public synchronized SpaceTimeNode getNode() {
        return this._node;
    }

    public void dispose() {
        this._node.removeChangeListener(this);
    }

    public String toString() {
        return this._node.toString();
    }
}

