/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.radar.rhai.spacetime;

import edu.cmu.cs.radar.stp.cachingdatamodel.SpaceTimeNode;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.text.DecimalFormat;
import javax.swing.JComponent;

public class ScoreChart
extends JComponent {
    private static final long serialVersionUID = 0L;
    private SpaceTimeNode _node;
    private float _value;
    private static final int EDGE_BUFFER = 4;
    private static final int LABEL_HEIGHT = 10;
    private static final int BAR_HEIGHT = 6;

    public ScoreChart(SpaceTimeNode node) {
        this._node = node;
        this.setSize(200, 26);
    }

    public ScoreChart() {
        this.setSize(200, 26);
        this._value = -100.0f;
    }

    public void setValue(float value) {
        this._value = value;
        this.repaint();
    }

    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        double currentScore = this._value;
        if (this._node != null) {
            currentScore = this._node.getScore();
        }
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        Font originalFont = g2.getFont();
        g2.setFont(new Font(originalFont.getFontName(), 0, 10));
        int width = this.getWidth();
        g2.setColor(Color.gray);
        g2.drawRect(0, 10, width - 1, 6);
        FontMetrics fontMetrics = g2.getFontMetrics();
        if (currentScore <= -100.0) {
            g2.setColor(Color.lightGray);
            g2.fillRect(1, 11, width - 2, 5);
            g2.setColor(Color.darkGray);
            String scoreLabel = "Score not available";
            if (currentScore == -101.0) {
                scoreLabel = "Waiting for score...";
            }
            g2.drawString(scoreLabel, width / 2 - fontMetrics.stringWidth(scoreLabel) / 2, 7);
            return;
        }
        if (currentScore == -6.0) {
            g2.setColor(Color.lightGray);
            g2.fillRect(1, 11, width - 2, 5);
            g2.setColor(Color.red);
            String scoreLabel = "Unacceptable";
            g2.drawString(scoreLabel, width / 2 - fontMetrics.stringWidth(scoreLabel) / 2, 7);
            return;
        }
        g2.setPaint(new GradientPaint(0.0f, 0.0f, new Color(255, 80, 80), width, 0.0f, new Color(80, 255, 80)));
        g2.fillRect(1, 11, width - 2, 5);
        g2.setColor(Color.gray);
        g2.drawString("Poor", 0, 26);
        g2.drawString("Good", width - fontMetrics.stringWidth("Good"), 26);
        double scorePercent = currentScore < 0.0 ? (currentScore + 5.0) / 10.0 : 0.5 + currentScore / 2.0;
        int barPos = (int)Math.min(Math.max(4.0, (double)(width - 8 - 2) * scorePercent), (double)(width - 8 - 2));
        int[] xPoints = new int[]{4 + barPos, 4 + barPos - 3, 4 + barPos + 3};
        int[] yPoints = new int[]{13, 8, 8};
        g2.setColor(Color.white);
        g2.fillPolygon(xPoints, yPoints, 3);
        g2.setColor(Color.black);
        g2.drawPolygon(xPoints, yPoints, 3);
        DecimalFormat decimalFormat = new DecimalFormat("#.0#");
        String scoreLabel = decimalFormat.format(new Double(currentScore));
        int scoreLabelWidth = fontMetrics.stringWidth(scoreLabel);
        int scoreLabelPos = Math.min(width - scoreLabelWidth, Math.max(0, 4 + barPos - scoreLabelWidth / 2));
        g2.setColor(Color.darkGray);
        g2.drawString(scoreLabel, scoreLabelPos, 7);
    }
}

