/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.radar.rhai.spacetime;

import edu.cmu.cs.radar.rhai.spacetime.ComponentDragListener;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager2;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JLayeredPane;
import javax.swing.SwingUtilities;

public class ComponentDragContainer
extends JLayeredPane {
    private static final long serialVersionUID = 0L;
    private boolean _isDragging;
    private Component _sourceComponent;
    private Component _dragComponent;
    private Component _currentTargetComponent;
    private ComponentDragListener _currentTargetComponentListener;
    private Point _dragOffset;
    private DragContainerLayoutManager _layoutManager;
    private Component _contentPane;
    private boolean _isCaptured;

    public ComponentDragContainer() {
        this.setBackground(Color.white);
        this._layoutManager = new DragContainerLayoutManager(this);
        this._isCaptured = false;
        this.setLayout(this._layoutManager);
        this.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (ComponentDragContainer.this._isDragging && e.getKeyCode() == 27) {
                    ComponentDragContainer.this.abortDrag();
                }
            }

            public void keyReleased(KeyEvent e) {
            }

            public void keyTyped(KeyEvent e) {
            }
        });
    }

    public void setContentPane(Component contentPane) {
        this._contentPane = contentPane;
        this.add(contentPane, new Integer(0));
    }

    public static ComponentDragContainer findDragContainer(Component component) {
        Container parent = component.getParent();
        while (parent != null) {
            if (parent instanceof ComponentDragContainer) {
                return (ComponentDragContainer)parent;
            }
            parent = parent.getParent();
        }
        return null;
    }

    private static boolean isChildOfComponent(Component parent, Component child) {
        Container childParent = child.getParent();
        while (childParent != null) {
            if (childParent == parent) {
                return true;
            }
            childParent = childParent.getParent();
        }
        return false;
    }

    public void startDrag(Component source, Component component, Point point) {
        this._isDragging = true;
        this._sourceComponent = source;
        this._dragComponent = component;
        Point componentLocation = component.getLocation();
        this._dragOffset = new Point(point.x - componentLocation.x, point.y - componentLocation.y);
        Point globalPoint = SwingUtilities.convertPoint(source, componentLocation, this);
        this._dragComponent.setSize(source.getSize());
        this._dragComponent.setLocation(globalPoint);
        this.add(this._dragComponent, new Integer(1));
        this.requestFocus();
        this._currentTargetComponent = source;
        this._currentTargetComponentListener = this._currentTargetComponent instanceof ComponentDragListener ? (ComponentDragListener)((Object)this._currentTargetComponent) : null;
    }

    public void abortDrag() {
        this._isDragging = false;
        this._isCaptured = false;
        if (this._dragComponent != null) {
            this.remove(this._dragComponent);
        }
        if (this._sourceComponent != null && this._sourceComponent instanceof ComponentDragListener) {
            ((ComponentDragListener)((Object)this._sourceComponent)).componentDragAbort(this, this._dragComponent);
        }
        if (this._currentTargetComponentListener != null) {
            this._currentTargetComponentListener.componentDragAbort(this, this._dragComponent);
        }
        this._dragComponent = null;
        this._currentTargetComponent = null;
        this._currentTargetComponentListener = null;
        this.repaint();
    }

    public boolean isDragging() {
        return this._isDragging;
    }

    public Component getDragComponent() {
        return this._dragComponent;
    }

    public Component getSourceComponent() {
        return this._sourceComponent;
    }

    public Component getTargetComponent() {
        return this._currentTargetComponent;
    }

    public boolean isCaptured() {
        return this._isCaptured;
    }

    public void captureDragControl() {
        if (!this._isCaptured) {
            this._isCaptured = true;
            this.remove(this._dragComponent);
        }
    }

    public void unCaptureDragControl() {
        if (this._isCaptured) {
            this._isCaptured = false;
            this.add(this._dragComponent);
        }
    }

    public void dragMouseMove(Point point) {
        Point globalPoint = SwingUtilities.convertPoint(this._sourceComponent, point, this);
        Point adjustedPoint = new Point(globalPoint.x - this._dragOffset.x, globalPoint.y - this._dragOffset.y);
        this._dragComponent.setLocation(adjustedPoint);
        Component component = SwingUtilities.getDeepestComponentAt(this._contentPane, globalPoint.x, globalPoint.y);
        if (component == null) {
            return;
        }
        if (this._isCaptured && component != this._currentTargetComponent && ComponentDragContainer.isChildOfComponent(this._currentTargetComponent, component)) {
            if (this._currentTargetComponentListener != null) {
                Point localPoint = SwingUtilities.convertPoint(this, globalPoint, this._currentTargetComponent);
                this._currentTargetComponentListener.componentDragged(localPoint);
            }
            return;
        }
        Point localPoint = SwingUtilities.convertPoint(this, globalPoint, component);
        if (component != this._currentTargetComponent) {
            if (this._currentTargetComponentListener != null) {
                this._currentTargetComponentListener.componentDragLeave(this, this._dragComponent, localPoint);
            }
            this._currentTargetComponent = component;
            this._currentTargetComponentListener = null;
            while (this._currentTargetComponent != null && !(this._currentTargetComponent instanceof ComponentDragListener)) {
                this._currentTargetComponent = this._currentTargetComponent.getParent();
            }
            if (this._currentTargetComponent instanceof ComponentDragListener) {
                this._currentTargetComponentListener = (ComponentDragListener)((Object)this._currentTargetComponent);
            }
            if (this._currentTargetComponentListener != null) {
                this._currentTargetComponentListener.componentDragEnter(this, this._dragComponent, localPoint);
            }
        } else if (this._currentTargetComponentListener != null) {
            this._currentTargetComponentListener.componentDragged(localPoint);
        }
    }

    public void dragMouseDrop(Point point) {
        Point globalPoint;
        Point localPoint;
        this._isDragging = false;
        this._isCaptured = false;
        this.remove(this._dragComponent);
        if (this._currentTargetComponent != null && this._currentTargetComponentListener != null && this._currentTargetComponentListener.componentDropped(localPoint = SwingUtilities.convertPoint(this, globalPoint = SwingUtilities.convertPoint(this._sourceComponent, point, this), this._currentTargetComponent)) && this._sourceComponent instanceof ComponentDragListener) {
            ((ComponentDragListener)((Object)this._sourceComponent)).componentDropComplete(this, this._dragComponent);
        }
        this._dragComponent = null;
        this._currentTargetComponent = null;
        this._currentTargetComponentListener = null;
        this.repaint();
    }

    private static class DragContainerLayoutManager
    implements LayoutManager2 {
        private ComponentDragContainer _dragContainer;

        public DragContainerLayoutManager(ComponentDragContainer container) {
            this._dragContainer = container;
        }

        public void addLayoutComponent(Component component, Object arg) {
        }

        public float getLayoutAlignmentX(Container container) {
            return 0.0f;
        }

        public float getLayoutAlignmentY(Container container) {
            return 0.0f;
        }

        public void invalidateLayout(Container container) {
        }

        public Dimension maximumLayoutSize(Container container) {
            return null;
        }

        public void addLayoutComponent(String label, Component component) {
        }

        public void layoutContainer(Container container) {
            if (this._dragContainer._contentPane != null) {
                this._dragContainer._contentPane.setLocation(0, 0);
                this._dragContainer._contentPane.setSize(container.getSize());
            }
        }

        public Dimension minimumLayoutSize(Container container) {
            return new Dimension(100, 100);
        }

        public Dimension preferredLayoutSize(Container container) {
            return new Dimension(100, 100);
        }

        public void removeLayoutComponent(Component container) {
        }
    }
}

