/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.radar.rhai.calendar;

import edu.cmu.cs.radar.rhai.calendar.Time;
import edu.cmu.cs.radar.rhai.calendar.TimeView;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;

public class TimeLabel
extends TimeView {
    private static final long serialVersionUID = 1L;
    protected String mLabel;

    public TimeLabel(Time.Range range) {
        this(range, null);
    }

    public TimeLabel(Time.Range range, String label) {
        super(range);
        this.mLabel = label;
    }

    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        FontMetrics fm = g2.getFontMetrics();
        int ascent = fm.getAscent();
        Time currentTime = this.getStart().roundDownToHour();
        Time lastHour = this.getEnd().roundUpToHour();
        while (currentTime.beforeOrEqual(lastHour)) {
            int y = this.getValueForTimeAsInteger(currentTime);
            if (currentTime.isHour()) {
                String strHour = currentTime.toStringHourMinute();
                Rectangle2D strHourBounds = fm.getStringBounds(strHour, g2);
                g2.setPaint(Color.BLACK);
                g2.drawString(currentTime.toStringHourMinute(), (float)this.getWidth() - 5.0f - (float)strHourBounds.getWidth(), (float)y + (float)ascent);
                g2.setPaint(HOUR_GRAY);
                g2.drawLine(this.getWidth() - 21, y, this.getWidth(), y);
            } else {
                g2.setPaint(QUARTER_HOUR_GRAY);
                g2.drawLine(this.getWidth() - 4, y, this.getWidth(), y);
            }
            if (currentTime.afterOrEqual(lastHour)) break;
            currentTime = currentTime.addMinutes(15);
        }
        if (this.mLabel != null) {
            g2 = (Graphics2D)g2.create();
            g2.setPaint(Color.BLACK);
            Rectangle2D strLabelBounds = fm.getStringBounds(this.mLabel, g2);
            AffineTransform trans = AffineTransform.getTranslateInstance(this.getWidth() - 40, ((double)this.getHeight() + strLabelBounds.getWidth()) / 2.0);
            trans.concatenate(AffineTransform.getRotateInstance(-1.5707963267948966));
            g2.transform(trans);
            g2.drawString(this.mLabel, 0, 0);
        }
    }

    public Dimension getMinimumSize() {
        int labelWidth = this.mLabel != null ? 20 : 0;
        Dimension dim = super.getMinimumSize();
        dim.width = 40 + labelWidth;
        return dim;
    }

    public Dimension getPreferredSize() {
        int labelWidth = this.mLabel != null ? 20 : 0;
        Dimension dim = super.getPreferredSize();
        dim.width = 40 + labelWidth;
        return dim;
    }
}

