/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.radar.stp.cachingdatamodel;

import Ch.Elca.Iiop.GenericUserException;
import SpaceTime.DataModel.CertainPlf;
import SpaceTime.DataModel.SpaceTimeNode;
import edu.cmu.cs.radar.rhai.spacetime.Services;
import edu.cmu.cs.radar.stp.cachingdatamodel.LinearFunctionData;
import edu.cmu.cs.radar.stp.cachingdatamodel.UncertaintyDistributionData;
import java.text.NumberFormat;
import java.util.Comparator;

public class SpaceTimeProperty {
    private static final int NOVALUE = -100;
    private SpaceTime.DataModel.SpaceTimeProperty _property;
    private String _propertyType;
    private String _label;
    private int _dataType;
    private int _storedDataType;
    private String _category;
    private String _stringValue;
    private int _intValue;
    private double _moneyValue;
    private Boolean _isHidden;
    private Boolean _isEditable;
    private boolean _nullFunctionData;
    private LinearFunctionData _functionData;
    private boolean _nullUncertaintyData;
    private UncertaintyDistributionData _uncertaintyData;
    private String _ownerAndLabel;
    public static Comparator sLabelAndDisplayStringComparator = new Comparator(){

        public int compare(Object o1, Object o2) {
            SpaceTimeProperty property1 = (SpaceTimeProperty)o1;
            SpaceTimeProperty property2 = (SpaceTimeProperty)o2;
            return property1.getDisplayLabelAndValueString().compareToIgnoreCase(property2.getDisplayLabelAndValueString());
        }
    };

    public SpaceTimeProperty(SpaceTime.DataModel.SpaceTimeProperty property) {
        this._property = property;
        this._intValue = -100;
        this._moneyValue = -100.0;
        this._dataType = -100;
        this._storedDataType = -100;
        this._nullFunctionData = false;
        this._nullUncertaintyData = false;
    }

    public SpaceTime.DataModel.SpaceTimeProperty getHostedProperty() {
        return this._property;
    }

    public String getPropertyType() {
        if (this._propertyType == null) {
            Services.logger.trace("API: SpaceTimeProperty.PropertyType(): " + this.getOwnerAndType());
            this._propertyType = this._property.PropertyType();
        }
        return this._propertyType;
    }

    public void setPropertyType(String type) {
        this._propertyType = type;
        this._property.PropertyType(type);
    }

    public int getDataType() {
        if (this._dataType == -100) {
            Services.logger.trace("API: SpaceTimeProperty.DataType(): " + this.getOwnerAndType());
            this._dataType = this._property.DataType();
        }
        return this._dataType;
    }

    public int getStoredDataType() {
        if (this._storedDataType == -100) {
            Services.logger.trace("API: SpaceTimeProperty.StoredDataType(): " + this.getOwnerAndType());
            this._storedDataType = this._property.StoredDataType();
        }
        return this._storedDataType;
    }

    public String getLabel() {
        if (this._label == null) {
            Services.logger.trace("API: SpaceTimeProperty.Label(): " + this.getOwnerAndType());
            this._label = this._property.Label();
        }
        return this._label;
    }

    public boolean isHidden() {
        if (this._isHidden == null) {
            Services.logger.trace("API: SpaceTimeProperty.IsHidden(): " + this.getOwnerAndType());
            this._isHidden = new Boolean(this._property.IsHidden());
        }
        return this._isHidden;
    }

    public boolean isEditable() {
        if (this._isEditable == null) {
            Services.logger.trace("API: SpaceTimeProperty.IsEditable(): " + this.getOwnerAndType());
            this._isEditable = new Boolean(this._property.IsEditable());
        }
        return this._isEditable;
    }

    public boolean isAbsent() {
        String stringValue = this.getStringValue();
        return stringValue != null && stringValue.equalsIgnoreCase("absent");
    }

    public boolean isDisplayed() {
        return !this._property.IsHidden() && !this.isAbsent();
    }

    public String getCategory() {
        if (this._category == null) {
            Services.logger.trace("SpaceTimeProperty.Category(): " + this.getOwnerAndType());
            this._category = this._property.Category();
        }
        return this._category;
    }

    public String getStringValue() {
        if (this._stringValue == null) {
            Services.logger.trace("API: SpaceTimeProperty.StringValue(): " + this.getOwnerAndType());
            this._stringValue = this._property.StringValue();
        }
        return this._stringValue;
    }

    public void setStringValue(String value) {
        this._stringValue = value;
        try {
            this._property.SetStringValue(value);
        }
        catch (GenericUserException exception) {
            this._stringValue = null;
        }
    }

    public int getIntValue() {
        if (this._intValue == -100) {
            Services.logger.trace("API: SpaceTimeProperty.IntValue(): " + this.getOwnerAndType());
            this._intValue = this._property.IntValue();
        }
        return this._intValue;
    }

    public void setIntValue(int value) {
        this._intValue = value;
        try {
            this._property.SetIntValue(value);
        }
        catch (GenericUserException exception) {
            this._intValue = -100;
        }
    }

    public double getMoneyValue() {
        if (this._moneyValue == -100.0) {
            Services.logger.trace("API: SpaceTimeProperty.MoneyValue(): " + this.getOwnerAndType());
            this._moneyValue = (double)this._property.MoneyValue() / 100.0;
        }
        return this._moneyValue;
    }

    public void setMoneyValue(double value) {
        this._moneyValue = value;
        try {
            this._property.SetMoneyValue((int)Math.round(this._moneyValue * 100.0));
        }
        catch (GenericUserException exception) {
            this._moneyValue = -100.0;
        }
    }

    public LinearFunctionData getFunctionData() {
        if (this._nullFunctionData) {
            return null;
        }
        if (this._functionData == null) {
            CertainPlf functionData;
            block5: {
                Services.logger.trace("API: SpaceTimeProperty.GetCertainPlf(): " + this.getOwnerAndType());
                functionData = this._property.GetCertainPlf();
                if (functionData != null) break block5;
                this._nullFunctionData = true;
                return null;
            }
            try {
                this._functionData = new LinearFunctionData(functionData);
            }
            catch (GenericUserException genericUserException) {
                // empty catch block
            }
        }
        return this._functionData;
    }

    public UncertaintyDistributionData getUncertaintyData() {
        if (this._nullUncertaintyData) {
            return null;
        }
        if (this._uncertaintyData == null) {
            SpaceTime.DataModel.UncertaintyDistributionData uncertaintyData;
            block5: {
                Services.logger.trace("API: SpaceTimeProperty.GetUncertaintyData(): " + this.getOwnerAndType());
                uncertaintyData = this._property.GetUncertaintyData();
                if (uncertaintyData != null) break block5;
                this._nullUncertaintyData = true;
                return null;
            }
            try {
                this._uncertaintyData = new UncertaintyDistributionData(uncertaintyData);
            }
            catch (GenericUserException genericUserException) {
                // empty catch block
            }
        }
        return this._uncertaintyData;
    }

    public String getDisplayLabel() {
        String label = this.getLabel();
        if (label == null) {
            label = this.getPropertyType();
        }
        return label;
    }

    public String getDisplayValueString() {
        String propertyValue = this.getStringValue();
        switch (this.getStoredDataType()) {
            case 4: {
                UncertaintyDistributionData uncertaintyData = this.getUncertaintyData();
                if (uncertaintyData == null) break;
                propertyValue = uncertaintyData.getRangeString().replaceAll(" - ", "\u2013");
                if (this.getDataType() != 6) break;
                try {
                    String[] parts = propertyValue.split("\u2013");
                    if (parts.length != 2) break;
                    int min = Integer.parseInt(parts[0]);
                    int max = Integer.parseInt(parts[1]);
                    String minMoney = NumberFormat.getCurrencyInstance().format((double)min / 100.0);
                    String maxMoney = NumberFormat.getCurrencyInstance().format((double)max / 100.0);
                    propertyValue = String.valueOf(minMoney) + "\u2013" + maxMoney;
                }
                catch (NumberFormatException ex) {
                    Services.logger.error("invalid money pud", ex);
                }
                break;
            }
            case 7: {
                propertyValue = NumberFormat.getCurrencyInstance().format(this.getMoneyValue());
            }
        }
        return propertyValue;
    }

    public String getDisplayLabelAndValueString() {
        return String.valueOf(this.getDisplayLabel()) + ": " + this.getDisplayValueString();
    }

    public synchronized String getOwnerAndType() {
        if (this._ownerAndLabel == null) {
            SpaceTimeNode owner = this._property.OwnerNode();
            String ownerName = owner != null ? owner.Name() : "<no owner>";
            this._ownerAndLabel = String.valueOf(ownerName) + ":" + this._property.PropertyType();
        }
        return this._ownerAndLabel;
    }
}

