/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.radar.stp.cachingdatamodel;

import Ch.Elca.Iiop.GenericUserException;
import edu.cmu.cs.radar.stp.cachingdatamodel.SpaceTimeProperty;
import java.util.HashMap;

public class SpaceTimeEdge {
    protected SpaceTime.DataModel.SpaceTimeEdge _edge;
    private HashMap _propertyCache;
    private String _type;
    private String _target;

    public SpaceTimeEdge(SpaceTime.DataModel.SpaceTimeEdge edge) {
        this._edge = edge;
        this._propertyCache = new HashMap();
    }

    public SpaceTime.DataModel.SpaceTimeEdge getHostedEdge() {
        return this._edge;
    }

    public String getType() {
        if (this._type == null) {
            this._type = this._edge.Type();
        }
        return this._type;
    }

    public void setEdgeType(String newType) {
        this._type = newType;
        this._edge.Type(newType);
    }

    public String getTarget() {
        if (this._target == null) {
            this._target = this._edge.Target();
        }
        return this._target;
    }

    public void setTarget(String newTarget) {
        this._edge.Target(newTarget);
        this._target = newTarget;
    }

    private SpaceTimeProperty getPropertyFromCache(String propertyType) {
        return (SpaceTimeProperty)this._propertyCache.get(propertyType);
    }

    public SpaceTimeProperty getProperty(String propertyType) {
        SpaceTimeProperty cachedProperty = this.getPropertyFromCache(propertyType);
        if (cachedProperty == null) {
            if (this._propertyCache.containsKey(propertyType)) {
                return null;
            }
            try {
                SpaceTime.DataModel.SpaceTimeProperty property = this._edge.GetProperty(propertyType);
                if (property != null) {
                    cachedProperty = new SpaceTimeProperty(property);
                }
                this._propertyCache.put(propertyType, cachedProperty);
            }
            catch (GenericUserException genericUserException) {
                // empty catch block
            }
        }
        return cachedProperty;
    }

    public void addProperty(SpaceTimeProperty property) {
        try {
            this._edge.AddProperty(property.getHostedProperty());
            this._propertyCache.put(property.getPropertyType(), property);
        }
        catch (GenericUserException genericUserException) {
            // empty catch block
        }
    }

    public boolean equals(SpaceTimeEdge otherEdge) {
        return this._edge.equals(otherEdge._edge);
    }
}

