/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.radar.stp.cachingdatamodel;

import Ch.Elca.Iiop.GenericUserException;
import SpaceTime.DataModel.ChangeListener;
import SpaceTime.DataModel.ChangeListenerHelper;
import SpaceTime.DataModel.ChangeListenerPOA;
import SpaceTime.DataModel.DMArrayList;
import SpaceTime.DataModel.EventListenerHelper;
import SpaceTime.DataModel.EventListenerPOA;
import SpaceTime.DataModel.NodeChangeSummary;
import SpaceTime.DataModel.Parameters;
import SpaceTime.DataModel.RoomRequest;
import SpaceTime.DataModel.RoomReservationImpl;
import SpaceTime.DataModel.SpaceTimeEvent;
import SpaceTime.DataModel.SpaceTimeNodeHelper;
import SpaceTime.DataModel.TimeSlot;
import edu.cmu.cs.radar.integ.ICMRadarRequires;
import edu.cmu.cs.radar.rhai.spacetime.Services;
import edu.cmu.cs.radar.stp.cachingdatamodel.EventListener;
import edu.cmu.cs.radar.stp.cachingdatamodel.GlobalChangeListener;
import edu.cmu.cs.radar.stp.cachingdatamodel.NodeChangeListener;
import edu.cmu.cs.radar.stp.cachingdatamodel.SpaceTimeEdge;
import edu.cmu.cs.radar.stp.cachingdatamodel.SpaceTimeNode;
import edu.cmu.cs.radar.stp.cachingdatamodel.SpaceTimeProperty;
import java.awt.EventQueue;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.Servant;

public class SpaceTimeDataAdapter {
    private static final int NOVALUE = -100;
    private SpaceTime.DataModel.SpaceTimeDataAdapter _dataAdapter;
    private POA _rootPOA;
    private ArrayList _requests;
    private ArrayList _rooms;
    private boolean _requestCacheComplete;
    private boolean _roomCacheComplete;
    private ChangeListener _changeListener;
    private ChangeListenerPOA _changeListenerPOA;
    private SpaceTime.DataModel.EventListener _eventListener;
    private EventListenerPOA _eventListenerPOA;
    private ArrayList _globalListeners;
    private ArrayList _nodeListeners;
    private ArrayList _eventListeners;
    private float _globalScore;
    private SpaceTimeNode _roomNode;
    private Barrier _optimizationDoneBarrier;

    public SpaceTimeDataAdapter(SpaceTime.DataModel.SpaceTimeDataAdapter dataAdapter, POA rootPOA) {
        this._dataAdapter = dataAdapter;
        this._rootPOA = rootPOA;
        this._requests = new ArrayList();
        this._rooms = new ArrayList();
        this._requestCacheComplete = false;
        this._roomCacheComplete = false;
        this._globalListeners = new ArrayList();
        this._nodeListeners = new ArrayList();
        this._eventListeners = new ArrayList();
        this._globalScore = -100.0f;
        this._optimizationDoneBarrier = new Barrier();
        this._changeListenerPOA = new ChangeListenerPOA(){

            public void WorldStateNodeChanged(SpaceTime.DataModel.SpaceTimeNode node, NodeChangeSummary changes) {
                Services.logger.trace("WorldStateNodeChanged");
                SpaceTimeDataAdapter.this._optimizationDoneBarrier.up();
                try {
                    try {
                        Thread.yield();
                        EventQueue.invokeAndWait(new Runnable(this, node, changes){
                            final /* synthetic */ 1 this$1;
                            private final /* synthetic */ SpaceTime.DataModel.SpaceTimeNode val$node;
                            private final /* synthetic */ NodeChangeSummary val$changes;
                            {
                                this.this$1 = var1_1;
                                this.val$node = spaceTimeNode;
                                this.val$changes = nodeChangeSummary;
                            }

                            public void run() {
                                1.access$0(this.this$1).fireWorldStateNodeChanged(this.val$node, this.val$changes);
                            }
                        });
                    }
                    catch (InterruptedException ex) {
                        Services.logger.error("", ex);
                    }
                    catch (InvocationTargetException ex) {
                        Services.logger.error("", ex);
                    }
                }
                finally {
                    SpaceTimeDataAdapter.this._optimizationDoneBarrier.down();
                }
            }

            public void WorldStateNodeAdded(SpaceTime.DataModel.SpaceTimeNode node) {
                Services.logger.trace("WorldStateNodeAdded");
                try {
                    EventQueue.invokeAndWait(new Runnable(this, node){
                        final /* synthetic */ 1 this$1;
                        private final /* synthetic */ SpaceTime.DataModel.SpaceTimeNode val$node;
                        {
                            this.this$1 = var1_1;
                            this.val$node = spaceTimeNode;
                        }

                        public void run() {
                            SpaceTimeDataAdapter.access$1(1.access$0(this.this$1), this.val$node);
                        }
                    });
                }
                catch (InterruptedException ex) {
                    Services.logger.error("", ex);
                }
                catch (InvocationTargetException ex) {
                    Services.logger.error("", ex);
                }
            }

            public void WorldStateNodeScoreUpdated(String nodeId, double score) {
                Services.logger.trace("WorldStateNodeScoreUpdated");
                try {
                    EventQueue.invokeAndWait(new Runnable(this, nodeId, score){
                        final /* synthetic */ 1 this$1;
                        private final /* synthetic */ String val$nodeId;
                        private final /* synthetic */ double val$score;
                        {
                            this.this$1 = var1_1;
                            this.val$nodeId = string;
                            this.val$score = d;
                        }

                        public void run() {
                            SpaceTimeDataAdapter.access$2(1.access$0(this.this$1), this.val$nodeId, this.val$score);
                        }
                    });
                }
                catch (InterruptedException ex) {
                    Services.logger.error("", ex);
                }
                catch (InvocationTargetException ex) {
                    Services.logger.error("", ex);
                }
            }

            public void WorldStateGlobalScoreUpdated(double score) {
                Services.logger.trace("WorldStateGlobalScoreUpdated");
                try {
                    EventQueue.invokeAndWait(new Runnable(this, score){
                        final /* synthetic */ 1 this$1;
                        private final /* synthetic */ double val$score;
                        {
                            this.this$1 = var1_1;
                            this.val$score = d;
                        }

                        public void run() {
                            SpaceTimeDataAdapter.access$3(1.access$0(this.this$1), this.val$score);
                        }
                    });
                }
                catch (InterruptedException ex) {
                    Services.logger.error("", ex);
                }
                catch (InvocationTargetException ex) {
                    Services.logger.error("", ex);
                }
            }

            static /* synthetic */ SpaceTimeDataAdapter access$0(1 var0) {
                return var0.SpaceTimeDataAdapter.this;
            }
        };
        this._eventListenerPOA = new EventListenerPOA(){

            public void Notify(SpaceTimeEvent stEvent) {
                Services.logger.trace("Notify: enter: " + stEvent._eventID + " " + stEvent._value);
                if (stEvent._eventID == 4) {
                    Services.logger.trace("_optimizationDoneBarrier.pass(): before");
                    SpaceTimeDataAdapter.this._optimizationDoneBarrier.pass();
                    Services.logger.trace("_optimizationDoneBarrier.pass(): after");
                }
                try {
                    EventQueue.invokeAndWait(new Runnable(this, stEvent){
                        final /* synthetic */ 6 this$1;
                        private final /* synthetic */ SpaceTimeEvent val$stEvent;
                        {
                            this.this$1 = var1_1;
                            this.val$stEvent = spaceTimeEvent;
                        }

                        public void run() {
                            switch (this.val$stEvent._eventID) {
                                case 5: {
                                    SpaceTimeDataAdapter.access$4(6.access$0(this.this$1), this.val$stEvent._value);
                                    break;
                                }
                                case 6: {
                                    SpaceTimeDataAdapter.access$5(6.access$0(this.this$1));
                                    break;
                                }
                                case 3: {
                                    break;
                                }
                                case 4: {
                                    Services.logger.trace("calling fireOptimizationDone");
                                    SpaceTimeDataAdapter.access$6(6.access$0(this.this$1));
                                    break;
                                }
                                case 2: {
                                    SpaceTimeDataAdapter.access$7(6.access$0(this.this$1), Boolean.valueOf(this.val$stEvent._value));
                                    break;
                                }
                                case 1: {
                                    SpaceTimeDataAdapter.access$8(6.access$0(this.this$1), this.val$stEvent._value);
                                    break;
                                }
                                case 8: {
                                    SpaceTimeDataAdapter.access$9(6.access$0(this.this$1), this.val$stEvent._value);
                                    break;
                                }
                                case 7: {
                                    SpaceTimeDataAdapter.access$10(6.access$0(this.this$1));
                                    break;
                                }
                                case 9: {
                                    SpaceTimeDataAdapter.access$11(6.access$0(this.this$1));
                                }
                            }
                        }
                    });
                }
                catch (InterruptedException ex) {
                    Services.logger.error("", ex);
                }
                catch (InvocationTargetException ex) {
                    Services.logger.error("", ex);
                }
                Services.logger.trace("Notify: exit: " + stEvent._eventID + " " + stEvent._value);
            }

            static /* synthetic */ SpaceTimeDataAdapter access$0(6 var0) {
                return var0.SpaceTimeDataAdapter.this;
            }
        };
        try {
            this._rootPOA.activate_object((Servant)this._changeListenerPOA);
            this._changeListener = ChangeListenerHelper.narrow(rootPOA.servant_to_reference((Servant)this._changeListenerPOA));
            this._dataAdapter.AddGlobalChangeListener(this._changeListener);
            this._rootPOA.activate_object((Servant)this._eventListenerPOA);
            this._eventListener = EventListenerHelper.narrow(rootPOA.servant_to_reference((Servant)this._eventListenerPOA));
            this._dataAdapter.AddEventListener(this._eventListener);
            this._roomNode = this.getNodeById("room");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void dispose() {
        try {
            this._dataAdapter.RemoveGlobalChangeListener(this._changeListener);
            this._dataAdapter.RemoveEventListener(this._eventListener);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected synchronized void fireWorldStateNodeChanged(SpaceTime.DataModel.SpaceTimeNode node, NodeChangeSummary changes) {
        Object listener;
        Services.logger.trace("fireWorldStateNodeChanged: enter ");
        String nodeName = node.Name();
        Services.logger.trace("fireWorldStateNodeChanged: " + nodeName + ", " + (changes != null));
        SpaceTimeNode cachedNode = this.getNodeFromCache(node.Name());
        if (cachedNode != null) {
            if (changes != null) {
                cachedNode.flushCache(changes);
            } else {
                cachedNode.flushCache();
            }
        }
        int i = 0;
        while (i < this._nodeListeners.size()) {
            listener = (NodeListenerHolder)this._nodeListeners.get(i);
            if (nodeName.equals(((NodeListenerHolder)listener).getNodeName())) {
                ((NodeListenerHolder)listener).getListener().nodeChanged(nodeName, changes);
            }
            ++i;
        }
        i = 0;
        while (i < this._globalListeners.size()) {
            listener = (GlobalChangeListener)this._globalListeners.get(i);
            listener.worldStateNodeChanged(nodeName, changes);
            ++i;
        }
    }

    private synchronized void fireWorldStateNodeAdded(SpaceTime.DataModel.SpaceTimeNode node) {
        String nodeName = node.Name();
        Services.logger.trace("fireWorldStateNodeAdded: " + nodeName);
        int i = 0;
        while (i < this._globalListeners.size()) {
            GlobalChangeListener listener = (GlobalChangeListener)this._globalListeners.get(i);
            listener.worldStateNodeAdded(nodeName);
            ++i;
        }
    }

    private synchronized void fireWorldStateNodeScoreUpdated(String nodeId, double score) {
        Services.logger.trace("fireWorldStateNodeScoreUpdated: " + nodeId + ", " + score);
        SpaceTimeNode node = this.getRequestNodeFromCache(nodeId);
        if (node != null) {
            node.updateCachedScore(score);
        }
        int i = 0;
        while (i < this._globalListeners.size()) {
            GlobalChangeListener listener = (GlobalChangeListener)this._globalListeners.get(i);
            listener.worldStateNodeScoreChanged(nodeId, score);
            ++i;
        }
    }

    private synchronized void fireWorldStateGlobalScoreUpdated(double score) {
        Services.logger.trace("fireWorldStateGlobalScoreUpdated: " + score);
        this._globalScore = (float)score;
        int i = 0;
        while (i < this._globalListeners.size()) {
            GlobalChangeListener listener = (GlobalChangeListener)this._globalListeners.get(i);
            listener.worldStateGlobalScoreChanged(score);
            ++i;
        }
    }

    private synchronized void fireElicitationDone(String ouputFile) {
        Services.logger.trace("fireElicitationDone");
        int i = 0;
        while (i < this._eventListeners.size()) {
            EventListener listener = (EventListener)this._eventListeners.get(i);
            listener.elicitationDone(ouputFile);
            ++i;
        }
    }

    private synchronized void fireEndOfBatchLearning() {
        Services.logger.trace("fireEndOfBatchLearning");
        int i = 0;
        while (i < this._eventListeners.size()) {
            EventListener listener = (EventListener)this._eventListeners.get(i);
            listener.batchLearningDone();
            ++i;
        }
    }

    private synchronized void fireOptimizationDone() {
        Services.logger.trace("fireOptimizationDone");
        int i = 0;
        while (i < this._eventListeners.size()) {
            EventListener listener = (EventListener)this._eventListeners.get(i);
            listener.optimizationDone();
            ++i;
        }
    }

    private synchronized void fireOptimizationRecommended(boolean optimize) {
        Services.logger.trace("fireOptimizationRecommended: " + optimize);
        int i = 0;
        while (i < this._eventListeners.size()) {
            EventListener listener = (EventListener)this._eventListeners.get(i);
            listener.optimizationRecommended(optimize);
            ++i;
        }
    }

    private synchronized void fireSchedulePublished(String wbeFile) {
        Services.logger.trace("fireSchedulePublished");
        int i = 0;
        while (i < this._eventListeners.size()) {
            EventListener listener = (EventListener)this._eventListeners.get(i);
            listener.schedulePublished(wbeFile);
            ++i;
        }
    }

    private synchronized void fireVendorElicitorDone(String outputFile) {
        Services.logger.trace("fireVendorElicitorDone: " + outputFile);
        int i = 0;
        while (i < this._eventListeners.size()) {
            EventListener listener = (EventListener)this._eventListeners.get(i);
            listener.vendorElicitorDone(outputFile);
            ++i;
        }
    }

    private synchronized void fireVendorOptimizerDone() {
        Services.logger.trace("fireVendorOptimizerDone");
        int i = 0;
        while (i < this._eventListeners.size()) {
            EventListener listener = (EventListener)this._eventListeners.get(i);
            listener.vendorOptimizerDone();
            ++i;
        }
    }

    private synchronized void fireRoomsRequested() {
        Services.logger.trace("fireRoomsRequested");
        try {
            RoomRequest[] roomRequests = this._dataAdapter.GetRoomRequestor().GetRoomRequests();
            int i = 0;
            while (i < this._eventListeners.size()) {
                EventListener listener = (EventListener)this._eventListeners.get(i);
                listener.roomsRequested(roomRequests);
                ++i;
            }
        }
        catch (GenericUserException genericUserException) {
            // empty catch block
        }
    }

    public synchronized void addGlobalChangeListener(GlobalChangeListener listener) {
        this._globalListeners.add(listener);
    }

    public synchronized void removeGlobalChangeListener(GlobalChangeListener listener) {
        this._globalListeners.remove(listener);
    }

    public synchronized void addNodeChangeListener(NodeChangeListener listener, String nodeName) {
        this._nodeListeners.add(new NodeListenerHolder(listener, nodeName));
    }

    public synchronized void removeNodeChangeListener(NodeChangeListener listener) {
        int i = 0;
        while (i < this._nodeListeners.size()) {
            NodeListenerHolder localListener = (NodeListenerHolder)this._nodeListeners.get(i);
            if (listener == localListener.getListener()) {
                this._nodeListeners.remove(i);
                return;
            }
            ++i;
        }
    }

    public synchronized void addEventListener(EventListener listener) {
        this._eventListeners.add(listener);
    }

    public synchronized void removeEventListener(EventListener listener) {
        this._eventListeners.remove(listener);
    }

    public void notifyGlobalScorePending() {
        this.fireWorldStateGlobalScoreUpdated(-101.0);
    }

    public String getScheduleAsXml(boolean fixAssigned, boolean fixUnassigned) {
        try {
            return this._dataAdapter.SaveAsString(fixAssigned, fixUnassigned);
        }
        catch (GenericUserException genericUserException) {
            return null;
        }
    }

    public void flushScores() {
        try {
            this._dataAdapter.FlushScores();
        }
        catch (GenericUserException genericUserException) {
            // empty catch block
        }
    }

    public SpaceTimeNode createNode(String xml) {
        try {
            SpaceTime.DataModel.SpaceTimeNode node = this._dataAdapter.CreateNode(xml);
            return new SpaceTimeNode(node, this);
        }
        catch (GenericUserException genericUserException) {
            return null;
        }
    }

    public SpaceTimeEdge createEdge(String target, String edgeType) {
        try {
            return new SpaceTimeEdge(this._dataAdapter.CreateEdge(target, edgeType));
        }
        catch (GenericUserException genericUserException) {
            return null;
        }
    }

    public SpaceTimeProperty createProperty(String propertyType) {
        try {
            return new SpaceTimeProperty(this._dataAdapter.CreateProperty(propertyType));
        }
        catch (GenericUserException genericUserException) {
            return null;
        }
    }

    public long getScenarioStart() {
        SpaceTimeProperty startProperty = this._roomNode.getProperty("start");
        return startProperty.getIntValue();
    }

    public long getScenarioStop() {
        return this.getScenarioStart() + this.getScenarioDuration();
    }

    public long getScenarioDuration() {
        SpaceTimeProperty startProperty = this._roomNode.getProperty("duration");
        return startProperty.getIntValue();
    }

    public float getGlobalScore() {
        if (this._globalScore != -100.0f) {
            return this._globalScore;
        }
        try {
            this._globalScore = this._dataAdapter.GetGlobalScore();
            return this._globalScore;
        }
        catch (GenericUserException genericUserException) {
            return -6.0f;
        }
    }

    public SpaceTimeNode getNodeById(String nodeId) {
        SpaceTimeNode cachedNode = this.getNodeFromCache(nodeId);
        if (cachedNode != null) {
            return cachedNode;
        }
        try {
            cachedNode = new SpaceTimeNode(this._dataAdapter.GetNodeById(nodeId), this);
            return cachedNode;
        }
        catch (GenericUserException genericUserException) {
            return null;
        }
    }

    private SpaceTimeNode getNodeFromCache(String nodeId) {
        SpaceTimeNode node = null;
        node = this.getRequestNodeFromCache(nodeId);
        if (node != null) {
            return node;
        }
        node = this.getRoomNodeFromCache(nodeId);
        if (node != null) {
            return node;
        }
        return null;
    }

    private SpaceTimeNode getRequestNodeFromCache(String nodeId) {
        int i = 0;
        while (i < this._requests.size()) {
            SpaceTimeNode node = (SpaceTimeNode)this._requests.get(i);
            if (nodeId.equals(node.getName())) {
                return node;
            }
            ++i;
        }
        return null;
    }

    private SpaceTimeNode getRoomNodeFromCache(String nodeId) {
        int i = 0;
        while (i < this._rooms.size()) {
            SpaceTimeNode node = (SpaceTimeNode)this._rooms.get(i);
            if (nodeId.equals(node.getName())) {
                return node;
            }
            ++i;
        }
        return null;
    }

    public String getNodeXml(String nodeId) {
        try {
            return this._dataAdapter.GetNodeXml(nodeId);
        }
        catch (GenericUserException genericUserException) {
            return null;
        }
    }

    public List getRequests() {
        if (this._requestCacheComplete) {
            return this._requests;
        }
        ArrayList<SpaceTimeNode> list = new ArrayList<SpaceTimeNode>();
        try {
            DMArrayList dmList = this._dataAdapter.GetRequests();
            int i = 0;
            while (i < dmList.Count()) {
                SpaceTime.DataModel.SpaceTimeNode node = SpaceTimeNodeHelper.extract(dmList.GetAt(i));
                SpaceTimeNode cachedNode = this.getRequestNodeFromCache(node.Name());
                if (cachedNode == null) {
                    cachedNode = new SpaceTimeNode(node, this);
                    this._requests.add(cachedNode);
                }
                list.add(cachedNode);
                ++i;
            }
        }
        catch (GenericUserException genericUserException) {
            // empty catch block
        }
        this._requestCacheComplete = true;
        return list;
    }

    public List getRooms() {
        if (this._roomCacheComplete) {
            return this._rooms;
        }
        ArrayList<SpaceTimeNode> list = new ArrayList<SpaceTimeNode>();
        try {
            DMArrayList dmList = this._dataAdapter.GetRooms();
            int i = 0;
            while (i < dmList.Count()) {
                SpaceTime.DataModel.SpaceTimeNode node = SpaceTimeNodeHelper.extract(dmList.GetAt(i));
                SpaceTimeNode cachedNode = this.getRoomNodeFromCache(node.Name());
                if (cachedNode == null) {
                    cachedNode = new SpaceTimeNode(node, this);
                    this._rooms.add(cachedNode);
                }
                list.add(cachedNode);
                ++i;
            }
        }
        catch (GenericUserException genericUserException) {
            // empty catch block
        }
        this._roomCacheComplete = true;
        return list;
    }

    public String getAssociatedPropertyName(String propertyName) {
        try {
            return this._dataAdapter.GetAssociatedPropertyName(propertyName);
        }
        catch (GenericUserException genericUserException) {
            return null;
        }
    }

    public boolean isPropertyAssociated(String property) {
        try {
            return this._dataAdapter.IsPropertyAssociated(property);
        }
        catch (GenericUserException genericUserException) {
            return false;
        }
    }

    public String getAssociatedWeightName(String preference) {
        try {
            return this._dataAdapter.GetAssociatedWeightName(preference);
        }
        catch (GenericUserException genericUserException) {
            return null;
        }
    }

    public Parameters getParameters() {
        try {
            return this._dataAdapter.GetParameters();
        }
        catch (GenericUserException genericUserException) {
            return null;
        }
    }

    public boolean getOptimizationHint() {
        try {
            return Boolean.valueOf(this._dataAdapter.GetOptimizationHint());
        }
        catch (GenericUserException genericUserException) {
            return true;
        }
    }

    public void submitRoomReservation(ICMRadarRequires.Reservation reservation) {
        try {
            RoomReservationImpl roomReservation = null;
            if (reservation != null) {
                roomReservation = new RoomReservationImpl(reservation);
            }
            this._dataAdapter.GetRoomRequestor().SubmitRoomReservation(roomReservation);
        }
        catch (GenericUserException genericUserException) {
            // empty catch block
        }
    }

    public void updateTimeSlots(TimeSlot[] slots) {
        try {
            this._dataAdapter.UpdateTimeSlots(slots);
        }
        catch (GenericUserException genericUserException) {
            // empty catch block
        }
    }

    static /* synthetic */ void access$1(SpaceTimeDataAdapter spaceTimeDataAdapter, SpaceTime.DataModel.SpaceTimeNode spaceTimeNode) {
        spaceTimeDataAdapter.fireWorldStateNodeAdded(spaceTimeNode);
    }

    static /* synthetic */ void access$2(SpaceTimeDataAdapter spaceTimeDataAdapter, String string, double d) {
        spaceTimeDataAdapter.fireWorldStateNodeScoreUpdated(string, d);
    }

    static /* synthetic */ void access$3(SpaceTimeDataAdapter spaceTimeDataAdapter, double d) {
        spaceTimeDataAdapter.fireWorldStateGlobalScoreUpdated(d);
    }

    static /* synthetic */ void access$4(SpaceTimeDataAdapter spaceTimeDataAdapter, String string) {
        spaceTimeDataAdapter.fireElicitationDone(string);
    }

    static /* synthetic */ void access$5(SpaceTimeDataAdapter spaceTimeDataAdapter) {
        spaceTimeDataAdapter.fireEndOfBatchLearning();
    }

    static /* synthetic */ void access$6(SpaceTimeDataAdapter spaceTimeDataAdapter) {
        spaceTimeDataAdapter.fireOptimizationDone();
    }

    static /* synthetic */ void access$7(SpaceTimeDataAdapter spaceTimeDataAdapter, boolean bl) {
        spaceTimeDataAdapter.fireOptimizationRecommended(bl);
    }

    static /* synthetic */ void access$8(SpaceTimeDataAdapter spaceTimeDataAdapter, String string) {
        spaceTimeDataAdapter.fireSchedulePublished(string);
    }

    static /* synthetic */ void access$9(SpaceTimeDataAdapter spaceTimeDataAdapter, String string) {
        spaceTimeDataAdapter.fireVendorElicitorDone(string);
    }

    static /* synthetic */ void access$10(SpaceTimeDataAdapter spaceTimeDataAdapter) {
        spaceTimeDataAdapter.fireVendorOptimizerDone();
    }

    static /* synthetic */ void access$11(SpaceTimeDataAdapter spaceTimeDataAdapter) {
        spaceTimeDataAdapter.fireRoomsRequested();
    }

    private static class NodeListenerHolder {
        private NodeChangeListener _listener;
        private String _nodeName;

        public NodeListenerHolder(NodeChangeListener listener, String nodeName) {
            this._listener = listener;
            this._nodeName = nodeName;
        }

        public NodeChangeListener getListener() {
            return this._listener;
        }

        public String getNodeName() {
            return this._nodeName;
        }
    }

    private static class Barrier {
        private int mCount = 0;

        private Barrier() {
        }

        public synchronized void up() {
            ++this.mCount;
            this.notify();
        }

        public synchronized void down() {
            --this.mCount;
            this.notify();
        }

        public synchronized void pass() {
            while (this.mCount > 0) {
                try {
                    this.wait();
                }
                catch (InterruptedException ex) {
                    Services.logger.error("Barrier.pass(): ", ex);
                }
            }
        }
    }
}

