/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.radar.rhai.spacetime;

import SpaceTime.DataModel.NodeChangeSummary;
import edu.cmu.cs.radar.rhai.spacetime.RequestListModel;
import edu.cmu.cs.radar.rhai.spacetime.Services;
import edu.cmu.cs.radar.rhai.spacetime.SpaceTimeDate;
import edu.cmu.cs.radar.rhai.spacetime.SpaceTimeDuration;
import edu.cmu.cs.radar.rhai.spacetime.SpaceTimeRequestNode;
import edu.cmu.cs.radar.stp.cachingdatamodel.GlobalChangeListener;
import edu.cmu.cs.radar.stp.cachingdatamodel.SpaceTimeNode;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class WorkJournal {
    private Vector _journal = new Vector();
    private Vector _listeners = new Vector();
    private int _cursor = 0;
    private Item _executingItem;

    public void addListener(Listener listener) {
        this._listeners.add(listener);
    }

    public void removeListener(Listener listener) {
        this._listeners.remove(listener);
    }

    public int size() {
        return this._journal.size();
    }

    public Item getExecutingItem() {
        return this._executingItem;
    }

    public void setExecutingItem(Item item) {
        this._executingItem = item;
    }

    public void addItem(Item item) {
        this._journal.insertElementAt(item, this._cursor++);
        int journalSize = this._journal.size();
        int i = this._cursor;
        while (i < journalSize) {
            this._journal.removeElementAt(this._cursor);
            ++i;
        }
        this.notifyChange();
    }

    private void notifyChange() {
        this._executingItem = null;
        int i = 0;
        while (i < this._listeners.size()) {
            Listener listener = (Listener)this._listeners.get(i);
            listener.workJournalChanged();
            ++i;
        }
    }

    public void clear() {
        this._cursor = 0;
        this._journal.clear();
        this.notifyChange();
    }

    public void undo() {
        if (!this.isUndoAvailable()) {
            return;
        }
        Item item = (Item)this._journal.get(this._cursor - 1);
        item.log("undone");
        item.undoAction();
        --this._cursor;
        this.notifyChange();
    }

    public void redo() {
        if (!this.isRedoAvailable()) {
            return;
        }
        Item item = (Item)this._journal.get(this._cursor);
        item.log("redone");
        item.redoAction();
        ++this._cursor;
        this.notifyChange();
    }

    public boolean isUndoAvailable() {
        return this._cursor > 0;
    }

    public boolean isRedoAvailable() {
        return this._cursor < this._journal.size();
    }

    public String getUndoTitle() {
        if (!this.isUndoAvailable()) {
            return "";
        }
        Item item = (Item)this._journal.get(this._cursor - 1);
        return item.getActionTitle();
    }

    public String getRedoTitle() {
        if (!this.isRedoAvailable()) {
            return "";
        }
        Item item = (Item)this._journal.get(this._cursor);
        return item.getActionTitle();
    }

    public static interface Listener {
        public void workJournalChanged();
    }

    public static abstract class Item {
        public abstract String getActionTitle();

        public abstract void setActionTitle(String var1);

        public abstract void undoAction();

        public abstract void redoAction();

        public abstract String log();

        protected void log(String type) {
            String action = this.getActionTitle();
            action = String.valueOf(action.matches("(?i:^[aeiou].*)") ? "an" : "a") + " " + action;
            Services.logger.info("The user has " + type + ": " + this.log());
        }

        protected abstract boolean isStateEqual();
    }

    private static class SavedAllocation {
        private String _room;
        private SpaceTimeDate _start;
        private SpaceTimeDuration _duration;

        public SavedAllocation(SpaceTimeRequestNode requestNode) {
            this._room = requestNode.getRoom();
            this._start = requestNode.getStart();
            this._duration = requestNode.getDuration();
        }

        public void apply(SpaceTimeRequestNode requestNode) {
            if (this._room == null || this._start == null || this._duration == null) {
                requestNode.removeAllocation();
            } else if (!(this._room.equals(requestNode.getRoom()) && this._start.equals(requestNode.getStart()) && this._duration.equals(requestNode.getDuration()))) {
                requestNode.assign(this._room, this._start, this._duration);
            }
        }

        public String log() {
            if (this._room == null || this._room.equalsIgnoreCase("grass")) {
                return "'unscheduled'";
            }
            return "'" + this._room + "'/'" + this._start + "'/'" + this._duration + "'";
        }

        public String toString() {
            return String.valueOf(this._room) + "\t" + this._start + "\t" + this._duration;
        }
    }

    public static class NodeStateCaptureItem
    extends Item {
        private SpaceTimeNode _node;
        private String _description;
        private RequestListModel _listModel;
        private String _logDescription;
        private SavedAllocation _initialState;
        private SavedAllocation _finalState;

        public NodeStateCaptureItem(RequestListModel listModel, SpaceTimeNode node, String description) {
            this._listModel = listModel;
            this._node = node;
            this._description = description;
            SpaceTimeRequestNode requestNode = new SpaceTimeRequestNode(node);
            this._initialState = new SavedAllocation(requestNode);
            requestNode.dispose();
            this._listModel.getSize();
        }

        public String getActionTitle() {
            return this._description;
        }

        public void setActionTitle(String description) {
            this._description = description;
        }

        public void setLogDescription(String logDescription) {
            this._logDescription = logDescription;
        }

        public void captureState() {
            SpaceTimeRequestNode requestNode = new SpaceTimeRequestNode(this._node);
            this._finalState = new SavedAllocation(requestNode);
            requestNode.dispose();
        }

        public void undoAction() {
            SpaceTimeRequestNode requestNode = new SpaceTimeRequestNode(this._node);
            this._initialState.apply(requestNode);
            requestNode.dispose();
        }

        public void redoAction() {
            SpaceTimeRequestNode requestNode = new SpaceTimeRequestNode(this._node);
            this._finalState.apply(requestNode);
            requestNode.dispose();
        }

        protected boolean isStateEqual() {
            return false;
        }

        public String log() {
            String result = "The user " + this._logDescription + ". event '" + this._node.getName() + "';";
            if (this._finalState != null) {
                result = String.valueOf(result) + " new: " + this._finalState.log() + ";";
            }
            result = String.valueOf(result) + " old: " + this._initialState.log();
            return result;
        }
    }

    public static class WorldStateCaptureItem
    extends Item
    implements GlobalChangeListener {
        private RequestListModel _listModel;
        private String _description;
        private HashSet _changedNodes;
        private HashMap _initialState;
        private HashMap _finalState;

        public WorldStateCaptureItem(RequestListModel listModel, String description) {
            this._listModel = listModel;
            this._description = description;
            this._changedNodes = new HashSet();
            this._initialState = this.saveState();
            this._listModel.getDataAdapter().addGlobalChangeListener(this);
        }

        public String getActionTitle() {
            return this._description;
        }

        public void setActionTitle(String description) {
            this._description = description;
        }

        public void captureState() {
            this._finalState = this.saveState();
            this._listModel.getDataAdapter().removeGlobalChangeListener(this);
        }

        public void undoAction() {
            this.applyChanges(this._initialState);
        }

        public void redoAction() {
            this.applyChanges(this._finalState);
        }

        private void applyChanges(HashMap state) {
            try {
                Iterator changedNodesIterator = this._changedNodes.iterator();
                while (changedNodesIterator.hasNext()) {
                    String nodeId = (String)changedNodesIterator.next();
                    SavedAllocation savedAllocation = (SavedAllocation)state.get(nodeId);
                    if (savedAllocation == null) continue;
                    SpaceTimeNode node = this._listModel.getDataAdapter().getNodeById(nodeId);
                    SpaceTimeRequestNode requestNode = new SpaceTimeRequestNode(node);
                    savedAllocation.apply(requestNode);
                    requestNode.dispose();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }

        protected boolean isStateEqual() {
            return this._initialState.equals(this._finalState);
        }

        private HashMap saveState() {
            HashMap<String, SavedAllocation> state = new HashMap<String, SavedAllocation>();
            List requests = this._listModel.getDataAdapter().getRequests();
            Iterator requestsIterator = requests.iterator();
            while (requestsIterator.hasNext()) {
                SpaceTimeNode node = (SpaceTimeNode)requestsIterator.next();
                SpaceTimeRequestNode requestNode = new SpaceTimeRequestNode(node);
                SavedAllocation savedAllocation = new SavedAllocation(requestNode);
                state.put(node.getName(), savedAllocation);
                requestNode.dispose();
            }
            return state;
        }

        public void worldStateGlobalScoreChanged(double score) {
        }

        public void worldStateNodeAdded(String nodeId) {
        }

        public void worldStateNodeChanged(String nodeId, NodeChangeSummary changes) {
            this._changedNodes.add(nodeId);
        }

        public void worldStateNodeScoreChanged(String nodeId, double score) {
        }

        public String log() {
            return this._description;
        }
    }
}

