/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.radar.rhai.spacetime;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager2;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;

public class VerticalScrollLayout
implements LayoutManager2 {
    private int _hPad;
    private int _vPad;
    private int _topPad;
    private boolean _suppressLayout;

    public VerticalScrollLayout(int hPad, int vPad, int topPad) {
        this._hPad = hPad;
        this._vPad = vPad;
        this._topPad = topPad;
        this._suppressLayout = false;
    }

    public float getLayoutAlignmentX(Container container) {
        return 0.0f;
    }

    public float getLayoutAlignmentY(Container container) {
        return 0.0f;
    }

    public void invalidateLayout(Container container) {
    }

    public Dimension minimumLayoutSize(Container container) {
        return new Dimension(0, 0);
    }

    public Dimension maximumLayoutSize(Container container) {
        return new Dimension(0, 0);
    }

    public Dimension preferredLayoutSize(Container container) {
        return new Dimension(0, 0);
    }

    public void addLayoutComponent(Component component, Object object) {
    }

    public void addLayoutComponent(String string, Component component) {
    }

    public void removeLayoutComponent(Component component) {
    }

    public void suppressLayout(boolean suppress) {
        this._suppressLayout = suppress;
    }

    public void layoutContainer(Container container) {
        Container parent2;
        if (this._suppressLayout) {
            return;
        }
        int componentCount = container.getComponentCount();
        int width = container.getWidth();
        int margin = this._topPad;
        int finalHeight = this._topPad;
        int i = 0;
        while (i < componentCount) {
            Component component = container.getComponent(i);
            finalHeight += component.getHeight() + this._vPad;
            ++i;
        }
        Container parent = container.getParent();
        if (parent != null && (parent2 = parent.getParent()) instanceof JScrollPane && (finalHeight += this._vPad + 4) > parent2.getHeight()) {
            JScrollBar scrollBar = ((JScrollPane)parent2).getVerticalScrollBar();
            width = parent2.getWidth() - scrollBar.getWidth();
        }
        int offset = margin;
        this._suppressLayout = true;
        int i2 = 0;
        while (i2 < componentCount) {
            Component component = container.getComponent(i2);
            component.setBounds(this._hPad, offset, width - this._hPad * 2 - 1, component.getPreferredSize().height);
            offset += component.getHeight() + this._vPad;
            ++i2;
        }
        if (container instanceof JComponent) {
            ((JComponent)container).setPreferredSize(new Dimension(width, finalHeight));
        }
        this._suppressLayout = false;
    }
}

